<?php
/*
  Author: Greg Feigenson
  File: open_workorders.php
  Copyright: 2004-2005 Greg Feigenson
  
  This software is licensed under the BSD license.
  Please see attached license or www.opensource.org
  for details
*/

/* 
 TO DO LIST: pagination - LIMIT row_count OFFSET offset (http://www.varlena.com/varlena/GeneralBits/13.html)
*/
require_once("objects/workorder_object.php");
require('includes/header.inc.php');
	
//container class for workorders
$workorders = array();
$problem = "";
$workordersWithProblems = array();
$note = "";

/* Print header */
echo "<DIV align='center'> <H1>Trouble Tickets:</H1>";

/* Connecting, selecting database */
require("includes/db.inc.php");

if (isset($_POST['submitted']) /*== "yes"*/)
{
	$status = $_POST['select'];
	$id = $_POST['wo_id'];
	$query = "UPDATE $tbl_workorders SET status=$status WHERE workorder_id=$id";
	$result = pg_exec($query) or die(pg_last_error($connection));
}

/* Performing SQL query */
$query = "SELECT * FROM $view_wo_cust";
$result = pg_exec($query) or die("Query failed : " . pg_last_error($connection));
   
/* Printing results in HTML */
echo " <table padding=1 border=1><tr>
	   <td> Workorder ID (mouse over)  </td>
	   <td> Date Due                   </td>
	   <td> Customer                   </td>
	   <td> Phone1                     </td>
	   <td> Phone2                     </td>
	   <td> Assigned to                </td>
	   <td> Status (mouse over)        </td>
	   <td><td><td><td><td><td><td><td><td><td><td><td><td><td><td><td><td><td> <!-- hack for Z-Layer bug -->
	   <td> New Status                 </td>
	   </tr><tr></tr><tr></tr>";

while ($line = pg_fetch_assoc($result)) {
		$db_workorder = new workorder($line['start_date'],$line['promised_date'], $line['first_name'], $line['last_name'],$line['phone1'], $line['phone2'], $line['workorder_id']);                   
		$db_workorder->setStaff($line['staff']);
		$db_workorder->setStatus($line['wo_status']);
		array_push($workorders,$db_workorder);  //build array of workorders
}
    
/* associate problems with work orders */
foreach($workorders as $workorder)
{
	$id = $workorder->id;
	$query = "SELECT description, notes, estimated_time FROM $tbl_problems WHERE work_order_id = $id";
	$result = pg_query($connection,$query) or die("Query failed : " . pg_last_error($connection));

	while ($line = pg_fetch_assoc($result)) {
		  $problem .= "Problem: "       .$line['description']   ."<br> ";
		  $problem .= "Notes: "         .$line['notes']         ."<br> ";
		  $problem .= "Estimated Time: ".$line['estimated_time']." hours<br><br><br>";
	}
	
	$workorder->problems = $problem;//add the problem
	array_push($workordersWithProblems,$workorder);   //since the foreach doesn't allow editing of data...
	$problem = ""; //empty the problem
}

unset($workorders);
$workorders = array();

/* Associate notes with work orders */
foreach($workordersWithProblems as $workorder)
{
	$id = $workorder->id;
	$query = "SELECT date, author, text FROM $tbl_notes WHERE work_order_id = $id";
	$result = pg_exec($query) or die("Query failed : " . pg_last_error($connection)); 
		
	while ($line = pg_fetch_assoc($result)) {
		  $note .= "Author: ".$line['author']."<br> ";
		  $note .= "Date: ".$line['date']."<br> ";
		  $note .= "Note: ".$line['text']."<br><br>";
	}
	$workorder->addNote($note);//add the problem
	array_push($workorders,$workorder);
	$note = "";
}

/* Prints the workorder table */
foreach($workorders as $workorder)
{
	 echo "<tr><td><a href='invoice_detail.php?invoice=$workorder->id' class='info'>".$workorder->id."<span>".$workorder->problems."</span></a></td>";
		 
	 if (strtotime($workorder->due_date) <= time())
		echo "<td><b><font color='red'>(PAST DUE) ".date("d/m/Y h:ia",strtotime($workorder->due_date))."<b></td>";
	 else
		echo "<td>".date("m/d/Y h:ia",strtotime($workorder->due_date))."</td>";
			
	 echo "<td>".$workorder->first_name." ".$workorder->last_name."</td>";
	 echo "<td>".$workorder->phone1."</td>";
	 echo "<td>".$workorder->phone2."</td>";   
	 echo "<td>".$workorder->staff."</td>";
	 echo "<td><a href='#' class='info'>".$workorder->checkStatus($workorder->status)."<span>".$workorder->notes."</span></a></td>";
		 
	 /* Form for changing status */
	 echo "<td><td><td><td><td><td><td><td><td><td><td><td><td><td><td><td><td><td>";
	 echo "<td><form name='form' action='open_workorders.php' method='POST'>";
	 echo "<input type='hidden' name='submitted' value='yes'>";
	 echo "<input type='hidden' name='wo_id' value='".$workorder->id."'>";
	 echo "<select name='select' onChange='submit()'>";
	 echo "<option value='0'></option>";
	 echo "<option value='0'>Open</option>";
	 echo "<option value='1'>Closed</option>";
	 echo "<option value='2'>On Hold</option>";
	 echo "</select>";
	 echo "</form></td>";
}
        
print "</table>\n";

/* Closing connection */
pg_close($connection);
   
require('includes/footer.inc.php');
?>