import java.sql.*;
import javax.sql.*;
import java.util.*;
import java.io.*;

public class jdbc_batch_test {
	static Connection conn;
	/* test case
     *   0: No error	
     *   1: SQL error	
     *   2: JDBC exception
	 */
	static int testCase = 2;

	static int isbatch = 1;

	/** count
	  *   if less than 5 then no error
	  */
	static int count = 5;
	
	public static void prepare() throws SQLException {
        Statement stmt = null;
		stmt = conn.createStatement();
		stmt.executeUpdate("DROP TABLE IF EXISTS batch2;");
		stmt.executeUpdate("CREATE TABLE batch2 (" +
		                   "  i int," +
		                   "  tx text," +
		                   "  tx2 text," +
		                   "  i2 int," +
					       "  d date," +
					       "  t2 timestamp with time zone DEFAULT now()," +
					       "  t timestamp with time zone DEFAULT now()" +
					       ");");
		stmt.close();
	}

	public static void doTest() throws SQLException {
		
		conn.setAutoCommit(false);
        PreparedStatement stmt = null, stmt0;

        stmt0 = conn.prepareStatement("INSERT INTO batch2(i,t) values(?,?)");

		if (testCase == 0) {
        	stmt = conn.prepareStatement("INSERT INTO batch2(i,t) values(?,?)");
		} else if (testCase == 1) {
        	stmt = conn.prepareStatement("INSERT INTO batch2(i) values(?)");
		} else if (testCase == 2) {
        	//stmt = conn.prepareStatement("INSERT INTO batch2(d) values(?)");
        	stmt = conn.prepareStatement("INSERT INTO batch2(d, t, t2) values(?, now(), now())");
        	//stmt = conn.prepareStatement("INSERT INTO batch2(i, i2) values(?,?)");
		} else if (testCase == 3) {
        	stmt = conn.prepareStatement("INSERT INTO batch2(i,i2) values(?,?)");
		} else if (testCase == 4) {
        	stmt = conn.prepareStatement("INSERT INTO batch2(tx,tx2) values(?,?)");
		} else if (testCase == 5) {
        	stmt = conn.prepareStatement("INSERT INTO batch2(i,tx) values(?,?)");
		}

		Object param;
/*
		for (int i = 0; i < count; i++) {
			param = i;
			stmt0.setObject(1, param);
			param = new java.util.Date();
			stmt0.setTimestamp(2, new java.sql.Timestamp(((java.util.Date)param).getTime()));
		//for (int i = 0; i < count; i++) {
			stmt0.executeUpdate();
		}
		stmt0.close();
		Statement stmt1 = conn.createStatement();
		stmt1.executeQuery("SELECT 1");
		stmt1.close();
		*/

		for (int i = 0; i < count; i++) {

			if (testCase == 0) {
				param = i;
				stmt.setObject(1, param);
				param = new java.util.Date();
				stmt.setTimestamp(2, new java.sql.Timestamp(((java.util.Date)param).getTime()));

			} else if (testCase == 1) {
				param = i;
				stmt.setObject(1, param);

			} else if (testCase == 2){
				param = new java.util.Date();
				stmt.setTimestamp(1, new java.sql.Timestamp(((java.util.Date)param).getTime()));

			} else if (testCase == 3) {
				param = i;
				stmt.setObject(1, param);
				stmt.setObject(2, param);

			} else if (testCase == 4) {
				param = i;
				stmt.setObject(1, param);
				stmt.setObject(2, param);

			} else if (testCase == 5) {
				param = i;
				stmt.setObject(1, param);
				stmt.setObject(2, param);
			}

			if (isbatch==1) { 
				stmt.addBatch();
			} else {
				stmt.executeUpdate();
			}
		}
		if (isbatch==1) { 
			stmt.executeBatch();
		}


		conn.commit();
		stmt.close();
	}

	public static void main(String[] args) {
		try {
			try {
				//org.postgresql.Driver.setLogLevel(org.postgresql.Driver.DEBUG);
				Properties prop = new Properties();
				prop.load(new FileInputStream("jdbctest.prop"));
				String url = prop.getProperty("jdbc.url");
				String user = prop.getProperty("jdbc.user");
				String pwd = prop.getProperty("jdbc.password");
				conn = DriverManager.getConnection(url, user, pwd);

				testCase = Integer.parseInt(prop.getProperty("test.testCase"));
				count = Integer.parseInt(prop.getProperty("test.count"));
				isbatch = Integer.parseInt(prop.getProperty("test.isbatch"));

		   //String sql = "INSERT INTO t VALUES ('1', 'a', 'X');";
		   //   Statement statement = conn.createStatement();
			//     statement.executeUpdate(sql);

				prepare();
				doTest();

			} catch (Exception e) {
				System.err.println(e.getMessage());
				e.printStackTrace();
			} finally {
				if (conn != null) { conn.close(); }
			}

		} catch (SQLException e) {
			while (e != null){
				System.out.println(e.getMessage());
				e=e.getNextException();
			}

		} catch (Exception e) {
			System.err.println(e.getMessage());
			e.printStackTrace();
		}
	}
}
