/* A Bison parser, made by GNU Bison 2.5.  */

/* Bison implementation for Yacc-like parsers in C
   
      Copyright (C) 1984, 1989-1990, 2000-2011 Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.5"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 1

/* Substitute the variable and function names.  */
#define yyparse         base_yyparse
#define yylex           base_yylex
#define yyerror         base_yyerror
#define yylval          base_yylval
#define yychar          base_yychar
#define yydebug         base_yydebug
#define yynerrs         base_yynerrs
#define yylloc          base_yylloc

/* Copy the first part of user declarations.  */

/* Line 268 of yacc.c  */
#line 5 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"
#include "ecpg_config.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
		if (N)						\
			(Current) = (Rhs)[1];	\
		else						\
			(Current) = (Rhs)[0];	\
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * This is only here so the string gets into the POT.  Bison uses it
 * internally.
 */
#define bison_gettext_dummy gettext_noop("syntax error")

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
char *current_function;
int ecpg_internal_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char	pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];
static int	varchar_counter = 1;

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
static void __attribute__((format(PG_PRINTF_ATTRIBUTE, 3, 0)))
vmmerror(int error_code, enum errortype type, const char *error, va_list ap)
{
	/* internationalize the error message string */
	error = _(error);

	fprintf(stderr, "%s:%d: ", input_filename, yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, _("WARNING: "));
			break;
		case ET_ERROR:
			fprintf(stderr, _("ERROR: "));
			break;
	}

	vfprintf(stderr, error, ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
	}
}

void
mmerror(int error_code, enum errortype type, const char *error, ...)
{
	va_list		ap;

	va_start(ap, error);
	vmmerror(error_code, type, error, ap);
	va_end(ap);
}

void
mmfatal(int error_code, const char *error, ...)
{
	va_list		ap;

	va_start(ap, error);
	vmmerror(error_code, ET_ERROR, error, ap);
	va_end(ap);

	if (yyin)
		fclose(yyin);
	if (yyout)
		fclose(yyout);

	if (strcmp(output_filename, "-") != 0 && unlink(output_filename) != 0)
		fprintf(stderr, _("could not remove output file \"%s\"\n"), output_filename);
	exit(error_code);
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	if (strlen(str1) != 0 && strlen(str2) != 0)
		strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	return mm_strdup(yytext);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, mm_strdup(pacounter_buffer), mm_strdup(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_outofscope_cursor_vars(struct cursor *cur)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
	 * For instance you can DECLARE a cursor in one function, and OPEN/FETCH/CLOSE
	 * it in another functions. This is very useful for e.g. event-driver programming,
	 * but may also lead to dangerous programming. The limitation when this is allowed
	 * and doesn't cause problems have to be documented, like the allocated variables
	 * must not be realloc()'ed.
	 *
	 * We have to change the variables to our own struct and just store the pointer
	 * instead of the variable. Do it only for local variables, not for globals.
	 */

	char *result = EMPTY;
	int insert;

	for (insert = 1; insert >= 0; insert--)
	{
		struct arguments *list;
		struct arguments *ptr;
		struct arguments *newlist = NULL;
		struct variable *newvar, *newind;

		list = (insert ? cur->argsinsert : cur->argsresult);

		for (ptr = list; ptr != NULL; ptr = ptr->next)
		{
			char var_text[20];
			char *original_var;
			bool skip_set_var = false;
			bool var_ptr = false;

			/* change variable name to "ECPGget_var(<counter>)" */
			original_var = ptr->variable->name;
			sprintf(var_text, "%d))", ecpg_internal_var);

			/* Don't emit ECPGset_var() calls for global variables */
			if (ptr->variable->brace_level == 0)
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type == ECPGt_char_variable)
					 && (strncmp(ptr->variable->name, "ECPGprepared_statement", strlen("ECPGprepared_statement")) == 0))
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type != ECPGt_varchar
					  && ptr->variable->type->type != ECPGt_char
					  && ptr->variable->type->type != ECPGt_unsigned_char
					  && ptr->variable->type->type != ECPGt_string)
					 && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type,
																			   mm_strdup("1"),
																			   ptr->variable->type->u.element->counter),
														  ptr->variable->type->size),
									  0);
			}
			else if ((ptr->variable->type->type == ECPGt_varchar
					  || ptr->variable->type->type == ECPGt_char
					  || ptr->variable->type->type == ECPGt_unsigned_char
					  || ptr->variable->type->type == ECPGt_string)
					 && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_simple_type(ptr->variable->type->type,
														   ptr->variable->type->size,
														   ptr->variable->type->counter),
									  0);
				if (ptr->variable->type->type == ECPGt_varchar)
					var_ptr = true;
			}
			else if (ptr->variable->type->type == ECPGt_struct
					 || ptr->variable->type->type == ECPGt_union)
			{
				newvar = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->variable->type->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
									  ECPGmake_struct_type(ptr->variable->type->u.members,
														   ptr->variable->type->type,
														   ptr->variable->type->type_name,
														   ptr->variable->type->struct_sizeof),
									  0);
				var_ptr = true;
			}
			else if (ptr->variable->type->type == ECPGt_array)
			{
				if (ptr->variable->type->u.element->type == ECPGt_struct
					|| ptr->variable->type->u.element->type == ECPGt_union)
				{
					newvar = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->variable->type->u.element->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
										  ECPGmake_struct_type(ptr->variable->type->u.element->u.members,
															   ptr->variable->type->u.element->type,
															   ptr->variable->type->u.element->type_name,
															   ptr->variable->type->u.element->struct_sizeof),
										  0);
				}
				else
				{
					newvar = new_variable(cat_str(4, mm_strdup("("),
												  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type,
																				   ptr->variable->type->u.element->size,
																				   ptr->variable->type->u.element->counter),
															  ptr->variable->type->size),
										  0);
					var_ptr = true;
				}
			}
			else
			{
				newvar = new_variable(cat_str(4, mm_strdup("*("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_simple_type(ptr->variable->type->type,
														   ptr->variable->type->size,
														   ptr->variable->type->counter),
									  0);
				var_ptr = true;
			}

			/* create call to "ECPGset_var(<counter>, <connection>, <pointer>. <line number>)" */
			if (!skip_set_var)
			{
				sprintf(var_text, "%d, %s", ecpg_internal_var++, var_ptr ? "&(" : "(");
				result = cat_str(5, result, mm_strdup("ECPGset_var("),
								 mm_strdup(var_text), mm_strdup(original_var),
								 mm_strdup("), __LINE__);\n"));
			}

			/* now the indicator if there is one and it's not a global variable */
			if ((ptr->indicator->type->type == ECPGt_NO_INDICATOR) || (ptr->indicator->brace_level == 0))
			{
				newind = ptr->indicator;
			}
			else
			{
				/* change variable name to "ECPGget_var(<counter>)" */
				original_var = ptr->indicator->name;
				sprintf(var_text, "%d))", ecpg_internal_var);
				var_ptr = false;

				if (ptr->indicator->type->type == ECPGt_struct
					|| ptr->indicator->type->type == ECPGt_union)
				{
					newind = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->indicator->type->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
										  ECPGmake_struct_type(ptr->indicator->type->u.members,
															   ptr->indicator->type->type,
															   ptr->indicator->type->type_name,
															   ptr->indicator->type->struct_sizeof),
										  0);
					var_ptr = true;
				}
				else if (ptr->indicator->type->type == ECPGt_array)
				{
					if (ptr->indicator->type->u.element->type == ECPGt_struct
						|| ptr->indicator->type->u.element->type == ECPGt_union)
					{
						newind = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->indicator->type->u.element->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
											  ECPGmake_struct_type(ptr->indicator->type->u.element->u.members,
																   ptr->indicator->type->u.element->type,
																   ptr->indicator->type->u.element->type_name,
																   ptr->indicator->type->u.element->struct_sizeof),
											  0);
					}
					else
					{
						newind = new_variable(cat_str(4, mm_strdup("("),
													  mm_strdup(ecpg_type_name(ptr->indicator->type->u.element->type)),
													  mm_strdup(" *)(ECPGget_var("), mm_strdup(var_text)),
											  ECPGmake_array_type(ECPGmake_simple_type(ptr->indicator->type->u.element->type,
																					   ptr->indicator->type->u.element->size,
																					   ptr->indicator->type->u.element->counter),
																  ptr->indicator->type->size),
											  0);
						var_ptr = true;
					}
				}
				else if (atoi(ptr->indicator->type->size) > 1)
				{
					newind = new_variable(cat_str(4, mm_strdup("("),
												  mm_strdup(ecpg_type_name(ptr->indicator->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_simple_type(ptr->indicator->type->type,
															   ptr->indicator->type->size,
															   ptr->variable->type->counter),
										  0);
				}
				else
				{
					newind = new_variable(cat_str(4, mm_strdup("*("),
												  mm_strdup(ecpg_type_name(ptr->indicator->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_simple_type(ptr->indicator->type->type,
															   ptr->indicator->type->size,
															   ptr->variable->type->counter),
										  0);
					var_ptr = true;
				}

				/* create call to "ECPGset_var(<counter>, <pointer>. <line number>)" */
				sprintf(var_text, "%d, %s", ecpg_internal_var++, var_ptr ? "&(" : "(");
				result = cat_str(5, result, mm_strdup("ECPGset_var("),
								 mm_strdup(var_text), mm_strdup(original_var),
								 mm_strdup("), __LINE__);\n"));
			}

			add_variable_to_tail(&newlist, newvar, newind);
		}

		if (insert)
			cur->argsinsert_oos = newlist;
		else
			cur->argsresult_oos = newlist;
	}

	return result;
}

/* This tests whether the cursor was declared and opened in the same function. */
#define SAMEFUNC(cur)	\
	((cur->function == NULL) ||		\
	 (cur->function != NULL && strcmp(cur->function, current_function) == 0))

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;
	int (* strcmp_fn)(const char *, const char *) = ((name[0] == ':' || name[0] == '"') ? strcmp : pg_strcasecmp);

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp_fn(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "cursor \"%s\" does not exist", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = (SAMEFUNC(ptr) ? ptr->argsinsert : ptr->argsinsert_oos); p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = (SAMEFUNC(ptr) ? ptr->argsresult : ptr->argsresult_oos); p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char *dimension, char *length, enum ECPGttype type_enum,
			char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
		 type_enum == ECPGt_union) &&
		initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "initializer not allowed in type definition");
	else if (INFORMIX_MODE && strcmp(name, "string") == 0)
		mmerror(PARSE_ERROR, ET_ERROR, "type name \"string\" is reserved in Informix mode");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "type \"%s\" is already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			type_enum != ECPGt_string &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "multidimensional arrays for simple data types are not supported");

		types = this;
	}
}


/* Line 268 of yacc.c  */
#line 650 "preproc.c"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_COUNT = 265,
     SQL_DATETIME_INTERVAL_CODE = 266,
     SQL_DATETIME_INTERVAL_PRECISION = 267,
     SQL_DESCRIBE = 268,
     SQL_DESCRIPTOR = 269,
     SQL_DISCONNECT = 270,
     SQL_FOUND = 271,
     SQL_FREE = 272,
     SQL_GET = 273,
     SQL_GO = 274,
     SQL_GOTO = 275,
     SQL_IDENTIFIED = 276,
     SQL_INDICATOR = 277,
     SQL_KEY_MEMBER = 278,
     SQL_LENGTH = 279,
     SQL_LONG = 280,
     SQL_NULLABLE = 281,
     SQL_OCTET_LENGTH = 282,
     SQL_OPEN = 283,
     SQL_OUTPUT = 284,
     SQL_REFERENCE = 285,
     SQL_RETURNED_LENGTH = 286,
     SQL_RETURNED_OCTET_LENGTH = 287,
     SQL_SCALE = 288,
     SQL_SECTION = 289,
     SQL_SHORT = 290,
     SQL_SIGNED = 291,
     SQL_SQL = 292,
     SQL_SQLERROR = 293,
     SQL_SQLPRINT = 294,
     SQL_SQLWARNING = 295,
     SQL_START = 296,
     SQL_STOP = 297,
     SQL_STRUCT = 298,
     SQL_UNSIGNED = 299,
     SQL_VAR = 300,
     SQL_WHENEVER = 301,
     S_ADD = 302,
     S_AND = 303,
     S_ANYTHING = 304,
     S_AUTO = 305,
     S_CONST = 306,
     S_DEC = 307,
     S_DIV = 308,
     S_DOTPOINT = 309,
     S_EQUAL = 310,
     S_EXTERN = 311,
     S_INC = 312,
     S_LSHIFT = 313,
     S_MEMPOINT = 314,
     S_MEMBER = 315,
     S_MOD = 316,
     S_MUL = 317,
     S_NEQUAL = 318,
     S_OR = 319,
     S_REGISTER = 320,
     S_RSHIFT = 321,
     S_STATIC = 322,
     S_SUB = 323,
     S_VOLATILE = 324,
     S_TYPEDEF = 325,
     CSTRING = 326,
     CVARIABLE = 327,
     CPP_LINE = 328,
     IP = 329,
     DOLCONST = 330,
     ECONST = 331,
     NCONST = 332,
     UCONST = 333,
     UIDENT = 334,
     IDENT = 335,
     FCONST = 336,
     SCONST = 337,
     BCONST = 338,
     XCONST = 339,
     Op = 340,
     ICONST = 341,
     PARAM = 342,
     TYPECAST = 343,
     DOT_DOT = 344,
     COLON_EQUALS = 345,
     ABORT_P = 346,
     ABSOLUTE_P = 347,
     ACCESS = 348,
     ACTION = 349,
     ADD_P = 350,
     ADMIN = 351,
     AFTER = 352,
     AGGREGATE = 353,
     ALL = 354,
     ALSO = 355,
     ALTER = 356,
     ALWAYS = 357,
     ANALYSE = 358,
     ANALYZE = 359,
     AND = 360,
     ANY = 361,
     ARRAY = 362,
     AS = 363,
     ASC = 364,
     ASSERTION = 365,
     ASSIGNMENT = 366,
     ASYMMETRIC = 367,
     AT = 368,
     ATTRIBUTE = 369,
     AUTHORIZATION = 370,
     BACKWARD = 371,
     BEFORE = 372,
     BEGIN_P = 373,
     BETWEEN = 374,
     BIGINT = 375,
     BINARY = 376,
     BIT = 377,
     BOOLEAN_P = 378,
     BOTH = 379,
     BY = 380,
     CACHE = 381,
     CALLED = 382,
     CASCADE = 383,
     CASCADED = 384,
     CASE = 385,
     CAST = 386,
     CATALOG_P = 387,
     CHAIN = 388,
     CHAR_P = 389,
     CHARACTER = 390,
     CHARACTERISTICS = 391,
     CHECK = 392,
     CHECKPOINT = 393,
     CLASS = 394,
     CLOSE = 395,
     CLUSTER = 396,
     COALESCE = 397,
     COLLATE = 398,
     COLLATION = 399,
     COLUMN = 400,
     COMMENT = 401,
     COMMENTS = 402,
     COMMIT = 403,
     COMMITTED = 404,
     CONCURRENTLY = 405,
     CONFIGURATION = 406,
     CONNECTION = 407,
     CONSTRAINT = 408,
     CONSTRAINTS = 409,
     CONTENT_P = 410,
     CONTINUE_P = 411,
     CONVERSION_P = 412,
     COPY = 413,
     COST = 414,
     CREATE = 415,
     CROSS = 416,
     CSV = 417,
     CURRENT_P = 418,
     CURRENT_CATALOG = 419,
     CURRENT_DATE = 420,
     CURRENT_ROLE = 421,
     CURRENT_SCHEMA = 422,
     CURRENT_TIME = 423,
     CURRENT_TIMESTAMP = 424,
     CURRENT_USER = 425,
     CURSOR = 426,
     CYCLE = 427,
     DATA_P = 428,
     DATABASE = 429,
     DAY_P = 430,
     DEALLOCATE = 431,
     DEC = 432,
     DECIMAL_P = 433,
     DECLARE = 434,
     DEFAULT = 435,
     DEFAULTS = 436,
     DEFERRABLE = 437,
     DEFERRED = 438,
     DEFINER = 439,
     DELETE_P = 440,
     DELIMITER = 441,
     DELIMITERS = 442,
     DESC = 443,
     DICTIONARY = 444,
     DISABLE_P = 445,
     DISCARD = 446,
     DISTINCT = 447,
     DO = 448,
     DOCUMENT_P = 449,
     DOMAIN_P = 450,
     DOUBLE_P = 451,
     DROP = 452,
     EACH = 453,
     ELSE = 454,
     ENABLE_P = 455,
     ENCODING = 456,
     ENCRYPTED = 457,
     END_P = 458,
     ENUM_P = 459,
     ESCAPE = 460,
     EVENT = 461,
     EXCEPT = 462,
     EXCLUDE = 463,
     EXCLUDING = 464,
     EXCLUSIVE = 465,
     EXECUTE = 466,
     EXISTS = 467,
     EXPLAIN = 468,
     EXTENSION = 469,
     EXTERNAL = 470,
     EXTRACT = 471,
     FALSE_P = 472,
     FAMILY = 473,
     FETCH = 474,
     FILTER = 475,
     FIRST_P = 476,
     FLOAT_P = 477,
     FOLLOWING = 478,
     FOR = 479,
     FORCE = 480,
     FOREIGN = 481,
     FORWARD = 482,
     FREEZE = 483,
     FROM = 484,
     FULL = 485,
     FUNCTION = 486,
     FUNCTIONS = 487,
     GLOBAL = 488,
     GRANT = 489,
     GRANTED = 490,
     GREATEST = 491,
     GROUP_P = 492,
     HANDLER = 493,
     HAVING = 494,
     HEADER_P = 495,
     HOLD = 496,
     HOUR_P = 497,
     IDENTITY_P = 498,
     IF_P = 499,
     ILIKE = 500,
     IMMEDIATE = 501,
     IMMUTABLE = 502,
     IMPLICIT_P = 503,
     IN_P = 504,
     INCLUDING = 505,
     INCREMENT = 506,
     INDEX = 507,
     INDEXES = 508,
     INHERIT = 509,
     INHERITS = 510,
     INITIALLY = 511,
     INLINE_P = 512,
     INNER_P = 513,
     INOUT = 514,
     INPUT_P = 515,
     INSENSITIVE = 516,
     INSERT = 517,
     INSTEAD = 518,
     INT_P = 519,
     INTEGER = 520,
     INTERSECT = 521,
     INTERVAL = 522,
     INTO = 523,
     INVOKER = 524,
     IS = 525,
     ISNULL = 526,
     ISOLATION = 527,
     JOIN = 528,
     KEY = 529,
     LABEL = 530,
     LANGUAGE = 531,
     LARGE_P = 532,
     LAST_P = 533,
     LATERAL_P = 534,
     LC_COLLATE_P = 535,
     LC_CTYPE_P = 536,
     LEADING = 537,
     LEAKPROOF = 538,
     LEAST = 539,
     LEFT = 540,
     LEVEL = 541,
     LIKE = 542,
     LIMIT = 543,
     LISTEN = 544,
     LOAD = 545,
     LOCAL = 546,
     LOCALTIME = 547,
     LOCALTIMESTAMP = 548,
     LOCATION = 549,
     LOCK_P = 550,
     MAPPING = 551,
     MATCH = 552,
     MATERIALIZED = 553,
     MAXVALUE = 554,
     MINUTE_P = 555,
     MINVALUE = 556,
     MODE = 557,
     MONTH_P = 558,
     MOVE = 559,
     NAME_P = 560,
     NAMES = 561,
     NATIONAL = 562,
     NATURAL = 563,
     NCHAR = 564,
     NEXT = 565,
     NO = 566,
     NONE = 567,
     NOT = 568,
     NOTHING = 569,
     NOTIFY = 570,
     NOTNULL = 571,
     NOWAIT = 572,
     NULL_P = 573,
     NULLIF = 574,
     NULLS_P = 575,
     NUMERIC = 576,
     OBJECT_P = 577,
     OF = 578,
     OFF = 579,
     OFFSET = 580,
     OIDS = 581,
     ON = 582,
     ONLY = 583,
     OPERATOR = 584,
     OPTION = 585,
     OPTIONS = 586,
     OR = 587,
     ORDER = 588,
     ORDINALITY = 589,
     OUT_P = 590,
     OUTER_P = 591,
     OVER = 592,
     OVERLAPS = 593,
     OVERLAY = 594,
     OWNED = 595,
     OWNER = 596,
     PARSER = 597,
     PARTIAL = 598,
     PARTITION = 599,
     PASSING = 600,
     PASSWORD = 601,
     PLACING = 602,
     PLANS = 603,
     POSITION = 604,
     PRECEDING = 605,
     PRECISION = 606,
     PRESERVE = 607,
     PREPARE = 608,
     PREPARED = 609,
     PRIMARY = 610,
     PRIOR = 611,
     PRIVILEGES = 612,
     PROCEDURAL = 613,
     PROCEDURE = 614,
     PROGRAM = 615,
     QUOTE = 616,
     RANGE = 617,
     READ = 618,
     REAL = 619,
     REASSIGN = 620,
     RECHECK = 621,
     RECURSIVE = 622,
     REF = 623,
     REFERENCES = 624,
     REFRESH = 625,
     REINDEX = 626,
     RELATIVE_P = 627,
     RELEASE = 628,
     RENAME = 629,
     REPEATABLE = 630,
     REPLACE = 631,
     REPLICA = 632,
     RESET = 633,
     RESTART = 634,
     RESTRICT = 635,
     RETURNING = 636,
     RETURNS = 637,
     REVOKE = 638,
     RIGHT = 639,
     ROLE = 640,
     ROLLBACK = 641,
     ROW = 642,
     ROWS = 643,
     RULE = 644,
     SAVEPOINT = 645,
     SCHEMA = 646,
     SCROLL = 647,
     SEARCH = 648,
     SECOND_P = 649,
     SECURITY = 650,
     SELECT = 651,
     SEQUENCE = 652,
     SEQUENCES = 653,
     SERIALIZABLE = 654,
     SERVER = 655,
     SESSION = 656,
     SESSION_USER = 657,
     SET = 658,
     SETOF = 659,
     SHARE = 660,
     SHOW = 661,
     SIMILAR = 662,
     SIMPLE = 663,
     SMALLINT = 664,
     SNAPSHOT = 665,
     SOME = 666,
     STABLE = 667,
     STANDALONE_P = 668,
     START = 669,
     STATEMENT = 670,
     STATISTICS = 671,
     STDIN = 672,
     STDOUT = 673,
     STORAGE = 674,
     STRICT_P = 675,
     STRIP_P = 676,
     SUBSTRING = 677,
     SYMMETRIC = 678,
     SYSID = 679,
     SYSTEM_P = 680,
     TABLE = 681,
     TABLES = 682,
     TABLESPACE = 683,
     TEMP = 684,
     TEMPLATE = 685,
     TEMPORARY = 686,
     TEXT_P = 687,
     THEN = 688,
     TIME = 689,
     TIMESTAMP = 690,
     TO = 691,
     TRAILING = 692,
     TRANSACTION = 693,
     TREAT = 694,
     TRIGGER = 695,
     TRIM = 696,
     TRUE_P = 697,
     TRUNCATE = 698,
     TRUSTED = 699,
     TYPE_P = 700,
     TYPES_P = 701,
     UNBOUNDED = 702,
     UNCOMMITTED = 703,
     UNENCRYPTED = 704,
     UNION = 705,
     UNIQUE = 706,
     UNKNOWN = 707,
     UNLISTEN = 708,
     UNLOGGED = 709,
     UNTIL = 710,
     UPDATE = 711,
     USER = 712,
     USING = 713,
     VACUUM = 714,
     VALID = 715,
     VALIDATE = 716,
     VALIDATOR = 717,
     VALUE_P = 718,
     VALUES = 719,
     VARCHAR = 720,
     VARIADIC = 721,
     VARYING = 722,
     VERBOSE = 723,
     VERSION_P = 724,
     VIEW = 725,
     VIEWS = 726,
     VOLATILE = 727,
     WHEN = 728,
     WHERE = 729,
     WHITESPACE_P = 730,
     WINDOW = 731,
     WITH = 732,
     WITHIN = 733,
     WITHOUT = 734,
     WORK = 735,
     WRAPPER = 736,
     WRITE = 737,
     XML_P = 738,
     XMLATTRIBUTES = 739,
     XMLCONCAT = 740,
     XMLELEMENT = 741,
     XMLEXISTS = 742,
     XMLFOREST = 743,
     XMLPARSE = 744,
     XMLPI = 745,
     XMLROOT = 746,
     XMLSERIALIZE = 747,
     YEAR_P = 748,
     YES_P = 749,
     ZONE = 750,
     NULLS_FIRST = 751,
     NULLS_LAST = 752,
     WITH_ORDINALITY = 753,
     WITH_TIME = 754,
     POSTFIXOP = 755,
     UMINUS = 756
   };
#endif



#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 293 of yacc.c  */
#line 579 "preproc.y"

	double	dval;
	char	*str;
	int		ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;



/* Line 293 of yacc.c  */
#line 1204 "preproc.c"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif

#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */


/* Line 343 of yacc.c  */
#line 1229 "preproc.c"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
	     && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE) + sizeof (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   111727

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  521
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  716
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2840
/* YYNRULES -- Number of states.  */
#define YYNSTATES  5223

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   756

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   508,     2,     2,
     513,   514,   506,   504,   516,   505,   515,   507,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   518,   517,
     501,   500,   502,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   511,     2,   512,   509,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   519,     2,   520,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   503,   510
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     7,     9,    11,    13,    15,    17,
      19,    21,    23,    25,    27,    29,    31,    33,    35,    37,
      39,    41,    43,    45,    47,    49,    51,    53,    55,    57,
      59,    61,    63,    65,    67,    69,    71,    73,    75,    77,
      79,    81,    83,    85,    87,    89,    91,    93,    95,    97,
      99,   101,   103,   105,   107,   109,   111,   113,   115,   117,
     119,   121,   123,   125,   127,   129,   131,   133,   135,   137,
     139,   141,   143,   145,   147,   149,   151,   153,   155,   157,
     159,   161,   163,   165,   167,   169,   171,   173,   175,   177,
     179,   181,   183,   185,   187,   189,   191,   193,   195,   197,
     199,   201,   203,   205,   207,   209,   211,   213,   215,   217,
     219,   221,   223,   225,   227,   229,   231,   233,   235,   237,
     239,   241,   243,   245,   247,   249,   251,   253,   255,   257,
     259,   261,   263,   265,   267,   269,   271,   273,   275,   276,
     282,   284,   285,   288,   289,   292,   293,   296,   299,   303,
     307,   309,   313,   317,   320,   322,   324,   327,   330,   333,
     337,   341,   347,   353,   354,   358,   364,   370,   376,   381,
     385,   391,   395,   401,   407,   414,   416,   418,   422,   428,
     435,   440,   450,   458,   460,   461,   464,   465,   467,   469,
     471,   473,   475,   477,   480,   484,   488,   491,   497,   499,
     503,   507,   511,   515,   517,   521,   525,   528,   531,   534,
     537,   541,   545,   549,   553,   555,   559,   561,   565,   567,
     569,   572,   575,   578,   580,   582,   584,   586,   588,   590,
     592,   596,   603,   605,   607,   609,   611,   613,   614,   616,
     618,   621,   625,   630,   634,   637,   640,   642,   645,   647,
     651,   656,   662,   667,   670,   675,   677,   679,   681,   683,
     685,   688,   691,   694,   697,   700,   705,   712,   717,   724,
     729,   736,   741,   748,   754,   762,   764,   768,   771,   775,
     780,   787,   794,   801,   807,   813,   820,   827,   832,   841,
     846,   849,   854,   858,   865,   870,   874,   878,   882,   886,
     890,   895,   900,   904,   908,   912,   916,   920,   924,   929,
     934,   938,   941,   945,   948,   951,   955,   959,   962,   965,
     969,   971,   975,   978,   980,   982,   983,   986,   987,   990,
     991,   993,   995,   997,  1001,  1005,  1008,  1009,  1011,  1015,
    1019,  1021,  1027,  1031,  1036,  1038,  1042,  1047,  1054,  1059,
    1068,  1071,  1074,  1086,  1094,  1096,  1098,  1100,  1101,  1103,
    1105,  1107,  1109,  1113,  1116,  1117,  1119,  1121,  1123,  1127,
    1131,  1133,  1135,  1139,  1143,  1147,  1151,  1156,  1160,  1163,
    1165,  1166,  1169,  1170,  1174,  1175,  1177,  1178,  1180,  1184,
    1187,  1189,  1191,  1193,  1197,  1198,  1200,  1204,  1206,  1218,
    1233,  1244,  1258,  1260,  1262,  1265,  1268,  1271,  1274,  1276,
    1277,  1279,  1280,  1284,  1285,  1287,  1291,  1293,  1297,  1299,
    1301,  1303,  1305,  1307,  1312,  1317,  1320,  1321,  1325,  1327,
    1329,  1332,  1335,  1337,  1341,  1346,  1352,  1355,  1361,  1363,
    1366,  1369,  1372,  1376,  1380,  1384,  1385,  1387,  1389,  1391,
    1393,  1395,  1397,  1401,  1403,  1409,  1417,  1421,  1430,  1435,
    1445,  1457,  1460,  1461,  1465,  1466,  1468,  1472,  1474,  1477,
    1480,  1483,  1484,  1486,  1490,  1494,  1501,  1506,  1507,  1509,
    1511,  1514,  1517,  1518,  1522,  1526,  1529,  1531,  1533,  1536,
    1539,  1544,  1545,  1548,  1551,  1554,  1555,  1559,  1564,  1569,
    1570,  1573,  1574,  1579,  1580,  1584,  1590,  1593,  1597,  1598,
    1607,  1612,  1614,  1615,  1622,  1628,  1633,  1640,  1642,  1643,
    1645,  1648,  1651,  1653,  1656,  1660,  1663,  1666,  1669,  1672,
    1676,  1680,  1682,  1686,  1688,  1689,  1691,  1694,  1696,  1698,
    1702,  1709,  1720,  1722,  1723,  1725,  1728,  1731,  1732,  1735,
    1738,  1740,  1741,  1747,  1755,  1757,  1758,  1766,  1769,  1770,
    1774,  1780,  1786,  1795,  1798,  1799,  1802,  1805,  1808,  1814,
    1817,  1818,  1821,  1829,  1840,  1847,  1854,  1861,  1868,  1876,
    1884,  1894,  1904,  1911,  1919,  1926,  1935,  1944,  1953,  1962,
    1969,  1976,  1984,  1992,  2001,  2008,  2015,  2023,  2026,  2029,
    2032,  2035,  2037,  2040,  2042,  2043,  2050,  2059,  2067,  2074,
    2079,  2080,  2082,  2086,  2091,  2093,  2097,  2099,  2102,  2105,
    2108,  2111,  2113,  2115,  2126,  2129,  2130,  2133,  2136,  2138,
    2139,  2144,  2151,  2157,  2162,  2167,  2178,  2192,  2198,  2206,
    2215,  2217,  2219,  2221,  2229,  2239,  2248,  2264,  2285,  2287,
    2289,  2292,  2294,  2298,  2300,  2302,  2304,  2308,  2310,  2314,
    2315,  2317,  2318,  2320,  2322,  2327,  2328,  2330,  2334,  2335,
    2337,  2339,  2341,  2343,  2346,  2347,  2348,  2351,  2354,  2356,
    2359,  2362,  2365,  2368,  2375,  2384,  2396,  2410,  2412,  2416,
    2422,  2424,  2428,  2434,  2436,  2439,  2442,  2444,  2453,  2458,
    2464,  2469,  2474,  2479,  2483,  2491,  2500,  2507,  2514,  2521,
    2528,  2535,  2540,  2546,  2550,  2552,  2556,  2560,  2562,  2564,
    2566,  2568,  2570,  2572,  2576,  2578,  2582,  2586,  2588,  2589,
    2591,  2595,  2603,  2613,  2623,  2627,  2628,  2642,  2644,  2648,
    2654,  2661,  2666,  2674,  2677,  2679,  2680,  2683,  2684,  2687,
    2692,  2693,  2695,  2696,  2703,  2712,  2721,  2723,  2727,  2733,
    2739,  2747,  2757,  2765,  2775,  2781,  2788,  2795,  2800,  2806,
    2814,  2816,  2818,  2820,  2823,  2825,  2828,  2831,  2833,  2835,
    2837,  2839,  2841,  2843,  2847,  2851,  2855,  2859,  2861,  2865,
    2867,  2870,  2873,  2877,  2883,  2886,  2889,  2890,  2897,  2905,
    2913,  2921,  2930,  2939,  2946,  2955,  2965,  2975,  2983,  2994,
    3002,  3004,  3006,  3008,  3010,  3012,  3014,  3016,  3018,  3020,
    3023,  3025,  3027,  3029,  3031,  3033,  3036,  3038,  3042,  3045,
    3049,  3053,  3057,  3061,  3063,  3065,  3074,  3084,  3094,  3104,
    3114,  3117,  3118,  3120,  3122,  3125,  3128,  3130,  3132,  3134,
    3136,  3138,  3140,  3142,  3144,  3147,  3149,  3151,  3154,  3157,
    3161,  3166,  3172,  3177,  3183,  3187,  3192,  3196,  3201,  3203,
    3206,  3210,  3214,  3218,  3222,  3227,  3232,  3236,  3240,  3245,
    3250,  3255,  3260,  3262,  3264,  3266,  3267,  3275,  3283,  3294,
    3296,  3298,  3301,  3306,  3312,  3314,  3318,  3321,  3324,  3327,
    3330,  3332,  3335,  3338,  3343,  3347,  3350,  3353,  3356,  3359,
    3363,  3366,  3369,  3372,  3378,  3384,  3390,  3392,  3396,  3398,
    3401,  3405,  3406,  3408,  3412,  3415,  3422,  3429,  3439,  3443,
    3444,  3448,  3449,  3455,  3458,  3459,  3463,  3467,  3471,  3479,
    3487,  3498,  3500,  3502,  3504,  3506,  3521,  3523,  3524,  3526,
    3527,  3529,  3530,  3533,  3534,  3536,  3540,  3546,  3552,  3560,
    3563,  3564,  3566,  3569,  3570,  3572,  3574,  3575,  3577,  3579,
    3580,  3590,  3603,  3611,  3614,  3615,  3619,  3622,  3624,  3628,
    3632,  3635,  3637,  3641,  3645,  3649,  3652,  3655,  3657,  3659,
    3661,  3663,  3666,  3668,  3670,  3672,  3674,  3679,  3685,  3687,
    3691,  3695,  3697,  3701,  3705,  3711,  3718,  3720,  3724,  3726,
    3729,  3734,  3740,  3742,  3744,  3746,  3748,  3752,  3756,  3759,
    3762,  3764,  3767,  3770,  3773,  3775,  3778,  3781,  3783,  3785,
    3787,  3791,  3794,  3795,  3798,  3800,  3804,  3810,  3812,  3815,
    3817,  3818,  3824,  3832,  3838,  3846,  3852,  3860,  3864,  3870,
    3876,  3882,  3884,  3888,  3891,  3893,  3896,  3898,  3901,  3913,
    3924,  3935,  3938,  3941,  3942,  3952,  3955,  3956,  3961,  3966,
    3971,  3973,  3975,  3977,  3978,  3987,  3996,  4005,  4015,  4027,
    4039,  4051,  4064,  4070,  4076,  4084,  4091,  4098,  4105,  4112,
    4121,  4130,  4137,  4144,  4152,  4162,  4172,  4179,  4186,  4193,
    4202,  4209,  4218,  4225,  4234,  4242,  4252,  4259,  4268,  4276,
    4286,  4295,  4306,  4316,  4328,  4337,  4347,  4359,  4368,  4377,
    4385,  4392,  4399,  4406,  4415,  4424,  4433,  4442,  4449,  4459,
    4461,  4462,  4465,  4466,  4474,  4481,  4488,  4495,  4502,  4509,
    4517,  4527,  4537,  4544,  4553,  4562,  4571,  4580,  4589,  4596,
    4605,  4612,  4621,  4629,  4639,  4647,  4657,  4664,  4672,  4679,
    4686,  4693,  4700,  4707,  4715,  4723,  4731,  4741,  4751,  4758,
    4765,  4772,  4781,  4790,  4799,  4806,  4814,  4828,  4830,  4832,
    4836,  4840,  4842,  4844,  4846,  4848,  4850,  4852,  4854,  4855,
    4857,  4859,  4861,  4863,  4865,  4867,  4868,  4875,  4884,  4888,
    4891,  4892,  4895,  4898,  4901,  4904,  4908,  4912,  4915,  4918,
    4921,  4924,  4928,  4931,  4937,  4942,  4946,  4950,  4954,  4956,
    4958,  4959,  4963,  4966,  4969,  4971,  4974,  4976,  4980,  4983,
    4985,  4986,  4996,  5008,  5021,  5036,  5040,  5045,  5050,  5051,
    5054,  5060,  5063,  5064,  5068,  5072,  5076,  5080,  5084,  5088,
    5092,  5096,  5100,  5104,  5108,  5112,  5116,  5121,  5125,  5129,
    5131,  5132,  5138,  5145,  5150,  5153,  5154,  5159,  5163,  5169,
    5174,  5181,  5186,  5193,  5200,  5206,  5214,  5224,  5231,  5233,
    5234,  5241,  5253,  5265,  5277,  5291,  5301,  5313,  5324,  5329,
    5332,  5338,  5341,  5342,  5347,  5353,  5359,  5364,  5371,  5373,
    5377,  5379,  5381,  5383,  5385,  5388,  5393,  5395,  5397,  5399,
    5400,  5402,  5403,  5405,  5406,  5410,  5411,  5414,  5419,  5423,
    5429,  5431,  5433,  5435,  5437,  5439,  5441,  5443,  5445,  5447,
    5449,  5453,  5456,  5458,  5460,  5462,  5464,  5465,  5471,  5476,
    5480,  5481,  5483,  5485,  5487,  5489,  5494,  5504,  5508,  5509,
    5516,  5518,  5523,  5526,  5528,  5532,  5535,  5539,  5540,  5548,
    5551,  5552,  5558,  5562,  5563,  5566,  5569,  5572,  5576,  5578,
    5582,  5584,  5587,  5589,  5590,  5599,  5601,  5605,  5607,  5609,
    5613,  5619,  5622,  5624,  5628,  5636,  5638,  5640,  5641,  5645,
    5648,  5651,  5654,  5655,  5658,  5661,  5663,  5665,  5669,  5673,
    5675,  5678,  5683,  5688,  5691,  5695,  5701,  5707,  5709,  5711,
    5721,  5723,  5726,  5731,  5736,  5741,  5744,  5748,  5750,  5754,
    5761,  5763,  5764,  5767,  5769,  5770,  5774,  5778,  5783,  5788,
    5793,  5798,  5802,  5805,  5807,  5809,  5810,  5812,  5814,  5815,
    5817,  5823,  5825,  5826,  5828,  5829,  5833,  5835,  5839,  5844,
    5848,  5851,  5854,  5856,  5858,  5860,  5861,  5864,  5869,  5875,
    5878,  5882,  5884,  5886,  5888,  5890,  5894,  5895,  5897,  5899,
    5901,  5903,  5905,  5909,  5910,  5913,  5914,  5916,  5920,  5922,
    5923,  5925,  5928,  5932,  5935,  5940,  5943,  5947,  5950,  5951,
    5954,  5958,  5961,  5962,  5964,  5968,  5971,  5974,  5978,  5981,
    5985,  5987,  5992,  5996,  6001,  6007,  6012,  6018,  6023,  6029,
    6032,  6037,  6039,  6041,  6042,  6044,  6049,  6055,  6060,  6061,
    6064,  6067,  6070,  6072,  6074,  6075,  6080,  6083,  6085,  6088,
    6091,  6096,  6098,  6102,  6104,  6107,  6111,  6114,  6121,  6124,
    6126,  6130,  6135,  6136,  6138,  6139,  6142,  6143,  6146,  6151,
    6152,  6154,  6155,  6157,  6161,  6165,  6168,  6172,  6178,  6185,
    6188,  6192,  6196,  6201,  6202,  6204,  6206,  6208,  6210,  6212,
    6215,  6221,  6223,  6225,  6227,  6229,  6232,  6236,  6240,  6241,
    6243,  6245,  6247,  6249,  6251,  6254,  6257,  6260,  6263,  6266,
    6268,  6272,  6273,  6275,  6277,  6279,  6281,  6287,  6290,  6292,
    6294,  6296,  6298,  6304,  6307,  6310,  6313,  6315,  6319,  6323,
    6326,  6328,  6329,  6333,  6334,  6340,  6343,  6349,  6352,  6354,
    6357,  6361,  6362,  6364,  6366,  6368,  6370,  6372,  6374,  6378,
    6382,  6386,  6390,  6394,  6398,  6402,  6403,  6405,  6410,  6412,
    6416,  6420,  6426,  6429,  6432,  6436,  6440,  6444,  6448,  6452,
    6456,  6460,  6464,  6468,  6472,  6475,  6478,  6482,  6486,  6489,
    6493,  6499,  6504,  6511,  6515,  6521,  6526,  6533,  6538,  6545,
    6551,  6559,  6563,  6566,  6571,  6574,  6578,  6582,  6587,  6591,
    6596,  6600,  6605,  6611,  6618,  6625,  6633,  6640,  6648,  6655,
    6663,  6667,  6672,  6677,  6684,  6687,  6691,  6696,  6698,  6702,
    6705,  6708,  6712,  6716,  6720,  6724,  6728,  6732,  6736,  6740,
    6744,  6748,  6751,  6754,  6760,  6767,  6774,  6782,  6786,  6791,
    6793,  6795,  6798,  6803,  6805,  6807,  6809,  6812,  6815,  6818,
    6821,  6823,  6827,  6833,  6840,  6849,  6856,  6863,  6868,  6873,
    6875,  6877,  6879,  6885,  6887,  6889,  6894,  6896,  6901,  6903,
    6908,  6910,  6915,  6917,  6919,  6921,  6923,  6925,  6927,  6934,
    6939,  6944,  6949,  6954,  6961,  6967,  6973,  6979,  6984,  6991,
    6996,  7001,  7006,  7011,  7017,  7025,  7033,  7043,  7049,  7054,
    7061,  7067,  7075,  7083,  7091,  7094,  7098,  7102,  7106,  7111,
    7112,  7117,  7119,  7123,  7127,  7129,  7131,  7133,  7136,  7139,
    7140,  7143,  7148,  7153,  7160,  7166,  7167,  7173,  7174,  7177,
    7178,  7180,  7184,  7188,  7191,  7194,  7195,  7202,  7204,  7205,
    7209,  7210,  7213,  7216,  7217,  7219,  7224,  7227,  7230,  7233,
    7236,  7239,  7244,  7248,  7254,  7256,  7258,  7260,  7262,  7264,
    7266,  7268,  7270,  7272,  7274,  7276,  7278,  7280,  7282,  7284,
    7289,  7291,  7296,  7298,  7303,  7305,  7308,  7310,  7313,  7315,
    7319,  7321,  7325,  7327,  7331,  7333,  7337,  7341,  7345,  7348,
    7350,  7354,  7358,  7359,  7361,  7363,  7365,  7367,  7369,  7371,
    7373,  7375,  7380,  7384,  7387,  7391,  7392,  7396,  7400,  7403,
    7406,  7408,  7409,  7412,  7415,  7419,  7422,  7424,  7426,  7430,
    7436,  7438,  7441,  7446,  7449,  7450,  7452,  7453,  7455,  7458,
    7461,  7464,  7468,  7474,  7476,  7479,  7480,  7483,  7485,  7486,
    7488,  7490,  7492,  7496,  7500,  7502,  7503,  7505,  7509,  7513,
    7516,  7518,  7520,  7522,  7526,  7528,  7531,  7533,  7537,  7539,
    7541,  7543,  7545,  7547,  7549,  7551,  7554,  7556,  7558,  7560,
    7562,  7564,  7567,  7574,  7577,  7581,  7588,  7590,  7592,  7594,
    7596,  7598,  7600,  7602,  7604,  7608,  7610,  7612,  7615,  7618,
    7620,  7622,  7624,  7626,  7628,  7630,  7632,  7634,  7636,  7638,
    7640,  7642,  7644,  7646,  7648,  7650,  7652,  7654,  7656,  7658,
    7660,  7662,  7664,  7666,  7668,  7670,  7672,  7674,  7676,  7678,
    7680,  7682,  7684,  7686,  7688,  7690,  7692,  7694,  7696,  7698,
    7700,  7702,  7704,  7706,  7708,  7710,  7712,  7714,  7716,  7718,
    7720,  7722,  7724,  7726,  7728,  7730,  7732,  7734,  7736,  7738,
    7740,  7742,  7744,  7746,  7748,  7750,  7752,  7754,  7756,  7758,
    7760,  7762,  7764,  7766,  7768,  7770,  7772,  7774,  7776,  7778,
    7780,  7782,  7784,  7786,  7788,  7790,  7792,  7794,  7796,  7798,
    7800,  7802,  7804,  7806,  7808,  7810,  7812,  7814,  7816,  7818,
    7820,  7822,  7824,  7826,  7828,  7830,  7832,  7834,  7836,  7838,
    7840,  7842,  7844,  7846,  7848,  7850,  7852,  7854,  7856,  7858,
    7860,  7862,  7864,  7866,  7868,  7870,  7872,  7874,  7876,  7878,
    7880,  7882,  7884,  7886,  7888,  7890,  7892,  7894,  7896,  7898,
    7900,  7902,  7904,  7906,  7908,  7910,  7912,  7914,  7916,  7918,
    7920,  7922,  7924,  7926,  7928,  7930,  7932,  7934,  7936,  7938,
    7940,  7942,  7944,  7946,  7948,  7950,  7952,  7954,  7956,  7958,
    7960,  7962,  7964,  7966,  7968,  7970,  7972,  7974,  7976,  7978,
    7980,  7982,  7984,  7986,  7988,  7990,  7992,  7994,  7996,  7998,
    8000,  8002,  8004,  8006,  8008,  8010,  8012,  8014,  8016,  8018,
    8020,  8022,  8024,  8026,  8028,  8030,  8032,  8034,  8036,  8038,
    8040,  8042,  8044,  8046,  8048,  8050,  8052,  8054,  8056,  8058,
    8060,  8062,  8064,  8066,  8068,  8070,  8072,  8074,  8076,  8078,
    8080,  8082,  8084,  8086,  8088,  8090,  8092,  8094,  8096,  8098,
    8100,  8102,  8104,  8106,  8108,  8110,  8112,  8114,  8116,  8118,
    8120,  8122,  8124,  8126,  8128,  8130,  8132,  8134,  8136,  8138,
    8140,  8142,  8144,  8146,  8148,  8150,  8152,  8154,  8156,  8158,
    8160,  8162,  8164,  8166,  8168,  8170,  8172,  8174,  8176,  8178,
    8180,  8182,  8184,  8186,  8188,  8190,  8192,  8194,  8196,  8198,
    8200,  8202,  8204,  8206,  8208,  8210,  8212,  8214,  8216,  8218,
    8220,  8222,  8224,  8226,  8228,  8230,  8232,  8234,  8236,  8238,
    8240,  8242,  8244,  8246,  8248,  8250,  8252,  8254,  8256,  8258,
    8260,  8262,  8264,  8266,  8268,  8270,  8272,  8274,  8276,  8278,
    8280,  8282,  8284,  8286,  8288,  8290,  8292,  8294,  8296,  8298,
    8300,  8302,  8304,  8306,  8308,  8310,  8312,  8314,  8316,  8318,
    8320,  8322,  8324,  8326,  8328,  8330,  8332,  8334,  8336,  8338,
    8340,  8342,  8344,  8346,  8348,  8350,  8352,  8354,  8356,  8358,
    8360,  8362,  8364,  8366,  8368,  8370,  8372,  8374,  8376,  8378,
    8380,  8382,  8384,  8386,  8388,  8390,  8392,  8394,  8396,  8398,
    8400,  8402,  8404,  8406,  8408,  8409,  8412,  8417,  8421,  8424,
    8426,  8428,  8430,  8432,  8434,  8435,  8444,  8447,  8453,  8457,
    8460,  8463,  8467,  8475,  8477,  8479,  8481,  8482,  8485,  8488,
    8490,  8491,  8493,  8497,  8499,  8502,  8503,  8506,  8507,  8510,
    8511,  8513,  8517,  8522,  8526,  8528,  8530,  8532,  8534,  8537,
    8538,  8541,  8546,  8547,  8550,  8553,  8556,  8558,  8560,  8568,
    8572,  8574,  8576,  8578,  8580,  8583,  8584,  8586,  8590,  8594,
    8598,  8602,  8603,  8608,  8614,  8620,  8621,  8623,  8625,  8627,
    8630,  8633,  8635,  8638,  8639,  8647,  8648,  8654,  8655,  8660,
    8663,  8666,  8667,  8670,  8672,  8674,  8676,  8678,  8680,  8682,
    8684,  8686,  8688,  8690,  8692,  8698,  8701,  8703,  8707,  8710,
    8713,  8717,  8718,  8724,  8726,  8727,  8733,  8736,  8739,  8741,
    8743,  8745,  8748,  8751,  8755,  8757,  8760,  8763,  8767,  8771,
    8776,  8779,  8781,  8784,  8786,  8788,  8791,  8794,  8798,  8800,
    8802,  8804,  8806,  8807,  8809,  8813,  8819,  8820,  8823,  8824,
    8826,  8829,  8833,  8836,  8838,  8840,  8842,  8843,  8845,  8847,
    8849,  8851,  8853,  8856,  8859,  8863,  8864,  8866,  8869,  8871,
    8876,  8880,  8885,  8889,  8892,  8894,  8898,  8900,  8902,  8904,
    8906,  8909,  8912,  8914,  8917,  8920,  8922,  8924,  8926,  8931,
    8936,  8941,  8946,  8951,  8953,  8954,  8958,  8962,  8967,  8969,
    8973,  8977,  8982,  8984,  8988,  8992,  8994,  8996,  8998,  9005,
    9007,  9011,  9015,  9022,  9024,  9028,  9032,  9034,  9036,  9039,
    9042,  9044,  9046,  9048,  9050,  9052,  9054,  9056,  9058,  9060,
    9062,  9064,  9066,  9068,  9070,  9072,  9074,  9079,  9084,  9086,
    9088,  9093,  9098,  9102,  9103,  9111,  9113,  9114,  9115,  9123,
    9127,  9132,  9136,  9138,  9140,  9142,  9145,  9149,  9155,  9158,
    9164,  9167,  9169,  9171,  9173,  9175,  9177,  9179,  9181,  9183,
    9185,  9187,  9189,  9191,  9193,  9195,  9197,  9199,  9201,  9203,
    9205,  9207,  9209,  9211,  9213,  9215,  9217,  9219,  9221,  9223,
    9225,  9227,  9229,  9231,  9233,  9235,  9237,  9239,  9241,  9243,
    9245,  9247,  9249,  9251,  9253,  9255,  9257,  9259,  9261,  9263,
    9265,  9267,  9269,  9271,  9273,  9275,  9277,  9279,  9281,  9283,
    9285,  9287,  9289,  9291,  9293,  9295,  9297,  9299,  9301,  9303,
    9305,  9307,  9309,  9311,  9313,  9315,  9317,  9319,  9321,  9323,
    9325,  9327,  9329,  9331,  9333,  9335,  9337,  9339,  9341,  9343,
    9345,  9347,  9349,  9351,  9353,  9355,  9357,  9359,  9361,  9363,
    9367,  9369,  9370,  9372,  9375,  9377,  9380,  9382,  9384,  9386,
    9389,  9392,  9394,  9396,  9398,  9400,  9402,  9404,  9406,  9408,
    9410,  9412,  9414,  9416,  9418,  9420,  9422,  9424,  9427,  9431,
    9433,  9436,  9438,  9442,  9444,  9448,  9450,  9452,  9454,  9456,
    9458,  9460,  9462,  9464,  9466,  9468,  9470,  9472,  9474,  9476,
    9478,  9480,  9482,  9484,  9486,  9488,  9490,  9492,  9494,  9496,
    9498,  9500,  9502,  9504,  9506,  9508,  9510,  9512,  9514,  9516,
    9518,  9520,  9522,  9524,  9526,  9528,  9530,  9532,  9534,  9536,
    9538,  9540,  9542,  9544,  9546,  9548,  9550,  9552,  9554,  9556,
    9558,  9560,  9562,  9564,  9566,  9568,  9570,  9573,  9577,  9580,
    9584,  9586,  9590,  9594,  9598,  9602,  9606,  9610,  9612,  9614,
    9619,  9620,  9623,  9626,  9628,  9630,  9633,  9635,  9637,  9639,
    9640
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     522,     0,    -1,  1088,    -1,   712,    -1,   862,    -1,   863,
      -1,   776,    -1,   869,    -1,   726,    -1,   664,    -1,   667,
      -1,   673,    -1,   687,    -1,   689,    -1,   814,    -1,   539,
      -1,   836,    -1,   837,    -1,   643,    -1,   867,    -1,   567,
      -1,   832,    -1,   579,    -1,   533,    -1,   531,    -1,   872,
      -1,   871,    -1,   693,    -1,   535,    -1,   534,    -1,   879,
      -1,   565,    -1,   582,    -1,   874,    -1,   750,    -1,   562,
      -1,   583,    -1,  1090,    -1,   714,    -1,   825,    -1,   873,
      -1,   868,    -1,   661,    -1,   668,    -1,   682,    -1,   688,
      -1,   792,    -1,   538,    -1,   638,    -1,   728,    -1,   735,
      -1,   736,    -1,   650,    -1,   542,    -1,   642,    -1,   599,
      -1,   658,    -1,   694,    -1,   708,    -1,   524,    -1,   530,
      -1,   690,    -1,   858,    -1,  1231,    -1,   914,    -1,   716,
      -1,   901,    -1,   566,    -1,   822,    -1,   715,    -1,   827,
      -1,   672,    -1,   686,    -1,   541,    -1,   739,    -1,   740,
      -1,   741,    -1,   656,    -1,   845,    -1,   743,    -1,   660,
      -1,   707,    -1,   536,    -1,   537,    -1,   692,    -1,   866,
      -1,   894,    -1,   885,    -1,   757,    -1,   761,    -1,   772,
      -1,   781,    -1,   896,    -1,   848,    -1,   641,    -1,   857,
      -1,   903,    -1,   846,    -1,   891,    -1,   742,    -1,   829,
      -1,   818,    -1,   817,    -1,   819,    -1,   833,    -1,   762,
      -1,   773,    -1,   838,    -1,   753,    -1,   918,    -1,   850,
      -1,   748,    -1,   849,    -1,   907,    -1,   876,    -1,   558,
      -1,   546,    -1,   561,    -1,   855,    -1,  1167,    -1,  1093,
      -1,  1110,    -1,  1168,    -1,  1150,    -1,  1165,    -1,  1151,
      -1,  1111,    -1,  1155,    -1,  1177,    -1,  1169,    -1,  1156,
      -1,  1185,    -1,  1187,    -1,  1180,    -1,  1172,    -1,  1188,
      -1,  1191,    -1,  1193,    -1,    -1,   160,   385,  1080,   525,
     526,    -1,   477,    -1,    -1,   526,   529,    -1,    -1,   527,
     528,    -1,    -1,   346,  1221,    -1,   346,   318,    -1,   202,
     346,  1221,    -1,   449,   346,  1221,    -1,   254,    -1,   152,
     288,  1082,    -1,   460,   455,  1221,    -1,   457,  1081,    -1,
    1223,    -1,   528,    -1,   424,  1079,    -1,    96,  1081,    -1,
     385,  1081,    -1,   249,   385,  1081,    -1,   249,   237,  1081,
      -1,   160,   457,  1080,   525,   526,    -1,   101,   385,  1080,
     525,   527,    -1,    -1,   249,   174,  1072,    -1,   101,   385,
    1080,   532,   559,    -1,   101,   385,    99,   532,   559,    -1,
     101,   457,  1080,   525,   527,    -1,   101,   457,  1080,   559,
      -1,   197,   385,  1081,    -1,   197,   385,   244,   212,  1081,
      -1,   197,   457,  1081,    -1,   197,   457,   244,   212,  1081,
      -1,   160,   237,  1080,   525,   526,    -1,   101,   237,  1080,
     540,   457,  1081,    -1,    95,    -1,   197,    -1,   197,   237,
    1081,    -1,   197,   237,   244,   212,  1081,    -1,   160,   391,
     543,   115,  1080,   544,    -1,   160,   391,  1201,   544,    -1,
     160,   391,   244,   313,   212,   543,   115,  1080,   544,    -1,
     160,   391,   244,   313,   212,  1201,   544,    -1,  1201,    -1,
      -1,   544,   545,    -1,    -1,   599,    -1,   781,    -1,   642,
      -1,   694,    -1,   761,    -1,   855,    -1,   403,   547,    -1,
     403,   291,   547,    -1,   403,   401,   547,    -1,   438,   853,
      -1,   401,   136,   108,   438,   853,    -1,   549,    -1,   550,
     436,   551,    -1,   550,   500,   551,    -1,   550,   436,   180,
      -1,   550,   500,   180,    -1,   548,    -1,   550,   229,   163,
      -1,   434,   495,   555,    -1,   132,  1221,    -1,   391,  1221,
      -1,   306,   556,    -1,   385,   557,    -1,   401,   115,   557,
      -1,   401,   115,   180,    -1,   483,   330,  1014,    -1,   438,
     410,  1221,    -1,  1200,    -1,   550,   515,  1201,    -1,   552,
      -1,   551,   516,   552,    -1,   554,    -1,   648,    -1,   363,
     448,    -1,   363,   149,    -1,   375,   363,    -1,   399,    -1,
     442,    -1,   217,    -1,   327,    -1,   557,    -1,  1221,    -1,
    1223,    -1,   998,  1221,  1000,    -1,   998,   513,  1079,   514,
    1221,  1000,    -1,   648,    -1,   180,    -1,   291,    -1,  1221,
      -1,   180,    -1,    -1,  1083,    -1,  1221,    -1,   378,   550,
      -1,   378,   434,   495,    -1,   378,   438,   272,   286,    -1,
     378,   401,   115,    -1,   378,    99,    -1,   403,   547,    -1,
     558,    -1,   403,   549,    -1,   558,    -1,   406,   550,  1234,
      -1,   406,   434,   495,  1234,    -1,   406,   438,   272,   286,
    1234,    -1,   406,   401,   115,  1234,    -1,   406,    99,    -1,
     403,   154,   563,   564,    -1,    99,    -1,  1068,    -1,   183,
      -1,   246,    -1,   138,    -1,   191,    99,    -1,   191,   429,
      -1,   191,   431,    -1,   191,   348,    -1,   191,   398,    -1,
     101,   426,   965,   568,    -1,   101,   426,   244,   212,   965,
     568,    -1,   101,   252,  1069,   568,    -1,   101,   252,   244,
     212,  1069,   568,    -1,   101,   397,  1069,   568,    -1,   101,
     397,   244,   212,  1069,   568,    -1,   101,   470,  1069,   568,
      -1,   101,   470,   244,   212,  1069,   568,    -1,   101,   298,
     470,  1069,   568,    -1,   101,   298,   470,   244,   212,  1069,
     568,    -1,   569,    -1,   568,   516,   569,    -1,    95,   607,
      -1,    95,   145,   607,    -1,   101,   834,  1201,   570,    -1,
     101,   834,  1201,   197,   313,   318,    -1,   101,   834,  1201,
     403,   313,   318,    -1,   101,   834,  1201,   403,   416,  1082,
      -1,   101,   834,  1201,   403,   575,    -1,   101,   834,  1201,
     378,   575,    -1,   101,   834,  1201,   403,   419,  1201,    -1,
     197,   834,   244,   212,  1201,   571,    -1,   197,   834,  1201,
     571,    -1,   101,   834,  1201,   835,   445,   978,   572,   573,
      -1,   101,   834,  1201,   676,    -1,    95,   616,    -1,   101,
     153,  1071,   705,    -1,   461,   153,  1071,    -1,   197,   153,
     244,   212,  1071,   571,    -1,   197,   153,  1071,   571,    -1,
     403,   477,   326,    -1,   403,   479,   326,    -1,   141,   327,
    1071,    -1,   403,   479,   141,    -1,   200,   440,  1071,    -1,
     200,   102,   440,  1071,    -1,   200,   377,   440,  1071,    -1,
     200,   440,    99,    -1,   200,   440,   457,    -1,   190,   440,
    1071,    -1,   190,   440,    99,    -1,   190,   440,   457,    -1,
     200,   389,  1071,    -1,   200,   102,   389,  1071,    -1,   200,
     377,   389,  1071,    -1,   190,   389,  1071,    -1,   254,  1069,
      -1,   311,   254,  1069,    -1,   323,   746,    -1,   313,   323,
      -1,   341,   436,  1080,    -1,   403,   428,  1071,    -1,   403,
     575,    -1,   378,   575,    -1,   377,   243,   574,    -1,   676,
      -1,   403,   180,  1002,    -1,   197,   180,    -1,   128,    -1,
     380,    -1,    -1,   143,   746,    -1,    -1,   458,  1002,    -1,
      -1,   314,    -1,   230,    -1,   180,    -1,   458,   252,  1071,
      -1,   513,   577,   514,    -1,   477,   575,    -1,    -1,   578,
      -1,   577,   516,   578,    -1,  1203,   500,   720,    -1,  1203,
      -1,  1203,   515,  1203,   500,   720,    -1,  1203,   515,  1203,
      -1,   101,   445,   746,   580,    -1,   581,    -1,   580,   516,
     581,    -1,    95,   114,   977,   571,    -1,   197,   114,   244,
     212,  1201,   571,    -1,   197,   114,  1201,   571,    -1,   101,
     114,  1201,   835,   445,   978,   572,   571,    -1,   140,   915,
      -1,   140,    99,    -1,   158,   590,  1069,   619,   591,   584,
     585,   586,   592,   525,   587,    -1,   158,   919,   436,   585,
     586,   525,   587,    -1,   229,    -1,   436,    -1,   360,    -1,
      -1,  1221,    -1,   417,    -1,   418,    -1,   588,    -1,   513,
     594,   514,    -1,   588,   589,    -1,    -1,   121,    -1,   326,
      -1,   228,    -1,   186,   870,  1221,    -1,   318,   870,  1221,
      -1,   162,    -1,   240,    -1,   361,   870,  1221,    -1,   205,
     870,  1221,    -1,   225,   361,   620,    -1,   225,   361,   506,
      -1,   225,   313,   318,   620,    -1,   225,   318,   620,    -1,
     201,  1221,    -1,   121,    -1,    -1,   477,   326,    -1,    -1,
     593,   187,  1221,    -1,    -1,   458,    -1,    -1,   595,    -1,
     594,   516,   595,    -1,  1203,   596,    -1,   554,    -1,   648,
      -1,   506,    -1,   513,   597,   514,    -1,    -1,   598,    -1,
     597,   516,   598,    -1,   554,    -1,   160,   600,   426,  1069,
     513,   601,   514,   630,   631,   632,   633,    -1,   160,   600,
     426,   244,   313,   212,  1069,   513,   601,   514,   630,   631,
     632,   633,    -1,   160,   600,   426,  1069,   323,   746,   602,
     631,   632,   633,    -1,   160,   600,   426,   244,   313,   212,
    1069,   323,   746,   602,   631,   632,   633,    -1,   431,    -1,
     429,    -1,   291,   431,    -1,   291,   429,    -1,   233,   431,
      -1,   233,   429,    -1,   454,    -1,    -1,   603,    -1,    -1,
     513,   604,   514,    -1,    -1,   605,    -1,   603,   516,   605,
      -1,   606,    -1,   604,   516,   606,    -1,   607,    -1,   613,
      -1,   616,    -1,   608,    -1,   616,    -1,  1201,   978,   674,
     609,    -1,  1201,   477,   331,   609,    -1,   609,   610,    -1,
      -1,   153,  1071,   611,    -1,   611,    -1,   612,    -1,   143,
     746,    -1,   313,   318,    -1,   318,    -1,   451,   811,   634,
      -1,   355,   274,   811,   634,    -1,   137,   513,  1002,   514,
     618,    -1,   180,  1003,    -1,   369,  1069,   619,   622,   626,
      -1,   182,    -1,   313,   182,    -1,   256,   183,    -1,   256,
     246,    -1,   287,  1069,   614,    -1,   614,   250,   615,    -1,
     614,   209,   615,    -1,    -1,   181,    -1,   154,    -1,   253,
      -1,   419,    -1,   147,    -1,    99,    -1,   153,  1071,   617,
      -1,   617,    -1,   137,   513,  1002,   514,   705,    -1,   451,
     513,   620,   514,   811,   634,   705,    -1,   451,   635,   705,
      -1,   355,   274,   513,   620,   514,   811,   634,   705,    -1,
     355,   274,   635,   705,    -1,   208,   785,   513,   623,   514,
     811,   634,   625,   705,    -1,   226,   274,   513,   620,   514,
     369,  1069,   619,   622,   626,   705,    -1,   311,   254,    -1,
      -1,   513,   620,   514,    -1,    -1,   621,    -1,   620,   516,
     621,    -1,  1201,    -1,   297,   230,    -1,   297,   343,    -1,
     297,   408,    -1,    -1,   624,    -1,   623,   516,   624,    -1,
     787,   477,   821,    -1,   787,   477,   329,   513,   821,   514,
      -1,   474,   513,  1002,   514,    -1,    -1,   627,    -1,   628,
      -1,   627,   628,    -1,   628,   627,    -1,    -1,   327,   456,
     629,    -1,   327,   185,   629,    -1,   311,    94,    -1,   380,
      -1,   128,    -1,   403,   318,    -1,   403,   180,    -1,   255,
     513,  1068,   514,    -1,    -1,   477,   575,    -1,   477,   326,
      -1,   479,   326,    -1,    -1,   327,   148,   197,    -1,   327,
     148,   185,   388,    -1,   327,   148,   352,   388,    -1,    -1,
     428,  1071,    -1,    -1,   458,   252,   428,  1071,    -1,    -1,
     458,   252,  1075,    -1,  1069,   619,   631,   632,   633,    -1,
     477,   173,    -1,   477,   311,   173,    -1,    -1,   160,   640,
     298,   470,   639,   108,   918,   637,    -1,  1069,   619,   576,
     633,    -1,   454,    -1,    -1,   370,   298,   470,   783,  1069,
     637,    -1,   160,   600,   397,  1069,   644,    -1,   101,   397,
    1069,   645,    -1,   101,   397,   244,   212,  1069,   645,    -1,
     645,    -1,    -1,   646,    -1,   645,   646,    -1,   126,   648,
      -1,   172,    -1,   311,   172,    -1,   251,   647,   648,    -1,
     299,   648,    -1,   301,   648,    -1,   311,   299,    -1,   311,
     301,    -1,   340,   125,   746,    -1,   414,   525,   648,    -1,
     379,    -1,   379,   525,   648,    -1,   125,    -1,    -1,  1220,
      -1,   505,  1220,    -1,  1082,    -1,   648,    -1,   649,   516,
     648,    -1,   160,   793,   651,   657,   276,   557,    -1,   160,
     793,   651,   657,   276,   557,   238,   652,   653,   655,    -1,
     444,    -1,    -1,  1071,    -1,  1071,   747,    -1,   257,   652,
      -1,    -1,   462,   652,    -1,   311,   462,    -1,   654,    -1,
      -1,   197,   657,   276,   557,   571,    -1,   197,   657,   276,
     244,   212,   557,   571,    -1,   358,    -1,    -1,   160,   428,
    1071,   659,   294,  1221,   576,    -1,   341,  1071,    -1,    -1,
     197,   428,  1071,    -1,   197,   428,   244,   212,  1071,    -1,
     160,   214,  1071,   525,   662,    -1,   160,   214,   244,   313,
     212,  1071,   525,   662,    -1,   662,   663,    -1,    -1,   391,
    1071,    -1,   469,   557,    -1,   229,   557,    -1,   101,   214,
    1071,   456,   665,    -1,   665,   666,    -1,    -1,   436,   557,
      -1,   101,   214,  1071,   540,    98,  1077,   805,    -1,   101,
     214,  1071,   540,   131,   513,   978,   108,   978,   514,    -1,
     101,   214,  1071,   540,   144,   746,    -1,   101,   214,  1071,
     540,   157,   746,    -1,   101,   214,  1071,   540,   195,   746,
      -1,   101,   214,  1071,   540,   231,   771,    -1,   101,   214,
    1071,   540,   657,   276,  1071,    -1,   101,   214,  1071,   540,
     329,   821,   820,    -1,   101,   214,  1071,   540,   329,   139,
     746,   458,  1073,    -1,   101,   214,  1071,   540,   329,   218,
     746,   458,  1073,    -1,   101,   214,  1071,   540,   391,  1071,
      -1,   101,   214,  1071,   540,   206,   440,  1071,    -1,   101,
     214,  1071,   540,   426,   746,    -1,   101,   214,  1071,   540,
     432,   393,   342,   746,    -1,   101,   214,  1071,   540,   432,
     393,   189,   746,    -1,   101,   214,  1071,   540,   432,   393,
     430,   746,    -1,   101,   214,  1071,   540,   432,   393,   151,
     746,    -1,   101,   214,  1071,   540,   397,   746,    -1,   101,
     214,  1071,   540,   470,   746,    -1,   101,   214,  1071,   540,
     298,   470,   746,    -1,   101,   214,  1071,   540,   226,   426,
     746,    -1,   101,   214,  1071,   540,   226,   173,   481,  1071,
      -1,   101,   214,  1071,   540,   400,  1071,    -1,   101,   214,
    1071,   540,   445,   746,    -1,   160,   226,   173,   481,  1071,
     671,   674,    -1,   238,   652,    -1,   311,   238,    -1,   462,
     652,    -1,   311,   462,    -1,   669,    -1,   670,   669,    -1,
     670,    -1,    -1,   197,   226,   173,   481,  1071,   571,    -1,
     197,   226,   173,   481,   244,   212,  1071,   571,    -1,   101,
     226,   173,   481,  1071,   671,   676,    -1,   101,   226,   173,
     481,  1071,   670,    -1,   331,   513,   675,   514,    -1,    -1,
     679,    -1,   675,   516,   679,    -1,   331,   513,   677,   514,
      -1,   678,    -1,   677,   516,   678,    -1,   679,    -1,   403,
     679,    -1,    95,   679,    -1,   197,   680,    -1,   680,   681,
      -1,  1203,    -1,  1221,    -1,   160,   400,  1071,   683,   685,
     226,   173,   481,  1071,   674,    -1,   445,  1221,    -1,    -1,
     469,  1221,    -1,   469,   318,    -1,   684,    -1,    -1,   197,
     400,  1071,   571,    -1,   197,   400,   244,   212,  1071,   571,
      -1,   101,   400,  1071,   684,   676,    -1,   101,   400,  1071,
     684,    -1,   101,   400,  1071,   676,    -1,   160,   226,   426,
    1069,   513,   601,   514,   400,  1071,   674,    -1,   160,   226,
     426,   244,   313,   212,  1069,   513,   601,   514,   400,  1071,
     674,    -1,   101,   226,   426,   965,   568,    -1,   101,   226,
     426,   244,   212,   965,   568,    -1,   160,   457,   296,   224,
     691,   400,  1071,   674,    -1,   170,    -1,   457,    -1,  1080,
      -1,   197,   457,   296,   224,   691,   400,  1071,    -1,   197,
     457,   296,   244,   212,   224,   691,   400,  1071,    -1,   101,
     457,   296,   224,   691,   400,  1071,   676,    -1,   160,   440,
    1071,   695,   696,   327,  1069,   698,   701,   211,   359,  1077,
     513,   702,   514,    -1,   160,   153,   440,  1071,    97,   696,
     327,  1069,   704,   705,   224,   198,   387,   701,   211,   359,
    1077,   513,   702,   514,    -1,   117,    -1,    97,    -1,   263,
     323,    -1,   697,    -1,   696,   332,   697,    -1,   262,    -1,
     185,    -1,   456,    -1,   456,   323,   620,    -1,   443,    -1,
     224,   699,   700,    -1,    -1,   198,    -1,    -1,   387,    -1,
     415,    -1,   473,   513,  1002,   514,    -1,    -1,   703,    -1,
     702,   516,   703,    -1,    -1,  1079,    -1,  1220,    -1,  1221,
      -1,  1203,    -1,   229,  1069,    -1,    -1,    -1,   705,   706,
      -1,   313,   182,    -1,   182,    -1,   256,   246,    -1,   256,
     183,    -1,   313,   460,    -1,   311,   254,    -1,   197,   440,
    1071,   327,   746,   571,    -1,   197,   440,   244,   212,  1071,
     327,   746,   571,    -1,   160,   206,   440,  1071,   327,  1203,
     211,   359,  1077,   513,   514,    -1,   160,   206,   440,  1071,
     327,  1203,   473,   709,   211,   359,  1077,   513,   514,    -1,
     710,    -1,   709,   105,   710,    -1,  1201,   249,   513,   711,
     514,    -1,    82,    -1,   711,   516,    82,    -1,   101,   206,
     440,  1071,   713,    -1,   200,    -1,   200,   377,    -1,   200,
     102,    -1,   190,    -1,   160,   110,  1071,   137,   513,  1002,
     514,   705,    -1,   197,   110,  1071,   571,    -1,   160,    98,
    1077,   805,   717,    -1,   160,    98,  1077,   721,    -1,   160,
     329,   821,   717,    -1,   160,   445,   746,   717,    -1,   160,
     445,   746,    -1,   160,   445,   746,   108,   513,   975,   514,
      -1,   160,   445,   746,   108,   204,   513,   724,   514,    -1,
     160,   445,   746,   108,   362,   717,    -1,   160,   432,   393,
     342,   746,   717,    -1,   160,   432,   393,   189,   746,   717,
      -1,   160,   432,   393,   430,   746,   717,    -1,   160,   432,
     393,   151,   746,   717,    -1,   160,   144,   746,   717,    -1,
     160,   144,   746,   229,   746,    -1,   513,   718,   514,    -1,
     719,    -1,   718,   516,   719,    -1,  1203,   500,   720,    -1,
    1203,    -1,   802,    -1,  1087,    -1,  1034,    -1,   648,    -1,
    1221,    -1,   513,   722,   514,    -1,   723,    -1,   722,   516,
     723,    -1,  1223,   500,   720,    -1,   725,    -1,    -1,  1221,
      -1,   725,   516,  1221,    -1,   101,   445,   746,    95,   463,
     727,  1221,    -1,   101,   445,   746,    95,   463,   727,  1221,
     117,  1221,    -1,   101,   445,   746,    95,   463,   727,  1221,
      97,  1221,    -1,   244,   313,   212,    -1,    -1,   160,   329,
     139,   746,   731,   224,   445,   978,   458,  1073,   732,   108,
     729,    -1,   730,    -1,   729,   516,   730,    -1,   329,  1079,
     821,   733,   734,    -1,   329,  1079,   821,   820,   733,   734,
      -1,   231,  1079,  1077,   794,    -1,   231,  1079,   513,  1039,
     514,  1077,   794,    -1,   419,   978,    -1,   180,    -1,    -1,
     218,   746,    -1,    -1,   224,   393,    -1,   224,   333,   125,
     746,    -1,    -1,   366,    -1,    -1,   160,   329,   218,   746,
     458,  1073,    -1,   101,   329,   218,   746,   458,  1073,    95,
     729,    -1,   101,   329,   218,   746,   458,  1073,   197,   737,
      -1,   738,    -1,   737,   516,   738,    -1,   329,  1079,   513,
    1039,   514,    -1,   231,  1079,   513,  1039,   514,    -1,   197,
     329,   139,   746,   458,  1073,   571,    -1,   197,   329,   139,
     244,   212,   746,   458,  1073,   571,    -1,   197,   329,   218,
     746,   458,  1073,   571,    -1,   197,   329,   218,   244,   212,
     746,   458,  1073,   571,    -1,   197,   340,   125,  1081,   571,
      -1,   365,   340,   125,  1081,   436,  1071,    -1,   197,   744,
     244,   212,   745,   571,    -1,   197,   744,   745,   571,    -1,
     197,   252,   150,   745,   571,    -1,   197,   252,   150,   244,
     212,   745,   571,    -1,   426,    -1,   397,    -1,   470,    -1,
     298,   470,    -1,   252,    -1,   226,   426,    -1,   206,   440,
      -1,   445,    -1,   195,    -1,   144,    -1,   157,    -1,   391,
      -1,   214,    -1,   432,   393,   342,    -1,   432,   393,   189,
      -1,   432,   393,   430,    -1,   432,   393,   151,    -1,   746,
      -1,   745,   516,   746,    -1,  1201,    -1,  1201,   747,    -1,
     515,  1074,    -1,   747,   515,  1074,    -1,   443,   929,   966,
     749,   571,    -1,   156,   243,    -1,   379,   243,    -1,    -1,
     146,   327,   751,   746,   270,   752,    -1,   146,   327,    98,
    1077,   805,   270,   752,    -1,   146,   327,   231,  1077,   794,
     270,   752,    -1,   146,   327,   329,   821,   820,   270,   752,
      -1,   146,   327,   153,  1071,   327,   746,   270,   752,    -1,
     146,   327,   389,  1071,   327,   746,   270,   752,    -1,   146,
     327,   389,  1071,   270,   752,    -1,   146,   327,   440,  1071,
     327,   746,   270,   752,    -1,   146,   327,   329,   139,   746,
     458,  1073,   270,   752,    -1,   146,   327,   329,   218,   746,
     458,  1073,   270,   752,    -1,   146,   327,   277,   322,   648,
     270,   752,    -1,   146,   327,   131,   513,   978,   108,   978,
     514,   270,   752,    -1,   146,   327,   657,   276,   746,   270,
     752,    -1,   145,    -1,   174,    -1,   391,    -1,   252,    -1,
     397,    -1,   426,    -1,   195,    -1,   445,    -1,   470,    -1,
     298,   470,    -1,   144,    -1,   157,    -1,   428,    -1,   214,
      -1,   385,    -1,   226,   426,    -1,   400,    -1,   226,   173,
     481,    -1,   206,   440,    -1,   432,   393,   151,    -1,   432,
     393,   189,    -1,   432,   393,   342,    -1,   432,   393,   430,
      -1,  1221,    -1,   318,    -1,   395,   275,   754,   327,   755,
     746,   270,   756,    -1,   395,   275,   754,   327,    98,  1077,
     805,   270,   756,    -1,   395,   275,   754,   327,   231,  1077,
     794,   270,   756,    -1,   395,   275,   754,   327,   277,   322,
     648,   270,   756,    -1,   395,   275,   754,   327,   657,   276,
     746,   270,   756,    -1,   224,   557,    -1,    -1,   145,    -1,
     174,    -1,   206,   440,    -1,   226,   426,    -1,   391,    -1,
     397,    -1,   426,    -1,   195,    -1,   385,    -1,   428,    -1,
     445,    -1,   470,    -1,   298,   470,    -1,  1221,    -1,   318,
      -1,   219,   758,    -1,   304,   758,    -1,   219,   758,  1235,
      -1,   219,   227,   915,  1236,    -1,   219,   227,   759,   915,
    1236,    -1,   219,   116,   915,  1236,    -1,   219,   116,   759,
     915,  1236,    -1,   304,   227,   915,    -1,   304,   227,   759,
     915,    -1,   304,   116,   915,    -1,   304,   116,   759,   915,
      -1,   915,    -1,   759,   915,    -1,   310,   760,   915,    -1,
     356,   760,   915,    -1,   221,   760,   915,    -1,   278,   760,
     915,    -1,    92,  1082,   760,   915,    -1,   372,  1082,   760,
     915,    -1,  1082,   760,   915,    -1,    99,   760,   915,    -1,
     227,  1082,   760,   915,    -1,   227,    99,   760,   915,    -1,
     116,  1082,   760,   915,    -1,   116,    99,   760,   915,    -1,
     229,    -1,   249,    -1,   759,    -1,    -1,   234,   763,   327,
     766,   436,   767,   769,    -1,   383,   763,   327,   766,   229,
     767,   571,    -1,   383,   234,   330,   224,   763,   327,   766,
     229,   767,   571,    -1,   764,    -1,    99,    -1,    99,   357,
      -1,    99,   513,   620,   514,    -1,    99,   357,   513,   620,
     514,    -1,   765,    -1,   764,   516,   765,    -1,   396,   619,
      -1,   369,   619,    -1,   160,   619,    -1,  1201,   619,    -1,
    1068,    -1,   426,  1068,    -1,   397,  1068,    -1,   226,   173,
     481,  1070,    -1,   226,   400,  1070,    -1,   231,   770,    -1,
     174,  1070,    -1,   195,   745,    -1,   276,  1070,    -1,   277,
     322,   649,    -1,   391,  1070,    -1,   428,  1070,    -1,   445,
     745,    -1,    99,   427,   249,   391,  1070,    -1,    99,   398,
     249,   391,  1070,    -1,    99,   232,   249,   391,  1070,    -1,
     768,    -1,   767,   516,   768,    -1,  1080,    -1,   237,  1080,
      -1,   477,   234,   330,    -1,    -1,   771,    -1,   770,   516,
     771,    -1,  1077,   794,    -1,   234,   764,   436,  1081,   774,
     775,    -1,   383,   764,   229,  1081,   775,   571,    -1,   383,
      96,   330,   224,   764,   229,  1081,   775,   571,    -1,   477,
      96,   330,    -1,    -1,   235,   125,  1080,    -1,    -1,   101,
     180,   357,   777,   779,    -1,   777,   778,    -1,    -1,   249,
     391,  1070,    -1,   224,   385,  1081,    -1,   224,   457,  1081,
      -1,   234,   763,   327,   780,   436,   767,   769,    -1,   383,
     763,   327,   780,   229,   767,   571,    -1,   383,   234,   330,
     224,   763,   327,   780,   229,   767,   571,    -1,   427,    -1,
     232,    -1,   398,    -1,   446,    -1,   160,   782,   252,   783,
     784,   327,  1069,   785,   513,   786,   514,   576,   633,   973,
      -1,   451,    -1,    -1,   150,    -1,    -1,  1075,    -1,    -1,
     458,  1073,    -1,    -1,   787,    -1,   786,   516,   787,    -1,
    1201,   788,   789,   790,   791,    -1,  1007,   788,   789,   790,
     791,    -1,   513,  1002,   514,   788,   789,   790,   791,    -1,
     143,   746,    -1,    -1,   746,    -1,   458,   746,    -1,    -1,
     109,    -1,   188,    -1,    -1,   496,    -1,   497,    -1,    -1,
     160,   793,   231,  1077,   796,   382,   801,   807,   811,    -1,
     160,   793,   231,  1077,   796,   382,   426,   513,   813,   514,
     807,   811,    -1,   160,   793,   231,  1077,   796,   807,   811,
      -1,   332,   376,    -1,    -1,   513,   795,   514,    -1,   513,
     514,    -1,   798,    -1,   795,   516,   798,    -1,   513,   797,
     514,    -1,   513,   514,    -1,   803,    -1,   797,   516,   803,
      -1,   799,   800,   802,    -1,   800,   799,   802,    -1,   800,
     802,    -1,   799,   802,    -1,   802,    -1,   249,    -1,   335,
      -1,   259,    -1,   249,   335,    -1,   466,    -1,  1202,    -1,
     802,    -1,   978,    -1,  1202,   747,   508,   445,    -1,   404,
    1202,   747,   508,   445,    -1,   798,    -1,   798,   180,  1002,
      -1,   798,   500,  1002,    -1,   798,    -1,   513,   506,   514,
      -1,   513,   806,   514,    -1,   513,   333,   125,   806,   514,
      -1,   513,   806,   333,   125,   806,   514,    -1,   804,    -1,
     806,   516,   804,    -1,   809,    -1,   807,   809,    -1,   127,
     327,   318,   260,    -1,   382,   318,   327,   318,   260,    -1,
     420,    -1,   247,    -1,   412,    -1,   472,    -1,   215,   395,
     184,    -1,   215,   395,   269,    -1,   395,   184,    -1,   395,
     269,    -1,   283,    -1,   313,   283,    -1,   159,   648,    -1,
     388,   648,    -1,   560,    -1,   108,   810,    -1,   276,   557,
      -1,   476,    -1,   808,    -1,  1221,    -1,  1221,   516,  1221,
      -1,   477,   717,    -1,    -1,   800,   802,    -1,   812,    -1,
     813,   516,   812,    -1,   101,   231,   771,   815,   816,    -1,
     808,    -1,   815,   808,    -1,   380,    -1,    -1,   197,   231,
    1077,   794,   571,    -1,   197,   231,   244,   212,  1077,   794,
     571,    -1,   197,    98,  1077,   805,   571,    -1,   197,    98,
     244,   212,  1077,   805,   571,    -1,   197,   329,   821,   820,
     571,    -1,   197,   329,   244,   212,   821,   820,   571,    -1,
     513,   978,   514,    -1,   513,   978,   516,   978,   514,    -1,
     513,   312,   516,   978,   514,    -1,   513,   978,   516,   312,
     514,    -1,  1031,    -1,  1201,   515,   821,    -1,   193,   823,
      -1,   824,    -1,   823,   824,    -1,  1221,    -1,   276,   557,
      -1,   160,   131,   513,   978,   108,   978,   514,   477,   231,
     771,   826,    -1,   160,   131,   513,   978,   108,   978,   514,
     479,   231,   826,    -1,   160,   131,   513,   978,   108,   978,
     514,   477,   259,   826,    -1,   108,   248,    -1,   108,   111,
      -1,    -1,   197,   131,   828,   513,   978,   108,   978,   514,
     571,    -1,   244,   212,    -1,    -1,   371,   830,  1069,   831,
      -1,   371,   425,  1071,   831,    -1,   371,   174,  1071,   831,
      -1,   252,    -1,   426,    -1,   225,    -1,    -1,   101,   428,
    1071,   304,    99,   436,  1071,   906,    -1,   101,   428,  1071,
     304,   427,   436,  1071,   906,    -1,   101,   428,  1071,   304,
     253,   436,  1071,   906,    -1,   101,   428,  1071,   304,   298,
     471,   436,  1071,   906,    -1,   101,   428,  1071,   304,    99,
     340,   125,  1081,   436,  1071,   906,    -1,   101,   428,  1071,
     304,   427,   340,   125,  1081,   436,  1071,   906,    -1,   101,
     428,  1071,   304,   253,   340,   125,  1081,   436,  1071,   906,
      -1,   101,   428,  1071,   304,   298,   471,   340,   125,  1081,
     436,  1071,   906,    -1,   101,   428,  1071,   403,   575,    -1,
     101,   428,  1071,   378,   575,    -1,   101,    98,  1077,   805,
     374,   436,  1071,    -1,   101,   144,   746,   374,   436,  1071,
      -1,   101,   157,   746,   374,   436,  1071,    -1,   101,   174,
    1072,   374,   436,  1072,    -1,   101,   195,   746,   374,   436,
    1071,    -1,   101,   195,   746,   374,   153,  1071,   436,  1071,
      -1,   101,   226,   173,   481,  1071,   374,   436,  1071,    -1,
     101,   231,   771,   374,   436,  1071,    -1,   101,   237,  1080,
     374,   436,  1080,    -1,   101,   657,   276,  1071,   374,   436,
    1071,    -1,   101,   329,   139,   746,   458,  1073,   374,   436,
    1071,    -1,   101,   329,   218,   746,   458,  1073,   374,   436,
    1071,    -1,   101,   391,  1071,   374,   436,  1071,    -1,   101,
     400,  1071,   374,   436,  1071,    -1,   101,   426,   965,   374,
     436,  1071,    -1,   101,   426,   244,   212,   965,   374,   436,
    1071,    -1,   101,   397,  1069,   374,   436,  1071,    -1,   101,
     397,   244,   212,  1069,   374,   436,  1071,    -1,   101,   470,
    1069,   374,   436,  1071,    -1,   101,   470,   244,   212,  1069,
     374,   436,  1071,    -1,   101,   298,   470,  1069,   374,   436,
    1071,    -1,   101,   298,   470,   244,   212,  1069,   374,   436,
    1071,    -1,   101,   252,  1069,   374,   436,  1071,    -1,   101,
     252,   244,   212,  1069,   374,   436,  1071,    -1,   101,   226,
     426,   965,   374,   436,  1071,    -1,   101,   226,   426,   244,
     212,   965,   374,   436,  1071,    -1,   101,   426,   965,   374,
     834,  1071,   436,  1071,    -1,   101,   426,   244,   212,   965,
     374,   834,  1071,   436,  1071,    -1,   101,   298,   470,  1069,
     374,   834,  1071,   436,  1071,    -1,   101,   298,   470,   244,
     212,  1069,   374,   834,  1071,   436,  1071,    -1,   101,   426,
     965,   374,   153,  1071,   436,  1071,    -1,   101,   226,   426,
     965,   374,   834,  1071,   436,  1071,    -1,   101,   226,   426,
     244,   212,   965,   374,   834,  1071,   436,  1071,    -1,   101,
     389,  1071,   327,  1069,   374,   436,  1071,    -1,   101,   440,
    1071,   327,  1069,   374,   436,  1071,    -1,   101,   206,   440,
    1071,   374,   436,  1071,    -1,   101,   385,  1080,   374,   436,
    1080,    -1,   101,   457,  1080,   374,   436,  1080,    -1,   101,
     428,  1071,   374,   436,  1071,    -1,   101,   432,   393,   342,
     746,   374,   436,  1071,    -1,   101,   432,   393,   189,   746,
     374,   436,  1071,    -1,   101,   432,   393,   430,   746,   374,
     436,  1071,    -1,   101,   432,   393,   151,   746,   374,   436,
    1071,    -1,   101,   445,   746,   374,   436,  1071,    -1,   101,
     445,   746,   374,   114,  1071,   436,  1071,   571,    -1,   145,
      -1,    -1,   403,   173,    -1,    -1,   101,    98,  1077,   805,
     403,   391,  1071,    -1,   101,   144,   746,   403,   391,  1071,
      -1,   101,   157,   746,   403,   391,  1071,    -1,   101,   195,
     746,   403,   391,  1071,    -1,   101,   214,   746,   403,   391,
    1071,    -1,   101,   231,   771,   403,   391,  1071,    -1,   101,
     329,   821,   820,   403,   391,  1071,    -1,   101,   329,   139,
     746,   458,  1073,   403,   391,  1071,    -1,   101,   329,   218,
     746,   458,  1073,   403,   391,  1071,    -1,   101,   426,   965,
     403,   391,  1071,    -1,   101,   426,   244,   212,   965,   403,
     391,  1071,    -1,   101,   432,   393,   342,   746,   403,   391,
    1071,    -1,   101,   432,   393,   189,   746,   403,   391,  1071,
      -1,   101,   432,   393,   430,   746,   403,   391,  1071,    -1,
     101,   432,   393,   151,   746,   403,   391,  1071,    -1,   101,
     397,  1069,   403,   391,  1071,    -1,   101,   397,   244,   212,
    1069,   403,   391,  1071,    -1,   101,   470,  1069,   403,   391,
    1071,    -1,   101,   470,   244,   212,  1069,   403,   391,  1071,
      -1,   101,   298,   470,  1069,   403,   391,  1071,    -1,   101,
     298,   470,   244,   212,  1069,   403,   391,  1071,    -1,   101,
     226,   426,   965,   403,   391,  1071,    -1,   101,   226,   426,
     244,   212,   965,   403,   391,  1071,    -1,   101,   445,   746,
     403,   391,  1071,    -1,   101,    98,  1077,   805,   341,   436,
    1080,    -1,   101,   144,   746,   341,   436,  1080,    -1,   101,
     157,   746,   341,   436,  1080,    -1,   101,   174,  1072,   341,
     436,  1080,    -1,   101,   195,   746,   341,   436,  1080,    -1,
     101,   231,   771,   341,   436,  1080,    -1,   101,   657,   276,
    1071,   341,   436,  1080,    -1,   101,   277,   322,   648,   341,
     436,  1080,    -1,   101,   329,   821,   820,   341,   436,  1080,
      -1,   101,   329,   139,   746,   458,  1073,   341,   436,  1080,
      -1,   101,   329,   218,   746,   458,  1073,   341,   436,  1080,
      -1,   101,   391,  1071,   341,   436,  1080,    -1,   101,   445,
     746,   341,   436,  1080,    -1,   101,   428,  1071,   341,   436,
    1080,    -1,   101,   432,   393,   189,   746,   341,   436,  1080,
      -1,   101,   432,   393,   151,   746,   341,   436,  1080,    -1,
     101,   226,   173,   481,  1071,   341,   436,  1080,    -1,   101,
     400,  1071,   341,   436,  1080,    -1,   101,   206,   440,  1071,
     341,   436,  1080,    -1,   160,   793,   389,  1071,   108,   327,
     843,   436,  1069,   973,   193,   844,   839,    -1,   314,    -1,
     841,    -1,   513,   840,   514,    -1,   840,   517,   842,    -1,
     842,    -1,   918,    -1,   896,    -1,   907,    -1,   901,    -1,
     846,    -1,   841,    -1,    -1,   396,    -1,   456,    -1,   185,
      -1,   262,    -1,   263,    -1,   100,    -1,    -1,   197,   389,
    1071,   327,   746,   571,    -1,   197,   389,   244,   212,  1071,
     327,   746,   571,    -1,   315,  1201,   847,    -1,   516,  1221,
      -1,    -1,   289,  1201,    -1,   453,  1201,    -1,   453,   506,
      -1,    91,   851,    -1,   118,   851,   854,    -1,   414,   438,
     854,    -1,   148,   851,    -1,   203,   851,    -1,   386,   851,
      -1,   390,  1201,    -1,   373,   390,  1201,    -1,   373,  1201,
      -1,   386,   851,   436,   390,  1201,    -1,   386,   851,   436,
    1201,    -1,   353,   438,  1221,    -1,   148,   354,  1221,    -1,
     386,   354,  1221,    -1,   480,    -1,   438,    -1,    -1,   272,
     286,   553,    -1,   363,   328,    -1,   363,   482,    -1,   182,
      -1,   313,   182,    -1,   852,    -1,   853,   516,   852,    -1,
     853,   852,    -1,   853,    -1,    -1,   160,   600,   470,  1069,
     619,   576,   108,   918,   856,    -1,   160,   332,   376,   600,
     470,  1069,   619,   576,   108,   918,   856,    -1,   160,   600,
     367,   470,  1069,   513,   620,   514,   576,   108,   918,   856,
      -1,   160,   332,   376,   600,   367,   470,  1069,   513,   620,
     514,   576,   108,   918,   856,    -1,   477,   137,   330,    -1,
     477,   129,   137,   330,    -1,   477,   291,   137,   330,    -1,
      -1,   290,  1076,    -1,   160,   174,  1072,   525,   859,    -1,
     859,   860,    -1,    -1,   428,   861,  1071,    -1,   428,   861,
     180,    -1,   294,   861,  1221,    -1,   294,   861,   180,    -1,
     430,   861,  1071,    -1,   430,   861,   180,    -1,   201,   861,
    1221,    -1,   201,   861,  1079,    -1,   201,   861,   180,    -1,
     280,   861,  1221,    -1,   280,   861,   180,    -1,   281,   861,
    1221,    -1,   281,   861,   180,    -1,   152,   288,   861,  1082,
      -1,   341,   861,  1071,    -1,   341,   861,   180,    -1,   500,
      -1,    -1,   101,   174,  1072,   525,   864,    -1,   101,   174,
    1072,   403,   428,  1071,    -1,   101,   174,  1072,   559,    -1,
     864,   865,    -1,    -1,   152,   288,   861,  1082,    -1,   197,
     174,  1072,    -1,   197,   174,   244,   212,  1072,    -1,   101,
     425,   403,   548,    -1,   160,   195,   746,   870,   978,   609,
      -1,   101,   195,   746,   570,    -1,   101,   195,   746,   197,
     313,   318,    -1,   101,   195,   746,   403,   313,   318,    -1,
     101,   195,   746,    95,   616,    -1,   101,   195,   746,   197,
     153,  1071,   571,    -1,   101,   195,   746,   197,   153,   244,
     212,  1071,   571,    -1,   101,   195,   746,   461,   153,  1071,
      -1,   108,    -1,    -1,   101,   432,   393,   189,   746,   717,
      -1,   101,   432,   393,   151,   746,    95,   296,   224,  1070,
     477,   745,    -1,   101,   432,   393,   151,   746,   101,   296,
     224,  1070,   477,   745,    -1,   101,   432,   393,   151,   746,
     101,   296,   376,   746,   477,   746,    -1,   101,   432,   393,
     151,   746,   101,   296,   224,  1070,   376,   746,   477,   746,
      -1,   101,   432,   393,   151,   746,   197,   296,   224,  1070,
      -1,   101,   432,   393,   151,   746,   197,   296,   244,   212,
     224,  1070,    -1,   160,   731,   157,   746,   224,  1221,   436,
    1221,   229,   746,    -1,   141,   881,  1069,   875,    -1,   141,
     881,    -1,   141,   881,  1075,   327,  1069,    -1,   458,  1075,
      -1,    -1,   459,   882,   883,   881,    -1,   459,   882,   883,
     881,  1069,    -1,   459,   882,   883,   881,   879,    -1,   459,
     513,   877,   514,    -1,   459,   513,   877,   514,  1069,   884,
      -1,   878,    -1,   877,   516,   878,    -1,   880,    -1,   468,
      -1,   228,    -1,   230,    -1,   880,   881,    -1,   880,   881,
    1069,   884,    -1,   104,    -1,   103,    -1,   468,    -1,    -1,
     230,    -1,    -1,   228,    -1,    -1,   513,  1070,   514,    -1,
      -1,   213,   886,    -1,   213,   880,   881,   886,    -1,   213,
     468,   886,    -1,   213,   513,   887,   514,   886,    -1,   918,
      -1,   896,    -1,   907,    -1,   901,    -1,   914,    -1,  1090,
      -1,   638,    -1,   641,    -1,   894,    -1,   888,    -1,   887,
     516,   888,    -1,   889,   890,    -1,  1083,    -1,   880,    -1,
     554,    -1,   648,    -1,    -1,   353,  1109,   892,   108,   893,
      -1,   353,  1109,   229,  1154,    -1,   513,  1039,   514,    -1,
      -1,   918,    -1,   896,    -1,   907,    -1,   901,    -1,   211,
    1109,   895,  1233,    -1,   160,   600,   426,   636,   108,   211,
    1071,   895,   637,    -1,   513,  1036,   514,    -1,    -1,   926,
     262,   268,  1069,   897,   900,    -1,   918,    -1,   513,   898,
     514,   918,    -1,   180,   464,    -1,   899,    -1,   898,   516,
     899,    -1,  1201,  1060,    -1,   381,  1066,  1234,    -1,    -1,
     926,   185,   229,   967,   902,   974,   900,    -1,   458,   956,
      -1,    -1,   295,   929,   966,   904,   906,    -1,   249,   905,
     302,    -1,    -1,    93,   405,    -1,   387,   405,    -1,   387,
     210,    -1,   405,   456,   210,    -1,   405,    -1,   405,   387,
     210,    -1,   210,    -1,    93,   210,    -1,   317,    -1,    -1,
     926,   456,   967,   403,   908,   955,   974,   900,    -1,   909,
      -1,   908,   516,   909,    -1,   910,    -1,   911,    -1,   912,
     500,  1062,    -1,   513,   913,   514,   500,  1064,    -1,  1201,
    1060,    -1,   912,    -1,   913,   516,   912,    -1,   179,   915,
     916,   171,   917,   224,   918,    -1,  1071,    -1,  1214,    -1,
      -1,   916,   311,   392,    -1,   916,   392,    -1,   916,   121,
      -1,   916,   261,    -1,    -1,   477,   241,    -1,   479,   241,
      -1,   920,    -1,   919,    -1,   513,   920,   514,    -1,   513,
     919,   514,    -1,   922,    -1,   921,   933,    -1,   921,   932,
     948,   937,    -1,   921,   932,   936,   949,    -1,   923,   921,
      -1,   923,   921,   933,    -1,   923,   921,   932,   948,   937,
      -1,   923,   921,   932,   936,   949,    -1,   922,    -1,   919,
      -1,   396,   931,  1065,   927,   955,   973,   946,   947,  1019,
      -1,   954,    -1,   426,   965,    -1,   921,   450,   930,   921,
      -1,   921,   266,   930,   921,    -1,   921,   207,   930,   921,
      -1,   477,   924,    -1,   477,   367,   924,    -1,   925,    -1,
     924,   516,   925,    -1,  1071,   884,   108,   513,   893,   514,
      -1,   923,    -1,    -1,   268,   928,    -1,  1234,    -1,    -1,
     431,   929,  1069,    -1,   429,   929,  1069,    -1,   291,   431,
     929,  1069,    -1,   291,   429,   929,  1069,    -1,   233,   431,
     929,  1069,    -1,   233,   429,   929,  1069,    -1,   454,   929,
    1069,    -1,   426,  1069,    -1,  1069,    -1,   426,    -1,    -1,
      99,    -1,   192,    -1,    -1,   192,    -1,   192,   327,   513,
    1036,   514,    -1,    99,    -1,    -1,   933,    -1,    -1,   333,
     125,   934,    -1,   935,    -1,   934,   516,   935,    -1,  1002,
     458,  1034,   791,    -1,  1002,   790,   791,    -1,   938,   939,
      -1,   939,   938,    -1,   938,    -1,   939,    -1,   936,    -1,
      -1,   288,   940,    -1,   288,   940,   516,   941,    -1,   219,
     945,   942,   944,   328,    -1,   325,   941,    -1,   325,   943,
     944,    -1,  1002,    -1,    99,    -1,  1002,    -1,  1082,    -1,
     513,  1002,   514,    -1,    -1,  1004,    -1,   387,    -1,   388,
      -1,   221,    -1,   310,    -1,   237,   125,  1036,    -1,    -1,
     239,  1002,    -1,    -1,   950,    -1,   224,   363,   328,    -1,
     948,    -1,    -1,   951,    -1,   950,   951,    -1,   952,   953,
     906,    -1,   224,   456,    -1,   224,   311,   274,   456,    -1,
     224,   405,    -1,   224,   274,   405,    -1,   323,  1068,    -1,
      -1,   464,  1064,    -1,   954,   516,  1064,    -1,   229,   956,
      -1,    -1,   957,    -1,   956,   516,   957,    -1,   965,   960,
      -1,   968,   961,    -1,   279,   968,   961,    -1,   919,   960,
      -1,   279,   919,   960,    -1,   958,    -1,   513,   958,   514,
     959,    -1,   513,   958,   514,    -1,   957,   161,   273,   957,
      -1,   957,   962,   273,   957,   964,    -1,   957,   273,   957,
     964,    -1,   957,   308,   962,   273,   957,    -1,   957,   308,
     273,   957,    -1,   108,  1201,   513,  1070,   514,    -1,   108,
    1201,    -1,  1201,   513,  1070,   514,    -1,  1201,    -1,   959,
      -1,    -1,   959,    -1,   108,   513,   976,   514,    -1,   108,
    1201,   513,   976,   514,    -1,  1201,   513,   976,   514,    -1,
      -1,   230,   963,    -1,   285,   963,    -1,   384,   963,    -1,
     258,    -1,   336,    -1,    -1,   458,   513,  1070,   514,    -1,
     327,  1002,    -1,  1069,    -1,  1069,   506,    -1,   328,  1069,
      -1,   328,   513,  1069,   514,    -1,   965,    -1,   966,   516,
     965,    -1,   965,    -1,   965,  1201,    -1,   965,   108,  1201,
      -1,  1007,   972,    -1,   388,   229,   513,   970,   514,   972,
      -1,  1007,   971,    -1,   969,    -1,   970,   516,   969,    -1,
     108,   513,   976,   514,    -1,    -1,   498,    -1,    -1,   474,
    1002,    -1,    -1,   474,  1002,    -1,   474,   163,   323,   915,
      -1,    -1,   976,    -1,    -1,   977,    -1,   976,   516,   977,
      -1,  1201,   978,   572,    -1,   980,   979,    -1,   404,   980,
     979,    -1,   980,   107,   511,  1079,   512,    -1,   404,   980,
     107,   511,  1079,   512,    -1,   980,   107,    -1,   404,   980,
     107,    -1,   979,   511,   512,    -1,   979,   511,  1232,   512,
      -1,    -1,   982,    -1,   984,    -1,   986,    -1,   990,    -1,
     997,    -1,   998,  1000,    -1,   998,   513,  1079,   514,  1000,
      -1,   984,    -1,   987,    -1,   991,    -1,   997,    -1,  1202,
     983,    -1,  1202,   747,   983,    -1,   513,  1036,   514,    -1,
      -1,   264,    -1,   265,    -1,   409,    -1,   120,    -1,   364,
      -1,   222,   985,    -1,   196,   351,    -1,   178,   983,    -1,
     177,   983,    -1,   321,   983,    -1,   123,    -1,   513,  1079,
     514,    -1,    -1,   988,    -1,   989,    -1,   988,    -1,   989,
      -1,   122,   995,   513,  1036,   514,    -1,   122,   995,    -1,
     992,    -1,   993,    -1,   992,    -1,   993,    -1,   994,   513,
    1079,   514,   996,    -1,   994,   996,    -1,   135,   995,    -1,
     134,   995,    -1,   465,    -1,   307,   135,   995,    -1,   307,
     134,   995,    -1,   309,   995,    -1,   467,    -1,    -1,   135,
     403,  1201,    -1,    -1,   435,   513,  1079,   514,   999,    -1,
     435,   999,    -1,   434,   513,  1079,   514,   999,    -1,   434,
     999,    -1,   267,    -1,   499,   495,    -1,   479,   434,   495,
      -1,    -1,   493,    -1,   303,    -1,   175,    -1,   242,    -1,
     300,    -1,  1001,    -1,   493,   436,   303,    -1,   175,   436,
     242,    -1,   175,   436,   300,    -1,   175,   436,  1001,    -1,
     242,   436,   300,    -1,   242,   436,  1001,    -1,   300,   436,
    1001,    -1,    -1,   394,    -1,   394,   513,  1079,   514,    -1,
    1004,    -1,  1002,    88,   978,    -1,  1002,   143,   746,    -1,
    1002,   113,   434,   495,  1002,    -1,   504,  1002,    -1,   505,
    1002,    -1,  1002,   504,  1002,    -1,  1002,   505,  1002,    -1,
    1002,   506,  1002,    -1,  1002,   507,  1002,    -1,  1002,   508,
    1002,    -1,  1002,   509,  1002,    -1,  1002,   501,  1002,    -1,
    1002,   502,  1002,    -1,  1002,   500,  1002,    -1,  1002,  1033,
    1002,    -1,  1033,  1002,    -1,  1002,  1033,    -1,  1002,   105,
    1002,    -1,  1002,   332,  1002,    -1,   313,  1002,    -1,  1002,
     287,  1002,    -1,  1002,   287,  1002,   205,  1002,    -1,  1002,
     313,   287,  1002,    -1,  1002,   313,   287,  1002,   205,  1002,
      -1,  1002,   245,  1002,    -1,  1002,   245,  1002,   205,  1002,
      -1,  1002,   313,   245,  1002,    -1,  1002,   313,   245,  1002,
     205,  1002,    -1,  1002,   407,   436,  1002,    -1,  1002,   407,
     436,  1002,   205,  1002,    -1,  1002,   313,   407,   436,  1002,
      -1,  1002,   313,   407,   436,  1002,   205,  1002,    -1,  1002,
     270,   318,    -1,  1002,   271,    -1,  1002,   270,   313,   318,
      -1,  1002,   316,    -1,  1029,   338,  1029,    -1,  1002,   270,
     442,    -1,  1002,   270,   313,   442,    -1,  1002,   270,   217,
      -1,  1002,   270,   313,   217,    -1,  1002,   270,   452,    -1,
    1002,   270,   313,   452,    -1,  1002,   270,   192,   229,  1002,
      -1,  1002,   270,   313,   192,   229,  1002,    -1,  1002,   270,
     323,   513,  1039,   514,    -1,  1002,   270,   313,   323,   513,
    1039,   514,    -1,  1002,   119,  1061,  1003,   105,  1003,    -1,
    1002,   313,   119,  1061,  1003,   105,  1003,    -1,  1002,   119,
     423,  1003,   105,  1003,    -1,  1002,   313,   119,   423,  1003,
     105,  1003,    -1,  1002,   249,  1051,    -1,  1002,   313,   249,
    1051,    -1,  1002,  1035,  1030,   919,    -1,  1002,  1035,  1030,
     513,  1002,   514,    -1,   451,   919,    -1,  1002,   270,   194,
      -1,  1002,   270,   313,   194,    -1,  1004,    -1,  1003,    88,
     978,    -1,   504,  1003,    -1,   505,  1003,    -1,  1003,   504,
    1003,    -1,  1003,   505,  1003,    -1,  1003,   506,  1003,    -1,
    1003,   507,  1003,    -1,  1003,   508,  1003,    -1,  1003,   509,
    1003,    -1,  1003,   501,  1003,    -1,  1003,   502,  1003,    -1,
    1003,   500,  1003,    -1,  1003,  1033,  1003,    -1,  1033,  1003,
      -1,  1003,  1033,    -1,  1003,   270,   192,   229,  1003,    -1,
    1003,   270,   313,   192,   229,  1003,    -1,  1003,   270,   323,
     513,  1039,   514,    -1,  1003,   270,   313,   323,   513,  1039,
     514,    -1,  1003,   270,   194,    -1,  1003,   270,   313,   194,
      -1,  1057,    -1,  1078,    -1,  1218,  1060,    -1,   513,  1002,
     514,  1060,    -1,  1052,    -1,  1006,    -1,   919,    -1,   919,
    1059,    -1,   212,   919,    -1,   107,   919,    -1,   107,  1040,
      -1,  1029,    -1,  1077,   513,   514,    -1,  1077,   513,  1037,
     932,   514,    -1,  1077,   513,   466,  1038,   932,   514,    -1,
    1077,   513,  1037,   516,   466,  1038,   932,   514,    -1,  1077,
     513,    99,  1037,   932,   514,    -1,  1077,   513,   192,  1037,
     932,   514,    -1,  1077,   513,   506,   514,    -1,  1005,  1017,
    1018,  1022,    -1,  1008,    -1,  1005,    -1,  1008,    -1,   144,
     224,   513,  1002,   514,    -1,   165,    -1,   168,    -1,   168,
     513,  1079,   514,    -1,   169,    -1,   169,   513,  1079,   514,
      -1,   292,    -1,   292,   513,  1079,   514,    -1,   293,    -1,
     293,   513,  1079,   514,    -1,   166,    -1,   170,    -1,   402,
      -1,   457,    -1,   164,    -1,   167,    -1,   131,   513,  1002,
     108,   978,   514,    -1,   216,   513,  1042,   514,    -1,   339,
     513,  1044,   514,    -1,   349,   513,  1046,   514,    -1,   422,
     513,  1047,   514,    -1,   439,   513,  1002,   108,   978,   514,
      -1,   441,   513,   124,  1050,   514,    -1,   441,   513,   282,
    1050,   514,    -1,   441,   513,   437,  1050,   514,    -1,   441,
     513,  1050,   514,    -1,   319,   513,  1002,   516,  1002,   514,
      -1,   142,   513,  1036,   514,    -1,   236,   513,  1036,   514,
      -1,   284,   513,  1036,   514,    -1,   485,   513,  1036,   514,
      -1,   486,   513,   305,  1203,   514,    -1,   486,   513,   305,
    1203,   516,  1011,   514,    -1,   486,   513,   305,  1203,   516,
    1036,   514,    -1,   486,   513,   305,  1203,   516,  1011,   516,
    1036,   514,    -1,   487,   513,  1004,  1016,   514,    -1,   488,
     513,  1012,   514,    -1,   489,   513,  1014,  1002,  1015,   514,
      -1,   490,   513,   305,  1203,   514,    -1,   490,   513,   305,
    1203,   516,  1002,   514,    -1,   491,   513,  1002,   516,  1009,
    1010,   514,    -1,   492,   513,  1014,  1002,   108,   980,   514,
      -1,   469,  1002,    -1,   469,   311,   463,    -1,   516,   413,
     494,    -1,   516,   413,   311,    -1,   516,   413,   311,   463,
      -1,    -1,   484,   513,  1012,   514,    -1,  1013,    -1,  1012,
     516,  1013,    -1,  1002,   108,  1203,    -1,  1002,    -1,   194,
      -1,   155,    -1,   352,   475,    -1,   421,   475,    -1,    -1,
     345,  1004,    -1,   345,  1004,   125,   368,    -1,   345,   125,
     368,  1004,    -1,   345,   125,   368,  1004,   125,   368,    -1,
     478,   237,   513,   933,   514,    -1,    -1,   220,   513,   474,
    1002,   514,    -1,    -1,   476,  1020,    -1,    -1,  1021,    -1,
    1020,   516,  1021,    -1,  1201,   108,  1023,    -1,   337,  1023,
      -1,   337,  1201,    -1,    -1,   513,  1024,  1025,   932,  1026,
     514,    -1,  1201,    -1,    -1,   344,   125,  1036,    -1,    -1,
     362,  1027,    -1,   388,  1027,    -1,    -1,  1028,    -1,   119,
    1028,   105,  1028,    -1,   447,   350,    -1,   447,   223,    -1,
     163,   387,    -1,  1002,   350,    -1,  1002,   223,    -1,   387,
     513,  1036,   514,    -1,   387,   513,   514,    -1,   513,  1036,
     516,  1002,   514,    -1,   106,    -1,   411,    -1,    99,    -1,
      85,    -1,  1032,    -1,   504,    -1,   505,    -1,   506,    -1,
     507,    -1,   508,    -1,   509,    -1,   501,    -1,   502,    -1,
     500,    -1,    85,    -1,   329,   513,   821,   514,    -1,  1031,
      -1,   329,   513,   821,   514,    -1,  1031,    -1,   329,   513,
     821,   514,    -1,   287,    -1,   313,   287,    -1,   245,    -1,
     313,   245,    -1,  1002,    -1,  1036,   516,  1002,    -1,  1038,
      -1,  1037,   516,  1038,    -1,  1002,    -1,   800,    90,  1002,
      -1,   978,    -1,  1039,   516,   978,    -1,   511,  1036,   512,
      -1,   511,  1041,   512,    -1,   511,   512,    -1,  1040,    -1,
    1041,   516,  1040,    -1,  1043,   229,  1002,    -1,    -1,  1223,
      -1,   493,    -1,   303,    -1,   175,    -1,   242,    -1,   300,
      -1,   394,    -1,  1221,    -1,  1002,  1045,  1048,  1049,    -1,
    1002,  1045,  1048,    -1,   347,  1002,    -1,  1003,   249,  1003,
      -1,    -1,  1002,  1048,  1049,    -1,  1002,  1049,  1048,    -1,
    1002,  1048,    -1,  1002,  1049,    -1,  1036,    -1,    -1,   229,
    1002,    -1,   224,  1002,    -1,  1002,   229,  1036,    -1,   229,
    1036,    -1,  1036,    -1,   919,    -1,   513,  1036,   514,    -1,
     130,  1056,  1053,  1055,   203,    -1,  1054,    -1,  1053,  1054,
      -1,   473,  1002,   433,  1002,    -1,   199,  1002,    -1,    -1,
    1002,    -1,    -1,  1201,    -1,  1201,  1059,    -1,   515,  1074,
      -1,   515,   506,    -1,   511,  1002,   512,    -1,   511,  1002,
     518,  1002,   512,    -1,  1058,    -1,  1059,  1058,    -1,    -1,
    1060,  1058,    -1,   112,    -1,    -1,  1002,    -1,   180,    -1,
    1062,    -1,  1063,   516,  1062,    -1,   513,  1063,   514,    -1,
    1066,    -1,    -1,  1067,    -1,  1066,   516,  1067,    -1,  1002,
     108,  1203,    -1,  1002,  1223,    -1,  1002,    -1,   506,    -1,
    1069,    -1,  1068,   516,  1069,    -1,  1201,    -1,  1201,  1059,
      -1,  1071,    -1,  1070,   516,  1071,    -1,  1201,    -1,  1201,
      -1,  1201,    -1,  1203,    -1,  1201,    -1,  1221,    -1,  1202,
      -1,  1201,  1059,    -1,  1079,    -1,  1220,    -1,  1221,    -1,
    1219,    -1,    84,    -1,  1077,  1221,    -1,  1077,   513,  1037,
     932,   514,  1221,    -1,   981,  1221,    -1,   998,  1221,  1000,
      -1,   998,   513,  1079,   514,  1221,  1000,    -1,   442,    -1,
     217,    -1,   318,    -1,  1215,    -1,  1213,    -1,    86,    -1,
    1083,    -1,  1080,    -1,  1081,   516,  1080,    -1,  1079,    -1,
    1215,    -1,   504,  1079,    -1,   505,  1079,    -1,  1223,    -1,
    1084,    -1,  1085,    -1,  1086,    -1,    91,    -1,    92,    -1,
      93,    -1,    94,    -1,    95,    -1,    96,    -1,    97,    -1,
      98,    -1,   100,    -1,   101,    -1,   102,    -1,   110,    -1,
     111,    -1,   113,    -1,   114,    -1,   116,    -1,   117,    -1,
     118,    -1,   125,    -1,   126,    -1,   127,    -1,   128,    -1,
     129,    -1,   132,    -1,   133,    -1,   136,    -1,   138,    -1,
     139,    -1,   140,    -1,   141,    -1,   146,    -1,   147,    -1,
     148,    -1,   149,    -1,   151,    -1,   154,    -1,   155,    -1,
     156,    -1,   157,    -1,   158,    -1,   159,    -1,   162,    -1,
     171,    -1,   172,    -1,   173,    -1,   174,    -1,   176,    -1,
     179,    -1,   181,    -1,   183,    -1,   184,    -1,   185,    -1,
     186,    -1,   187,    -1,   189,    -1,   190,    -1,   191,    -1,
     194,    -1,   195,    -1,   196,    -1,   197,    -1,   198,    -1,
     200,    -1,   201,    -1,   202,    -1,   204,    -1,   205,    -1,
     206,    -1,   208,    -1,   209,    -1,   210,    -1,   211,    -1,
     213,    -1,   214,    -1,   215,    -1,   218,    -1,   220,    -1,
     221,    -1,   223,    -1,   225,    -1,   227,    -1,   231,    -1,
     232,    -1,   233,    -1,   235,    -1,   238,    -1,   240,    -1,
     241,    -1,   243,    -1,   244,    -1,   246,    -1,   247,    -1,
     248,    -1,   250,    -1,   251,    -1,   252,    -1,   253,    -1,
     254,    -1,   255,    -1,   257,    -1,   261,    -1,   262,    -1,
     263,    -1,   269,    -1,   272,    -1,   274,    -1,   275,    -1,
     276,    -1,   277,    -1,   278,    -1,   280,    -1,   281,    -1,
     283,    -1,   286,    -1,   289,    -1,   290,    -1,   291,    -1,
     294,    -1,   295,    -1,   296,    -1,   297,    -1,   298,    -1,
     299,    -1,   301,    -1,   302,    -1,   304,    -1,   305,    -1,
     306,    -1,   310,    -1,   311,    -1,   314,    -1,   315,    -1,
     317,    -1,   320,    -1,   322,    -1,   323,    -1,   324,    -1,
     326,    -1,   329,    -1,   330,    -1,   331,    -1,   334,    -1,
     337,    -1,   340,    -1,   341,    -1,   342,    -1,   343,    -1,
     344,    -1,   345,    -1,   346,    -1,   348,    -1,   350,    -1,
     353,    -1,   354,    -1,   352,    -1,   356,    -1,   357,    -1,
     358,    -1,   359,    -1,   360,    -1,   361,    -1,   362,    -1,
     363,    -1,   365,    -1,   366,    -1,   367,    -1,   368,    -1,
     370,    -1,   371,    -1,   372,    -1,   373,    -1,   374,    -1,
     375,    -1,   376,    -1,   377,    -1,   378,    -1,   379,    -1,
     380,    -1,   382,    -1,   383,    -1,   385,    -1,   386,    -1,
     388,    -1,   389,    -1,   390,    -1,   391,    -1,   392,    -1,
     393,    -1,   395,    -1,   397,    -1,   398,    -1,   399,    -1,
     400,    -1,   401,    -1,   403,    -1,   405,    -1,   406,    -1,
     408,    -1,   410,    -1,   412,    -1,   413,    -1,   414,    -1,
     415,    -1,   416,    -1,   417,    -1,   418,    -1,   419,    -1,
     420,    -1,   421,    -1,   424,    -1,   425,    -1,   427,    -1,
     428,    -1,   429,    -1,   430,    -1,   431,    -1,   432,    -1,
     438,    -1,   440,    -1,   443,    -1,   444,    -1,   445,    -1,
     446,    -1,   447,    -1,   448,    -1,   449,    -1,   452,    -1,
     453,    -1,   454,    -1,   455,    -1,   456,    -1,   459,    -1,
     460,    -1,   461,    -1,   462,    -1,   463,    -1,   467,    -1,
     469,    -1,   470,    -1,   471,    -1,   472,    -1,   475,    -1,
     478,    -1,   479,    -1,   480,    -1,   481,    -1,   482,    -1,
     483,    -1,   494,    -1,   495,    -1,   119,    -1,   120,    -1,
     122,    -1,   123,    -1,   135,    -1,   142,    -1,   177,    -1,
     178,    -1,   212,    -1,   216,    -1,   222,    -1,   236,    -1,
     259,    -1,   265,    -1,   267,    -1,   284,    -1,   307,    -1,
     309,    -1,   312,    -1,   319,    -1,   321,    -1,   335,    -1,
     339,    -1,   349,    -1,   351,    -1,   364,    -1,   387,    -1,
     404,    -1,   409,    -1,   422,    -1,   434,    -1,   435,    -1,
     439,    -1,   441,    -1,   465,    -1,   484,    -1,   485,    -1,
     486,    -1,   487,    -1,   488,    -1,   489,    -1,   490,    -1,
     491,    -1,   492,    -1,   115,    -1,   121,    -1,   144,    -1,
     150,    -1,   161,    -1,   167,    -1,   228,    -1,   230,    -1,
     245,    -1,   258,    -1,   270,    -1,   271,    -1,   273,    -1,
     285,    -1,   287,    -1,   308,    -1,   316,    -1,   336,    -1,
     338,    -1,   384,    -1,   407,    -1,   468,    -1,    99,    -1,
     103,    -1,   104,    -1,   105,    -1,   106,    -1,   107,    -1,
     108,    -1,   109,    -1,   112,    -1,   124,    -1,   130,    -1,
     131,    -1,   137,    -1,   143,    -1,   145,    -1,   153,    -1,
     160,    -1,   164,    -1,   165,    -1,   166,    -1,   168,    -1,
     169,    -1,   170,    -1,   180,    -1,   182,    -1,   188,    -1,
     192,    -1,   193,    -1,   199,    -1,   203,    -1,   207,    -1,
     217,    -1,   219,    -1,   224,    -1,   226,    -1,   229,    -1,
     234,    -1,   237,    -1,   239,    -1,   249,    -1,   256,    -1,
     266,    -1,   268,    -1,   279,    -1,   282,    -1,   288,    -1,
     292,    -1,   293,    -1,   313,    -1,   318,    -1,   325,    -1,
     327,    -1,   328,    -1,   332,    -1,   333,    -1,   347,    -1,
     355,    -1,   369,    -1,   381,    -1,   396,    -1,   402,    -1,
     411,    -1,   423,    -1,   426,    -1,   433,    -1,   437,    -1,
     442,    -1,   451,    -1,   457,    -1,   458,    -1,   466,    -1,
     473,    -1,   474,    -1,   476,    -1,   477,    -1,    -1,  1088,
    1089,    -1,  1210,  1092,   523,   517,    -1,  1210,   523,   517,
      -1,  1210,  1112,    -1,  1117,    -1,  1229,    -1,    73,    -1,
     519,    -1,   520,    -1,    -1,   160,   600,   426,   636,   108,
    1091,   918,   637,    -1,   113,  1153,    -1,     9,   436,  1094,
    1101,  1102,    -1,     9,   436,   180,    -1,     9,  1103,    -1,
     174,  1094,    -1,  1095,  1098,  1100,    -1,  1096,   518,  1097,
    1100,   507,  1095,  1106,    -1,  1105,    -1,  1221,    -1,  1072,
      -1,    -1,  1223,  1217,    -1,    85,  1099,    -1,  1097,    -1,
      -1,  1201,    -1,  1201,   515,  1099,    -1,    74,    -1,   518,
    1079,    -1,    -1,   108,  1153,    -1,    -1,   457,  1103,    -1,
      -1,  1104,    -1,  1104,   507,  1104,    -1,  1104,    21,   125,
    1104,    -1,  1104,   458,  1104,    -1,  1080,    -1,  1221,    -1,
    1215,    -1,  1217,    -1,    85,  1107,    -1,    -1,  1201,  1108,
      -1,  1201,  1108,    85,  1107,    -1,    -1,   500,  1079,    -1,
     500,  1223,    -1,   500,  1215,    -1,  1071,    -1,  1105,    -1,
     179,   915,   916,   171,   917,   224,  1109,    -1,   211,   246,
    1154,    -1,  1113,    -1,  1124,    -1,  1126,    -1,   648,    -1,
     516,   648,    -1,    -1,  1000,    -1,   493,   436,   300,    -1,
     493,   436,   394,    -1,   175,   436,   175,    -1,   303,   436,
     303,    -1,    -1,  1119,  1118,  1121,  1120,    -1,  1210,   118,
     179,    34,   517,    -1,  1210,   203,   179,    34,   517,    -1,
      -1,  1122,    -1,  1113,    -1,    73,    -1,  1122,  1113,    -1,
    1122,    73,    -1,  1126,    -1,  1123,  1126,    -1,    -1,    70,
    1125,  1133,  1149,  1205,   979,   517,    -1,    -1,  1130,  1133,
    1127,  1146,   517,    -1,    -1,  1133,  1128,  1146,   517,    -1,
    1136,   517,    -1,   518,  1079,    -1,    -1,  1131,  1132,    -1,
    1131,    -1,  1132,    -1,    56,    -1,    67,    -1,    65,    -1,
      50,    -1,    51,    -1,    69,    -1,  1142,    -1,  1138,    -1,
    1134,    -1,  1205,   513,  1114,  1115,   514,    -1,  1205,  1116,
      -1,  1140,    -1,   204,  1199,  1135,    -1,   204,  1135,    -1,
     204,  1199,    -1,   519,  1227,   520,    -1,    -1,  1140,  1137,
     519,  1123,   520,    -1,  1136,    -1,    -1,  1141,  1139,   519,
    1123,   520,    -1,    43,  1199,    -1,   450,  1199,    -1,    43,
      -1,   450,    -1,  1143,    -1,  1145,  1144,    -1,    44,    35,
      -1,    44,    35,   264,    -1,    44,    -1,    44,   264,    -1,
      44,    25,    -1,    44,    25,   264,    -1,    44,    25,    25,
      -1,    44,    25,    25,   264,    -1,    44,   134,    -1,    35,
      -1,    35,   264,    -1,   264,    -1,    25,    -1,    25,   264,
      -1,    25,    25,    -1,    25,    25,   264,    -1,     5,    -1,
     134,    -1,   196,    -1,    36,    -1,    -1,  1147,    -1,  1146,
     516,  1147,    -1,  1149,  1204,   979,  1129,  1148,    -1,    -1,
     500,  1228,    -1,    -1,   506,    -1,   506,   506,    -1,   179,
     415,  1223,    -1,    15,  1152,    -1,  1153,    -1,   163,    -1,
      99,    -1,    -1,  1072,    -1,   180,    -1,  1105,    -1,  1105,
      -1,    71,    -1,    17,   915,    -1,    17,    99,    -1,    28,
     915,  1157,    -1,    -1,  1158,    -1,   458,  1162,    -1,  1159,
      -1,   458,    37,    14,  1224,    -1,   458,    14,  1071,    -1,
     268,    37,    14,  1224,    -1,   268,    14,  1071,    -1,   268,
    1071,    -1,  1163,    -1,  1163,   516,  1162,    -1,  1164,    -1,
    1215,    -1,  1213,    -1,  1079,    -1,   504,  1079,    -1,   505,
    1079,    -1,  1220,    -1,   504,  1220,    -1,   505,  1220,    -1,
    1221,    -1,  1219,    -1,  1222,    -1,    13,   260,  1109,  1159,
      -1,    13,  1166,  1109,  1159,    -1,    13,  1166,  1109,  1160,
      -1,    13,   260,  1109,  1161,    -1,    13,  1166,  1109,  1161,
      -1,    29,    -1,    -1,     3,    14,  1224,    -1,   176,    14,
    1224,    -1,    18,    14,  1224,  1170,    -1,  1171,    -1,  1170,
     516,  1171,    -1,  1217,   500,  1176,    -1,   403,    14,  1224,
    1173,    -1,  1174,    -1,  1173,   516,  1174,    -1,  1176,   500,
    1175,    -1,  1079,    -1,  1217,    -1,    10,    -1,    18,    14,
    1224,   463,  1175,  1178,    -1,  1179,    -1,  1178,   516,  1179,
      -1,  1217,   500,  1184,    -1,   403,    14,  1224,   463,  1175,
    1181,    -1,  1182,    -1,  1181,   516,  1182,    -1,  1184,   500,
    1183,    -1,  1220,    -1,  1175,    -1,   505,  1220,    -1,   505,
    1079,    -1,  1221,    -1,     8,    -1,   173,    -1,    11,    -1,
      12,    -1,    22,    -1,    23,    -1,    24,    -1,   305,    -1,
      26,    -1,    27,    -1,   351,    -1,    31,    -1,    32,    -1,
      33,    -1,   445,    -1,   403,     4,   500,  1186,    -1,   403,
       4,   436,  1186,    -1,   327,    -1,   324,    -1,   403,   152,
     436,  1153,    -1,   403,   152,   500,  1153,    -1,   403,   152,
    1153,    -1,    -1,   445,  1189,  1205,   270,  1133,   979,  1190,
      -1,    30,    -1,    -1,    -1,    45,  1192,  1203,   270,  1133,
     979,  1190,    -1,    46,    38,  1194,    -1,    46,   313,    16,
    1194,    -1,    46,    40,  1194,    -1,   156,    -1,    39,    -1,
      42,    -1,    20,  1071,    -1,    19,   436,  1071,    -1,   193,
    1071,   513,  1211,   514,    -1,   193,     6,    -1,     7,  1071,
     513,  1211,   514,    -1,     7,  1071,    -1,  1196,    -1,  1197,
      -1,     6,    -1,     7,    -1,     8,    -1,    10,    -1,    11,
      -1,    12,    -1,    16,    -1,    19,    -1,    20,    -1,    21,
      -1,    22,    -1,    23,    -1,    24,    -1,    26,    -1,    27,
      -1,    31,    -1,    32,    -1,    33,    -1,    34,    -1,    37,
      -1,    38,    -1,    39,    -1,    40,    -1,    42,    -1,     9,
      -1,    13,    -1,    15,    -1,    28,    -1,    45,    -1,    46,
      -1,     5,    -1,    25,    -1,    29,    -1,    35,    -1,    43,
      -1,    36,    -1,    44,    -1,  1203,    -1,  1223,    -1,  1084,
      -1,  1085,    -1,  1208,    -1,  1195,    -1,  1206,    -1,   134,
      -1,   464,    -1,  1223,    -1,  1207,    -1,  1085,    -1,  1195,
      -1,  1206,    -1,   134,    -1,   464,    -1,  1223,    -1,  1207,
      -1,  1086,    -1,  1195,    -1,  1206,    -1,  1198,    -1,  1204,
      -1,  1198,    -1,   134,    -1,   163,    -1,   260,    -1,   264,
      -1,   436,    -1,   450,    -1,   464,    -1,  1206,    -1,  1208,
      -1,  1205,    -1,  1084,    -1,  1087,    -1,  1197,    -1,   152,
      -1,  1223,    -1,  1085,    -1,  1086,    -1,  1196,    -1,    50,
      -1,    51,    -1,    56,    -1,    65,    -1,    67,    -1,    70,
      -1,    69,    -1,  1084,    -1,  1208,    -1,   152,    -1,   175,
      -1,   242,    -1,   300,    -1,   303,    -1,   394,    -1,   493,
      -1,  1212,    -1,  1209,   516,  1212,    -1,    41,    -1,    -1,
    1227,    -1,  1217,  1216,    -1,  1217,    -1,  1217,  1216,    -1,
    1105,    -1,  1217,    -1,  1217,    -1,    22,  1217,    -1,    22,
    1071,    -1,    72,    -1,    87,    -1,    83,    -1,    81,    -1,
      82,    -1,    76,    -1,    77,    -1,    78,    -1,    75,    -1,
      84,    -1,    80,    -1,    71,    -1,    79,    -1,  1071,    -1,
    1105,    -1,  1230,    -1,   513,   514,    -1,   513,  1226,   514,
      -1,  1225,    -1,  1226,  1225,    -1,  1228,    -1,  1227,   516,
    1228,    -1,  1226,    -1,   519,  1227,   520,    -1,  1230,    -1,
     513,    -1,   514,    -1,   516,    -1,   517,    -1,  1223,    -1,
    1079,    -1,  1220,    -1,  1221,    -1,   506,    -1,   504,    -1,
     505,    -1,   507,    -1,   508,    -1,   318,    -1,    47,    -1,
      48,    -1,    49,    -1,    50,    -1,    51,    -1,    52,    -1,
      53,    -1,    54,    -1,    55,    -1,    56,    -1,    57,    -1,
      58,    -1,    60,    -1,    59,    -1,    61,    -1,    62,    -1,
      63,    -1,    64,    -1,    65,    -1,    66,    -1,    67,    -1,
      68,    -1,    70,    -1,    69,    -1,     5,    -1,   204,    -1,
     242,    -1,   264,    -1,    25,    -1,   300,    -1,   303,    -1,
     394,    -1,    35,    -1,    36,    -1,    43,    -1,    44,    -1,
     493,    -1,   134,    -1,   222,    -1,   436,    -1,   450,    -1,
     465,    -1,   511,    -1,   512,    -1,   500,    -1,   518,    -1,
     176,  1109,    -1,   176,   353,  1109,    -1,   176,    99,    -1,
     176,   353,    99,    -1,  1079,    -1,   513,  1232,   514,    -1,
    1232,   504,  1232,    -1,  1232,   505,  1232,    -1,  1232,   506,
    1232,    -1,  1232,   507,  1232,    -1,  1232,   508,  1232,    -1,
    1221,    -1,  1201,    -1,  1201,   513,  1133,   514,    -1,    -1,
    1158,  1234,    -1,  1234,  1158,    -1,  1158,    -1,  1234,    -1,
     268,  1209,    -1,  1160,    -1,  1234,    -1,  1159,    -1,    -1,
    1235,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1509,  1509,  1512,  1514,  1516,  1518,  1520,  1522,  1524,
    1526,  1528,  1530,  1532,  1534,  1536,  1538,  1540,  1542,  1544,
    1546,  1548,  1550,  1552,  1554,  1556,  1558,  1560,  1562,  1564,
    1566,  1568,  1570,  1588,  1590,  1592,  1594,  1596,  1598,  1600,
    1602,  1604,  1606,  1608,  1610,  1612,  1614,  1616,  1618,  1620,
    1622,  1624,  1626,  1628,  1630,  1632,  1634,  1636,  1638,  1640,
    1642,  1644,  1646,  1648,  1652,  1654,  1656,  1658,  1660,  1662,
    1664,  1666,  1668,  1670,  1672,  1674,  1676,  1678,  1680,  1682,
    1684,  1686,  1688,  1690,  1692,  1694,  1696,  1698,  1700,  1702,
    1704,  1706,  1708,  1710,  1712,  1714,  1716,  1718,  1720,  1727,
    1729,  1731,  1733,  1735,  1737,  1739,  1741,  1743,  1745,  1747,
    1749,  1755,  1757,  1759,  1761,  1763,  1765,  1767,  1769,  1771,
    1777,  1787,  1791,  1797,  1801,  1811,  1821,  1822,  1836,  1843,
    1849,  1860,  1866,  1875,  1882,  1888,  1897,  1904,  1912,  1917,
    1925,  1930,  1936,  1941,  1947,  1952,  1958,  1962,  1966,  1970,
    1974,  1978,  1982,  1986,  1990,  1998,  2002,  2006,  2010,  2014,
    2018,  2026,  2034,  2043,  2045,  2053,  2057,  2065,  2073,  2081,
    2085,  2093,  2097,  2105,  2113,  2121,  2125,  2133,  2137,  2145,
    2149,  2153,  2158,  2167,  2172,  2178,  2183,  2189,  2193,  2197,
    2201,  2205,  2209,  2217,  2221,  2225,  2233,  2237,  2241,  2249,
    2253,  2257,  2261,  2262,  2266,  2270,  2274,  2279,  2283,  2287,
    2291,  2295,  2299,  2303,  2311,  2315,  2323,  2327,  2335,  2339,
    2353,  2357,  2361,  2365,  2373,  2377,  2381,  2385,  2393,  2397,
    2401,  2405,  2409,  2413,  2417,  2425,  2429,  2434,  2440,  2444,
    2452,  2456,  2460,  2464,  2468,  2476,  2480,  2488,  2492,  2500,
    2504,  2508,  2512,  2516,  2525,  2533,  2537,  2545,  2549,  2557,
    2565,  2569,  2573,  2577,  2581,  2589,  2593,  2597,  2601,  2605,
    2609,  2613,  2617,  2621,  2625,  2633,  2637,  2645,  2649,  2653,
    2657,  2661,  2665,  2669,  2673,  2677,  2681,  2685,  2689,  2693,
    2697,  2701,  2705,  2709,  2713,  2717,  2721,  2725,  2729,  2733,
    2737,  2741,  2745,  2749,  2753,  2757,  2761,  2765,  2769,  2773,
    2777,  2781,  2785,  2789,  2793,  2797,  2801,  2805,  2809,  2813,
    2817,  2825,  2829,  2837,  2841,  2846,  2852,  2857,  2863,  2868,
    2874,  2878,  2882,  2886,  2894,  2902,  2907,  2913,  2917,  2925,
    2929,  2933,  2937,  2945,  2953,  2957,  2965,  2969,  2973,  2977,
    2985,  2990,  2998,  3006,  3014,  3018,  3026,  3031,  3037,  3041,
    3045,  3053,  3057,  3065,  3070,  3076,  3080,  3084,  3088,  3092,
    3096,  3100,  3104,  3108,  3112,  3116,  3120,  3124,  3128,  3136,
    3141,  3147,  3152,  3158,  3163,  3169,  3174,  3180,  3184,  3192,
    3200,  3204,  3208,  3212,  3217,  3223,  3227,  3235,  3243,  3247,
    3251,  3255,  3263,  3267,  3271,  3275,  3279,  3283,  3287,  3292,
    3298,  3303,  3309,  3314,  3320,  3324,  3332,  3336,  3344,  3348,
    3352,  3360,  3364,  3372,  3380,  3388,  3393,  3399,  3403,  3407,
    3411,  3419,  3423,  3427,  3431,  3435,  3439,  3443,  3451,  3455,
    3459,  3463,  3471,  3479,  3483,  3488,  3494,  3498,  3502,  3506,
    3510,  3514,  3522,  3526,  3534,  3538,  3542,  3546,  3550,  3554,
    3558,  3566,  3571,  3577,  3582,  3588,  3592,  3600,  3608,  3612,
    3617,  3622,  3628,  3632,  3640,  3644,  3652,  3657,  3663,  3667,
    3671,  3675,  3680,  3686,  3694,  3702,  3706,  3710,  3714,  3718,
    3726,  3731,  3737,  3741,  3745,  3750,  3756,  3760,  3764,  3769,
    3775,  3780,  3786,  3791,  3797,  3805,  3813,  3817,  3822,  3828,
    3836,  3844,  3849,  3855,  3863,  3871,  3875,  3883,  3888,  3894,
    3898,  3906,  3910,  3914,  3918,  3922,  3926,  3930,  3934,  3938,
    3942,  3946,  3950,  3958,  3963,  3969,  3973,  3977,  3985,  3989,
    3997,  4001,  4009,  4014,  4020,  4024,  4032,  4037,  4043,  4047,
    4055,  4060,  4066,  4070,  4078,  4083,  4089,  4097,  4102,  4108,
    4112,  4120,  4124,  4132,  4137,  4143,  4147,  4151,  4159,  4167,
    4172,  4178,  4186,  4190,  4194,  4198,  4202,  4206,  4210,  4214,
    4218,  4222,  4226,  4230,  4234,  4238,  4242,  4246,  4250,  4254,
    4258,  4262,  4266,  4270,  4274,  4278,  4286,  4294,  4298,  4302,
    4306,  4314,  4318,  4326,  4331,  4337,  4341,  4349,  4353,  4361,
    4366,  4372,  4376,  4384,  4392,  4396,  4404,  4408,  4412,  4416,
    4424,  4432,  4440,  4448,  4456,  4461,  4467,  4471,  4479,  4484,
    4490,  4494,  4502,  4506,  4510,  4518,  4522,  4530,  4534,  4542,
    4550,  4554,  4558,  4566,  4570,  4578,  4586,  4590,  4598,  4602,
    4606,  4614,  4618,  4626,  4630,  4634,  4638,  4642,  4650,  4655,
    4661,  4666,  4672,  4676,  4684,  4689,  4695,  4699,  4704,  4710,
    4714,  4718,  4722,  4730,  4735,  4742,  4744,  4752,  4756,  4760,
    4764,  4768,  4772,  4780,  4784,  4792,  4796,  4804,  4808,  4816,
    4824,  4828,  4836,  4844,  4848,  4852,  4856,  4864,  4873,  4882,
    4886,  4890,  4894,  4898,  4902,  4906,  4910,  4914,  4918,  4922,
    4926,  4930,  4934,  4942,  4950,  4954,  4962,  4966,  4974,  4978,
    4982,  4986,  4990,  4998,  5006,  5010,  5018,  5026,  5031,  5037,
    5041,  5049,  5053,  5057,  5065,  5070,  5076,  5084,  5088,  5096,
    5100,  5104,  5108,  5112,  5120,  5125,  5131,  5136,  5142,  5146,
    5151,  5157,  5163,  5169,  5177,  5181,  5189,  5193,  5201,  5205,
    5213,  5217,  5225,  5229,  5237,  5245,  5253,  5257,  5261,  5265,
    5273,  5277,  5281,  5285,  5289,  5293,  5297,  5301,  5305,  5309,
    5313,  5317,  5321,  5325,  5329,  5333,  5337,  5345,  5349,  5357,
    5361,  5369,  5373,  5381,  5389,  5393,  5398,  5404,  5408,  5412,
    5416,  5420,  5424,  5428,  5432,  5436,  5440,  5444,  5448,  5452,
    5460,  5464,  5468,  5472,  5476,  5480,  5484,  5488,  5492,  5496,
    5500,  5504,  5508,  5512,  5516,  5520,  5524,  5528,  5532,  5536,
    5540,  5544,  5548,  5556,  5560,  5568,  5572,  5576,  5580,  5584,
    5592,  5597,  5603,  5607,  5611,  5615,  5619,  5623,  5627,  5631,
    5635,  5639,  5643,  5647,  5651,  5659,  5663,  5671,  5675,  5679,
    5683,  5689,  5695,  5701,  5707,  5713,  5719,  5725,  5735,  5746,
    5757,  5768,  5779,  5790,  5801,  5817,  5833,  5849,  5860,  5876,
    5887,  5903,  5918,  5922,  5930,  5935,  5941,  5949,  5953,  5961,
    5965,  5969,  5973,  5977,  5985,  5989,  5997,  6001,  6005,  6009,
    6017,  6021,  6025,  6029,  6033,  6037,  6041,  6045,  6049,  6053,
    6057,  6061,  6065,  6069,  6073,  6077,  6085,  6089,  6097,  6101,
    6109,  6114,  6120,  6124,  6132,  6140,  6148,  6152,  6160,  6165,
    6171,  6176,  6182,  6190,  6195,  6201,  6205,  6209,  6217,  6221,
    6225,  6233,  6237,  6241,  6245,  6253,  6261,  6266,  6272,  6277,
    6283,  6288,  6294,  6299,  6305,  6309,  6317,  6321,  6325,  6333,
    6338,  6344,  6348,  6353,  6359,  6363,  6368,  6374,  6378,  6383,
    6389,  6393,  6397,  6405,  6410,  6416,  6420,  6428,  6432,  6440,
    6444,  6452,  6456,  6464,  6468,  6472,  6476,  6480,  6488,  6492,
    6496,  6500,  6504,  6512,  6520,  6528,  6532,  6536,  6544,  6548,
    6552,  6560,  6569,  6573,  6577,  6581,  6589,  6593,  6601,  6605,
    6613,  6617,  6621,  6625,  6629,  6633,  6637,  6641,  6645,  6649,
    6653,  6657,  6661,  6665,  6669,  6677,  6681,  6685,  6689,  6697,
    6701,  6709,  6714,  6720,  6728,  6732,  6740,  6748,  6752,  6760,
    6765,  6771,  6775,  6783,  6787,  6795,  6799,  6807,  6811,  6815,
    6819,  6827,  6831,  6839,  6847,  6851,  6859,  6863,  6871,  6875,
    6879,  6887,  6891,  6896,  6902,  6910,  6915,  6921,  6925,  6929,
    6937,  6941,  6949,  6954,  6960,  6964,  6968,  6972,  6976,  6980,
    6984,  6988,  6992,  6996,  7004,  7008,  7012,  7016,  7020,  7024,
    7028,  7032,  7036,  7040,  7044,  7048,  7052,  7056,  7060,  7064,
    7068,  7072,  7076,  7080,  7084,  7088,  7092,  7096,  7100,  7104,
    7108,  7112,  7116,  7120,  7124,  7128,  7132,  7136,  7140,  7144,
    7148,  7152,  7156,  7160,  7164,  7168,  7172,  7176,  7180,  7188,
    7193,  7199,  7204,  7210,  7214,  7218,  7222,  7226,  7230,  7234,
    7238,  7242,  7246,  7250,  7254,  7258,  7262,  7266,  7270,  7274,
    7278,  7282,  7286,  7290,  7294,  7298,  7302,  7310,  7314,  7318,
    7322,  7326,  7330,  7334,  7338,  7342,  7346,  7350,  7354,  7358,
    7362,  7366,  7370,  7374,  7378,  7382,  7390,  7398,  7402,  7406,
    7414,  7418,  7426,  7430,  7434,  7438,  7442,  7450,  7455,  7461,
    7465,  7469,  7473,  7481,  7485,  7490,  7496,  7500,  7508,  7516,
    7521,  7527,  7535,  7539,  7547,  7551,  7555,  7559,  7563,  7567,
    7571,  7575,  7579,  7583,  7587,  7591,  7595,  7599,  7607,  7611,
    7616,  7622,  7626,  7630,  7634,  7638,  7646,  7650,  7654,  7662,
    7667,  7673,  7677,  7681,  7686,  7695,  7699,  7703,  7708,  7714,
    7722,  7730,  7735,  7741,  7745,  7749,  7753,  7757,  7761,  7765,
    7769,  7773,  7777,  7781,  7785,  7789,  7793,  7797,  7801,  7809,
    7814,  7820,  7824,  7832,  7840,  7845,  7851,  7859,  7863,  7871,
    7879,  7887,  7891,  7895,  7899,  7903,  7907,  7911,  7919,  7924,
    7930,  7938,  7942,  7946,  7950,  7954,  7958,  7966,  7974,  7978,
    7982,  7990,  7995,  8001,  8005,  8009,  8013,  8017,  8025,  8029,
    8037,  8041,  8045,  8049,  8057,  8061,  8069,  8073,  8081,  8086,
    8092,  8097,  8103,  8108,  8114,  8119,  8125,  8129,  8133,  8137,
    8145,  8149,  8153,  8157,  8161,  8165,  8169,  8173,  8177,  8185,
    8189,  8197,  8205,  8209,  8217,  8221,  8226,  8232,  8238,  8248,
    8253,  8259,  8263,  8267,  8271,  8279,  8281,  8289,  8294,  8300,
    8308,  8312,  8316,  8324,  8328,  8336,  8344,  8349,  8355,  8363,
    8368,  8374,  8382,  8387,  8393,  8397,  8401,  8405,  8409,  8413,
    8417,  8421,  8429,  8434,  8440,  8448,  8452,  8460,  8464,  8472,
    8480,  8488,  8496,  8500,  8508,  8561,  8565,  8578,  8580,  8584,
    8588,  8592,  8601,  8607,  8611,  8619,  8623,  8631,  8635,  8643,
    8647,  8651,  8655,  8659,  8663,  8667,  8671,  8679,  8683,  8691,
    8695,  8699,  8703,  8707,  8711,  8719,  8723,  8731,  8735,  8743,
    8751,  8756,  8762,  8767,  8769,  8775,  8779,  8783,  8787,  8791,
    8795,  8799,  8803,  8807,  8815,  8820,  8826,  8830,  8835,  8841,
    8845,  8849,  8854,  8860,  8865,  8871,  8879,  8883,  8891,  8895,
    8903,  8907,  8911,  8915,  8923,  8928,  8934,  8938,  8943,  8951,
    8955,  8963,  8967,  8975,  8983,  8987,  8992,  8998,  9006,  9010,
    9018,  9022,  9030,  9035,  9041,  9046,  9052,  9056,  9064,  9069,
    9075,  9079,  9087,  9095,  9099,  9103,  9107,  9115,  9120,  9126,
    9130,  9138,  9143,  9149,  9153,  9161,  9165,  9169,  9173,  9180,
    9187,  9191,  9199,  9203,  9207,  9211,  9215,  9219,  9227,  9231,
    9235,  9239,  9247,  9252,  9258,  9262,  9266,  9270,  9275,  9281,
    9285,  9289,  9293,  9301,  9306,  9312,  9316,  9324,  9328,  9332,
    9336,  9344,  9348,  9356,  9360,  9364,  9372,  9376,  9384,  9392,
    9396,  9404,  9409,  9415,  9420,  9426,  9431,  9437,  9441,  9447,
    9453,  9458,  9464,  9468,  9476,  9484,  9486,  9488,  9492,  9496,
    9500,  9508,  9518,  9529,  9538,  9542,  9546,  9550,  9554,  9558,
    9562,  9570,  9574,  9578,  9582,  9590,  9594,  9602,  9607,  9613,
    9617,  9621,  9625,  9629,  9633,  9637,  9641,  9645,  9649,  9653,
    9661,  9666,  9672,  9676,  9684,  9688,  9696,  9704,  9712,  9716,
    9724,  9728,  9736,  9744,  9752,  9756,  9760,  9764,  9768,  9772,
    9780,  9785,  9791,  9796,  9802,  9806,  9810,  9814,  9822,  9830,
    9834,  9839,  9845,  9849,  9853,  9857,  9861,  9865,  9869,  9873,
    9877,  9881,  9885,  9889,  9893,  9898,  9904,  9908,  9916,  9920,
    9924,  9928,  9932,  9936,  9940,  9944,  9948,  9952,  9956,  9960,
    9964,  9968,  9972,  9976,  9980,  9984,  9988,  9992,  9996, 10000,
   10004, 10008, 10012, 10016, 10020, 10024, 10028, 10032, 10036, 10040,
   10044, 10048, 10052, 10056, 10060, 10064, 10068, 10072, 10076, 10080,
   10084, 10088, 10092, 10096, 10100, 10104, 10108, 10112, 10116, 10120,
   10124, 10128, 10132, 10136, 10140, 10145, 10149, 10157, 10161, 10165,
   10169, 10173, 10177, 10181, 10185, 10189, 10193, 10197, 10201, 10205,
   10209, 10213, 10217, 10221, 10225, 10229, 10233, 10237, 10241, 10249,
   10253, 10257, 10261, 10265, 10269, 10273, 10277, 10281, 10285, 10289,
   10293, 10301, 10305, 10309, 10313, 10317, 10321, 10325, 10333, 10337,
   10345, 10349, 10357, 10361, 10365, 10369, 10373, 10377, 10381, 10385,
   10389, 10393, 10397, 10401, 10405, 10409, 10413, 10417, 10421, 10425,
   10429, 10433, 10437, 10441, 10445, 10449, 10453, 10457, 10461, 10465,
   10469, 10473, 10477, 10481, 10485, 10489, 10493, 10497, 10501, 10505,
   10509, 10513, 10517, 10521, 10529, 10533, 10541, 10545, 10549, 10554,
   10560, 10568, 10572, 10580, 10584, 10592, 10596, 10604, 10608, 10613,
   10619, 10623, 10627, 10631, 10639, 10644, 10650, 10655, 10661, 10666,
   10672, 10676, 10684, 10692, 10696, 10701, 10707, 10715, 10719, 10726,
   10731, 10737, 10742, 10747, 10753, 10757, 10765, 10769, 10773, 10777,
   10781, 10789, 10793, 10797, 10805, 10809, 10813, 10821, 10825, 10833,
   10837, 10841, 10845, 10849, 10853, 10857, 10861, 10865, 10873, 10877,
   10885, 10889, 10897, 10901, 10905, 10909, 10913, 10917, 10925, 10929,
   10937, 10941, 10949, 10953, 10961, 10965, 10973, 10977, 10981, 10989,
   10993, 11001, 11006, 11012, 11016, 11020, 11024, 11028, 11032, 11036,
   11040, 11048, 11052, 11060, 11068, 11073, 11079, 11083, 11087, 11091,
   11095, 11100, 11106, 11114, 11122, 11126, 11130, 11138, 11142, 11150,
   11158, 11162, 11170, 11178, 11183, 11189, 11194, 11200, 11204, 11212,
   11216, 11220, 11224, 11232, 11236, 11245, 11247, 11255, 11260, 11266,
   11270, 11278, 11282, 11290, 11298, 11303, 11309, 11313, 11321, 11325,
   11329, 11333, 11341, 11345, 11353, 11357, 11365, 11369, 11377, 11385,
   11393, 11401, 11409, 11417, 11425, 11429, 11437, 11441, 11445, 11449,
   11453, 11457, 11461, 11465, 11469, 11473, 11477, 11481, 11485, 11489,
   11490, 11495, 11501, 11509, 11513, 11521, 11525, 11526, 11530, 11538,
   11542, 11546, 11550, 11558, 11562, 11566, 11570, 11574, 11578, 11582,
   11586, 11590, 11594, 11598, 11602, 11606, 11610, 11614, 11618, 11622,
   11626, 11630, 11634, 11638, 11642, 11646, 11650, 11654, 11658, 11662,
   11666, 11670, 11674, 11678, 11682, 11686, 11690, 11694, 11698, 11702,
   11706, 11710, 11714, 11718, 11722, 11726, 11730, 11734, 11738, 11742,
   11746, 11750, 11754, 11758, 11762, 11766, 11770, 11774, 11778, 11782,
   11786, 11790, 11794, 11798, 11802, 11806, 11810, 11814, 11818, 11822,
   11826, 11830, 11834, 11838, 11842, 11846, 11850, 11854, 11858, 11862,
   11866, 11870, 11874, 11878, 11882, 11886, 11890, 11894, 11898, 11902,
   11906, 11910, 11914, 11918, 11922, 11926, 11930, 11934, 11938, 11942,
   11946, 11950, 11954, 11958, 11962, 11966, 11970, 11974, 11978, 11982,
   11986, 11990, 11994, 11998, 12002, 12006, 12010, 12014, 12018, 12022,
   12026, 12030, 12034, 12038, 12042, 12046, 12050, 12054, 12058, 12062,
   12066, 12070, 12074, 12078, 12082, 12086, 12090, 12094, 12098, 12102,
   12106, 12110, 12114, 12118, 12122, 12126, 12130, 12134, 12138, 12142,
   12146, 12150, 12154, 12158, 12162, 12166, 12170, 12174, 12178, 12182,
   12186, 12190, 12194, 12198, 12202, 12206, 12210, 12214, 12218, 12222,
   12226, 12230, 12234, 12238, 12242, 12246, 12250, 12254, 12258, 12262,
   12266, 12270, 12274, 12278, 12282, 12286, 12290, 12294, 12298, 12302,
   12306, 12310, 12314, 12318, 12322, 12326, 12330, 12334, 12338, 12342,
   12346, 12350, 12354, 12358, 12362, 12366, 12370, 12374, 12378, 12382,
   12386, 12390, 12394, 12398, 12402, 12406, 12410, 12414, 12418, 12422,
   12426, 12430, 12434, 12438, 12442, 12446, 12450, 12454, 12458, 12462,
   12466, 12470, 12474, 12478, 12482, 12486, 12490, 12494, 12498, 12502,
   12506, 12510, 12514, 12518, 12522, 12526, 12530, 12534, 12538, 12542,
   12546, 12550, 12554, 12562, 12566, 12570, 12574, 12578, 12582, 12586,
   12590, 12594, 12598, 12602, 12606, 12610, 12614, 12618, 12622, 12626,
   12630, 12634, 12638, 12642, 12646, 12650, 12654, 12658, 12662, 12666,
   12670, 12674, 12678, 12682, 12686, 12690, 12694, 12698, 12702, 12706,
   12710, 12714, 12718, 12722, 12726, 12730, 12734, 12742, 12746, 12750,
   12754, 12758, 12762, 12766, 12770, 12774, 12778, 12782, 12786, 12790,
   12794, 12798, 12802, 12806, 12810, 12814, 12818, 12822, 12826, 12834,
   12838, 12842, 12846, 12850, 12854, 12858, 12862, 12866, 12870, 12874,
   12878, 12882, 12886, 12890, 12894, 12898, 12902, 12906, 12910, 12914,
   12918, 12922, 12926, 12930, 12934, 12938, 12942, 12946, 12950, 12954,
   12958, 12962, 12966, 12970, 12974, 12978, 12982, 12986, 12990, 12994,
   12998, 13002, 13006, 13010, 13014, 13018, 13022, 13026, 13030, 13034,
   13038, 13042, 13046, 13050, 13054, 13058, 13062, 13066, 13070, 13074,
   13078, 13082, 13086, 13090, 13094, 13098, 13102, 13106, 13110, 13114,
   13118, 13122, 13126, 13130, 13140, 13141, 13144, 13145, 13146, 13152,
   13153, 13154, 13155, 13156, 13169, 13169, 13178, 13193, 13195, 13198,
   13200, 13204, 13216, 13232, 13236, 13247, 13248, 13251, 13263, 13272,
   13273, 13276, 13277, 13278, 13281, 13282, 13285, 13286, 13289, 13290,
   13293, 13295, 13297, 13299, 13303, 13310, 13317, 13333, 13367, 13377,
   13380, 13384, 13397, 13398, 13400, 13402, 13406, 13420, 13427, 13488,
   13497, 13499, 13500, 13503, 13505, 13506, 13509, 13510, 13511, 13512,
   13513, 13520, 13519, 13529, 13531, 13533, 13534, 13537, 13538, 13539,
   13540, 13543, 13544, 13548, 13547, 13564, 13562, 13578, 13577, 13591,
   13597, 13598, 13601, 13603, 13604, 13607, 13608, 13609, 13610, 13613,
   13614, 13617, 13625, 13642, 13650, 13673, 13779, 13813, 13815, 13817,
   13821, 13825, 13824, 13875, 13877, 13876, 13891, 13897, 13904, 13909,
   13915, 13916, 13919, 13920, 13921, 13922, 13923, 13924, 13925, 13933,
   13941, 13944, 13945, 13946, 13947, 13948, 13949, 13957, 13965, 13966,
   13967, 13970, 13971, 13974, 13976, 13985, 14073, 14074, 14081, 14082,
   14083, 14089, 14098, 14101, 14102, 14103, 14104, 14107, 14108, 14109,
   14112, 14114, 14122, 14123, 14129, 14137, 14138, 14141, 14142, 14145,
   14150, 14157, 14162, 14169, 14176, 14176, 14178, 14185, 14186, 14189,
   14190, 14191, 14192, 14193, 14194, 14195, 14196, 14197, 14203, 14210,
   14222, 14228, 14235, 14243, 14244, 14256, 14267, 14278, 14282, 14283,
   14286, 14291, 14295, 14296, 14299, 14305, 14313, 14319, 14326, 14330,
   14331, 14334, 14337, 14341, 14342, 14345, 14351, 14360, 14365, 14375,
   14385, 14397, 14398, 14399, 14400, 14401, 14402, 14403, 14404, 14405,
   14406, 14407, 14408, 14409, 14410, 14411, 14418, 14419, 14422, 14423,
   14430, 14431, 14432, 14439, 14438, 14455, 14456, 14463, 14462, 14532,
   14538, 14544, 14552, 14558, 14564, 14570, 14576, 14582, 14588, 14594,
   14600, 14611, 14612, 14615, 14616, 14617, 14618, 14619, 14620, 14621,
   14622, 14623, 14624, 14625, 14626, 14627, 14628, 14629, 14630, 14631,
   14632, 14633, 14634, 14635, 14636, 14637, 14638, 14641, 14642, 14643,
   14644, 14645, 14646, 14650, 14651, 14652, 14653, 14654, 14655, 14656,
   14659, 14662, 14663, 14664, 14665, 14666, 14667, 14668, 14669, 14682,
   14683, 14684, 14685, 14686, 14687, 14688, 14693, 14694, 14695, 14696,
   14697, 14698, 14704, 14705, 14706, 14707, 14708, 14709, 14710, 14711,
   14712, 14713, 14714, 14717, 14718, 14719, 14720, 14721, 14724, 14725,
   14726, 14727, 14730, 14731, 14732, 14733, 14734, 14735, 14736, 14753,
   14754, 14755, 14758, 14759, 14760, 14761, 14762, 14763, 14767, 14767,
   14770, 14776, 14777, 14780, 14782, 14787, 14797, 14808, 14815, 14816,
   14817, 14820, 14853, 14855, 14857, 14860, 14870, 14880, 14890, 14891,
   14894, 14896, 14897, 14898, 14901, 14903, 14911, 14912, 14913, 14917,
   14918, 14922, 14923, 14926, 14927, 14930, 14931, 14932, 14933, 14934,
   14937, 14938, 14939, 14940, 14941, 14942, 14943, 14944, 14945, 14946,
   14947, 14948, 14949, 14950, 14951, 14952, 14953, 14954, 14955, 14956,
   14957, 14958, 14959, 14960, 14961, 14962, 14963, 14964, 14965, 14966,
   14967, 14968, 14969, 14970, 14971, 14972, 14973, 14974, 14975, 14976,
   14977, 14978, 14979, 14980, 14981, 14982, 14983, 14984, 14985, 14986,
   14987, 14988, 14989, 14990, 14991, 14992, 14995, 14996, 14997, 14998,
   15001, 15002, 15003, 15004, 15005, 15006, 15007, 15008, 15009, 15010,
   15017, 15018, 15019, 15020, 15021, 15024, 15025, 15028, 15029, 15040,
   15041
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT",
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT",
  "SQL_COUNT", "SQL_DATETIME_INTERVAL_CODE",
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR",
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GET", "SQL_GO",
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER",
  "SQL_LENGTH", "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", "SQL_OPEN",
  "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH",
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT",
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT",
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED",
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO",
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN",
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL",
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB",
  "S_VOLATILE", "S_TYPEDEF", "CSTRING", "CVARIABLE", "CPP_LINE", "IP",
  "DOLCONST", "ECONST", "NCONST", "UCONST", "UIDENT", "IDENT", "FCONST",
  "SCONST", "BCONST", "XCONST", "Op", "ICONST", "PARAM", "TYPECAST",
  "DOT_DOT", "COLON_EQUALS", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION",
  "ADD_P", "ADMIN", "AFTER", "AGGREGATE", "ALL", "ALSO", "ALTER", "ALWAYS",
  "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION",
  "ASSIGNMENT", "ASYMMETRIC", "AT", "ATTRIBUTE", "AUTHORIZATION",
  "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", "BINARY", "BIT",
  "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", "CASCADE", "CASCADED",
  "CASE", "CAST", "CATALOG_P", "CHAIN", "CHAR_P", "CHARACTER",
  "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER",
  "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMENT", "COMMENTS",
  "COMMIT", "COMMITTED", "CONCURRENTLY", "CONFIGURATION", "CONNECTION",
  "CONSTRAINT", "CONSTRAINTS", "CONTENT_P", "CONTINUE_P", "CONVERSION_P",
  "COPY", "COST", "CREATE", "CROSS", "CSV", "CURRENT_P", "CURRENT_CATALOG",
  "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_SCHEMA", "CURRENT_TIME",
  "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", "DATA_P",
  "DATABASE", "DAY_P", "DEALLOCATE", "DEC", "DECIMAL_P", "DECLARE",
  "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", "DELETE_P",
  "DELIMITER", "DELIMITERS", "DESC", "DICTIONARY", "DISABLE_P", "DISCARD",
  "DISTINCT", "DO", "DOCUMENT_P", "DOMAIN_P", "DOUBLE_P", "DROP", "EACH",
  "ELSE", "ENABLE_P", "ENCODING", "ENCRYPTED", "END_P", "ENUM_P", "ESCAPE",
  "EVENT", "EXCEPT", "EXCLUDE", "EXCLUDING", "EXCLUSIVE", "EXECUTE",
  "EXISTS", "EXPLAIN", "EXTENSION", "EXTERNAL", "EXTRACT", "FALSE_P",
  "FAMILY", "FETCH", "FILTER", "FIRST_P", "FLOAT_P", "FOLLOWING", "FOR",
  "FORCE", "FOREIGN", "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION",
  "FUNCTIONS", "GLOBAL", "GRANT", "GRANTED", "GREATEST", "GROUP_P",
  "HANDLER", "HAVING", "HEADER_P", "HOLD", "HOUR_P", "IDENTITY_P", "IF_P",
  "ILIKE", "IMMEDIATE", "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING",
  "INCREMENT", "INDEX", "INDEXES", "INHERIT", "INHERITS", "INITIALLY",
  "INLINE_P", "INNER_P", "INOUT", "INPUT_P", "INSENSITIVE", "INSERT",
  "INSTEAD", "INT_P", "INTEGER", "INTERSECT", "INTERVAL", "INTO",
  "INVOKER", "IS", "ISNULL", "ISOLATION", "JOIN", "KEY", "LABEL",
  "LANGUAGE", "LARGE_P", "LAST_P", "LATERAL_P", "LC_COLLATE_P",
  "LC_CTYPE_P", "LEADING", "LEAKPROOF", "LEAST", "LEFT", "LEVEL", "LIKE",
  "LIMIT", "LISTEN", "LOAD", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP",
  "LOCATION", "LOCK_P", "MAPPING", "MATCH", "MATERIALIZED", "MAXVALUE",
  "MINUTE_P", "MINVALUE", "MODE", "MONTH_P", "MOVE", "NAME_P", "NAMES",
  "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NONE", "NOT", "NOTHING",
  "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF", "NULLS_P", "NUMERIC",
  "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "ON", "ONLY", "OPERATOR",
  "OPTION", "OPTIONS", "OR", "ORDER", "ORDINALITY", "OUT_P", "OUTER_P",
  "OVER", "OVERLAPS", "OVERLAY", "OWNED", "OWNER", "PARSER", "PARTIAL",
  "PARTITION", "PASSING", "PASSWORD", "PLACING", "PLANS", "POSITION",
  "PRECEDING", "PRECISION", "PRESERVE", "PREPARE", "PREPARED", "PRIMARY",
  "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE", "PROGRAM", "QUOTE",
  "RANGE", "READ", "REAL", "REASSIGN", "RECHECK", "RECURSIVE", "REF",
  "REFERENCES", "REFRESH", "REINDEX", "RELATIVE_P", "RELEASE", "RENAME",
  "REPEATABLE", "REPLACE", "REPLICA", "RESET", "RESTART", "RESTRICT",
  "RETURNING", "RETURNS", "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "ROW",
  "ROWS", "RULE", "SAVEPOINT", "SCHEMA", "SCROLL", "SEARCH", "SECOND_P",
  "SECURITY", "SELECT", "SEQUENCE", "SEQUENCES", "SERIALIZABLE", "SERVER",
  "SESSION", "SESSION_USER", "SET", "SETOF", "SHARE", "SHOW", "SIMILAR",
  "SIMPLE", "SMALLINT", "SNAPSHOT", "SOME", "STABLE", "STANDALONE_P",
  "START", "STATEMENT", "STATISTICS", "STDIN", "STDOUT", "STORAGE",
  "STRICT_P", "STRIP_P", "SUBSTRING", "SYMMETRIC", "SYSID", "SYSTEM_P",
  "TABLE", "TABLES", "TABLESPACE", "TEMP", "TEMPLATE", "TEMPORARY",
  "TEXT_P", "THEN", "TIME", "TIMESTAMP", "TO", "TRAILING", "TRANSACTION",
  "TREAT", "TRIGGER", "TRIM", "TRUE_P", "TRUNCATE", "TRUSTED", "TYPE_P",
  "TYPES_P", "UNBOUNDED", "UNCOMMITTED", "UNENCRYPTED", "UNION", "UNIQUE",
  "UNKNOWN", "UNLISTEN", "UNLOGGED", "UNTIL", "UPDATE", "USER", "USING",
  "VACUUM", "VALID", "VALIDATE", "VALIDATOR", "VALUE_P", "VALUES",
  "VARCHAR", "VARIADIC", "VARYING", "VERBOSE", "VERSION_P", "VIEW",
  "VIEWS", "VOLATILE", "WHEN", "WHERE", "WHITESPACE_P", "WINDOW", "WITH",
  "WITHIN", "WITHOUT", "WORK", "WRAPPER", "WRITE", "XML_P",
  "XMLATTRIBUTES", "XMLCONCAT", "XMLELEMENT", "XMLEXISTS", "XMLFOREST",
  "XMLPARSE", "XMLPI", "XMLROOT", "XMLSERIALIZE", "YEAR_P", "YES_P",
  "ZONE", "NULLS_FIRST", "NULLS_LAST", "WITH_ORDINALITY", "WITH_TIME",
  "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", "'%'",
  "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", "','", "';'", "':'",
  "'{'", "'}'", "$accept", "prog", "stmt", "CreateRoleStmt", "opt_with",
  "OptRoleList", "AlterOptRoleList", "AlterOptRoleElem",
  "CreateOptRoleElem", "CreateUserStmt", "AlterRoleStmt",
  "opt_in_database", "AlterRoleSetStmt", "AlterUserStmt",
  "AlterUserSetStmt", "DropRoleStmt", "DropUserStmt", "CreateGroupStmt",
  "AlterGroupStmt", "add_drop", "DropGroupStmt", "CreateSchemaStmt",
  "OptSchemaName", "OptSchemaEltList", "schema_stmt", "VariableSetStmt",
  "set_rest", "generic_set", "set_rest_more", "var_name", "var_list",
  "var_value", "iso_level", "opt_boolean_or_string", "zone_value",
  "opt_encoding", "NonReservedWord_or_Sconst", "VariableResetStmt",
  "SetResetClause", "FunctionSetResetClause", "VariableShowStmt",
  "ConstraintsSetStmt", "constraints_set_list", "constraints_set_mode",
  "CheckPointStmt", "DiscardStmt", "AlterTableStmt", "alter_table_cmds",
  "alter_table_cmd", "alter_column_default", "opt_drop_behavior",
  "opt_collate_clause", "alter_using", "replica_identity", "reloptions",
  "opt_reloptions", "reloption_list", "reloption_elem",
  "AlterCompositeTypeStmt", "alter_type_cmds", "alter_type_cmd",
  "ClosePortalStmt", "CopyStmt", "copy_from", "opt_program",
  "copy_file_name", "copy_options", "copy_opt_list", "copy_opt_item",
  "opt_binary", "opt_oids", "copy_delimiter", "opt_using",
  "copy_generic_opt_list", "copy_generic_opt_elem", "copy_generic_opt_arg",
  "copy_generic_opt_arg_list", "copy_generic_opt_arg_list_item",
  "CreateStmt", "OptTemp", "OptTableElementList",
  "OptTypedTableElementList", "TableElementList", "TypedTableElementList",
  "TableElement", "TypedTableElement", "columnDef", "columnOptions",
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr",
  "TableLikeClause", "TableLikeOptionList", "TableLikeOption",
  "TableConstraint", "ConstraintElem", "opt_no_inherit", "opt_column_list",
  "columnList", "columnElem", "key_match", "ExclusionConstraintList",
  "ExclusionConstraintElem", "ExclusionWhereClause", "key_actions",
  "key_update", "key_delete", "key_action", "OptInherit", "OptWith",
  "OnCommitOption", "OptTableSpace", "OptConsTableSpace", "ExistingIndex",
  "create_as_target", "opt_with_data", "CreateMatViewStmt",
  "create_mv_target", "OptNoLog", "RefreshMatViewStmt", "CreateSeqStmt",
  "AlterSeqStmt", "OptSeqOptList", "SeqOptList", "SeqOptElem", "opt_by",
  "NumericOnly", "NumericOnly_list", "CreatePLangStmt", "opt_trusted",
  "handler_name", "opt_inline_handler", "validator_clause",
  "opt_validator", "DropPLangStmt", "opt_procedural",
  "CreateTableSpaceStmt", "OptTableSpaceOwner", "DropTableSpaceStmt",
  "CreateExtensionStmt", "create_extension_opt_list",
  "create_extension_opt_item", "AlterExtensionStmt",
  "alter_extension_opt_list", "alter_extension_opt_item",
  "AlterExtensionContentsStmt", "CreateFdwStmt", "fdw_option",
  "fdw_options", "opt_fdw_options", "DropFdwStmt", "AlterFdwStmt",
  "create_generic_options", "generic_option_list", "alter_generic_options",
  "alter_generic_option_list", "alter_generic_option_elem",
  "generic_option_elem", "generic_option_name", "generic_option_arg",
  "CreateForeignServerStmt", "opt_type", "foreign_server_version",
  "opt_foreign_server_version", "DropForeignServerStmt",
  "AlterForeignServerStmt", "CreateForeignTableStmt",
  "AlterForeignTableStmt", "CreateUserMappingStmt", "auth_ident",
  "DropUserMappingStmt", "AlterUserMappingStmt", "CreateTrigStmt",
  "TriggerActionTime", "TriggerEvents", "TriggerOneEvent",
  "TriggerForSpec", "TriggerForOptEach", "TriggerForType", "TriggerWhen",
  "TriggerFuncArgs", "TriggerFuncArg", "OptConstrFromTable",
  "ConstraintAttributeSpec", "ConstraintAttributeElem", "DropTrigStmt",
  "CreateEventTrigStmt", "event_trigger_when_list",
  "event_trigger_when_item", "event_trigger_value_list",
  "AlterEventTrigStmt", "enable_trigger", "CreateAssertStmt",
  "DropAssertStmt", "DefineStmt", "definition", "def_list", "def_elem",
  "def_arg", "old_aggr_definition", "old_aggr_list", "old_aggr_elem",
  "opt_enum_val_list", "enum_val_list", "AlterEnumStmt",
  "opt_if_not_exists", "CreateOpClassStmt", "opclass_item_list",
  "opclass_item", "opt_default", "opt_opfamily", "opclass_purpose",
  "opt_recheck", "CreateOpFamilyStmt", "AlterOpFamilyStmt",
  "opclass_drop_list", "opclass_drop", "DropOpClassStmt",
  "DropOpFamilyStmt", "DropOwnedStmt", "ReassignOwnedStmt", "DropStmt",
  "drop_type", "any_name_list", "any_name", "attrs", "TruncateStmt",
  "opt_restart_seqs", "CommentStmt", "comment_type", "comment_text",
  "SecLabelStmt", "opt_provider", "security_label_type", "security_label",
  "FetchStmt", "fetch_args", "from_in", "opt_from_in", "GrantStmt",
  "RevokeStmt", "privileges", "privilege_list", "privilege",
  "privilege_target", "grantee_list", "grantee", "opt_grant_grant_option",
  "function_with_argtypes_list", "function_with_argtypes", "GrantRoleStmt",
  "RevokeRoleStmt", "opt_grant_admin_option", "opt_granted_by",
  "AlterDefaultPrivilegesStmt", "DefACLOptionList", "DefACLOption",
  "DefACLAction", "defacl_privilege_target", "IndexStmt", "opt_unique",
  "opt_concurrently", "opt_index_name", "access_method_clause",
  "index_params", "index_elem", "opt_collate", "opt_class", "opt_asc_desc",
  "opt_nulls_order", "CreateFunctionStmt", "opt_or_replace", "func_args",
  "func_args_list", "func_args_with_defaults",
  "func_args_with_defaults_list", "func_arg", "arg_class", "param_name",
  "func_return", "func_type", "func_arg_with_default", "aggr_arg",
  "aggr_args", "aggr_args_list", "createfunc_opt_list",
  "common_func_opt_item", "createfunc_opt_item", "func_as",
  "opt_definition", "table_func_column", "table_func_column_list",
  "AlterFunctionStmt", "alterfunc_opt_list", "opt_restrict",
  "RemoveFuncStmt", "RemoveAggrStmt", "RemoveOperStmt", "oper_argtypes",
  "any_operator", "DoStmt", "dostmt_opt_list", "dostmt_opt_item",
  "CreateCastStmt", "cast_context", "DropCastStmt", "opt_if_exists",
  "ReindexStmt", "reindex_type", "opt_force", "AlterTblSpcStmt",
  "RenameStmt", "opt_column", "opt_set_data", "AlterObjectSchemaStmt",
  "AlterOwnerStmt", "RuleStmt", "RuleActionList", "RuleActionMulti",
  "RuleActionStmt", "RuleActionStmtOrEmpty", "event", "opt_instead",
  "DropRuleStmt", "NotifyStmt", "notify_payload", "ListenStmt",
  "UnlistenStmt", "TransactionStmt", "opt_transaction",
  "transaction_mode_item", "transaction_mode_list",
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option",
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item",
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt",
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", "AlterSystemStmt",
  "CreateDomainStmt", "AlterDomainStmt", "opt_as", "AlterTSDictionaryStmt",
  "AlterTSConfigurationStmt", "CreateConversionStmt", "ClusterStmt",
  "cluster_index_specification", "VacuumStmt", "vacuum_option_list",
  "vacuum_option_elem", "AnalyzeStmt", "analyze_keyword", "opt_verbose",
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt",
  "ExplainableStmt", "explain_option_list", "explain_option_elem",
  "explain_option_name", "explain_option_arg", "PrepareStmt",
  "prep_type_clause", "PreparableStmt", "ExecuteStmt",
  "execute_param_clause", "InsertStmt", "insert_rest",
  "insert_column_list", "insert_column_item", "returning_clause",
  "DeleteStmt", "using_clause", "LockStmt", "opt_lock", "lock_type",
  "opt_nowait", "UpdateStmt", "set_clause_list", "set_clause",
  "single_set_clause", "multiple_set_clause", "set_target",
  "set_target_list", "DeclareCursorStmt", "cursor_name", "cursor_options",
  "opt_hold", "SelectStmt", "select_with_parens", "select_no_parens",
  "select_clause", "simple_select", "with_clause", "cte_list",
  "common_table_expr", "opt_with_clause", "into_clause",
  "OptTempTableName", "opt_table", "opt_all", "opt_distinct",
  "opt_sort_clause", "sort_clause", "sortby_list", "sortby",
  "select_limit", "opt_select_limit", "limit_clause", "offset_clause",
  "select_limit_value", "select_offset_value",
  "opt_select_fetch_first_value", "select_offset_value2", "row_or_rows",
  "first_or_next", "group_clause", "having_clause", "for_locking_clause",
  "opt_for_locking_clause", "for_locking_items", "for_locking_item",
  "for_locking_strength", "locked_rels_list", "values_clause",
  "from_clause", "from_list", "table_ref", "joined_table", "alias_clause",
  "opt_alias_clause", "func_alias_clause", "join_type", "join_outer",
  "join_qual", "relation_expr", "relation_expr_list",
  "relation_expr_opt_alias", "func_table", "rowsfrom_item",
  "rowsfrom_list", "opt_col_def_list", "opt_ordinality", "where_clause",
  "where_or_current_clause", "OptTableFuncElementList",
  "TableFuncElementList", "TableFuncElement", "Typename",
  "opt_array_bounds", "SimpleTypename", "ConstTypename", "GenericType",
  "opt_type_modifiers", "Numeric", "opt_float", "Bit", "ConstBit",
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter",
  "CharacterWithLength", "CharacterWithoutLength", "character",
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval",
  "opt_timezone", "opt_interval", "interval_second", "a_expr", "b_expr",
  "c_expr", "func_application", "func_expr", "func_expr_windowless",
  "func_expr_common_subexpr", "xml_root_version",
  "opt_xml_root_standalone", "xml_attributes", "xml_attribute_list",
  "xml_attribute_el", "document_or_content", "xml_whitespace_option",
  "xmlexists_argument", "within_group_clause", "filter_clause",
  "window_clause", "window_definition_list", "window_definition",
  "over_clause", "window_specification", "opt_existing_window_name",
  "opt_partition_clause", "opt_frame_clause", "frame_extent",
  "frame_bound", "row", "sub_type", "all_Op", "MathOp", "qual_Op",
  "qual_all_Op", "subquery_Op", "expr_list", "func_arg_list",
  "func_arg_expr", "type_list", "array_expr", "array_expr_list",
  "extract_list", "extract_arg", "overlay_list", "overlay_placing",
  "position_list", "substr_list", "substr_from", "substr_for", "trim_list",
  "in_expr", "case_expr", "when_clause_list", "when_clause",
  "case_default", "case_arg", "columnref", "indirection_el", "indirection",
  "opt_indirection", "opt_asymmetric", "ctext_expr", "ctext_expr_list",
  "ctext_row", "opt_target_list", "target_list", "target_el",
  "qualified_name_list", "qualified_name", "name_list", "name",
  "database_name", "access_method", "attr_name", "index_name", "file_name",
  "func_name", "AexprConst", "Iconst", "RoleId", "role_list",
  "SignedIconst", "NonReservedWord", "unreserved_keyword",
  "col_name_keyword", "type_func_name_keyword", "reserved_keyword",
  "statements", "statement", "CreateAsStmt", "$@1", "at", "ECPGConnect",
  "connection_target", "opt_database_name", "db_prefix", "server",
  "opt_server", "server_name", "opt_port", "opt_connection_name",
  "opt_user", "ora_user", "user_name", "char_variable", "opt_options",
  "connect_options", "opt_opt_value", "prepared_name", "ECPGCursorStmt",
  "ECPGExecuteImmediateStmt", "ECPGVarDeclaration",
  "single_vt_declaration", "precision", "opt_scale", "ecpg_interval",
  "ECPGDeclaration", "$@2", "sql_startdeclare", "sql_enddeclare",
  "var_type_declarations", "vt_declarations", "variable_declarations",
  "type_declaration", "$@3", "var_declaration", "$@4", "$@5",
  "opt_bit_field", "storage_declaration", "storage_clause",
  "storage_modifier", "var_type", "enum_type", "enum_definition",
  "struct_union_type_with_symbol", "$@6", "struct_union_type", "$@7",
  "s_struct_union_symbol", "s_struct_union", "simple_type",
  "unsigned_type", "signed_type", "opt_signed", "variable_list",
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare",
  "ECPGDisconnect", "dis_name", "connection_object", "execstring",
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using",
  "using_descriptor", "into_descriptor", "into_sqlda", "using_list",
  "UsingValue", "UsingConst", "ECPGDescribe", "opt_output",
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader",
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem",
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems",
  "ECPGSetDescHeaderItem", "IntConstVar", "desc_header_item",
  "ECPGGetDescriptor", "ECPGGetDescItems", "ECPGGetDescItem",
  "ECPGSetDescriptor", "ECPGSetDescItems", "ECPGSetDescItem",
  "AllConstVar", "descriptor_item", "ECPGSetAutocommit", "on_off",
  "ECPGSetConnection", "ECPGTypedef", "$@8", "opt_reference", "ECPGVar",
  "$@9", "ECPGWhenever", "action", "ECPGKeywords", "ECPGKeywords_vanames",
  "ECPGKeywords_rest", "ECPGTypeName", "symbol", "ECPGColId", "ColId",
  "type_function_name", "ColLabel", "ECPGColLabel", "ECPGColLabelCommon",
  "ECPGCKeywords", "all_unreserved_keyword", "ECPGunreserved_interval",
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind",
  "char_civar", "civar", "indicator", "cvariable", "ecpg_param",
  "ecpg_bconst", "ecpg_fconst", "ecpg_sconst", "ecpg_xconst", "ecpg_ident",
  "quoted_ident_stringvar", "c_stuff_item", "c_stuff", "c_list", "c_term",
  "c_thing", "c_anything", "DeallocateStmt", "Iresult", "execute_rest",
  "ecpg_into", "ecpg_fetch_into", "opt_ecpg_fetch_into", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
      61,    60,    62,   755,    43,    45,    42,    47,    37,    94,
     756,    91,    93,    40,    41,    46,    44,    59,    58,   123,
     125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   521,   522,   523,   523,   523,   523,   523,   523,   523,
     523,   523,   523,   523,   523,   523,   523,   523,   523,   523,
     523,   523,   523,   523,   523,   523,   523,   523,   523,   523,
     523,   523,   523,   523,   523,   523,   523,   523,   523,   523,
     523,   523,   523,   523,   523,   523,   523,   523,   523,   523,
     523,   523,   523,   523,   523,   523,   523,   523,   523,   523,
     523,   523,   523,   523,   523,   523,   523,   523,   523,   523,
     523,   523,   523,   523,   523,   523,   523,   523,   523,   523,
     523,   523,   523,   523,   523,   523,   523,   523,   523,   523,
     523,   523,   523,   523,   523,   523,   523,   523,   523,   523,
     523,   523,   523,   523,   523,   523,   523,   523,   523,   523,
     523,   523,   523,   523,   523,   523,   523,   523,   523,   523,
     523,   523,   523,   523,   523,   523,   523,   523,   523,   523,
     523,   523,   523,   523,   523,   523,   523,   523,   523,   524,
     525,   525,   526,   526,   527,   527,   528,   528,   528,   528,
     528,   528,   528,   528,   528,   529,   529,   529,   529,   529,
     529,   530,   531,   532,   532,   533,   533,   534,   535,   536,
     536,   537,   537,   538,   539,   540,   540,   541,   541,   542,
     542,   542,   542,   543,   543,   544,   544,   545,   545,   545,
     545,   545,   545,   546,   546,   546,   547,   547,   547,   548,
     548,   548,   548,   549,   549,   549,   549,   549,   549,   549,
     549,   549,   549,   549,   550,   550,   551,   551,   552,   552,
     553,   553,   553,   553,   554,   554,   554,   554,   555,   555,
     555,   555,   555,   555,   555,   556,   556,   556,   557,   557,
     558,   558,   558,   558,   558,   559,   559,   560,   560,   561,
     561,   561,   561,   561,   562,   563,   563,   564,   564,   565,
     566,   566,   566,   566,   566,   567,   567,   567,   567,   567,
     567,   567,   567,   567,   567,   568,   568,   569,   569,   569,
     569,   569,   569,   569,   569,   569,   569,   569,   569,   569,
     569,   569,   569,   569,   569,   569,   569,   569,   569,   569,
     569,   569,   569,   569,   569,   569,   569,   569,   569,   569,
     569,   569,   569,   569,   569,   569,   569,   569,   569,   569,
     569,   570,   570,   571,   571,   571,   572,   572,   573,   573,
     574,   574,   574,   574,   575,   576,   576,   577,   577,   578,
     578,   578,   578,   579,   580,   580,   581,   581,   581,   581,
     582,   582,   583,   583,   584,   584,   585,   585,   586,   586,
     586,   587,   587,   588,   588,   589,   589,   589,   589,   589,
     589,   589,   589,   589,   589,   589,   589,   589,   589,   590,
     590,   591,   591,   592,   592,   593,   593,   594,   594,   595,
     596,   596,   596,   596,   596,   597,   597,   598,   599,   599,
     599,   599,   600,   600,   600,   600,   600,   600,   600,   600,
     601,   601,   602,   602,   603,   603,   604,   604,   605,   605,
     605,   606,   606,   607,   608,   609,   609,   610,   610,   610,
     610,   611,   611,   611,   611,   611,   611,   611,   612,   612,
     612,   612,   613,   614,   614,   614,   615,   615,   615,   615,
     615,   615,   616,   616,   617,   617,   617,   617,   617,   617,
     617,   618,   618,   619,   619,   620,   620,   621,   622,   622,
     622,   622,   623,   623,   624,   624,   625,   625,   626,   626,
     626,   626,   626,   627,   628,   629,   629,   629,   629,   629,
     630,   630,   631,   631,   631,   631,   632,   632,   632,   632,
     633,   633,   634,   634,   635,   636,   637,   637,   637,   638,
     639,   640,   640,   641,   642,   643,   643,   644,   644,   645,
     645,   646,   646,   646,   646,   646,   646,   646,   646,   646,
     646,   646,   646,   647,   647,   648,   648,   648,   649,   649,
     650,   650,   651,   651,   652,   652,   653,   653,   654,   654,
     655,   655,   656,   656,   657,   657,   658,   659,   659,   660,
     660,   661,   661,   662,   662,   663,   663,   663,   664,   665,
     665,   666,   667,   667,   667,   667,   667,   667,   667,   667,
     667,   667,   667,   667,   667,   667,   667,   667,   667,   667,
     667,   667,   667,   667,   667,   667,   668,   669,   669,   669,
     669,   670,   670,   671,   671,   672,   672,   673,   673,   674,
     674,   675,   675,   676,   677,   677,   678,   678,   678,   678,
     679,   680,   681,   682,   683,   683,   684,   684,   685,   685,
     686,   686,   687,   687,   687,   688,   688,   689,   689,   690,
     691,   691,   691,   692,   692,   693,   694,   694,   695,   695,
     695,   696,   696,   697,   697,   697,   697,   697,   698,   698,
     699,   699,   700,   700,   701,   701,   702,   702,   702,   703,
     703,   703,   703,   704,   704,   705,   705,   706,   706,   706,
     706,   706,   706,   707,   707,   708,   708,   709,   709,   710,
     711,   711,   712,   713,   713,   713,   713,   714,   715,   716,
     716,   716,   716,   716,   716,   716,   716,   716,   716,   716,
     716,   716,   716,   717,   718,   718,   719,   719,   720,   720,
     720,   720,   720,   721,   722,   722,   723,   724,   724,   725,
     725,   726,   726,   726,   727,   727,   728,   729,   729,   730,
     730,   730,   730,   730,   731,   731,   732,   732,   733,   733,
     733,   734,   734,   735,   736,   736,   737,   737,   738,   738,
     739,   739,   740,   740,   741,   742,   743,   743,   743,   743,
     744,   744,   744,   744,   744,   744,   744,   744,   744,   744,
     744,   744,   744,   744,   744,   744,   744,   745,   745,   746,
     746,   747,   747,   748,   749,   749,   749,   750,   750,   750,
     750,   750,   750,   750,   750,   750,   750,   750,   750,   750,
     751,   751,   751,   751,   751,   751,   751,   751,   751,   751,
     751,   751,   751,   751,   751,   751,   751,   751,   751,   751,
     751,   751,   751,   752,   752,   753,   753,   753,   753,   753,
     754,   754,   755,   755,   755,   755,   755,   755,   755,   755,
     755,   755,   755,   755,   755,   756,   756,   757,   757,   757,
     757,   757,   757,   757,   757,   757,   757,   757,   758,   758,
     758,   758,   758,   758,   758,   758,   758,   758,   758,   758,
     758,   758,   759,   759,   760,   760,   761,   762,   762,   763,
     763,   763,   763,   763,   764,   764,   765,   765,   765,   765,
     766,   766,   766,   766,   766,   766,   766,   766,   766,   766,
     766,   766,   766,   766,   766,   766,   767,   767,   768,   768,
     769,   769,   770,   770,   771,   772,   773,   773,   774,   774,
     775,   775,   776,   777,   777,   778,   778,   778,   779,   779,
     779,   780,   780,   780,   780,   781,   782,   782,   783,   783,
     784,   784,   785,   785,   786,   786,   787,   787,   787,   788,
     788,   789,   789,   789,   790,   790,   790,   791,   791,   791,
     792,   792,   792,   793,   793,   794,   794,   795,   795,   796,
     796,   797,   797,   798,   798,   798,   798,   798,   799,   799,
     799,   799,   799,   800,   801,   802,   802,   802,   803,   803,
     803,   804,   805,   805,   805,   805,   806,   806,   807,   807,
     808,   808,   808,   808,   808,   808,   808,   808,   808,   808,
     808,   808,   808,   808,   808,   809,   809,   809,   809,   810,
     810,   811,   811,   812,   813,   813,   814,   815,   815,   816,
     816,   817,   817,   818,   818,   819,   819,   820,   820,   820,
     820,   821,   821,   822,   823,   823,   824,   824,   825,   825,
     825,   826,   826,   826,   827,   828,   828,   829,   829,   829,
     830,   830,   831,   831,   832,   832,   832,   832,   832,   832,
     832,   832,   832,   832,   833,   833,   833,   833,   833,   833,
     833,   833,   833,   833,   833,   833,   833,   833,   833,   833,
     833,   833,   833,   833,   833,   833,   833,   833,   833,   833,
     833,   833,   833,   833,   833,   833,   833,   833,   833,   833,
     833,   833,   833,   833,   833,   833,   833,   833,   833,   834,
     834,   835,   835,   836,   836,   836,   836,   836,   836,   836,
     836,   836,   836,   836,   836,   836,   836,   836,   836,   836,
     836,   836,   836,   836,   836,   836,   836,   837,   837,   837,
     837,   837,   837,   837,   837,   837,   837,   837,   837,   837,
     837,   837,   837,   837,   837,   837,   838,   839,   839,   839,
     840,   840,   841,   841,   841,   841,   841,   842,   842,   843,
     843,   843,   843,   844,   844,   844,   845,   845,   846,   847,
     847,   848,   849,   849,   850,   850,   850,   850,   850,   850,
     850,   850,   850,   850,   850,   850,   850,   850,   851,   851,
     851,   852,   852,   852,   852,   852,   853,   853,   853,   854,
     854,   855,   855,   855,   855,   856,   856,   856,   856,   857,
     858,   859,   859,   860,   860,   860,   860,   860,   860,   860,
     860,   860,   860,   860,   860,   860,   860,   860,   860,   861,
     861,   862,   862,   863,   864,   864,   865,   866,   866,   867,
     868,   869,   869,   869,   869,   869,   869,   869,   870,   870,
     871,   872,   872,   872,   872,   872,   872,   873,   874,   874,
     874,   875,   875,   876,   876,   876,   876,   876,   877,   877,
     878,   878,   878,   878,   879,   879,   880,   880,   881,   881,
     882,   882,   883,   883,   884,   884,   885,   885,   885,   885,
     886,   886,   886,   886,   886,   886,   886,   886,   886,   887,
     887,   888,   889,   889,   890,   890,   890,   891,   891,   892,
     892,   893,   893,   893,   893,   894,   894,   895,   895,   896,
     897,   897,   897,   898,   898,   899,   900,   900,   901,   902,
     902,   903,   904,   904,   905,   905,   905,   905,   905,   905,
     905,   905,   906,   906,   907,   908,   908,   909,   909,   910,
     911,   912,   913,   913,   914,   915,   915,   916,   916,   916,
     916,   916,   917,   917,   917,   918,   918,   919,   919,   920,
     920,   920,   920,   920,   920,   920,   920,   921,   921,   922,
     922,   922,   922,   922,   922,   923,   923,   924,   924,   925,
     926,   926,   927,   927,   927,   928,   928,   928,   928,   928,
     928,   928,   928,   928,   929,   929,   930,   930,   930,   931,
     931,   931,   931,   932,   932,   933,   934,   934,   935,   935,
     936,   936,   936,   936,   937,   937,   938,   938,   938,   939,
     939,   940,   940,   941,   942,   942,   942,   943,   944,   944,
     945,   945,   946,   946,   947,   947,   948,   948,   949,   949,
     950,   950,   951,   952,   952,   952,   952,   953,   953,   954,
     954,   955,   955,   956,   956,   957,   957,   957,   957,   957,
     957,   957,   958,   958,   958,   958,   958,   958,   959,   959,
     959,   959,   960,   960,   961,   961,   961,   961,   961,   962,
     962,   962,   962,   963,   963,   964,   964,   965,   965,   965,
     965,   966,   966,   967,   967,   967,   968,   968,   969,   970,
     970,   971,   971,   972,   972,   973,   973,   974,   974,   974,
     975,   975,   976,   976,   977,   978,   978,   978,   978,   978,
     978,   979,   979,   979,   980,   980,   980,   980,   980,   980,
     980,   981,   981,   981,   981,   982,   982,   983,   983,   984,
     984,   984,   984,   984,   984,   984,   984,   984,   984,   984,
     985,   985,   986,   986,   987,   987,   988,   989,   990,   990,
     991,   991,   992,   993,   994,   994,   994,   994,   994,   994,
     995,   995,   996,   996,   997,   997,   997,   997,   998,   999,
     999,   999,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,
    1000,  1000,  1000,  1000,  1000,  1000,  1001,  1001,  1002,  1002,
    1002,  1002,  1002,  1002,  1002,  1002,  1002,  1002,  1002,  1002,
    1002,  1002,  1002,  1002,  1002,  1002,  1002,  1002,  1002,  1002,
    1002,  1002,  1002,  1002,  1002,  1002,  1002,  1002,  1002,  1002,
    1002,  1002,  1002,  1002,  1002,  1002,  1002,  1002,  1002,  1002,
    1002,  1002,  1002,  1002,  1002,  1002,  1002,  1002,  1002,  1002,
    1002,  1002,  1002,  1002,  1002,  1002,  1002,  1003,  1003,  1003,
    1003,  1003,  1003,  1003,  1003,  1003,  1003,  1003,  1003,  1003,
    1003,  1003,  1003,  1003,  1003,  1003,  1003,  1003,  1003,  1004,
    1004,  1004,  1004,  1004,  1004,  1004,  1004,  1004,  1004,  1004,
    1004,  1005,  1005,  1005,  1005,  1005,  1005,  1005,  1006,  1006,
    1007,  1007,  1008,  1008,  1008,  1008,  1008,  1008,  1008,  1008,
    1008,  1008,  1008,  1008,  1008,  1008,  1008,  1008,  1008,  1008,
    1008,  1008,  1008,  1008,  1008,  1008,  1008,  1008,  1008,  1008,
    1008,  1008,  1008,  1008,  1008,  1008,  1008,  1008,  1008,  1008,
    1008,  1008,  1008,  1008,  1009,  1009,  1010,  1010,  1010,  1010,
    1011,  1012,  1012,  1013,  1013,  1014,  1014,  1015,  1015,  1015,
    1016,  1016,  1016,  1016,  1017,  1017,  1018,  1018,  1019,  1019,
    1020,  1020,  1021,  1022,  1022,  1022,  1023,  1024,  1024,  1025,
    1025,  1026,  1026,  1026,  1027,  1027,  1028,  1028,  1028,  1028,
    1028,  1029,  1029,  1029,  1030,  1030,  1030,  1031,  1031,  1032,
    1032,  1032,  1032,  1032,  1032,  1032,  1032,  1032,  1033,  1033,
    1034,  1034,  1035,  1035,  1035,  1035,  1035,  1035,  1036,  1036,
    1037,  1037,  1038,  1038,  1039,  1039,  1040,  1040,  1040,  1041,
    1041,  1042,  1042,  1043,  1043,  1043,  1043,  1043,  1043,  1043,
    1043,  1044,  1044,  1045,  1046,  1046,  1047,  1047,  1047,  1047,
    1047,  1047,  1048,  1049,  1050,  1050,  1050,  1051,  1051,  1052,
    1053,  1053,  1054,  1055,  1055,  1056,  1056,  1057,  1057,  1058,
    1058,  1058,  1058,  1059,  1059,  1060,  1060,  1061,  1061,  1062,
    1062,  1063,  1063,  1064,  1065,  1065,  1066,  1066,  1067,  1067,
    1067,  1067,  1068,  1068,  1069,  1069,  1070,  1070,  1071,  1072,
    1073,  1074,  1075,  1076,  1077,  1077,  1078,  1078,  1078,  1078,
    1078,  1078,  1078,  1078,  1078,  1078,  1078,  1078,  1078,  1078,
    1078,  1079,  1080,  1081,  1081,  1082,  1082,  1082,  1082,  1083,
    1083,  1083,  1083,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1085,  1085,  1085,  1085,  1085,  1085,  1085,
    1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,
    1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,
    1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,
    1085,  1085,  1085,  1085,  1085,  1085,  1085,  1086,  1086,  1086,
    1086,  1086,  1086,  1086,  1086,  1086,  1086,  1086,  1086,  1086,
    1086,  1086,  1086,  1086,  1086,  1086,  1086,  1086,  1086,  1087,
    1087,  1087,  1087,  1087,  1087,  1087,  1087,  1087,  1087,  1087,
    1087,  1087,  1087,  1087,  1087,  1087,  1087,  1087,  1087,  1087,
    1087,  1087,  1087,  1087,  1087,  1087,  1087,  1087,  1087,  1087,
    1087,  1087,  1087,  1087,  1087,  1087,  1087,  1087,  1087,  1087,
    1087,  1087,  1087,  1087,  1087,  1087,  1087,  1087,  1087,  1087,
    1087,  1087,  1087,  1087,  1087,  1087,  1087,  1087,  1087,  1087,
    1087,  1087,  1087,  1087,  1087,  1087,  1087,  1087,  1087,  1087,
    1087,  1087,  1087,  1087,  1088,  1088,  1089,  1089,  1089,  1089,
    1089,  1089,  1089,  1089,  1091,  1090,  1092,  1093,  1093,  1093,
    1093,  1094,  1094,  1094,  1094,  1095,  1095,  1096,  1097,  1098,
    1098,  1099,  1099,  1099,  1100,  1100,  1101,  1101,  1102,  1102,
    1103,  1103,  1103,  1103,  1104,  1104,  1104,  1105,  1106,  1106,
    1107,  1107,  1108,  1108,  1108,  1108,  1109,  1109,  1110,  1111,
    1112,  1113,  1113,  1114,  1115,  1115,  1116,  1116,  1116,  1116,
    1116,  1118,  1117,  1119,  1120,  1121,  1121,  1122,  1122,  1122,
    1122,  1123,  1123,  1125,  1124,  1127,  1126,  1128,  1126,  1126,
    1129,  1129,  1130,  1130,  1130,  1131,  1131,  1131,  1131,  1132,
    1132,  1133,  1133,  1133,  1133,  1133,  1133,  1134,  1134,  1134,
    1135,  1137,  1136,  1138,  1139,  1138,  1140,  1140,  1141,  1141,
    1142,  1142,  1143,  1143,  1143,  1143,  1143,  1143,  1143,  1143,
    1143,  1144,  1144,  1144,  1144,  1144,  1144,  1144,  1144,  1144,
    1144,  1145,  1145,  1146,  1146,  1147,  1148,  1148,  1149,  1149,
    1149,  1150,  1151,  1152,  1152,  1152,  1152,  1153,  1153,  1153,
    1154,  1154,  1155,  1155,  1156,  1157,  1157,  1158,  1158,  1159,
    1159,  1160,  1160,  1161,  1162,  1162,  1163,  1163,  1163,  1164,
    1164,  1164,  1164,  1164,  1164,  1164,  1164,  1164,  1165,  1165,
    1165,  1165,  1165,  1166,  1166,  1167,  1168,  1169,  1170,  1170,
    1171,  1172,  1173,  1173,  1174,  1175,  1175,  1176,  1177,  1178,
    1178,  1179,  1180,  1181,  1181,  1182,  1183,  1183,  1183,  1183,
    1183,  1184,  1184,  1184,  1184,  1184,  1184,  1184,  1184,  1184,
    1184,  1184,  1184,  1184,  1184,  1184,  1185,  1185,  1186,  1186,
    1187,  1187,  1187,  1189,  1188,  1190,  1190,  1192,  1191,  1193,
    1193,  1193,  1194,  1194,  1194,  1194,  1194,  1194,  1194,  1194,
    1194,  1195,  1195,  1196,  1196,  1196,  1196,  1196,  1196,  1196,
    1196,  1196,  1196,  1196,  1196,  1196,  1196,  1196,  1196,  1196,
    1196,  1196,  1196,  1196,  1196,  1196,  1196,  1197,  1197,  1197,
    1197,  1197,  1197,  1198,  1198,  1198,  1198,  1198,  1198,  1198,
    1199,  1200,  1200,  1200,  1200,  1200,  1200,  1200,  1200,  1201,
    1201,  1201,  1201,  1201,  1201,  1201,  1202,  1202,  1202,  1202,
    1202,  1202,  1203,  1203,  1203,  1203,  1203,  1203,  1203,  1203,
    1203,  1203,  1203,  1204,  1204,  1204,  1204,  1204,  1205,  1205,
    1205,  1205,  1206,  1206,  1206,  1206,  1206,  1206,  1206,  1207,
    1207,  1207,  1208,  1208,  1208,  1208,  1208,  1208,  1209,  1209,
    1210,  1211,  1211,  1212,  1212,  1213,  1214,  1215,  1216,  1216,
    1216,  1217,  1218,  1219,  1220,  1221,  1221,  1221,  1221,  1221,
    1222,  1223,  1223,  1223,  1224,  1224,  1225,  1225,  1225,  1226,
    1226,  1227,  1227,  1228,  1228,  1229,  1229,  1229,  1229,  1229,
    1230,  1230,  1230,  1230,  1230,  1230,  1230,  1230,  1230,  1230,
    1230,  1230,  1230,  1230,  1230,  1230,  1230,  1230,  1230,  1230,
    1230,  1230,  1230,  1230,  1230,  1230,  1230,  1230,  1230,  1230,
    1230,  1230,  1230,  1230,  1230,  1230,  1230,  1230,  1230,  1230,
    1230,  1230,  1230,  1230,  1230,  1230,  1230,  1230,  1230,  1230,
    1230,  1230,  1230,  1230,  1230,  1230,  1231,  1231,  1231,  1231,
    1232,  1232,  1232,  1232,  1232,  1232,  1232,  1232,  1232,  1232,
    1233,  1233,  1233,  1233,  1233,  1234,  1234,  1235,  1235,  1236,
    1236
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     5,
       1,     0,     2,     0,     2,     0,     2,     2,     3,     3,
       1,     3,     3,     2,     1,     1,     2,     2,     2,     3,
       3,     5,     5,     0,     3,     5,     5,     5,     4,     3,
       5,     3,     5,     5,     6,     1,     1,     3,     5,     6,
       4,     9,     7,     1,     0,     2,     0,     1,     1,     1,
       1,     1,     1,     2,     3,     3,     2,     5,     1,     3,
       3,     3,     3,     1,     3,     3,     2,     2,     2,     2,
       3,     3,     3,     3,     1,     3,     1,     3,     1,     1,
       2,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       3,     6,     1,     1,     1,     1,     1,     0,     1,     1,
       2,     3,     4,     3,     2,     2,     1,     2,     1,     3,
       4,     5,     4,     2,     4,     1,     1,     1,     1,     1,
       2,     2,     2,     2,     2,     4,     6,     4,     6,     4,
       6,     4,     6,     5,     7,     1,     3,     2,     3,     4,
       6,     6,     6,     5,     5,     6,     6,     4,     8,     4,
       2,     4,     3,     6,     4,     3,     3,     3,     3,     3,
       4,     4,     3,     3,     3,     3,     3,     3,     4,     4,
       3,     2,     3,     2,     2,     3,     3,     2,     2,     3,
       1,     3,     2,     1,     1,     0,     2,     0,     2,     0,
       1,     1,     1,     3,     3,     2,     0,     1,     3,     3,
       1,     5,     3,     4,     1,     3,     4,     6,     4,     8,
       2,     2,    11,     7,     1,     1,     1,     0,     1,     1,
       1,     1,     3,     2,     0,     1,     1,     1,     3,     3,
       1,     1,     3,     3,     3,     3,     4,     3,     2,     1,
       0,     2,     0,     3,     0,     1,     0,     1,     3,     2,
       1,     1,     1,     3,     0,     1,     3,     1,    11,    14,
      10,    13,     1,     1,     2,     2,     2,     2,     1,     0,
       1,     0,     3,     0,     1,     3,     1,     3,     1,     1,
       1,     1,     1,     4,     4,     2,     0,     3,     1,     1,
       2,     2,     1,     3,     4,     5,     2,     5,     1,     2,
       2,     2,     3,     3,     3,     0,     1,     1,     1,     1,
       1,     1,     3,     1,     5,     7,     3,     8,     4,     9,
      11,     2,     0,     3,     0,     1,     3,     1,     2,     2,
       2,     0,     1,     3,     3,     6,     4,     0,     1,     1,
       2,     2,     0,     3,     3,     2,     1,     1,     2,     2,
       4,     0,     2,     2,     2,     0,     3,     4,     4,     0,
       2,     0,     4,     0,     3,     5,     2,     3,     0,     8,
       4,     1,     0,     6,     5,     4,     6,     1,     0,     1,
       2,     2,     1,     2,     3,     2,     2,     2,     2,     3,
       3,     1,     3,     1,     0,     1,     2,     1,     1,     3,
       6,    10,     1,     0,     1,     2,     2,     0,     2,     2,
       1,     0,     5,     7,     1,     0,     7,     2,     0,     3,
       5,     5,     8,     2,     0,     2,     2,     2,     5,     2,
       0,     2,     7,    10,     6,     6,     6,     6,     7,     7,
       9,     9,     6,     7,     6,     8,     8,     8,     8,     6,
       6,     7,     7,     8,     6,     6,     7,     2,     2,     2,
       2,     1,     2,     1,     0,     6,     8,     7,     6,     4,
       0,     1,     3,     4,     1,     3,     1,     2,     2,     2,
       2,     1,     1,    10,     2,     0,     2,     2,     1,     0,
       4,     6,     5,     4,     4,    10,    13,     5,     7,     8,
       1,     1,     1,     7,     9,     8,    15,    20,     1,     1,
       2,     1,     3,     1,     1,     1,     3,     1,     3,     0,
       1,     0,     1,     1,     4,     0,     1,     3,     0,     1,
       1,     1,     1,     2,     0,     0,     2,     2,     1,     2,
       2,     2,     2,     6,     8,    11,    13,     1,     3,     5,
       1,     3,     5,     1,     2,     2,     1,     8,     4,     5,
       4,     4,     4,     3,     7,     8,     6,     6,     6,     6,
       6,     4,     5,     3,     1,     3,     3,     1,     1,     1,
       1,     1,     1,     3,     1,     3,     3,     1,     0,     1,
       3,     7,     9,     9,     3,     0,    13,     1,     3,     5,
       6,     4,     7,     2,     1,     0,     2,     0,     2,     4,
       0,     1,     0,     6,     8,     8,     1,     3,     5,     5,
       7,     9,     7,     9,     5,     6,     6,     4,     5,     7,
       1,     1,     1,     2,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     3,     3,     3,     3,     1,     3,     1,
       2,     2,     3,     5,     2,     2,     0,     6,     7,     7,
       7,     8,     8,     6,     8,     9,     9,     7,    10,     7,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     1,     1,     1,     1,     2,     1,     3,     2,     3,
       3,     3,     3,     1,     1,     8,     9,     9,     9,     9,
       2,     0,     1,     1,     2,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     1,     1,     2,     2,     3,
       4,     5,     4,     5,     3,     4,     3,     4,     1,     2,
       3,     3,     3,     3,     4,     4,     3,     3,     4,     4,
       4,     4,     1,     1,     1,     0,     7,     7,    10,     1,
       1,     2,     4,     5,     1,     3,     2,     2,     2,     2,
       1,     2,     2,     4,     3,     2,     2,     2,     2,     3,
       2,     2,     2,     5,     5,     5,     1,     3,     1,     2,
       3,     0,     1,     3,     2,     6,     6,     9,     3,     0,
       3,     0,     5,     2,     0,     3,     3,     3,     7,     7,
      10,     1,     1,     1,     1,    14,     1,     0,     1,     0,
       1,     0,     2,     0,     1,     3,     5,     5,     7,     2,
       0,     1,     2,     0,     1,     1,     0,     1,     1,     0,
       9,    12,     7,     2,     0,     3,     2,     1,     3,     3,
       2,     1,     3,     3,     3,     2,     2,     1,     1,     1,
       1,     2,     1,     1,     1,     1,     4,     5,     1,     3,
       3,     1,     3,     3,     5,     6,     1,     3,     1,     2,
       4,     5,     1,     1,     1,     1,     3,     3,     2,     2,
       1,     2,     2,     2,     1,     2,     2,     1,     1,     1,
       3,     2,     0,     2,     1,     3,     5,     1,     2,     1,
       0,     5,     7,     5,     7,     5,     7,     3,     5,     5,
       5,     1,     3,     2,     1,     2,     1,     2,    11,    10,
      10,     2,     2,     0,     9,     2,     0,     4,     4,     4,
       1,     1,     1,     0,     8,     8,     8,     9,    11,    11,
      11,    12,     5,     5,     7,     6,     6,     6,     6,     8,
       8,     6,     6,     7,     9,     9,     6,     6,     6,     8,
       6,     8,     6,     8,     7,     9,     6,     8,     7,     9,
       8,    10,     9,    11,     8,     9,    11,     8,     8,     7,
       6,     6,     6,     8,     8,     8,     8,     6,     9,     1,
       0,     2,     0,     7,     6,     6,     6,     6,     6,     7,
       9,     9,     6,     8,     8,     8,     8,     8,     6,     8,
       6,     8,     7,     9,     7,     9,     6,     7,     6,     6,
       6,     6,     6,     7,     7,     7,     9,     9,     6,     6,
       6,     8,     8,     8,     6,     7,    13,     1,     1,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     0,     1,
       1,     1,     1,     1,     1,     0,     6,     8,     3,     2,
       0,     2,     2,     2,     2,     3,     3,     2,     2,     2,
       2,     3,     2,     5,     4,     3,     3,     3,     1,     1,
       0,     3,     2,     2,     1,     2,     1,     3,     2,     1,
       0,     9,    11,    12,    14,     3,     4,     4,     0,     2,
       5,     2,     0,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     4,     3,     3,     1,
       0,     5,     6,     4,     2,     0,     4,     3,     5,     4,
       6,     4,     6,     6,     5,     7,     9,     6,     1,     0,
       6,    11,    11,    11,    13,     9,    11,    10,     4,     2,
       5,     2,     0,     4,     5,     5,     4,     6,     1,     3,
       1,     1,     1,     1,     2,     4,     1,     1,     1,     0,
       1,     0,     1,     0,     3,     0,     2,     4,     3,     5,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     2,     1,     1,     1,     1,     0,     5,     4,     3,
       0,     1,     1,     1,     1,     4,     9,     3,     0,     6,
       1,     4,     2,     1,     3,     2,     3,     0,     7,     2,
       0,     5,     3,     0,     2,     2,     2,     3,     1,     3,
       1,     2,     1,     0,     8,     1,     3,     1,     1,     3,
       5,     2,     1,     3,     7,     1,     1,     0,     3,     2,
       2,     2,     0,     2,     2,     1,     1,     3,     3,     1,
       2,     4,     4,     2,     3,     5,     5,     1,     1,     9,
       1,     2,     4,     4,     4,     2,     3,     1,     3,     6,
       1,     0,     2,     1,     0,     3,     3,     4,     4,     4,
       4,     3,     2,     1,     1,     0,     1,     1,     0,     1,
       5,     1,     0,     1,     0,     3,     1,     3,     4,     3,
       2,     2,     1,     1,     1,     0,     2,     4,     5,     2,
       3,     1,     1,     1,     1,     3,     0,     1,     1,     1,
       1,     1,     3,     0,     2,     0,     1,     3,     1,     0,
       1,     2,     3,     2,     4,     2,     3,     2,     0,     2,
       3,     2,     0,     1,     3,     2,     2,     3,     2,     3,
       1,     4,     3,     4,     5,     4,     5,     4,     5,     2,
       4,     1,     1,     0,     1,     4,     5,     4,     0,     2,
       2,     2,     1,     1,     0,     4,     2,     1,     2,     2,
       4,     1,     3,     1,     2,     3,     2,     6,     2,     1,
       3,     4,     0,     1,     0,     2,     0,     2,     4,     0,
       1,     0,     1,     3,     3,     2,     3,     5,     6,     2,
       3,     3,     4,     0,     1,     1,     1,     1,     1,     2,
       5,     1,     1,     1,     1,     2,     3,     3,     0,     1,
       1,     1,     1,     1,     2,     2,     2,     2,     2,     1,
       3,     0,     1,     1,     1,     1,     5,     2,     1,     1,
       1,     1,     5,     2,     2,     2,     1,     3,     3,     2,
       1,     0,     3,     0,     5,     2,     5,     2,     1,     2,
       3,     0,     1,     1,     1,     1,     1,     1,     3,     3,
       3,     3,     3,     3,     3,     0,     1,     4,     1,     3,
       3,     5,     2,     2,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     2,     2,     3,     3,     2,     3,
       5,     4,     6,     3,     5,     4,     6,     4,     6,     5,
       7,     3,     2,     4,     2,     3,     3,     4,     3,     4,
       3,     4,     5,     6,     6,     7,     6,     7,     6,     7,
       3,     4,     4,     6,     2,     3,     4,     1,     3,     2,
       2,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     2,     2,     5,     6,     6,     7,     3,     4,     1,
       1,     2,     4,     1,     1,     1,     2,     2,     2,     2,
       1,     3,     5,     6,     8,     6,     6,     4,     4,     1,
       1,     1,     5,     1,     1,     4,     1,     4,     1,     4,
       1,     4,     1,     1,     1,     1,     1,     1,     6,     4,
       4,     4,     4,     6,     5,     5,     5,     4,     6,     4,
       4,     4,     4,     5,     7,     7,     9,     5,     4,     6,
       5,     7,     7,     7,     2,     3,     3,     3,     4,     0,
       4,     1,     3,     3,     1,     1,     1,     2,     2,     0,
       2,     4,     4,     6,     5,     0,     5,     0,     2,     0,
       1,     3,     3,     2,     2,     0,     6,     1,     0,     3,
       0,     2,     2,     0,     1,     4,     2,     2,     2,     2,
       2,     4,     3,     5,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     4,
       1,     4,     1,     4,     1,     2,     1,     2,     1,     3,
       1,     3,     1,     3,     1,     3,     3,     3,     2,     1,
       3,     3,     0,     1,     1,     1,     1,     1,     1,     1,
       1,     4,     3,     2,     3,     0,     3,     3,     2,     2,
       1,     0,     2,     2,     3,     2,     1,     1,     3,     5,
       1,     2,     4,     2,     0,     1,     0,     1,     2,     2,
       2,     3,     5,     1,     2,     0,     2,     1,     0,     1,
       1,     1,     3,     3,     1,     0,     1,     3,     3,     2,
       1,     1,     1,     3,     1,     2,     1,     3,     1,     1,
       1,     1,     1,     1,     1,     2,     1,     1,     1,     1,
       1,     2,     6,     2,     3,     6,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     1,     1,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     2,     4,     3,     2,     1,
       1,     1,     1,     1,     0,     8,     2,     5,     3,     2,
       2,     3,     7,     1,     1,     1,     0,     2,     2,     1,
       0,     1,     3,     1,     2,     0,     2,     0,     2,     0,
       1,     3,     4,     3,     1,     1,     1,     1,     2,     0,
       2,     4,     0,     2,     2,     2,     1,     1,     7,     3,
       1,     1,     1,     1,     2,     0,     1,     3,     3,     3,
       3,     0,     4,     5,     5,     0,     1,     1,     1,     2,
       2,     1,     2,     0,     7,     0,     5,     0,     4,     2,
       2,     0,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     5,     2,     1,     3,     2,     2,
       3,     0,     5,     1,     0,     5,     2,     2,     1,     1,
       1,     2,     2,     3,     1,     2,     2,     3,     3,     4,
       2,     1,     2,     1,     1,     2,     2,     3,     1,     1,
       1,     1,     0,     1,     3,     5,     0,     2,     0,     1,
       2,     3,     2,     1,     1,     1,     0,     1,     1,     1,
       1,     1,     2,     2,     3,     0,     1,     2,     1,     4,
       3,     4,     3,     2,     1,     3,     1,     1,     1,     1,
       2,     2,     1,     2,     2,     1,     1,     1,     4,     4,
       4,     4,     4,     1,     0,     3,     3,     4,     1,     3,
       3,     4,     1,     3,     3,     1,     1,     1,     6,     1,
       3,     3,     6,     1,     3,     3,     1,     1,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     4,     4,     1,     1,
       4,     4,     3,     0,     7,     1,     0,     0,     7,     3,
       4,     3,     1,     1,     1,     2,     3,     5,     2,     5,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     3,
       1,     0,     1,     2,     1,     2,     1,     1,     1,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     3,     1,
       2,     1,     3,     1,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     3,     2,     3,
       1,     3,     3,     3,     3,     3,     3,     1,     1,     4,
       0,     2,     2,     1,     1,     2,     1,     1,     1,     0,
       1
};

/* YYDEFACT[STATE-NAME] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
    2364,     0,     2,     1,  2794,  2798,  2802,  2803,  2720,  2804,
    2805,  2770,  2771,  2772,  2773,  2774,  2775,  2776,  2777,  2778,
    2779,  2780,  2781,  2783,  2782,  2784,  2785,  2786,  2787,  2788,
    2789,  2790,  2791,  2793,  2792,  2742,  2371,  2739,  2736,  2737,
    2738,  2743,  2741,  2734,  2735,  1961,  2807,  2795,  2808,  2796,
    2797,  2799,  2800,  2769,  2801,  2809,  2810,  2811,  2806,  2814,
    2765,  2766,  2764,  2767,  2768,  2812,  2813,  2756,  2757,  2758,
    2759,  2815,  2372,  2373,  2761,  2365,  2369,  2431,  2502,  2762,
    2763,  2760,  2370,  2755,  2502,     0,  2623,  2624,  2625,     0,
    2626,  2627,  2628,  2554,  2516,  2629,     0,     0,  2630,  2631,
    2632,  2633,  2634,  2635,  2636,  2637,     0,  2638,  2639,  2640,
    2641,  2501,  2642,  2643,  2644,  2645,  2646,  2478,  2484,  2607,
       0,  2458,  2459,  2455,  2457,  2456,  2460,  2443,  1220,   555,
    1307,  1306,     0,  2267,  1220,  2223,  2224,  2268,  2225,  2226,
    2227,   259,     0,  1309,  2228,  2269,     0,  1220,  2270,   380,
     974,  2271,  2272,  2386,     0,  2229,  2230,     0,     0,     0,
     555,  1220,     0,     0,  2231,  1421,  2232,     0,  2233,  2273,
    2274,     0,  2234,  2275,  2276,  2235,  2236,  2237,  2277,  2278,
    2279,  2238,  2280,  2281,     0,     0,  1435,     0,  2239,  2282,
    2240,  2241,     0,  2283,  2242,  2243,  2244,  2284,  2285,  2245,
    2246,  2247,     0,  2248,     0,     0,     0,     0,     0,     0,
    2286,  1220,  2249,     0,     0,  1442,     0,  2250,     0,  2287,
    2251,     0,  2252,     0,  2253,  2254,  2255,  2256,  1435,  2603,
    2479,     0,  1311,     0,  2257,  2288,     0,  2258,  2259,  2260,
    2261,  2262,  2263,  2264,  2265,  2266,     0,     0,    59,    60,
      24,    23,    29,    28,    82,    83,    47,    15,    73,    53,
     116,   115,   117,    35,    31,    67,    20,    22,    32,    36,
      55,    48,    94,    54,    18,    52,    77,    56,    80,    42,
       9,    10,    43,    71,    11,    44,    72,    12,    45,    13,
      61,    84,    27,    57,    81,    58,     3,    38,    69,    65,
       8,    49,    50,    51,    74,    75,    76,    99,    79,   111,
      34,   108,    88,    89,   105,    90,   106,     6,    91,    46,
      14,   102,   101,   103,    68,    39,    70,   100,    21,   104,
      16,    17,   107,    78,    97,    93,   112,   110,   118,    95,
      62,     4,     5,    85,    19,    41,     7,    26,    25,    40,
      33,   114,    30,  1309,    87,    98,    86,    92,    66,    96,
     113,    64,   109,  1408,  1395,  1444,  1407,  1420,     0,  1410,
    2699,  2700,    37,  1421,   120,   121,   126,  2368,  2420,  2421,
    2422,  2502,  2453,  2454,  2447,  2463,  2473,  2462,  2466,  2474,
    2461,  2480,     0,   123,   125,   127,   130,   124,   119,   122,
     129,   134,   128,   133,   131,   132,   135,   136,   137,  2701,
    1635,  2698,    63,  2438,  2437,     0,  2502,     0,  2731,  1973,
    1974,  1975,  1976,  1977,  1978,  1979,  1980,  1981,  1982,  1983,
    1984,  1985,  1986,  1987,  1988,  1989,  1990,  1991,  1992,  1993,
    1994,  1995,  1996,  1997,  1998,  1999,  2000,  2001,  2002,  2003,
    2004,  2005,  2006,  2007,  2008,  2009,  2010,  2011,  2012,  2013,
    2014,  2015,  2016,  2017,  2018,  2019,  2020,  2021,  2022,  2023,
    2024,  2025,  2026,  2027,  2028,  2029,  2030,  2031,  2032,  2033,
    2034,  2035,  2036,  2037,  2038,  2039,  2040,  2041,  2042,  2043,
    2044,  2045,  2046,  2047,  2048,  2049,  2050,  2051,  2052,  2053,
    2054,  2055,  2056,  2057,  2058,  2059,  2060,  2061,  2062,  2063,
    2064,  2065,  2066,  2067,  2068,  2069,  2070,  2071,  2072,  2073,
    2074,  2075,  2076,  2077,  2078,  2079,  2080,  2081,  2082,  2083,
    2084,  2085,  2086,  2087,  2088,  2089,  2090,  2091,  2092,  2093,
    2094,  2095,  2096,  2097,  2098,  2099,  2100,  2101,  2102,  2103,
    2104,  2105,  2106,  2107,  2108,  2109,  2110,  2111,  2112,  2113,
    2114,  2115,  2116,  2117,  2118,  2119,  2120,  2121,  2122,  2123,
    2124,  2127,  2125,  2126,  2128,  2129,  2130,  2131,  2132,  2133,
    2134,  2135,  2136,  2137,  2138,  2139,  2140,  2141,  2142,  2143,
    2144,  2145,  2146,  2147,  2148,  2149,  2150,  2151,  2152,  2153,
    2154,  2155,  2156,  2157,  2158,  2159,  2160,  2161,  2162,  2163,
    2164,  2165,  2166,  2167,  2168,  2169,  2170,  2171,  2172,  2173,
    2174,  2175,  2176,  2177,  2178,  2179,  2180,  2181,  2182,  2183,
    2184,  2185,  2186,  2187,  2188,  2189,  2386,  2190,  2191,  2192,
    2193,  2194,  2195,  2196,  2197,  2198,  2199,  2200,  2201,  2202,
    2203,  2204,  2205,  2206,  2207,  2208,  2209,  2210,  2211,  2212,
    2213,  2214,  2215,  2216,  2217,  2218,  2219,  2220,  2221,  2222,
    2404,  1962,  1970,  1971,  1972,  2379,  2400,  2406,  2727,  2405,
    1969,  2553,     0,     0,  2647,  2648,  2649,  2650,  2651,  2652,
    2702,  2703,  2704,  2705,  2706,  2708,  2707,  2515,  2674,  2711,
    2514,  2712,  2518,  2713,  2714,  2715,  2716,  2675,  2717,  2517,
    2709,  2671,  2519,  2512,  2513,  2672,  2621,  2622,  1939,  2673,
    2670,  2710,  2407,  2669,  2523,  2522,  1385,  2726,  1938,  1386,
       0,  2525,  2653,  2654,  2655,  2656,  2658,  2657,  2659,  2289,
    2290,  2291,  2292,  2293,  2294,  2295,  2296,  2297,  2298,  2299,
    2300,  2684,  2301,  2302,  2303,  2697,  2304,  2305,  2685,  2306,
    2307,  2308,  2309,  2310,  2311,  2312,  2313,  2314,  2315,  2316,
    2317,  2318,  2319,  2320,  2321,  2322,  2323,  2324,  2325,  2326,
    2327,  2328,  2329,  2686,  2687,  2330,  2331,  2332,  2333,  2334,
    2335,  2336,  2337,  2338,  2339,  2340,  2341,  2342,  2343,  2344,
    2345,  2346,  2347,  2348,  2349,  2350,  2351,  2352,  2353,  2688,
    2354,  2355,  2689,  2356,  2357,  2358,  2690,  2359,  2360,  2361,
    2362,  2363,  2694,  2695,  2696,  2683,  2476,  2660,  2682,  2693,
    2691,  2692,  2486,  2482,  2490,  2485,     0,     0,     0,     0,
    2502,  1219,  1218,  1204,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   554,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2376,     0,  1230,   351,   350,  1308,
    1289,   555,     0,  1207,   379,     0,     0,     0,     0,     0,
       0,     0,     0,   744,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   184,     0,     0,   403,   402,     0,
       0,     0,   946,   408,     0,     0,     0,     0,     0,   543,
    2385,  2380,  2390,     0,  2383,  2384,  2669,     0,  2818,  2125,
    2416,  2417,  2816,  2175,  1387,   260,   263,   264,   261,   262,
       0,  1053,  1054,  1056,     0,     0,  1066,   779,   780,     0,
     778,     0,   782,     0,     0,     0,   774,     0,     0,     0,
       0,     0,   781,   771,     0,   770,     0,     0,     0,   777,
       0,   772,     0,     0,  1208,     0,  2468,  2469,  2063,  1348,
     409,     0,     0,  1421,     0,  1326,  1327,  1309,  1316,  1328,
    1321,  1323,  1322,  1324,  1320,  1325,  1974,   885,  1988,   885,
    2053,   882,   883,   885,   885,   885,  2142,     0,     0,   857,
       0,   868,  1965,   885,  1966,  2727,   890,   464,   464,   464,
       0,   889,   894,   464,  1201,  1239,  1943,  1434,     0,  1988,
    2053,   858,  1200,  2190,  1340,     0,     0,     0,  1070,     0,
    1071,     0,  2157,  1212,   244,  2667,  2166,  2253,  2190,  2668,
     240,  2662,  2663,  2665,   214,  2666,  2664,  2661,  1978,     0,
       0,   889,     0,  1209,  1210,   841,  1441,  1439,  1925,     0,
       0,  1996,     0,  2008,  2089,   237,  2153,  2158,  2166,  2253,
    2190,  2220,   193,   203,   198,     0,   253,  2166,  2253,  2190,
       0,  1230,     0,  1411,  1527,  1934,     0,     0,  2477,  1203,
    1202,  1310,     0,  1313,     0,  1489,  2138,  1415,  1417,  1315,
    1408,     0,     0,  2367,  1304,  1438,  1438,     0,  1438,     0,
    1400,  1408,  1403,  1407,     0,     0,     0,     0,  1220,     0,
    2445,  2473,  2452,  2508,  2449,     0,     0,  2498,  2494,  2491,
    2499,  2500,  2493,  2481,  1624,  1625,  1626,  1623,  1636,  1622,
       0,  2426,  1627,  2465,  2432,     0,  2440,  2439,  2744,  2745,
    2555,  2378,  2397,     0,     0,     0,     0,     0,     0,     0,
    2524,  2526,  2528,  2488,  2487,  2483,     0,     0,     0,     0,
    2613,  2614,  2612,     0,  2609,  2611,     0,  2508,     0,  2678,
    2672,  2681,     0,  1944,  2673,  2670,  2669,     0,   789,     0,
     141,   934,     0,     0,     0,     0,  1938,     0,     0,     0,
       0,     0,  2062,     0,     0,     0,  1837,  2000,  2048,  1847,
    1845,  1846,  1839,  1840,  1841,  1842,  1843,  1844,     0,  1051,
    1838,     0,   163,   141,     0,     0,  2062,     0,     0,     0,
    2062,     0,     0,     0,     0,     0,  2092,   141,  2062,     0,
       0,     0,  1224,     0,     0,     0,  1226,  1229,  1205,  1292,
       0,  1934,     0,     0,   820,   810,     0,   821,   811,   816,
       0,   823,     0,     0,   813,     0,     0,     0,   824,     0,
     812,   814,   826,   815,   822,     0,     0,   817,   818,     0,
       0,  1216,   464,   357,     0,     0,     0,     0,     0,   141,
    1279,     0,  2062,   141,     0,     0,   407,   406,   141,   405,
     404,  2000,  2048,     0,   973,   141,  2062,     0,   186,   625,
     558,     0,     0,   703,  2092,   141,     0,     0,     0,     0,
       0,     0,   949,     0,     0,   542,   555,     0,  2389,  2395,
       0,  2387,  2556,  2819,  2817,  2511,     0,  1057,   238,   239,
    1055,  2062,     0,   325,     0,     0,  2062,  1267,   776,     0,
     775,  2062,     0,  2062,  1963,   177,     0,   773,  2000,  2048,
    2062,     0,     0,  2062,   169,  2062,     0,  2062,   325,  2062,
     559,     0,  2062,     0,  2062,  2092,   171,     0,  2062,   325,
     787,     0,     0,  2749,  2753,     0,  2751,  2746,  2467,  2521,
    2520,  2419,     0,  2830,     0,  1387,  1318,  1333,     0,  1329,
    1336,  1332,  1421,   885,   884,     0,   885,     0,  2839,   885,
       0,   885,     0,  2839,   885,     0,     0,     0,   885,  1967,
    1968,     0,     0,  2838,  2836,  2837,   859,   869,     0,   891,
       0,     0,   898,   897,   896,     0,     0,     0,   899,  1531,
    1363,     0,   866,     0,   864,     0,  1198,  1215,     0,     0,
       0,     0,   949,  1073,  1073,  1073,  1211,   243,   241,     0,
       0,     0,     0,     0,     0,  1217,     0,     0,     0,     0,
    2733,  1950,  1848,  2732,     0,  2224,  2225,  2226,  1906,     0,
    2674,  2227,  2228,  2269,  1756,  1743,  1752,  1757,  1744,  1746,
    1753,  2229,  2230,  2032,  2231,  2232,  1957,  2233,  2234,  1579,
    2236,  2237,  2238,  1748,  1750,  2239,  2240,     0,  1958,  2242,
    2243,  2111,  2245,  2246,  2248,  2249,  1754,  2251,  2252,  2253,
    2254,  2255,  2256,  1956,     0,  1755,  2257,  2259,  2260,  2261,
    2262,  2263,  2264,  2265,  2266,     0,     0,  1931,     0,  1725,
       0,  1571,  1572,  1594,  1595,  1573,  1600,  1601,  1613,  1574,
       0,  1930,  1638,  1805,  1724,  1739,  1730,     0,  1723,  1719,
    1424,  1924,  1926,     0,  1720,  1946,  1907,  1960,  1959,  2727,
    1915,  1949,  1947,  1948,     0,     0,     0,   206,     0,     0,
    2602,   255,     0,   256,  1932,  2166,   194,   236,   208,   235,
     209,   207,     0,  1998,   195,     0,     0,   196,     0,     0,
       0,     0,     0,     0,     0,   249,  1206,     0,  1529,  1528,
       0,     0,  1913,  1935,   796,     0,  1302,  1303,  1301,     0,
    1298,  1300,  1312,  1309,  1920,  1919,  1921,     0,  1416,     0,
       0,     0,  1398,  1397,  1315,  1436,  1437,     0,     0,     0,
       0,     0,     0,     0,     0,  1479,  1452,  1453,  1455,  1476,
    1480,  1488,     0,  1404,     0,     0,  1533,     0,  1490,  2366,
    2508,  2509,     0,  2503,     0,  2502,  2502,  2496,  2495,  2492,
       0,     0,     0,     0,     0,     0,     0,  2423,   537,  2425,
     535,     0,     0,  2399,     0,  2403,  2401,     0,  2548,  2551,
       0,  2549,  2550,  2552,     0,  2557,  2558,     0,     0,     0,
    2740,     0,     0,  2539,  2527,  2534,  2536,  2538,  2537,  2546,
    2542,  2545,  2547,  2489,  2502,  2620,     0,  2615,  2618,     0,
    2610,     0,     0,     0,  1945,     0,     0,     0,     0,   790,
       0,     0,     0,     0,     0,     0,   140,  1265,   246,  1263,
       0,     0,     0,     0,     0,     0,     0,  1271,     0,     0,
     175,   176,   570,   555,     0,  2062,     0,     0,     0,     0,
    1013,  1020,     0,     0,     0,     0,     0,     0,     0,  1014,
    1012,  1015,   248,  1024,  1037,  1040,     0,   924,     0,     0,
       0,     0,  1130,     0,     0,  1130,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   267,   275,
     320,     0,  2062,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   145,     0,     0,     0,     0,     0,     0,   522,
     534,     0,     0,     0,     0,     0,   531,     0,   141,   269,
     515,   519,     0,     0,     0,   634,   633,  1269,     0,     0,
    1130,     0,   265,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   343,
     344,     0,     0,     0,   145,   168,     0,     0,     0,   271,
       0,  2433,     0,  1225,  1222,  1223,     0,  1228,     0,  1288,
       0,     0,     0,     0,   828,     0,   825,     0,     0,   819,
    2000,  2048,     0,     0,     0,     0,     0,     0,   382,   356,
       0,     0,   700,     0,     0,  1582,  1611,  1589,  1611,  1611,
    1578,  1578,  1591,  1580,  1618,     0,  1611,  1578,  1583,     0,
    1581,  1621,  1621,  1606,     0,  1563,  1564,  1565,  1566,  1592,
    1593,  1567,  1598,  1599,  1568,  1635,  2679,  1578,  2680,  2677,
    2676,     0,     0,   711,     0,  1242,  1278,     0,     0,     0,
     564,     0,  2062,     0,   143,   745,     0,   701,   408,     0,
     143,     0,     0,   180,     0,   629,     0,     0,     0,     0,
       0,     0,   649,   648,     0,     0,     0,   702,     0,   143,
       0,   518,  2062,     0,   464,   464,     0,     0,   948,   951,
       0,     0,     0,  2393,  2388,  2391,     0,  2381,  2395,  1390,
    1392,  1391,     0,  1389,     0,   325,   323,   324,   698,  1065,
       0,     0,     0,     0,   325,     0,     0,  2062,   325,  2062,
       0,  2062,     0,     0,   325,   325,     0,     0,     0,     0,
     630,     0,   786,   784,   783,   785,     0,     0,     0,     0,
       0,  2062,   325,     0,     0,   767,  2747,     0,     0,  2750,
       0,  2470,  1858,     0,  2833,  1345,  2834,     0,     0,  1421,
       0,   225,   226,   224,  1334,   227,  1335,  1331,  1317,     0,
     877,     0,  2839,  2840,   862,     0,   872,     0,  2839,   860,
       0,   873,   870,   871,     0,     0,     0,  2835,  2718,  2724,
     876,     0,     0,   465,   467,     0,     0,  2018,  2031,     0,
    2054,  2080,  2081,  2158,  2162,     0,  2185,  2194,     0,   900,
     929,   895,     0,     0,  1373,   867,   865,  1199,  1338,  1864,
       0,  1421,     0,     0,  1072,  1069,  1068,  1067,   242,   215,
       0,     0,     0,   931,  2157,  1214,   840,   555,     0,     0,
    1728,  1729,  1610,  1597,  1905,     0,     0,  1605,  1604,     0,
       0,     0,     0,     0,  1587,  1586,  1585,  1727,  1872,     0,
    1584,     0,     0,     0,     0,  1611,  1611,  1609,  1658,     0,
    1588,     0,     0,  1885,     0,  1891,     0,     0,     0,  1617,
       0,  1615,     0,     0,  1694,     0,     0,     0,     0,     0,
       0,     0,     0,  1642,  1643,  2675,  1725,  1858,     0,  1726,
    1953,     0,     0,  1603,     0,  1635,  1848,     0,     0,     0,
       0,  1918,     0,  1856,     0,     0,  1672,  1854,     0,  1674,
       0,     0,     0,  1847,  1845,  1846,  1839,  1840,  1841,  1842,
    1843,  1844,  1852,  1655,     0,  1929,     0,  1807,     0,  1654,
       0,  1492,  1423,     0,     0,  1951,  1908,     0,  2725,  2728,
    1721,  2599,  2598,  2597,  2596,  2567,     0,  2561,  2562,     0,
    2600,  2601,   257,   258,   254,     0,     0,   211,   210,     0,
     233,   234,   205,   232,     0,   228,   229,   213,  1796,  1795,
     212,   204,   201,   199,   216,   218,   219,   202,   200,   252,
     250,     0,     0,     0,  1910,  1909,  1941,  1914,     0,     0,
     325,  2502,  1296,     0,  1293,  1923,     0,  1418,     0,  1936,
       0,  1305,  1414,  1413,  1445,  1446,   966,  1412,  1470,  1471,
    1466,     0,     0,     0,  1485,  1483,  1462,  1456,  1461,  1459,
       0,  1463,  1638,  1478,  1402,  1450,  1451,  1454,  1401,     0,
    1481,     0,  1373,  1479,  1455,  1360,     0,     0,  1534,     0,
       0,  2510,  2508,  2448,  1563,  2502,  2441,  2502,  2497,  2429,
    1629,  1630,  1631,  1632,  1633,  1634,  2430,     0,  2427,  1628,
    2428,   536,     0,     0,     0,  2396,     0,  2377,  2402,  2533,
    2642,  2565,     0,  2566,     0,     0,  2530,     0,  2540,  2543,
    2541,  2544,     0,  1563,  2721,  2616,  2721,  1563,   988,   990,
       0,   989,     0,   992,     0,  1001,     0,     0,   987,  1006,
       0,   995,   993,     0,     0,     0,     0,     0,     0,   791,
       0,     0,     0,     0,     0,     0,  2185,   245,  1261,     0,
       0,     0,     0,   933,   932,     0,     0,   953,     0,     0,
       0,  1274,   453,     0,   322,     0,     0,     0,     0,     0,
       0,     0,     0,   696,   693,     0,     0,   692,     0,   568,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   604,     0,
    1130,     0,   637,     0,  1022,     0,  1021,     0,     0,     0,
    1023,  1018,  1019,  2158,  2166,  2190,   247,  1039,     0,  1038,
    1036,   976,     0,   977,     0,     0,     0,     0,  2041,   277,
     290,     0,  1129,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   311,     0,   314,   313,     0,     0,
       0,     0,     0,   318,     0,     0,     0,   317,     0,     0,
       0,     0,  1130,     0,   273,     0,     0,     0,     0,     0,
       0,  1052,     0,   166,     0,   162,   165,     0,     0,     0,
       0,   521,   533,     0,   525,   526,   523,   527,   528,     0,
       0,     0,     0,     0,     0,   520,     0,     0,   627,   626,
     632,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1083,  1082,     0,     0,     0,     0,     0,     0,
     735,     0,     0,     0,     0,     0,     0,     0,   640,   641,
       0,   642,     0,   167,     0,     0,     0,     0,     0,     0,
       0,   223,  1221,  1227,  1291,  1942,  1290,     0,     0,     0,
     827,     0,     0,     0,     0,     0,     0,     0,   829,   830,
     831,   832,     0,     0,     0,     0,     0,   359,   360,   141,
     358,     0,   724,  2676,   699,     0,  1563,     0,  1559,  1555,
    1624,  1623,  1622,     0,  1569,  1578,  1575,   712,     0,   714,
     717,     0,  1240,   426,     0,     0,   561,   604,     0,   411,
     173,     0,     0,     0,     0,   139,   184,   186,   409,     0,
     185,   187,   189,   190,   191,   188,   192,   624,   628,     0,
     557,     0,     0,     0,     0,     0,   650,   654,   653,   657,
     655,     0,   651,     0,     0,  1551,     0,   161,     0,   514,
     517,     0,  2374,     0,   411,   495,   336,     0,   464,     0,
       0,   950,     0,     0,     0,     0,     0,  2394,     0,     0,
       0,     0,  1388,     0,  1043,     0,  1268,  2062,   325,     0,
    1041,   178,  1964,     0,   768,     0,     0,     0,     0,     0,
    1045,   764,   170,     0,   325,   325,   560,     0,   325,   172,
       0,     0,     0,   552,   325,   788,  2748,  2754,  2752,  1347,
       0,  2831,  2832,   464,  1392,  1319,  1330,   874,   881,   863,
     880,   879,   861,   878,   875,  2532,     0,     0,  2723,     0,
     892,     0,   463,     0,     0,     0,   906,   907,     0,     0,
     905,   922,   908,     0,   910,   902,   901,   911,   912,     0,
       0,   931,     0,  1370,     0,  1368,     0,  1532,  1372,  1361,
    1339,     0,  1337,  1342,  1344,  1343,  1341,     0,   508,     0,
       0,   889,     0,     0,   325,  1213,     0,   842,   843,   849,
       0,     0,     0,     0,     0,   850,   846,   847,   848,   851,
     852,   853,     0,     0,     0,  1868,     0,  1869,     0,     0,
       0,  1904,  1900,     0,     0,     0,     0,     0,     0,  1876,
    1877,  1878,  1875,  1879,  1874,     0,     0,  1880,  1873,     0,
       0,     0,     0,     0,  1608,  1607,     0,     0,     0,     0,
       0,     0,     0,  1697,  1730,     0,     0,  1832,     0,  1858,
    1890,     0,     0,  1619,     0,     0,     0,     0,     0,     0,
       0,  1858,  1896,     0,     0,     0,     0,  1794,     0,  1791,
       0,     0,     0,     0,  1915,     0,     0,     0,     0,  1954,
    1639,  1656,  1928,     0,  1917,     0,     0,  1640,  1663,     0,
    1897,  1690,     0,  1695,  1678,     0,  1671,     0,  1676,  1680,
    1659,  1918,  1857,     0,  1855,     0,     0,  1657,     0,  1652,
    1650,  1651,  1644,  1645,  1646,  1647,  1648,  1649,  1653,  1836,
    1834,  1835,     0,     0,     0,  1815,     0,     0,  1675,  2056,
    2089,     0,  1435,  1435,  1435,  1422,  1433,     0,  1546,  1927,
       0,     0,     0,     0,  1731,     0,  1862,  1444,  1860,  1944,
    2730,  2729,  1916,     0,     0,     0,  1933,     0,     0,  1635,
       0,   251,  1530,  1911,     0,   794,   795,   793,  1563,  1315,
    1299,  1295,  1294,  1922,  1314,     0,  1421,     0,   964,   965,
       0,   969,     0,     0,  1464,  1486,     0,  1477,     0,  1468,
    1469,  1460,  1487,  1482,  1406,  1405,     0,  1549,     0,     0,
    1357,  1350,  1535,     0,  1492,  1375,  1377,  1378,     0,  1915,
    2446,  2504,  2451,  2472,  2442,  2475,  1637,  2424,  2464,     0,
    2398,  2568,  2569,     0,  2559,  2560,  2529,  2535,  2606,     0,
    2722,     0,     0,   991,     0,  1578,  1002,     0,   986,     0,
     985,  1578,     0,  1003,     0,  1578,     0,     0,     0,  1158,
    1085,  1134,   792,  1159,  1086,  1135,  1160,  1087,  1262,     0,
    1264,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   675,  2062,   325,  1272,  1161,
       0,  1088,   321,  1273,  1136,  1277,   695,   694,     0,     0,
    1137,     0,   569,     0,     0,   574,   575,   576,     0,     0,
       0,   577,     0,  2000,  2048,     0,   582,   589,   594,   584,
       0,   595,   590,     0,     0,     0,     0,     0,     0,   601,
     603,     0,     0,     0,     0,     0,     0,  1016,  1017,  1162,
    1091,     0,  1138,   975,     0,  1092,   174,     0,   268,   278,
     610,   675,  1132,   297,   310,   305,   306,   304,  2062,   325,
    2062,   325,     0,     0,     0,     0,   307,   302,   303,   299,
     312,  1977,  2033,  2167,     0,   614,   616,     0,   621,   315,
    1106,   332,   331,   330,     0,   319,     0,   337,   340,   316,
     295,   298,   296,   292,   276,     0,     0,     0,     0,     0,
       0,  1940,     0,     0,  1047,     0,     0,     0,   164,  1120,
       0,     0,   150,     0,     0,     0,     0,   144,   154,     0,
    1168,  1096,     0,     0,   270,   516,   524,   529,  1100,   532,
    1148,   530,  1174,  1097,  1130,     0,   266,     0,  1098,     0,
    1142,     0,     0,     0,     0,     0,     0,     0,  1170,  1122,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1280,
       0,     0,     0,     0,     0,   325,     0,     0,     0,  1132,
    2062,   325,  1169,     0,  1127,  1156,     0,   345,     0,  1121,
       0,     0,   272,  1102,  1150,     0,     0,   221,   220,   222,
       0,     0,     0,     0,     0,     0,     0,     0,   834,   803,
     833,     0,     0,     0,   797,   381,   354,   355,   357,   364,
     723,     0,     0,     0,  1560,  1556,     0,     0,     0,     0,
       0,     0,  1576,   713,     0,     0,     0,     0,  1260,  1260,
    1260,  1260,  1260,  1260,  1260,  1241,  1270,     0,   141,     0,
       0,     0,   563,   603,   610,     0,     0,     0,   410,   414,
     418,   419,   420,     0,     0,     0,     0,   155,   142,     0,
     753,     0,   464,     0,   186,   179,     0,     0,     0,   336,
     710,   708,   707,   709,     0,     0,     0,   728,   706,     0,
    1550,  1552,     0,     0,     0,     0,     0,   413,     0,   467,
       0,     0,   499,     0,     0,     0,   336,     0,     0,   980,
       0,   998,   981,     0,     0,     0,  1027,  1032,  1028,  1008,
       0,   540,  2392,  2386,  1393,  1394,     0,   325,     0,     0,
     605,   325,   325,     0,   325,     0,   325,   325,     0,  1196,
     631,     0,   683,     0,     0,   325,   766,  1859,     0,  2531,
    2719,   893,   466,     0,     0,     0,     0,   904,     0,   538,
     909,     0,   921,   916,   918,     0,   925,  1371,  1364,  1366,
    1365,     0,     0,  1362,  1865,   765,     0,   513,     0,     0,
     325,     0,   926,     0,   844,   845,     0,     0,   854,     0,
       0,  1440,  1866,  1867,     0,     0,     0,     0,  1901,     0,
       0,  1769,     0,  1745,  1747,  1577,  1759,     0,  1590,  1770,
    1771,  1749,  1751,     0,  1849,     0,     0,  1760,  1699,  1700,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1712,  1711,  1761,  1831,     0,     0,  1888,
    1889,  1762,  1620,  1621,  1621,     0,     0,  1895,     0,     0,
       0,  1767,  1772,     0,     0,     0,     0,  1778,     0,  1799,
       0,     0,     0,  1722,  1859,  1612,  1613,     0,     0,     0,
       0,     0,     0,     0,     0,  1696,  1679,  1673,     0,  1677,
    1681,     0,     0,     0,     0,  1665,  1691,  1661,     0,     0,
    1667,     0,  1692,     0,     0,     0,  1738,  1435,  1435,  1435,
    1435,  1432,     0,     0,     0,     0,  2155,     0,  1513,  1491,
    1493,  1500,  1513,  1518,  1740,  1544,  1741,     0,  1934,     0,
    1473,  1444,  1444,  1444,  1737,     0,     0,     0,  1443,  2581,
    2583,  2584,  2585,  2586,  2587,  2589,  2590,  2592,  2593,  2594,
    2582,  2588,  2591,  2595,  2572,  2573,     0,  2563,  2564,   197,
       0,   230,   217,     0,  2606,  1297,  1937,     0,  1447,     0,
    1850,   969,   967,   968,  1449,     0,     0,  1484,  1457,  1359,
       0,  1357,  1352,     0,  1353,  1915,     0,  1349,  1382,     0,
       0,  1549,     0,  1381,     0,  2506,  2434,     0,     0,  2605,
    2608,  2619,  2617,  2444,     0,  1578,   983,   984,     0,  1007,
       0,  1157,  1084,  1133,  1260,   936,   937,     0,   935,     0,
       0,     0,   452,   952,     0,     0,     0,   675,     0,     0,
     456,     0,  1275,     0,  1175,  1119,   571,   572,     0,   583,
       0,   592,   591,     0,     0,   579,     0,     0,     0,     0,
     578,   597,   544,   598,   600,     0,     0,   599,   602,   607,
    1130,     0,   638,  1108,     0,  1154,  1010,     0,   978,     0,
       0,   426,   291,     0,     0,     0,   279,   289,     0,     0,
     294,     0,   287,   308,   300,   309,   301,   618,   619,   617,
     613,     0,   620,   622,     0,   334,     0,     0,     0,  1164,
    1130,     0,   274,  1104,     0,  1152,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1165,  1139,     0,
       0,   147,   146,     0,   153,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1373,     0,  1373,     0,     0,
       0,  1373,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   346,   327,     0,   731,
       0,     0,     0,   348,     0,     0,     0,     0,  1163,  1093,
     798,     0,     0,   799,   807,     0,     0,   800,     0,     0,
     809,     0,     0,   353,   361,   725,     0,  2111,  1839,  1840,
     721,   726,   718,   720,   719,   722,   675,     0,     0,     0,
    1561,     0,  2820,  2828,  2827,     0,  1635,   715,   716,     0,
    1260,  1259,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   438,     0,     0,   432,     0,     0,  1032,
     425,   428,   429,     0,     0,   564,   567,   565,   566,   596,
       0,   445,     0,     0,   157,     0,     0,   158,   156,     0,
       0,   336,     0,   182,   409,     0,     0,   556,   656,   659,
     652,     0,   727,   729,   704,     0,   610,     0,     0,  1348,
     508,     0,   495,   491,   493,   492,   494,     0,   501,   335,
       0,   508,   501,     0,   953,   979,     0,     0,     0,  1025,
    1029,  1026,     0,     0,   994,     0,  1009,   972,  1191,  1192,
    1189,  1190,     0,     0,  2409,  1384,  2418,  1044,     0,   325,
    1042,   769,     0,   760,     0,   762,  1046,   325,   325,   643,
       0,   553,     0,     0,     0,     0,   903,   923,     0,   919,
       0,     0,   886,   928,  1369,  1367,   506,     0,   931,     0,
     887,   930,     0,     0,     0,     0,     0,  1870,  1596,     0,
    1903,  1899,     0,  1742,  1871,     0,  1883,  1882,  1698,  1884,
       0,  1717,     0,     0,  1709,  1707,  1708,  1701,  1702,  1703,
    1704,  1705,  1706,  1710,  1893,  1892,  1886,  1887,  1616,  1614,
       0,  1764,  1765,  1766,  1894,  1773,     0,  1991,  1800,  1777,
    1793,  1792,     0,     0,     0,  1780,     0,     0,  1789,     0,
    1833,  1602,  1635,  1641,     0,     0,  1664,  1898,  1682,     0,
       0,     0,  1660,     0,     0,     0,     0,  1669,  1849,     0,
       0,     0,     0,  1818,  1813,  1814,     0,     0,     0,     0,
    1426,  1425,  1431,  1513,  1518,     0,  1408,     0,  1500,     0,
    1512,  1498,  1511,     0,     0,  1524,  1522,     0,  1524,     0,
    1524,     0,  1495,     0,  1514,  1496,  1511,  1543,  1536,     0,
    1935,  1545,     0,  1475,     0,     0,     0,     0,  1863,     0,
    1861,  1732,     0,     0,     0,  1912,  2604,  1419,     0,  1448,
    1465,  1458,     0,  1547,  1358,     0,     0,  1355,     0,     0,
       0,  1376,  1357,  1379,  2450,     0,  2505,  2570,  2571,  1004,
       0,     0,   996,     0,   942,   943,   941,   944,     0,     0,
       0,   675,     0,     0,   472,     0,   960,   960,     0,     0,
     458,   504,  1032,   678,     0,     0,     0,   676,   325,  1089,
       0,   593,     0,     0,   588,   586,   585,   587,   545,  1173,
    1090,     0,     0,     0,     0,  1011,  1107,     0,   423,     0,
     284,  1131,     0,     0,     0,   283,     0,   325,   325,   615,
     333,   338,   339,   342,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   754,   737,     0,     0,   755,   756,
       0,     0,     0,  1049,  1050,  1048,   151,   148,   149,   152,
    1117,  1101,  1149,  1099,     0,  1143,  1114,  1110,     0,  1074,
       0,  1076,     0,  1373,     0,  1075,     0,     0,     0,     0,
       0,  1172,  1126,  1147,  1171,  1124,  1145,  1123,  1144,  1125,
    1146,  1118,     0,  1554,   734,     0,     0,     0,   325,   325,
     645,  1103,  1151,     0,   801,     0,     0,   802,   804,   384,
       0,   387,   394,   365,   370,  1279,     0,  1279,     0,   367,
     371,  1279,   366,  1279,   363,   697,     0,     0,     0,  1557,
       0,  2502,     0,     0,     0,     0,     0,  1562,  1570,   674,
       0,  1251,  1250,  1249,  1253,  1252,  1255,  1254,  1246,  1245,
    1258,  1257,  1244,  1243,  1248,  1247,     0,   430,     0,   436,
     440,   441,   439,   431,  1032,   464,   503,     0,     0,   687,
       0,   562,   411,   442,     0,   415,   160,   159,     0,     0,
       0,   186,     0,     0,   661,   665,   705,     0,  1553,   639,
     336,     0,   411,   508,  2375,     0,   416,   421,   422,     0,
     499,     0,   495,     0,     0,   505,  1238,   509,   510,     0,
       0,   982,   999,  1000,     0,     0,  1032,  1031,     0,   547,
       0,  2382,   325,   606,   325,   325,  1197,   684,     0,   915,
     914,   913,   539,     0,   917,   507,   325,     0,     0,     0,
       0,     0,   856,   835,   855,  1902,  1758,  1768,  1881,     0,
       0,  1718,     0,     0,  1763,  2258,     0,     0,     0,     0,
    1797,  1798,  1779,     0,  2102,  1784,     0,     0,     0,  1955,
    1688,  1686,  1683,     0,  1684,     0,     0,  1666,  1662,     0,
    1668,  1693,  1804,     0,  1820,  1817,  1430,  1429,  1428,  1427,
    1499,  1497,     0,  1502,  1509,     0,  1494,     0,  1523,  1519,
       0,  1520,     0,     0,  1521,     0,     0,  1509,     0,  1444,
       0,     0,  1809,  1735,  1736,  1733,  1444,  1952,  2574,     0,
    2577,  2575,  2576,  2580,  1635,     0,     0,  1351,  1354,  1356,
       0,  1383,  1374,  2507,   997,  1005,  1266,     0,     0,     0,
     454,     0,  1032,     0,     0,     0,   963,   963,     0,  1032,
     503,   680,   679,   682,   677,   681,  1276,     0,   580,   581,
    1109,     0,  1155,  1115,     0,   611,   280,   281,   282,   285,
     327,   293,   286,     0,  1105,     0,  1153,  1112,  1166,  1094,
    1140,     0,     0,   743,     0,     0,     0,     0,  1167,  1095,
    1141,     0,     0,     0,     0,  1077,     0,     0,     0,     0,
    1285,     0,   326,   733,   732,   327,   347,  1128,     0,   805,
     806,   385,   141,     0,   362,     0,   392,     0,   390,   389,
     391,     0,   378,     0,     0,     0,     0,     0,     0,  1558,
       0,  1063,  1063,  2821,     0,  2822,  2823,  2824,  2825,  2826,
       0,   675,  1256,     0,     0,   427,   503,   471,     0,   433,
       0,     0,     0,     0,     0,     0,     0,   610,     0,     0,
       0,   181,   411,   610,   660,     0,     0,     0,   730,     0,
     413,     0,  1346,   412,     0,     0,   501,     0,   499,     0,
     496,     0,   500,     0,  1231,     0,     0,  1030,     0,  1034,
       0,   993,   970,  1546,     0,   551,  2408,  2412,  1064,   761,
     763,   644,   920,   927,   325,   836,   837,   838,   839,  1713,
       0,     0,     0,     0,  1774,     0,  1775,  1802,  1801,  1781,
    1785,     0,  1782,  1783,  1685,  1689,  1687,  1670,  1806,     0,
    1444,  1539,     0,  1542,  1501,     0,     0,  1503,     0,     0,
    1505,  1507,     0,     0,     0,     0,     0,  1938,     0,  1472,
    1474,     0,  1409,     0,  2579,  2578,   231,  1851,  1548,  1380,
     921,     0,   325,   960,   503,   473,  2111,   474,   959,     0,
     961,   966,   966,     0,   503,   675,   573,     0,   609,     0,
     329,   341,     0,     0,     0,   750,   738,     0,     0,   757,
    1111,  1373,  1373,     0,  1373,     0,     0,     0,     0,     0,
     325,   808,   364,     0,   388,   397,     0,   395,   368,   373,
       0,   377,   375,   374,   369,   372,  1063,     0,  1060,  1059,
    2829,   673,     0,   462,   434,     0,   482,     0,     0,   688,
       0,     0,     0,   451,   450,   447,   446,   448,   449,   444,
     443,   635,   747,   336,  1238,   623,   662,   663,   658,     0,
       0,     0,   495,   491,   417,   426,   400,     0,   501,   497,
     498,     0,     0,     0,  1287,     0,   954,  1033,     0,     0,
       0,   546,     0,     0,   550,   541,     0,  2410,   888,  1714,
       0,  1715,     0,     0,     0,  1787,  1786,     0,  1823,  1544,
       0,     0,  1538,     0,  1510,  1526,     0,  1506,  1504,  1515,
       0,  1517,  1732,  1808,  1810,     0,  1734,   938,     0,   939,
     963,   477,     0,   962,   969,   969,   464,   675,   455,  1116,
     612,     0,   288,  1113,     0,   741,     0,   752,   750,     0,
       0,  1078,  1080,  1373,  1079,  1281,     0,  1282,  1283,  1286,
     349,   352,   383,   393,     0,   376,  1058,  1062,  1061,     0,
       0,   435,   468,   469,   470,     0,   437,   478,   479,     0,
     685,     0,   690,     0,     0,     0,     0,     0,  1232,     0,
       0,  1238,   499,   495,   424,   490,   398,     0,  1235,     0,
     336,     0,  1032,  1035,  1195,   549,   548,  2413,  2415,  2414,
       0,  1716,  1790,  1776,  1803,  1788,  1819,     0,     0,     0,
    1537,  1540,     0,  1508,     0,  1516,     0,     0,     0,   966,
       0,   675,     0,   957,   956,   471,   457,   328,     0,     0,
     748,   751,   739,   752,   759,   758,  1081,     0,   396,     0,
     461,     0,     0,     0,   480,     0,   481,   502,     0,   689,
       0,   610,   746,     0,     0,   664,     0,  1233,   501,   499,
    1236,  1237,   501,   955,   971,  1194,  1193,  1421,  2411,  2223,
       0,  2196,     0,  1821,  1824,  1822,  1816,     0,  1525,  1811,
    1812,   325,   969,     0,   459,   475,   482,     0,     0,   740,
    1284,   665,   487,     0,   486,     0,   484,   483,   686,   691,
     636,   736,  1238,   668,   401,   501,  1546,  1177,  1421,  1176,
    1178,  1186,  1183,  1185,  1184,  1182,     0,  1828,  1827,  1826,
    1830,  1829,  1541,   940,   958,     0,   675,   742,   749,     0,
     485,   489,   488,  1234,     0,   666,   669,   672,   670,   671,
     399,   945,     0,  1187,  1181,  1408,  1395,     0,   476,   460,
       0,   646,     0,  1179,  1421,  1825,     0,   667,  1180,     0,
     668,     0,   647
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,   247,   248,  1747,  2690,  2565,  3417,  3418,   249,
     250,  1820,   251,   252,   253,   254,   255,   256,   257,  1763,
     258,   259,  1317,  1973,  2700,   260,  2437,  1083,  1084,  1085,
    2293,  2294,  2632,  2295,  2282,  1598,  2075,  1782,  1749,  1783,
     262,   263,  1592,  2274,   264,   265,   266,  1808,  1809,  1757,
    2018,  4363,  4992,  3245,  2547,  3454,  3246,  3247,   267,  1869,
    1870,   268,   269,  3368,  1910,  2659,  3923,  3924,  4394,   885,
    2656,  4682,  4683,  4380,  4381,  4689,  4876,  4877,  2701,  1969,
    3448,  4012,  3408,  4465,  3409,  4466,  3410,  4467,  3396,  3970,
    3971,  3972,  3411,  4443,  4909,  3412,  2452,  5021,  2735,  2105,
    2103,  4896,  4253,  4254,  5081,  5026,  5027,  5028,  5156,  4472,
    3452,  4018,  4475,  4719,  3145,  1993,  3527,   985,  2737,   916,
     986,  2702,   274,  2729,  1840,  1841,  2573,  3930,  3510,   275,
    1336,  3791,  4765,  4944,  4945,   276,   873,   277,  1977,   278,
     279,  2686,  3402,   280,  2469,  3162,   281,   282,  3189,  3190,
    3191,   283,   284,  3811,  4634,  1810,  3234,  3235,  3236,  3237,
    3832,   285,  1975,  1846,  2709,   286,   287,   288,   289,   290,
    2620,   291,   292,  2703,  1985,  2721,  2722,  4455,  4735,  4918,
    4737,  5194,  5195,  4711,  3770,  4267,   294,   295,  4438,  4439,
    5033,   296,  2467,   297,   298,   299,  1953,  2678,  2679,  3931,
    1912,  2661,  2662,  4001,  4002,   300,  3328,   301,  4314,  4315,
     917,  5036,  4997,  5092,   302,   303,  4318,  4319,   304,   305,
     306,   307,   308,   973,  1389,  1390,  1739,   309,  2310,   310,
    1290,  3359,   311,  1478,  2873,  4513,   312,  1009,  1414,  1415,
    2704,   314,  1020,  2851,  1022,  2118,  3512,  3513,  4072,  2820,
    1209,   315,   316,  2831,  2854,   317,  1750,  2443,  2444,  4248,
    2705,   918,  1999,  2740,  3140,  4935,  4255,  4616,  4841,  3051,
    3714,   319,   919,  1787,  2512,  2743,  3460,  2415,  2416,  2417,
    4033,  2418,  3462,  2419,  1733,  2420,  3467,  3468,  3469,  4029,
    4037,  4759,  4760,   320,  1785,  2510,   321,   322,   323,  1817,
    1228,   324,   941,   942,   325,  4888,   326,  1355,   327,  1041,
    2135,   328,   329,  2524,  3818,   330,   331,   332,  5169,  5202,
    5203,  5204,  4042,  5127,   333,  5171,  1456,   335,   336,   337,
     876,  1256,  1257,  1258,  2706,  4754,   339,   340,  2682,  3395,
    3952,   341,   342,  2438,  3130,   343,   344,   345,   346,  1957,
     347,   348,   349,   350,  1889,   351,  1629,  1630,   352,   353,
     880,  1103,  1633,  1641,   354,   988,  1408,  1409,  1410,  2077,
     355,  1460,  2842,   989,  1403,   990,  3070,  3723,  3724,  3727,
     991,  3067,   359,  2124,  2836,  2839,   992,  3074,  3075,  3076,
    3077,  3078,  3729,   993,  1011,  1346,  2751,   994,  1549,   364,
     365,   366,  1112,  1107,  1108,   368,  2251,  3005,  1028,  1647,
    1068,  1119,  3678,  2324,  2325,  2347,  2348,  1656,  1657,  2337,
    2339,  3053,  2340,  3061,  2330,  4203,  4582,  2343,  2344,  1659,
    1660,  1661,  2352,   369,  3008,  3659,  3660,  3661,  4180,  4181,
    4195,  4191,  4569,  4810,  3662,  1450,  1667,  3663,  4801,  4802,
    4962,  4198,  3670,  3721,  3439,  3440,  3441,  2421,  2669,  1935,
    1550,  1936,  2676,  1551,  2170,  1938,  1552,  1553,  1554,  1941,
    1555,  1556,  1557,  1558,  2153,  2213,  1559,  1560,  2189,  1151,
    1152,  2062,  2912,  1562,  1563,  1564,  3665,  1565,  4138,  4537,
    4526,  2938,  2939,  2290,  4134,  3605,  2247,  2995,  4822,  4973,
    4974,  3646,  4164,  4554,  4800,  5069,  5133,  5134,  1566,  2992,
    2242,  1230,  1567,  3933,  2244,  2932,  3017,  3018,  2130,  2151,
    2878,  2895,  2896,  2909,  3566,  2916,  2921,  3589,  3590,  2933,
    2961,  1568,  2881,  2882,  3549,  2155,  1569,  1622,  1623,  2260,
    2956,  1636,  1637,  1105,  1570,  1571,  1572,  2119,  1094,  4806,
     726,   709,  3260,  2305,  1260,  1025,  1573,  1574,  1575,  1364,
    1365,  1688,   671,   710,   711,  1189,   823,     2,    75,   995,
    3446,   373,   374,   921,   922,   923,  1338,  1339,  2004,  2007,
    1693,  2387,   675,   676,   727,  4491,  4766,  4947,   979,   375,
     376,   377,   378,  1689,  2383,  1153,    76,    84,    77,  1154,
     415,   416,  2365,   379,   840,   380,  1670,  1133,  3735,   381,
     382,   383,   384,   385,   976,   386,  1135,   387,  1136,   388,
     389,   390,   391,  1143,   392,  1672,  1673,  4236,  1674,   393,
     394,   713,   714,  1401,   395,   396,  1170,  1171,  1433,  1434,
    1699,  1714,  1715,  1716,   397,   683,   398,   399,   400,  1705,
    1706,   401,  2267,  2268,  2392,  2269,   402,  3091,  3092,   403,
    3694,  3695,  4591,  3696,   404,  2263,   405,   406,  1097,  3740,
     407,   836,   408,  1184,   715,   716,   717,  1191,   826,  1054,
     728,  1193,  3238,   828,   829,   719,   720,   721,  2097,    78,
    3099,  2098,  1577,   729,  1578,  2258,  1579,  1580,  1581,  1582,
    1583,  1722,   723,  1160,  1393,  1394,  3100,  1396,    82,  1397,
     412,  3945,  2065,  1435,  2083,  2084
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -4780
static const int yypact[] =
{
   -4780,   377, 11773, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, 25473, -4780,
   -4780, -4780, -4780, -4780,100380,   375, -4780, -4780, -4780,105321,
   -4780, -4780, -4780,   861, 68040, -4780, 70980,   963, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, 74410, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, 56757,  1264, -4780,
     470, -4780, -4780, -4780, -4780, -4780, -4780, -4780,   779, 13418,
   -4780, -4780, 71470, -4780,   297, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, 71960,   620, -4780, -4780,   854,   903, -4780,   101,
   10516, -4780, -4780, 64610, 69020, -4780, -4780, 74900,   737,  2394,
   13795,   779, 26216, 75390, -4780,  2313, -4780, 53280, -4780, -4780,
   -4780, 68530, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, 82250,  2445,   766, 53780, -4780, -4780,
   -4780, -4780, 82250, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, 75880, -4780,  1216,  1326,   809, 82740, 83230, 66080,
   -4780,  1168, -4780, 82250,  1407,  1433, 55775, -4780, 83720, -4780,
   -4780,  1343, -4780, 76370, -4780, -4780, -4780, -4780,   766, -4780,
   56757, 52296,    30,  1312, -4780, -4780, 84210, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780,  1798,  1316, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780,   620, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780,   694, -4780,   725,   727,  1578,   627,  1351,
   -4780, -4780, -4780, 24932, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780,101841,   322, -4780, -4780, -4780,  1454, -4780,  1496, -4780,
   -4780, -4780,  1955, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
     743, -4780, -4780, -4780, -4780,  2002,100867, 74410, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, 64120, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780,   198, -4780, -4780, -4780,
   -4780, -4780, 74410, 74410, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   74410,  1591, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780,   274,  1807, -4780, -4780, 56757,  2639,  2639,  2074,
  101841, -4780, -4780, -4780, 58230, 82250, 82250, 82250,  1796, 82250,
    1659, 82250,   355, 58230,109122, 84700,  1787,  1708, 47783, -4780,
  108278, 82250, 82250, 85190, 82250,  1817, 76860, 82250,  1919, 82250,
   82250,109544, 85680,  1934, -4780,  2286,  1308, -4780, -4780, -4780,
   82250, 13126,  2445, -4780, -4780, 82250,  1916, 58230, 82250,  1851,
   82250,  1946, 82250, -4780, 82250,  1949, 86170,   362,  1701,109122,
    2070, 48287,  1994,109122, 86660, 82250, 82250, -4780, -4780,  1999,
   82250, 82250, -4780,  2100,109966,  1411,  2109,  2291,  2222,   795,
   -4780, -4780,  2377,  1959, -4780, -4780,  2432, 74410, -4780, 72450,
   -4780, -4780, -4780,  2178, -4780, -4780, -4780, -4780, -4780, -4780,
  106590,  2394, -4780, -4780, 58721, 82250,  2272, -4780, -4780, 87150,
   -4780,  2089, -4780,   570, 59212,110388,  2391,  2075, 48791,  2429,
  110810, 87640, -4780, -4780, 88130, -4780, 88620,  2167, 89110, -4780,
  111232, -4780,  2296, 89600, -4780,  9306, -4780,  2059,  2304,  2073,
    1288, 74410, 74410,   797,103178, -4780, -4780,   620, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780,   233,  1913, 54280,   741,
   54780, -4780, -4780,   791,   954,   984,   233,  2523,  2523,    44,
   74410, -4780, -4780,  1913, -4780,   805,   -80,  2076,  2076,  2076,
    2302,  1091, -4780,  2076, -4780, -4780, -4780, -4780, 76370, 54280,
   54780, -4780,  2118,  2445,    43,  2515,  2180, 82250, -4780, 82250,
   -4780, 82250, 82250, -4780, -4780, -4780,  2539,  2162,  2389, -4780,
    2157, -4780, -4780, -4780, -4780, -4780, -4780, -4780,  2355,  2359,
    2339,    61,  2445,  2269, -4780,  2471, -4780,  2386, 31723,   -82,
   74410,  2445, 55280, 77350, 97440,   290,106590,  2445, 90090,  2213,
    1412,  2396, -4780, -4780, -4780,   569, -4780,  2615,  2226,  2464,
      19,  1308, 45299, -4780,  2238,   758, 76370,102328, -4780, -4780,
   -4780, -4780,   133,  2519, 32232, -4780, 82250,  2239, -4780,  2254,
    2256,  2275,  1578, -4780, 82250,  1539,  1539,  2648,  1539,  1658,
    2044, -4780,  2534, -4780,  2567,  2529, 76370,  1312,   779,  2284,
   -4780, -4780, -4780,  2300, -4780,  2295,  2315, -4780,   413,  2577,
   -4780, -4780, -4780, -4780,  2399,  2408,  2419,  2420,  2338,  2427,
     299, -4780, -4780, -4780, -4780,  2649, -4780, -4780, -4780, -4780,
   -4780, -4780,  2754,  2743,105746,105746,   624,   654,   149,   251,
   -4780, -4780, -4780,  2611, -4780, -4780,  2626, 82250,  2465, 82250,
   -4780, -4780, -4780, 90580, -4780, -4780,  2639,  2300,  2405, -4780,
     280, -4780,   758, -4780,   330,   381,   410,  1662,  2409,  1746,
    1823, -4780,   230, 82250,  2541,   154,   794,  2430, 77840,  3858,
    2435,   824,  2737,  4641,   299, 91070, -4780, 82250, 82250, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,  2439, -4780,
   -4780,  2440,  2712,  1604,  2646,  1622,  2756,  4489,  1592, 97930,
    2766,  5795,  2086,   818,  2658,  1084,  2721,  1627,  2774,  5994,
   82250,  2473, -4780,  2715,  2816,    13, -4780,   604, -4780,  2533,
    2680,   988, 58230,  2511, -4780, -4780, 82250, -4780, -4780, -4780,
    2598, -4780,   612, 58230, -4780,  2708,  2573, 49295, -4780, 82250,
   -4780, -4780, -4780, -4780, -4780,  2654, 82250, -4780, -4780,  2772,
   82250, -4780,  2076,  2703,  2583,  2935, 61667,    78, 82250,  2607,
    2982, 82250,  2784,  2607,  2619, 91560, -4780, -4780,  2607, -4780,
   -4780, 82250, 82250,  2603,  2027,  2607,  2797,  3006,  3013,  2688,
    2795,  1001,  1520,   117,  2917,  2607,  2672, 82250, 92050, 82250,
    2683, 82250,  2998, 58230, 82250, -4780,  2796, 78330, -4780,  2642,
    2377, -4780, -4780, -4780, -4780, -4780,  1404, -4780, -4780, -4780,
   -4780,  2949,  2405,   314,  2956,  2659,  2963, -4780, -4780,  2747,
   -4780,  2964,  2435,  2968, -4780,  2675, 92540, -4780, 93030, 93520,
    2987,  2439,109122,  2988,  2675,  2993,  2910,  3039,   314,  3054,
   -4780,  1147,  3063,  2947,  3064,  1924,  2675,107012,  3065,   131,
   -4780, 14431,  9306, -4780, 27670,  1730, -4780, -4780, -4780, -4780,
   -4780, -4780, 35795,   996,  2852, -4780, -4780, -4780,  2067, -4780,
  104465, -4780,   797,  1913, -4780, 74410,  1913, 74410,    44,  1913,
   74410,  1913, 74410,    44,  1913, 74410, 74410, 74410,  1913, -4780,
   -4780,  1702,  1930, -4780, -4780, -4780, -4780, -4780, 74410,  2769,
   82250, 82250, -4780, -4780, -4780, 69510,109122, 70000, -4780, -4780,
     205, 74410, -4780, 74410, -4780,  2445, -4780, -4780,  2304, 61667,
    3175,109122,  2998,  3060,  3060,  3060, -4780, -4780, -4780,  3002,
   82250,  3066,  3067, 69510,109122, -4780, 94010,106590,  2962,  2779,
   -4780, -4780, -4780, -4780,  2113,  2936,   370,  2992, 35795,  2780,
     168,   168,  2781,  3072, -4780, -4780, -4780,   449,  2785,  2786,
   -4780,   490,   490,  2946,  2787,  2789, -4780,   503,  2792, -4780,
    3049,   521,  2793,  2799,  2800,  2277,   168, 35795, -4780,  2801,
     490,  2806,  2807,  2808,  3062,  2810, -4780,  3088,  2812,   204,
     348,  2815,  2817, -4780,  2787, -4780,   359,  2821,  2822,  2823,
    2824,  2825,  2826,  2828,  2829, 35795, 35795, -4780, 30705,   758,
    2445, -4780, -4780, -4780, -4780, -4780, -4780, -4780,   103, -4780,
     531,  5116, -4780,  2832, -4780, -4780,  2969, 35795, -4780, -4780,
    3047,  2813, -4780,   542, -4780, -4780,   758, -4780, -4780,   337,
   -4780, -4780, -4780, -4780,  1972,  1972,   208, -4780, 71470, 71470,
   -4780, -4780,  1508,  2834, -4780,  1811, -4780, -4780, -4780, -4780,
   -4780, -4780,106168,  3214, -4780,  2259,  2445,   604,   219,  3181,
  103603,104034,  3080,  3080,  3071, -4780, -4780, 82250, -4780, -4780,
   35795, 51312, -4780,   758,    86,  3081, -4780, -4780, -4780,  2121,
   -4780, -4780, -4780,   620, -4780, 12994, -4780,  2139,  2239, 82250,
   82250,  3244, -4780, -4780,  2254, -4780, -4780,  1578,  1578, 35795,
    1578,  1008,  1544, 32741, 35795,  3129,  3033,  1561,  1314,  3136,
   -4780,  3038,  1658,  2044, 76370, 82250, 94500,  2959, -4780, -4780,
    2300,  2857,  1925, -4780, 63630,101354,101354,  3100, -4780, -4780,
     930,   577,  2971,  3068,  2523,  1180,  1318, -4780, -4780,  2850,
   -4780,  3188, 71470,  2916,105746, -4780, -4780, 82250, -4780, -4780,
   78820, -4780, -4780, -4780,  2287,  2858, -4780,  2875, 82250,  3362,
   -4780,  1318,  1318, -4780, -4780,  2861, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780,101841,  2865, 82250, -4780,  2866,  2867,
   -4780,102328, 51804,  1784,   758,  2948,  2965,  2994, 56757,  2873,
    2966,  2967,  3001,  2970,  2972, 98420, -4780, -4780, -4780, -4780,
    1446,   925,  1122,  2973,   234,   874,  3240, -4780,  1710,  3004,
   -4780, -4780, -4780,  4203, 82250,  3186,  6046,  3077,   299,  3012,
   -4780, -4780,  3131,  2976,  2979,  3098,   299,  1048, 98910, -4780,
   -4780, -4780, -4780, -4780, -4780,  4389, 29204, -4780,  2986,  2961,
   82250, 65100,   231,  3096,  1559,  1575,   486, 82250,  3176,  3110,
   82250,  2922,  3005,  3007,  3197,  2929,  2090,  3293,  2932, -4780,
   -4780,  3108,  3238,  6193,  2997,  3008, 60685,  1166, 49799,  3277,
    1749,  3029, -4780,  1749, 82250,  3032,  3035, 82250,   299, -4780,
    3347,   299,   299,  1395,  3350,  3042,   225,  1654,  2607,  2932,
    1506, -4780,  3043,  3044,  1782, -4780,  3143, -4780,  1114, 76370,
     613,  1795,  2932,   157,  3045,  3051,  2929,  2929, 82250, 82250,
   82250, 82250, 82250,   119,  3369,  3374,  3053,   134,  3103,  2975,
   -4780,107434,  3059, 97440, -4780, -4780, 82250,  3074,  2072,  2932,
    1670, -4780,  2038, -4780, -4780, -4780,  1308, -4780, 82250, -4780,
   82250,  2405, 61667,  3172, -4780,  3023, -4780,  2435,   299, -4780,
   82250, 82250,  2439,  1094,  1220,  3184, 82250,  3242,  3040, -4780,
     176, 51804, -4780,  2603,  3003, -4780,  3058, -4780,  3058,  3058,
    3017,  3017,  3018, -4780, -4780,  2277,  3058,  3017, -4780, 62649,
   -4780,  1794,  1849, -4780,  3410,  3413, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780,  1103, -4780,  2147, -4780, -4780,
   -4780, 82250, 56757, -4780,  3424, -4780, -4780, 61667,  3206,  3323,
   -4780, 82250,  3225,  3026, -4780,  3361,  3085, -4780, -4780,   -27,
   -4780,  3332,109122,  1455,  2445,  3078, 82250,  3252, 82250, 82250,
   82250, 82250, -4780, -4780,  3226,   675,   141, -4780,107434, -4780,
   82250,  1506,  3237,  3443,   763,  2076, 82250,  3328, -4780, 82250,
    3041,  3445,  3280, -4780, -4780,  3050,  2523, -4780,  2642, -4780,
    2196, -4780,  3165, -4780, 58230,   314, -4780, -4780, -4780, -4780,
   61667, 82250, 94990, 58230,   314,109122,109122,  3346,   131,  3352,
    3101,  3354,  3109, 49799,   314,   182,109122, 82250, 82250, 82250,
   -4780, 82250, -4780, -4780, -4780, -4780, 82250, 82250,109122,107434,
    3370,  3371,   314, 82250, 82250, -4780, -4780, 21065,  1801, -4780,
    9306, -4780, 12994,  2170,  3080, -4780,  1591, 82250,  1427,   797,
  107856, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, 74410,
   -4780, 74410,    44, -4780, -4780, 74410, -4780, 74410,    44, -4780,
   74410, -4780, -4780, -4780, 74410, 82250,  3570,  3073, -4780,   337,
   -4780, 82250,  2176, -4780, -4780,  2183,   907, 82250, 82250,   187,
   58230, 82250,  3266, 82250, 82250, 82250, 82250, 82250,  3154,  2834,
    1477, -4780,   310, 76370,  3275, -4780, -4780, -4780, -4780, -4780,
    2190,  1798,  1142, 82250, -4780, -4780, -4780, -4780, -4780, -4780,
   70000, 68530,  3365,   146, 82250, -4780, -4780,  3846, 35795, 31214,
   -4780, -4780, -4780,  3083, 12994,  3124, 35795, -4780, -4780, 35795,
    3086,  2523,  2523, 35795, -4780, -4780, -4780, -4780,  3349,  2523,
   -4780, 35795, 35795,  2523,  2523,  3058,  3058, -4780,  2458, 35795,
   -4780, 49799, 35795, 37322, 28694, 35795,  3166,  3106,  2523, -4780,
    2523, -4780, 35795, 30196, -4780, 35795,  3298, 38340, 35795,   219,
    3300, 35795,   219,  3519,  3519,  1312,  1380,  6224,  3092,   758,
   -4780,  3207,  2523, -4780,  2523,   254,   295, 61667, 35795, 56757,
    3178,   151, 82250, 35795,  3104,  1943, -4780, 35795,  1229, -4780,
    3105, 35795,  3173, 35795, 35795, 35795, 35795, 35795, 35795, 35795,
   35795, 35795, -4780, 39330,   305, -4780,  3376,  3394,   462,  1914,
   70490,  3391, -4780, 31723, 28184, -4780,   473, 74410, -4780, -4780,
     758, -4780, -4780, -4780, -4780, -4780,  2287,  3107, -4780,  3122,
   -4780, -4780, -4780, -4780, -4780, 82250,  3214, -4780, -4780,  3187,
   -4780, -4780, -4780, -4780,   550, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780,  3111, -4780, -4780, -4780, -4780,  3111, -4780,
   -4780,  3080,  3112,  2952, -4780, -4780, -4780, -4780,  3381,  3390,
     314,101841, 82250,   133, 72940, -4780, 32232, -4780,  2206, -4780,
    3121, -4780,  3372, -4780,  3119, -4780,  5106,  3372, -4780, -4780,
     206,  3235,  3367,  3314, -4780, -4780, -4780,  3128, 12994, -4780,
    2103, 12994,  2123, -4780, -4780, -4780, -4780, -4780, -4780,  1281,
   -4780, 82250,  3275,  3129,  1314,  3189,   920, 82250, -4780, 45794,
    1968, -4780,  2300, -4780, -4780, 26706, -4780, 27196, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780,  3132, -4780, -4780,
   -4780, -4780,   299,  3134,  3611, -4780,105746, -4780, -4780, -4780,
    3570, -4780,  2432, -4780,  2432,  3641, -4780, 74410, -4780, -4780,
   -4780, -4780,  1015, -4780,  9306, -4780,  9306, -4780,  3319, -4780,
    3531, -4780, 62649, -4780,  3144, -4780, 62158, 59703, -4780, -4780,
     807, -4780,   611,  3223,  3224,  3270,109122, 82250, 82250, -4780,
   56757,109122, 82250, 82250,109122, 82250, 82250, -4780,  3510,  1096,
   68530,  3272, 66570, -4780, -4780,  3151, 82250,  3208,  3395,  3396,
    -116, -4780, -4780, 95480, -4780,  3353,109122, 82250, 82250, 35795,
    3357, 82250, 82250, -4780,   169,  3229,  3232, -4780, 82250,  3236,
   58230,  3164, 82250, 82250, 82250,  3239,   680, 58230,  3211, 50303,
   82250, 82250, 82250, 82250,  3290, 82250, 82250,  3408,  1623, 76370,
     128,  2097,  2932,  3368, -4780,  1471, -4780,109122, 82250,  3358,
   -4780, -4780, -4780, 67060,  3572,  3278, -4780, -4780, 99400, -4780,
   -4780, -4780,  2236, -4780,109122,109122,  6315, 82250,   933, -4780,
   -4780, 61667, -4780, 82250, 82250, 82250, 82250, 73430, 95970, 96460,
    1619,  1674, 82250, 73920, -4780, 82250, -4780, -4780, 57248,109122,
   82250,   997, 56757, -4780, 82250,  3363,   783, -4780, 82250,  7553,
    3254, 82250,   186,  2151,  2932, 82250, 82250,  3179,  2240,  3256,
    3305, -4780, 82250, -4780,109122,  1036, -4780,  3324,109122, 82250,
    9146, -4780, -4780,   299, -4780, -4780, -4780, -4780, -4780, 82250,
   82250,   299, 82250,   299,  1605, -4780,109122, 82250, -4780, -4780,
   -4780,  6516, 82250, 82250, 82250, 82250,  1040,  1152,  3228,  1205,
  109122, 82250, -4780, -4780,  1190,  1742,   553,  1747,  3326, 82250,
    3453, 82250, 96950,109122, 82250, 82250, 82250,  1755, -4780, -4780,
    3301, -4780,109122,  1036,  6673, 82250, 82250,  3267,  3268,   112,
    3339, -4780, -4780, -4780, -4780, -4780, -4780,  3435,  3599, 82250,
   -4780,  3438,  3439,  3253,  3255,  3440,  2278, 82250, -4780, -4780,
   -4780, -4780, 82250,  3442,  2278,  3388,    93, -4780, -4780,  2607,
   -4780,  2245, -4780,  3215, -4780, 35795,  3609, 61667,  3212,  3216,
    3281, -4780,  3283,  2523, -4780,  2253, -4780, -4780,  2262, -4780,
    3231,   675,  1383, -4780, 56757, 82250,   543,   757,  3513, 65590,
    3491,  3502, 82250,  3258, 82250,  3491, 82250, -4780,  1474, 68530,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,  3503,
   -4780,  2445,  2603,  2603,  2603,  2603, -4780, -4780, -4780, -4780,
    3412,  1921, -4780,  3220,  2603, 82250,  3337,  3491,  3234, -4780,
    1506,  3526,  3528, 82250, 65590,  2336,  3264,  3634,  2076,  2445,
    3417, -4780, 29700,  4130,  3421,106590, 78330, -4780,  3243,  3508,
    3511,  3527, -4780,  2405, -4780,  3645, -4780,  3542,   314,  2435,
   -4780,  2675, -4780, 82250, -4780, 82250, 82250, 82250, 82250,  2439,
   -4780, -4780,  2675,  3428,   314,   314, -4780,  3429,   314,  2675,
    3359,  3533,106590, -4780,   131, -4780, -4780, -4780, -4780, -4780,
   35795, -4780, -4780,  2076,  2196, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, 74410,  2432, -4780,  2309,
   -4780, 82250, -4780,  3509,  3514,  3516,  3250,  3251,  3279, 82250,
    3257, -4780,  3250,   299,  3250,  2834,  2834,  3250,  3251,108700,
    3672,  3534,    74, -4780,   729,   939,  3468, -4780, -4780, -4780,
   -4780, 61667, -4780, -4780, -4780, -4780, -4780, 82250,  3294,   301,
    3448,  3260,108700,  3647,   314, -4780, 58230, -4780, -4780, -4780,
    3338,  3355, 58230,  3457,  3310, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780,  3506, 82250,  2333, -4780,  1830, -4780,  1855, 35795,
   35795,   222, -4780, 11275,  2381, 35795,  3269,  3271,  2400, -4780,
   -4780, -4780, -4780, -4780, -4780,  3274,  3555, -4780, -4780,  3282,
    2416,  2426,  3284,  3285, -4780, -4780,  5659,  3286, 11009,  3287,
   37322, 37322,  1293, -4780, -4780, 37322,  3289, -4780,  2467,  8059,
    3273,  3291,  3296, -4780,  3295,  3299, 11836, 33250, 35795, 33250,
   33250, 12242,  3273,  3302,  2483, 56757,  3441, 12392,  2488, -4780,
   35795, 56757,  5713, 35795, -4780, 35795, 82250,  3306,  3307, -4780,
   -4780,  2458, -4780,  3297, -4780, 37322, 37322, -4780,  5153, 30705,
   -4780, -4780,  3565, -4780, -4780,  1598, -4780,  3309, -4780, -4780,
    7402,   226, 35795,  3104, 35795,  3378, 49799,  3849, 35795,  5767,
    8621,  8621,   401,   401,   127,   127,   127,  2181,  1914, -4780,
   -4780, -4780,  3311,  3312,  3313,  3458,  2810, 35795, -4780,  2586,
    2590, 82250,  7646, 11113, 13821, -4780, -4780, 40843,  3333, -4780,
   35795, 35795, 35795,  3316, -4780,  3707, 12994,   534, -4780,  3718,
   -4780, -4780, -4780,  1183,  3641,  2287, -4780,  1308,  2523,   254,
  104465, -4780, -4780, -4780, 35795, -4780, -4780, -4780, -4780,  2254,
   -4780, -4780, -4780, -4780, -4780, 82250,  1798, 35795, -4780, -4780,
    1262,  2068, 35795,  2103, -4780, -4780,  3356, -4780, 35795, -4780,
   -4780, -4780,  2834, -4780, -4780, -4780, 40843,  3336,  3375, 44804,
    3450, -4780, -4780, 82250,   334, -4780, -4780, -4780,  3340, -4780,
   -4780, -4780,  1700, -4780, -4780, -4780, -4780, -4780, -4780,  3315,
   -4780,  3303, -4780,  3341, -4780, -4780, -4780, -4780,   173,  3329,
    3317,  3330,  1502, -4780, 59703,  2147, -4780, 62158, -4780, 62158,
   -4780,  2147,  3698, -4780, 59703,  2084,109122, 82250, 82250, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,  3550,
   -4780,109122,109122,  3518, 82250,  3517,  3521, 35795,   863, 82250,
    3342,  3344,  1113,  3594, 82250, -4780,  3637,   314, -4780, -4780,
    3414, -4780, 12994, -4780, -4780, -4780, -4780, -4780,109122, 82250,
   -4780,106590, -4780,  2405, 61667, -4780, -4780, -4780, 82250,  3373,
   82250, -4780, 82250, 82250, 82250,  2439, -4780, -4780, -4780, -4780,
    1278, -4780, -4780, 82250, 82250,   711,  3415,  3416, 82250, -4780,
     842,  3143,  6764, 82250, 82250, 82250,  3593, -4780, -4780, -4780,
   -4780,  3540, -4780, -4780, 59703, -4780,  2675,  3423,  2932, -4780,
    3530, -4780,  1490, -4780, -4780, -4780, -4780, -4780,  3650,   314,
    3651,   314, 82250, 82250, 82250, 82250, -4780, -4780, -4780, -4780,
   -4780, 56757, 56757, 56757,  2509, -4780, -4780,  2445, -4780, -4780,
   -4780, -4780, -4780, -4780,  3612, -4780,  2513, -4780,  1791, -4780,
   -4780, -4780, -4780, -4780, -4780,109122,  6805, 82250, 82250, 82250,
    1785, -4780,   762, 61667, -4780, 61176,109122, 82250, -4780, -4780,
    3577,  3520, -4780,  2358,  3522,109122,  3420, -4780, -4780,  3431,
   -4780, -4780,  3433,  2351,  2932,  1506, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780,   286,  2366,  2932,  3434, -4780,  3444,
   -4780,  3752, 82250,  3754, 82250,  1209,  3756, 82250, -4780, -4780,
    3588,  3589,  3591,  3452,  3454,  3498,  3456,  3459,  3505, -4780,
    3461,  3535,  3482,  3536,  3483,   314, 61667,  3580,  2445,  3501,
    3682,   314, -4780,  3486, -4780, -4780,  3810, -4780, 82250, -4780,
    3489,  2433,  2932, -4780, -4780,109122, 82250, -4780, -4780, -4780,
    2278, 61667,  3658,  2278,  2278, 82250, 82250,  2278, -4780, -4780,
   -4780,  3659,  3660,  2278, -4780, -4780, -4780, -4780,  2703,  3426,
   -4780,  2178, 47279,  7092,  3422,  3216,  3427,  2523, 43319,  1260,
    3639,  3432, -4780, -4780, 56757, 47279,  1927,  3655,  3447,  3447,
    3447,  3447,  3447,  3447,  3447, -4780,  1958,    72,  2607,106590,
   82250,106590, -4780,   757,  3530, 82250, 82250,  3449,  3437, -4780,
   -4780, -4780, -4780,109122,   921,109122,  2523, -4780, -4780,  3504,
   -4780, 82250,  2076,  3840,  3013,  1455,  3581,  2082,  3783,  3264,
   -4780, -4780, -4780, -4780, 82250, 82250,   675,  2445, -4780,  3455,
    3460, -4780, 82250, 82250, 82250, 82250,  1798,  3446,  3464, 61667,
     -32,  3632,  3643,  2929,  3863,  1798,  3264,  3537, 82250, -4780,
    2517,    89, -4780,  2445,106590, 60194, -4780,  4262, -4780, -4780,
    1134,  3728, -4780, 82250, -4780, -4780, 44309,   314, 61667, 82250,
   -4780,   314,   131,  3523,   314,  3524,   314,   314, 82250, -4780,
   -4780, 82250, -4780, 82250,107434,   314, -4780, 12994,  3748, -4780,
   -4780, -4780, -4780,  3584,  3595,  3597, 82250,  3250, 58230, -4780,
    3463,109122,  1601, -4780, -4780,  3663, -4780, -4780, -4780, -4780,
   -4780,  3770,  3787, -4780, -4780, -4780,   140, -4780,109122, 69510,
     215,109122, -4780,  2405, -4780, -4780,  2435,   299, -4780, 82250,
    3729, -4780, -4780, -4780,  3487,  2520, 12708, 35795, -4780,  3797,
   61667, -4780,  7115, -4780, -4780, -4780, -4780, 35795, -4780, -4780,
   -4780, -4780, -4780, 35795, -4780, 35795,  3772, -4780,  3914,  3914,
   61667, 37322,  1391,  2806, 37322, 37322, 37322, 37322, 37322, 37322,
   37322, 37322, 37322, 39839,  1667, -4780, -4780, 35795, 35795,  3780,
    3772, -4780, -4780,  1713,  1713, 61667,  3492,  3273,  3494,  3495,
   35795, -4780, -4780,  2528, 38835,  3496, 56757, -4780, 35795, 11795,
    2537,  3543, 12596,   758,  7443, -4780,  3870,  2445, 35795,  1778,
    2303, 35795,  2538, 35795,  3782, -4780, -4780, -4780,  3500, -4780,
   -4780, 61667, 35795, 37322, 37322,  9929, -4780, 10281, 35795,  3507,
   10391, 30705, -4780,  3681,  3541, 46289, -4780,   766,   766,   766,
     766, -4780, 82250, 82250, 82250, 41338,  3789, 40348, 79310,  3515,
    2317, -4780, 79310, 79800, -4780,  3525, -4780,  3529,   758, 35795,
    3779,   578,   578,  3681, -4780, 35795, 33759,  3532, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780,  3538, -4780,  3539, -4780, -4780,   604,
    3544, -4780, -4780,  7197,   173, -4780, -4780,  3545, -4780,  3547,
   -4780,  2068, -4780, -4780, -4780,  7896,  3691, -4780, -4780,  3515,
   34268,  3450, -4780,  2559, -4780, -4780, 31723, -4780, -4780,  2562,
   45794,  3336, 32232,   758,  2523,  3548, -4780,  2432,  1183, -4780,
   -4780, -4780, -4780, -4780,  2563,  2092, -4780, -4780, 59703, -4780,
    3582, -4780, -4780, -4780,  3447,  2675,  2675,   734,  3250,  3805,
     734,  7999, -4780, -4780, 41833, 82250, 82250, -4780, 82250,  2571,
    1887, 82250, -4780, 82250, -4780, -4780, -4780, -4780,  3922, -4780,
   82250, -4780, -4780,  3574,  3575, -4780, 82250, 82250, 82250, 82250,
   -4780, -4780,  2409, -4780, -4780,109122, 82250, -4780, -4780, -4780,
     317,  2438,  2932, -4780,  3598, -4780, -4780,  3777, -4780, 82250,
    3551, -4780,  1887,  1160,  2929,   740, -4780, -4780,  3600, 82250,
   -4780, 82250, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, 57248, -4780, -4780, 82250, -4780, 56757, 47279, 56757, -4780,
     335,  2503,  2932, -4780,  3602, -4780,  3604,  3607,  3653,  1107,
     971,  3613,  3614,  3656,  3549,  3552,  3557, -4780, -4780,   233,
    2445, -4780, -4780,  2445,  2675,  2445, 82250, 82250, 82250, 82250,
   82250, 82250, 82250, 82250,109122,  3275,109122,  3275,  3928, 82250,
  109122,  3275,  3831,   587,  1965,109122, 82250, 82250,109122, 82250,
   82250, 82250, 82250, 82250, 82250, 82250, -4780,  3913,  3853,  2148,
    3888,  3629, 82250, -4780, 82250,  3143, 82250, 82250, -4780, -4780,
   -4780,  3561,  2278, -4780, -4780,  3806,  3809, -4780,  2278,  2278,
   -4780,   176, 56757, -4780,  2918, -4780,  3215,  3547,  2523,  1318,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780,  2523,  2612,  3569,
   -4780, 43814, -4780,  3573, -4780,  2554,   254, -4780, -4780, 82250,
    3447, -4780,  2794,  2456,  2656,  2809, 80290, 80780, 81270,  3576,
   82250, 82250, 37322, -4780,  1735,   836, -4780,  3814, 82250,  3606,
   -4780, -4780, -4780,  3731, 82250, -4780, -4780, -4780, -4780, -4780,
    3578, -4780,  3692, 65590,  2675,109122,109122,  2675, -4780, 61667,
    3583,  3264,109122,  1455,  1443, 92050,  3616, -4780,  3579,  3869,
   -4780,  3585,  3587, -4780, -4780, 82250,  3530,  2587,   949,  2073,
    3294, 67550,  2336,  3845, -4780, -4780, -4780,  3953,  3678, -4780,
    1798,  3294,  3678,  2445,  3208, -4780, 59703, 35795, 35795, -4780,
    3610, -4780,  3596,  4377, -4780,  2603, -4780, -4780, -4780, -4780,
   -4780, -4780,  3671, 82250,  4025, -4780, -4780, -4780,  3601,   314,
   -4780, -4780, 82250, -4780, 82250, -4780, -4780,   314,   314, -4780,
    3711, -4780,  1798, 82250, 82250, 82250,  3250, -4780,   299, -4780,
    3879,108700, -4780, -4780, -4780, -4780, -4780,  3941,   146,  3887,
   -4780, -4780,  3855,  3857,  3859,  3860,  2369, -4780, -4780, 35795,
   12994, -4780,  3617, -4780, 12994,  8349, 12994,  3780, -4780,  2210,
    3903, -4780,  1374,  3620,  2210,  1244,  1244,   396,   396,   132,
     132,   132,  3914,  1667, 12994, 12994, -4780, -4780, -4780, -4780,
    3624, -4780, -4780, -4780,  3273, -4780, 36304,  3771,  4015, -4780,
   -4780, -4780,  3674,  3675,  3638, -4780, 35795, 36813,  3635, 62649,
   -4780, -4780,   254,  1799, 37322, 37322,  1194, -4780,  1874, 35795,
   61667,  2592,  1194,  2398,  2677, 35795, 35795, 11943,   316, 35795,
    8636,  3642, 35795, 99890, -4780, -4780, 82250, 82250, 82250, 82250,
   -4780, -4780, -4780, 79310, 79800,  3646, 42823,  2317,  3644, 82250,
   -4780, -4780,  3648, 40843,  3882,  3827, -4780, 40843,  3827,  2114,
    3827,  3891, -4780, 46784, -4780, -4780,  3654, -4780, -4780, 28184,
    2102, 12994,  4043,  3930, 35795,  3661,  3662,  3665, 12994, 35795,
   -4780,  2445,  1183,   664,  2445, -4780, -4780, -4780, 49799, -4780,
   -4780, -4780,  3847, 12994, -4780,  1798, 82250,   758,    25,  3673,
   82250, -4780,  3450, -4780, -4780,  9306, -4780, -4780, -4780, -4780,
    3727,  2597, -4780,   233, -4780, -4780, -4780, -4780,  3738, 68530,
    3948, -4780, 35795,  2601, -4780,  3703,  4039,   152,  2606,  2618,
    1887, -4780,  3606, -4780,  1752,  3929,   214, -4780,   314, -4780,
   61667, -4780, 82250, 82250, -4780, -4780, -4780, -4780,  2873, -4780,
   -4780, 82250, 82250, 82250, 82250, -4780, -4780, 56757,  1958,  3866,
   -4780, -4780,  3868,   233, 82250, -4780, 61667,   314,   314, -4780,
   -4780, -4780, -4780,  3687, 82250, 82250, 82250, 82250,109122, 82250,
   82250,  2523,  2523, 61667,  3676, -4780,  2523,  2523,  3680, -4780,
  109122, 82250, 82250, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780,  3762, -4780, -4780, -4780,  1177, -4780,
    1320, -4780,109122,  3275,  1346, -4780, 82250, 82250, 82250, 82250,
    3976, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, 82250, -4780, -4780,  2445,  2445, 61667,   314,   314,
   -4780, -4780, -4780,  3920, -4780,  2278,  2278, -4780, -4780,   593,
    2631, -4780,102750, -4780, -4780,  2982,  2445,  2982,   582, -4780,
   -4780,  2982, -4780,  2982, -4780,  1887,  3688,  1146,  3972, -4780,
    2415,101841, 43814, 43814, 43814, 43814, 43814, -4780, -4780,  3977,
     233, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, 35795, -4780,  1473,  2210,
   -4780, -4780, -4780, -4780,  3606,  2076,  3747, 58230,   242, -4780,
    3959,   543, 65590,  1690, 82250, -4780,  2675,  2675,  3751, 82250,
    4102, -4780,   964, 82250,  4014,  3740, -4780,  2445, -4780, -4780,
    3264, 82250, 65590,  3294, -4780,  2635, -4780, -4780, -4780,  3737,
    3643,  3702,  2336,  1027, 82250, -4780,  3739, -4780, -4780,  3988,
    3708, -4780, 12994, 12994,  2445, 63140,  4262, -4780, 82250,  3963,
   82250, -4780,   314, -4780,   314,   314, -4780, -4780, 82250,  3250,
    3250,  3250, -4780,  3892, -4780, -4780,   314,108700,  2369,  2369,
    2369,  2369, -4780, -4780, -4780, 12994, -4780, -4780, -4780, 37322,
    3994, -4780,  3712, 61667, -4780,  3713,  2641,  2653, 38340,  3856,
   -4780, -4780, -4780,  9149,  3765, 12994,  3816,  3716,  3720, -4780,
    2312,  2312,  1874,  2657, -4780, 37322, 37322,  1194,  1194, 35795,
    1194, -4780, -4780,  9476,  3895, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780, 57739, 79310,  3722, 82250,  2317, 40843, -4780, -4780,
    1683, -4780, 40843,  3968, -4780, 40843, 82250,  3734, 82250,   534,
   35795, 35795,  3766, -4780, -4780, -4780,  3681, -4780, -4780,  1318,
   -4780, -4780, -4780, -4780,   254,  3730, 74410, -4780, -4780, -4780,
    1312, -4780, -4780, -4780, -4780, -4780, -4780,108700,  3921,108700,
    1887,  9848,  3606, 41833, 50807, 82250, 81760, 81760,  3880,  3606,
    3747, -4780, -4780, -4780, -4780, -4780, -4780,  3741, -4780, -4780,
   -4780,  3818, -4780, -4780,  2673, -4780, -4780, -4780, -4780, -4780,
    3913, -4780, -4780, 47279, -4780,  3822, -4780, -4780, -4780, -4780,
   -4780, 42328, 49799, -4780,  1107,  3746,  3749,   971, -4780, -4780,
   -4780, 82250, 82250, 82250,  1399, -4780, 82250,  1602,   989,  3775,
    3250,  4036, -4780, -4780, -4780,  3913, -4780, -4780,  2278, -4780,
   -4780, -4780,  2607,  4076, -4780, 56757, -4780,104896, -4780, -4780,
   -4780,  2445, -4780,  2445,  3946, 82250, 52788,  2445,  2445, -4780,
   58230,  4157,  4157, -4780,  3755,  2137,  2137, -4780, -4780, -4780,
   82250, -4780, -4780,  9952,  3955, -4780,  3747,  3969,  4019, -4780,
    3763, 82250,  3918,  3767,  3768,   923,   923,  3530, 82250,  2674,
    1798,  1455, 65590,  3530, -4780,   -23,  3773,  4068, -4780,  4173,
    3446,  3774, -4780, -4780, 67550,  3961,  3678, 82250,  3643,  3896,
   -4780,  3902, -4780,  1159, -4780, 82250, 41833, -4780, 62158, -4780,
    2678, -4780, -4780,  3333, 82250,   702, -4780,  3795, -4780, -4780,
   -4780, -4780, -4780, -4780,   215, -4780, -4780, -4780, -4780,  1699,
   37322, 61667,  2679, 35795, -4780, 35795, -4780,  4171, -4780, -4780,
   -4780,   -26, -4780, -4780, -4780,  2312,  2312,  1194, -4780,  4172,
    3681, -4780,  2682,  4191, -4780, 82250,  2692, -4780, 35795,  3791,
   -4780, -4780, 40843,  1683,  2695, 82250,  2696, 61667,  3786,  3273,
   12994, 82250, -4780,  3788, -4780, -4780, -4780, -4780, -4780, -4780,
    1601,   734,   215,  4039,  3747, -4780,  3792, -4780, -4780, 82250,
   -4780,   244,   244, 82250,  3747, -4780, -4780, 82250, -4780, 56757,
    3850, -4780, 82250, 61667,  2435,   249, -4780, 61667, 61667, -4780,
   -4780,  3275,  3275, 82250,  3275, 82250, 82250, 82250, 82250, 82250,
     314, -4780,  3426,  2445, -4780, -4780,  2699, -4780, -4780, -4780,
   82250,  3579, -4780,  3579, -4780, -4780,  4157,   235, -4780, -4780,
   -4780, -4780,  2424,  3998, -4780,  1098,  3983,  3885,  3800, -4780,
   58230,  4233,  3917, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780,  4104,  3264,  3739, -4780, -4780, -4780, -4780, 35795,
    3966,  1798,  2336,  3845, -4780, -4780, -4780,  2700,  3678, -4780,
   -4780,  4183,  3996,  4190, -4780,  2704, -4780, -4780,  4377, 63140,
    4135, -4780,  3867, 82250, -4780, -4780,  2802,  4246, -4780,  1699,
    2705, -4780,  2710,  2711,  3964,  3873, -4780, 35795,     7,  3525,
   57739,  3828, -4780,  2718, -4780, 12994, 82250, -4780, -4780, -4780,
    2719, -4780, -4780,  3826, -4780,  4235, -4780, -4780,  4115, -4780,
   81760,  3872, 49799, -4780,  2068,  2068,  2076, -4780,  1887, -4780,
   -4780, 35795, -4780, -4780,  2724, -4780,  1493,  3982,  4128,  2729,
    2733, -4780, -4780,  3275, -4780,  3251,  3884,  3251, -4780,  3250,
   -4780, -4780, -4780, -4780,104896,  3579, -4780, -4780, -4780,  4161,
    4108, -4780, -4780, -4780, -4780,   623, -4780,  4037,  4040, 82250,
   -4780,  3861, -4780,  2734, 82250, 82250,  4258,  4260, -4780, 10427,
   58230,  3739,  3643,  2336,  1958, -4780, -4780,  4041, -4780,  4045,
    3264, 41833,  4262, -4780,   236, -4780, -4780, -4780, -4780, -4780,
   82250, -4780, -4780, -4780, -4780, -4780,  3273, 34777, 34777,  3862,
   -4780, -4780, 82250, -4780,  2738, -4780, 82250,  3865,108700,   244,
    3871, -4780,  3874, -4780, -4780,  3969,  1887, 12994, 58230,  4244,
   -4780, -4780, -4780,  3982, -4780, -4780, -4780, 82250, -4780,  3986,
   -4780,  1158,  1158,  4194, -4780,  3925, -4780, -4780,  3876, -4780,
    4300,  3530, -4780,  1107,  1798, -4780,  3878, -4780,  3678,  3643,
   -4780, -4780,  3678, -4780, -4780, -4780, -4780,  2091, -4780, 37831,
    3999,  1078,  8675, -4780, -4780, -4780, -4780,  2741, -4780, -4780,
   -4780,   215,  2068, 35795,  1887, -4780,  3983,  2435, 82250, -4780,
   -4780,  3740, -4780,  4289, -4780,   977, -4780, -4780, -4780, -4780,
   -4780,  3676,  3739, 56266, -4780,  3678,  3333, -4780,  2376, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780,  4280, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780, 10761, -4780, -4780, -4780,  4181,
   -4780, -4780, -4780, -4780,  2742, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780,  1415, -4780, -4780,  1788,  2275, 35286, -4780,  1887,
    4034, -4780, 56266, -4780,  2376, -4780, 58230, -4780, -4780,  3881,
   56266,  2746, -4780
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -4780, -4780,  4023, -4780, -1196,   -72,  2530, -1028, -4780, -4780,
   -4780,  3169, -4780, -4780, -4780, -4780, -4780, -4780, -4780,  3192,
   -4780, -4780,  1711, -2604, -4780, -4780,   -51,  3158, -1617,   -50,
    2803,  1378, -4780, -1386, -4780, -4780,  -894,    20, -1060, -4780,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -1100,  1861,  1199,
    4564, -2739, -4780, -4780, -1709, -3332, -4780,   576, -4780, -4780,
    1800, -4780, -4780, -4780,  1047,   495,  -454, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780,  -266, -4780, -4780,  -592,   163,  -107,
   -2608,  -317, -4780, -4780,   442,  -318, -1618, -4780, -3657, -4780,
       0, -4780, -4780, -4780,  -299, -1722,  1292, -4780,  -991, -1340,
    1620,  -653, -4780,  -180, -4780,  -710,  -591,  -589,  -663,  -483,
   -3857, -4298, -3872, -3350,  1299, -4780, -3787,   213, -4780, -4780,
     320,   339, -4780, -4780, -1821, -1738, -4780,  -950, -4780, -4780,
   -4780, -3102, -4780, -4780, -4780, -4780,   -94, -4780, -4780, -4780,
   -4780,   467, -4780, -4780, -4780, -4780, -4780, -4780, -2416,  1757,
    1759, -4780, -4780, -3326, -4780, -1203, -4780,   617, -3117,  1217,
   -4780, -4780, -4780,  2475, -4780, -4780, -4780, -4780, -4780, -4780,
   -1897, -4780, -4780,   341, -4780,  1770,  1016, -4780, -4780, -4780,
    -698,  -766,  -756, -4780, -3122, -4780, -4780, -4780, -4780,  -264,
   -4780, -4780, -4780, -4780, -4780, -4780, -1275, -4780,  1074, -3276,
   -4780, -4780,  1088, -4780, -4780, -4780, -4780, -4780,  -652,  -194,
    2497, -4780,  -535,  -629, -4780, -4780, -4780,  -191, -4780, -4780,
   -4780, -4780, -4780, -4780, -1333,  5940, -1880, -4780, -4780, -4780,
   -4780, -2544, -4780, -4780, -4780, -1574, -4780,  4281,    -1,    32,
     386, -4780,  -198,  -101,  3020, -1405, -2797,   398,  -360, -4780,
   -2061, -4780, -4780, -4780, -2706, -4780, -4780, -4780, -4780, -3603,
     391, -4780,  3009, -4780,   448, -4780, -4281, -4082, -4343, -3962,
   -3591, -4780, -4780, -1357, -4780, -4780, -4780, -1736,  2056, -2215,
   -4780, -2355,   453,  1360, -1241, -2923, -3871, -1020, -3373, -4780,
   -3790,  -459, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -1355,
    -878, -4780, -4780,  3546, -4780, -3756, -4780, -4780, -4780, -4780,
    1321, -4780, -4780, -1712,  1153, -4780, -4780, -4780, -4780, -4780,
    -646,  -730, -4780, -4780, -4780,   426, -4780, -4780, -4780, -4780,
    2182, -1217, -1001,  3397,   428, -4043, -4780, -4780, -4780, -4780,
   -3181, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -1932,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780,  2177,  2179,   -91,
    -220, -4780, -4780, -1531, -4780,  -843, -4780,  2421, -4780, -4780,
   -4780, -4780,  1448,   429,   483,   -75, -4780, -4780,   269, -3528,
     -71, -4780, -4780, -4780, -4780, -2305,   -69, -4780,   767, -4780,
   -4780, -2938, -4780,   434,   -65,  3091,  1704,   -59,   427,  -236,
    -228,  -224,   -77,  3393,  2863, -4780, -4780, -4780,  -211,  2154,
   -4780, -1078,  -340, -4780,  1456,  -929,  2152,  2853,  2851, -4780,
    1453, -4780, -4780,  1461, -4780, -4780, -4780,  -928,  2166, -4780,
    2856, -4780, -4780, -4780,  1449,  1458, -3515,   865, -3499, -3464,
     346,   338,  -921,  -284,  -166,  3462,  2870,   875,  -423, -4780,
   -4780,  -420, -4537,   810, -4780, -4371, -2510,  2508, -2168, -1875,
   -4780, -4780, -1430, 12790, -4780, -4780, -4780, 15560, 15981, -4780,
   -4780, 17058, 20526, -4780, -1261,   924, 21417, 12169, -1471, -1915,
   -1576, 19888, -2433,   331, -2932, -4780, -3633, -2683, -4780, -4780,
   -4780,  -234,   943,   159, -4780, -4780, -4780, -4780, -4780, -4780,
    -524, -4780,  -523, -4780, -4780, -4780,  -515, -4779,  2115, -4780,
    -837, -4780, 20667,  1505, -4780, -1170, -2866, -2884, -3504, -2031,
   -4780, -4780, -4780, -4780, -4780, -4780, -4780, -1900, -3390,  -311,
    1583, -4780, -4780,  1676, -4780, -4780, -4780, -1578, -1174, -2770,
    1588, -2221, -4780, -1115, -4780,   840,  2316, -1067, 10879, -1598,
   17523,  -119, -2500, -1571, -1815, -4780,  -505, -4780,  2507,  2957,
    -782,  -165,  -787,  5809,  4502,  5425, -3226, -4780, -4780,   443,
   -4780, -4780, -4780,  3926,  1095, -4780,  3245, -4780,  1826,  2566,
   -4780, -4780,  2191,  -970,   -31, -4780,  -484, -4780,  -150, -4780,
   -4780, -4780,   237, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
   -4780, -4780,  2906, -4780, -4780, -1499, -4780, -4780, -4780, -4780,
   -4780,  4205,  -373, -4780,  3618,  -366, -4780, -4780, -4780, -4780,
   -4780, -4780, -4780, -4780, -4780,  2919,  2231, -4780,  3401, -4780,
   -4780, -4780,   -48,  3138, -4780, -4780, -4780, -1220,  -614,  3430,
    3451,  2197, -4780, -4780, -4780, -4780, -4780, -4780, -4780, -4780,
    2204, -4780, -4780,  1577, -2181,  2214, -4780, -4780,   871, -4780,
   -4780,   400, -4780,   878, -4780,  3028, -4780, -4780, -4780,   913,
   -4780, -4780, -4780,  -611, 14957,    85,   114,   158,   724, -4780,
    9002,  6573,  -104,  2951,   -64, 12208, 19532,   100, -4780,  4206,
    2216,  1813, -1039, -4780,  4100,  2524, 18014, -4780, -1033,   265,
    1917, -4780,    -2,  -670, -1209,  3241,  -771, -1995, -4780,  4624,
   -4780, -3717, -4780, -1054,  3622, -1243
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2681
static const yytype_int16 yytable[] =
{
      81,   367,  1013,   357,   932,  2024,  1593,   358,  1130,   360,
    1111,  1060,  1668,   827,   410,  1131,  2034,  1096,  1734,   362,
     410,  1229,  1013,  1313,  2074,  1120,  1442,  1443,  1444,  2451,
    2674,   725,  1448,  2028,   920,  1845,  1615,  1822,  1967,  3015,
    1887,   731,  2318,   915,  1662,  2307,  1347,  3063,  1987,  2821,
    2513,  1874,  1034,  1913,  2666,  3530,  3262,  1093,   827,  2191,
    1168,  3108,  3110,   712,  1229,  2788,   972,  2675,  2142,  2520,
    1021,  2164,  2165,  2634,   987,  3664,   411,   878,  3979,  1607,
    1371,  3407,   411,  2529,   874,  3023,  3797,   680,   367,  3812,
    2180,  2726,   934,  3425,  4036,  3043,  2543,  3997,   261,  3325,
    2102,   712,  2585,  1955,  2372,  2374,  2375,  1960,  1061,  3948,
    3364,  2015,  1964,  2321,  3827,   411,  3829,  1172,  2877,  1970,
    4219,  1229,   924,   931,  4022,  3516,   827,  4151,  3673,  1989,
    1717,  4256,   931,  1114,  3664,  3728,  1719,  1839,  2594,  1122,
    1406,  1852,  4177,  1123,  3671,  3672,  3934,  2602,  2603,  1879,
    4478,   926,  2780,  1348,  4288,  4470,  2307,  4250,  1050,  3934,
     411,  2506,  4486,   409,  4194,  1082,  1010,  2429,  1090,   409,
    2730,   931,  4746,  2519,  3613,  4617,  2366,  2366,  1374,  4436,
    2089,  3744,  1600,  2064,  2741,  2059,  1010,  1875,  1386,  1784,
    1655,  1658,  3420,  4224,  1695,  1696,  3082,  1411,  4192,  4116,
    1687,  3107,   409,  3739,  1395,  4814,  1057,  4816,  3953,  3954,
    3955,  3956,  3957,  3958,  1057,  2217,  1057,   831,  2265,  1163,
    3570,   418,   884,  4464,  4400,  1986,  4940,  1185,   411,  2157,
    2158,   824,  2063,  2609,  4477,  3098,   130,   131,  2211,  3102,
    2220,   270,  2308, -1611, -1611, -1611, -1611,   409,  2614,  1760,
   -1611,    37,    38,    39,    40,  2177,  2596,  1342,    44,  2016,
    1101,  3347,   831,  2954,  1811,  1708,  3484,    79,  3486,  4027,
    2222,  3156,  1458,  2522,  4842,   825,   824,  1439,   418, -1621,
   -1621, -1621, -1621,  3973,  3517,  4955, -1621,  1431,  1709,  1348,
    1474,   271,    45,  1431,  4014,  4615,   367,  -141,   357,  1173,
    2949,  1908,   358, -1611,   360,   418,  -141,  1951,  1056,  3733,
    2016,  -141,  1431,  4076,   362,   409,  1056,   410,  1056,    45,
     825,   414,  3366,   418,  3666,  1751,    37,    38,    39,    40,
     831,  2522,    43,    44,  1480,  1710,  5125,    45,  2954,  1188,
    2693,  1884,  3143,  2016,   824,  2723,  5017,  4721,  1210,  2066,
    5176,  1761,   410,  3048,  1584, -2679, -2679, -2679, -2679,  2257,
    2818,  1626, -2679,  1627,  4916,    37,    38,    39,    40,  5067,
   -2679,   418,    44,   122,  2288,  2209,  2522,     3,  2208,   411,
      43,  2853,  1294,  3666,  2523,    45,  1159,  2457,   825,   417,
    1887,   126,  4917,   261, -1837,  5068,  4624,  3144,   272,  1902,
    1586, -1837,  2256,  2832,  2989, -2680, -2680, -2680, -2680,   418,
    2597,  2990, -2680,  2289,   411, -1853,  3171,   273,  1585,   293,
   -2680,  3547, -1853, -1621, -1621, -1621, -1621,  1752,  5215,  2670,
   -1621,  2522,  3049,  1440, -1606, -1606, -1606, -1606,  1677,  1352,
    1229, -1606,  2016,  2694,  4970, -1611, -1611, -1611, -1611,  1362,
    4928,  4077, -1611,  4722,  2122,  2598, -2677, -2677, -2677, -2677,
    2076,  2191,  2522, -2677,   313,  2309,   409,  1187,  4956,   318,
    1597, -2677,  4620,  4996,  1131,  4936,   875,  3568,  3569,  3518,
    2522,  2542,  3584,  5018,  3570, -2676, -2676, -2676, -2676,  2217,
    2164,  2165, -2676,  2052, -1606,  1885,  1145,  2180,  3375,  5126,
   -2676,   409,  1432,  2724,   334,   363,   338,   356,   837,  2816,
     838,  2017,   361,  2822,  2220,  2824,  2252,   920,  2827, -2100,
    2833,   372,  3619,  3620, -2272, -2272, -2272, -2272,  1207,  3367,
    3528, -2272,  1166,  1167,  1470,  1304,   270,  2666,  1174, -2272,
    2641,  2253,  3115,  1102,  2222,  3974,  3157,  2645, -1945, -1945,
   -1945, -1945,  1698,  1701,  1146, -1945,  1459,  2671,  2299,  2300,
    3348,  4302,  2017,  3007,  3193, -1578, -1578, -1578, -1578,  2078,
    2615,  1753, -1578,  4243,  2955,  1730,   886,  1447, -1591, -1591,
   -1591, -1591,  2610,  2146,  2599, -1591,   271,  2819,  2530,  4028,
    2035,  1952,   363,  2657,  2658,  2017, -1618, -1618, -1618, -1618,
    1348,  1628,  2123, -1618,  1754,   924,    37,    38,    39,    40,
    1762,  3934,  1704,    44,   246,  4748,  2212,    37,    38,    39,
      40,  2058,  3257,  1348,    44,    37,    38,    39,    40,  5201,
    1952,  2307,    44,  1755,   926,  2152,  2241,  5079,  2664,  3763,
    2581,  3582,  2583,  2590,  4716,  4260,  4543,  2054,  1148,  3633,
    2637,   931,   931,  1157,  2725,  2283,  1164,  2157,  2158,  4450,
    2296,  2296,  2026,  1620,  2120,  2177,  2492,  1621,  4566,  2633,
    2458,  2266,  4570,  1110,  4625,  4194,  4742,  1678,  2307,  2132,
    4459, -1611,  3022,  2186,  3378,  4705,  4706,  4707,  4708,  4709,
    1348,  1756,  2143,   272,  2017,  2880,  4762,  2834,  2026,  1159,
    1241,  5137,  1746,  2187,  4602,  1165, -1837,  4518,  2278,  4560,
    1007,  1008,   273,  2554,   293,  2835,  2991,  2188, -1578,  3052,
    2784,  2123,  3869,  3664,  2388,  3664, -2100, -1853,  1200,  -141,
    -141,  4071,  1176,  2353,  2354,   841,   418,  1007,  1008,    37,
      38,    39,    40,  1359,  5118,    43,    44,  2672,  1111,  3285,
      45,  4980,  3746,  4281,  3747,  1711,  1712,  1891,  2522,   313,
    2563,  2809,  1816,  2566,   318,  2509,  2592,  1412,  1897,  4410,
    5123,  4304,  3399,  1299,  3798,  2817,   410,   842,  3194,  1344,
    -386,  1208,  1663,   839,  2828,  1895,  1252,  1289,  1305,  1172,
   -2100, -1578,  4210, -2679,  1121,  3015,  3015,  3015,  1609,   334,
     363,   338,   356,  1007,  1686, -2100,  3910,   361,  5101,  3913,
    3914,  4347,  1124,  3917,  4395,  1348,   372,  1447,  2494,  3920,
    3993,  5165,  4834,  1348,  1348,  4241,  2500,  2186,  2000,  4844,
    1357,  1413,  3664,  1419,   411,  1424,   935,  2152,   411,  2799,
    3258,  1428,  1196, -2680,  3698,  2802,  2792,  2187,  2059,  2996,
    3730,  1196,   680,  3169, -1396,  3915,  3916,  3849,   680,  3122,
    2717,  2190,  1449,  2531,  1419,  1424,  3084,  1117,  3084,   680,
    3704,  5038, -1606,  1404,  4926,  2532,  1253,  2373,  2571,  4984,
    4985,  2574,  2575, -1611,  1122,  1196,   977, -1399,  1123,  1125,
     681,  2506,  1697,  1407, -2677,  4694,  1159,   680,   931,  3209,
    4695,   680,  3579,  3580,  3581,  3582,   367,  2238,  2239,  2240,
    2241,  1117,   680,  4291,  2904,  2905,  1405,  1254,  1144,  1760,
    2459,   409,  1700, -2676,  3251,   409,  2533,  3320, -1396,  4803,
    1449,  1345,  1115,  1418,  3400,  1423,   831,  2718,   680,  3519,
    2561,  4489,  1196,  4696, -1578,  1437,  4889,  1400,  2642,  3793,
     824,   931,  1196,   680,  1098,  4227,  3321,   980,   680,  3850,
    1666, -1399, -2272,  4348,  1452,  1454,  4244,  1255,   680,  1858,
    1001,  1148,  3666,    81,  3666,  2997,   981,   730,  2874,  2876,
    4256,  1229,   680,  1037,  1620,  1145, -1945,  3798,  1621,  2884,
    1002,  1116,  2585,  2888,   825,  3184,  1360,  1417,  5117,  1422,
    2445,  2900,  2901,  2163,  2736,  1610,  3461,  1859,   982, -2050,
    2791,  1631,  3401,  4942,  2918,  2920,  2169,  3932,  4432,  4782,
    1001,  1761,  4903,  1596,  1590,  2934,  1333,  1604,  1451,  1453,
    3932,  1420,  2209,  1625, -1618,  1425,  1426,  1427,  1896,  1159,
    1002,   712,  1766,  1146,  2214,  1438,  1147,  2825,  2826,  2593,
    3676,  4681,  4807,  4292,  2459,  2254,  5046,  4811,  1117, -2082,
    4813,  1038,  2445,  3028,  4804,  5042,  1196,  5052,  3185,  1611,
    4904,  2447,  1057, -2407,   680, -1396,  1057,  4905,  2446,  5102,
    3184,  3666,  1432,  1126,  1470,   936,  2733,   418,   879,  2448,
      37,    38,    39,    40,  4204,   411,    43,    44,  1480,  1710,
    3068,    45,  1196,  3851,  4906,  2369,  3170,    35, -1399,  3252,
    4034, -1578,  1432,  4036,  3701,    41,    42,  5142,  2719,  5193,
    1886,   682, -1578,  4256,  2163, -1578,  1738, -1578,  4739,  4610,
    5016,  2720,  4245,  2447,  3520,   937,  3852,  1148,  4099,  2813,
    3112,  4104,  4105,  4106,  4107,  4108,  4109,  4110,  4111,  4112,
    4113,  2448,  1978,  3185,  4433,  2769,  4293,  5191,  3985,  4294,
    1860,  4246,   680,   680,  4943,  3853,   938,   205,   939,  4589,
    4635, -1396,  2370,  3794,  1056,  1118,  4907,  3241,  1056,  1863,
    4247,   881,   409,  1001,  1334,  1864,  5119,  2460,  3270,  1848,
    1979,  3679,  1027,   215,  3680,  3681,  1229,  -789,  1788, -2050,
    4153,  4154,  4316,  1002, -1399,  3682,  3683,  3684, -1396,  3685,
    3686, -1396,  4749,  1001,  3687,  3688,  3689,   841,  2449,  3188,
    1748,  3507, -2101,   223,  4750,  3745,  2795,  3242,  4978,  2328,
    2371,  3115,  2501,  1002,  1039,  1040,  1149,  1057,  3271,  1335,
      79, -1399,  2002,  2761, -1399,  3382,  5164,  3031,  1861, -2082,
    5166,  3664, -2128,  2542,  2772,  3664,  1150,   882, -2050,   842,
    1196,   233,  5124, -2407,  1431,  2461,  2779,  1748,  5044,  1620,
    4845,  1196,  4461,  1621,   236,  2453,  2734,  4950,  2670,  2216,
    2449,  1865,  2217,  1411,  3062,  3310,  5152,  2733,  4931,   832,
    3272,  3311,  4601,  5200,  1950,  5192,  4932,  4967,  2042,   833,
    4317,  5178,  2454,  2907,  3188,  2814,  3986,  2220, -2082,  1738,
     246,  3243,  1111,  2221,  2450, -1942,   215,  2502,  2329,  4038,
    4210,  3113, -2407,  3114,  1148,  4586,  3521,  4803,  5022,  1482,
    3319,  1196,  3570,  4579,  2815,   367,  2043,  2222,  4311,  1056,
    2454,   841,  4908,  1980,  1229,  1145,   223,  1216,  2971,  4994,
    2080,  2403,  2082,  4999,  5000,  2086,  3690,  2088,  1131,  -608,
    2091,  2092,  2093,  1717,  2646,  4866,  4894,  4851,  4374,  1719,
     680,  2648,  4506,  2100,  4377,  4378,  2450,  4700,  1482,  4751,
    3301,  3570,  3273,   842,   233,   680,  2125,  3312,  2126,    81,
      81,  3139,    81,  5083,  5084,  3522,  4039,   236,   834,    43,
    1196,  4911,  3481,  1146,    45,  4701,  2671,  4915,   680,  2649,
     363,  1110, -2101,  2314,  3487,  1690,  3208,  3934,  4256,  2322,
    2323,  2647,  2327,  1123,  1123,  1866,  1123,  1400,  5179,  3786,
    3482,  1981,  3087,  3069,  1720,  2455,  4312,  3430,  3431,  3432,
    3433,  5023, -2128,  2224,   680,  2079,  -953,  4067,  2081,  3438,
    4933,  2085,  1172,  2087,  1169,  3244,  2090,  1950,  1867,   680,
    2094,  3015,  4462,  3369,  2225,  2226,  4867,  3787,  3808,  5153,
    3284, -2101,   680,  4289,  2972,   680,  3302,  4732,  2973,  1690,
    2378,  3131,  3932,  2379,  4981,  3274,  1196,  1868,  3691,  2044,
    1252,  3296,  3303,  3275,  4987,  4458,  3276,  1148,  1666,  1620,
    3666, -2128,  2370,  1621,  3666,  3045,  5024,  2559,  3705,  2753,
    2229,  4233,  3477,  4087,  3572,  1196,  2974,  2306,  2759,  1711,
    1712,   898,  1062,  2230,  3342,  2009,  4313,  1446,   835,  4429,
    4040,  3313,  1066,  1651,  3692,  3387,  3758,  3277,  5154,  1121,
    2270,  2271,  3571,  1196,  1196,  3306,  1196,  2585,  2009,  3878,
    1610,  5184,  4494,  3132,  4495,  2331,  1035,   712,   712,  2245,
    2371,  5155,  2650,  3572,  3314,  1196,  4520,  2576,  4521,  2560,
    4339,  3143,  4341,  3573,  2380,  2010,  4345,  2045,  2847,   900,
    1253,  5037,  3870,  4100,  3388,  4101,  -512, -1408,  3304,  4892,
    4041,  3709,  2332,  3315,  1252,  3277,  2672,  4060,  2794, -1408,
     680,  3175,  1653,  2286, -1408,  1210,   841,  1447,   680,   680,
    3959,   410,   410,  4662,  1611,  2698,  2673,  1982,  1196,   411,
    3788,  1254,  3573,  3286,  1036,  1067,  3766,   891,  3693,  1470,
    3664,  3289,  1828,  3291,  2306,  3664,  2975,  1983,  1645,  1654,
    3664,  3307,  1229,  3664,  2385,  3879, -1408,  1196,   842,  2535,
    2651,  1196,  1196,  3962,  1148,  3197,    79,    79,  2026,    79,
     410,   712,  4941,  3389,  3390,  2011,  4097,  2407, -1408,  2487,
    2439,  1255,   411,   411,   411,  1690,   898,  3391,  1829,  4036,
    2440,  3664,  1065,  2591,  1253,  3382,  2334,  3813,  2011,  2699,
    4117,  2272,   680,  2026,  2577,  2441,  2578,  4522,  2236,  2237,
    2238,  2239,  2240,  2241,  4102, -1408,   409,   898,  3789,  3545,
    4774,  4540,  4541, -1408,  4103,  2012,  2095,   907,  5122,   908,
    2522,   831,   411,  4988,  3392,  1254,  -947,  3096,  2528,   411,
    1950,  1646,  4990,  3206,   900,   824,   411,  2335,  2012,  2096,
    3198,  4015,   913,  1057,  4019, -2681, -2681,  3456,  3577,  3578,
    3579,  3580,  3581,  3582,  2273,  3570,  4663,  1830,  3597,   409,
     409,   409,  1219,  1220,  1221,   900,  1222,  1223,  1224,  1225,
    1226,  1227,  4628,  4629,   418,  1255,  1057,  2576,  1326,   825,
    1651,  1091,  4666,  1984,  1950,  5160,  4714,  3570,   824,  3622,
    3624,  3966,  3625,  3574,  3575,  3576,  2013,  3577,  3578,  3579,
    3580,  3581,  3582,  2372,  3769,  1831,  3426,  1832,  1327,   409,
    4830,  3393,  4832,  3394,  1950,  3626,   409,  2584,  2331,  2013,
    3785,  1801,  1606,   409,  3664,  1104,  5089,  2208,  3967,  2442,
   -1408,  4679,  4680,  1113,  4724,  4863,  2026,  1328,   831,   363,
    1748,  5056,  3968,  1748,  4184,  1056,  1834,  4731,  2680,  1653,
    3336,  3471,   824,  1819,  4741,  2332,  1864,    37,    38,    39,
      40,  3184,  2026,  1482,    44,  5086,  3570,  1127,  3814,   680,
    1690,  1057,   907,  3509,   908,  1690,  1690,  1651,  1056,  3666,
    3664,  1329,  1652,  4144,  3666,  1836,  5090,  2217,  3495,  3666,
    1950,  1620,  3666,  3815,  1642,  1621,   825,  1968,  2695,  4725,
    2463,  4850,  2756,   907,  2577,   908,  2578,  2333,  4066,  2663,
    2464,  2150,  4278,  4185,   910,  2026,  3627,  2727,  4430,    80,
    1838,  3628,  3777,  1801,  3969,   912,  1602,  1950,  1968,  5213,
    3666,  2167,  5214,  1842,  3185,  4621,  4870,  3572,  3038,  3677,
    4726,  4186,  2222,  2850,  1708,  1131,  1653,  2276,  2526,  2334,
     411,  2381,  1865,  4261,  2830,  1950,  4187,  2837,  1348,  5144,
    1137,  2194,  2217,  1825,  3186,  3163,  1843,  1709,  4188, -2681,
     680,  1134,  1210,  1056,   215,  2206,  2399,  2401,  1821,  1407,
    1138,  4431,  -163,  1654,  3015,  2342,   680,  2220,  3799,  3015,
    1139,  4189,   367,  2026,  3015,  1348,  1826,  3187,  4622,  2527,
    2335,  1872,  2217,  1735,   223,   208,   679,  -163,  3222,  3817,
    4808,  2627,  1196,  3378,  2797, -2471,  2798,  2222,  1950,  3743,
    2800,  1196,  2801,   680,   680,  2803,  3699,  2220,  3664,  2804,
    1873,  4408,  4590,  1690,   680,  3022,  1736,   409,  4665,  2849,
    3629,  1690,   233,     8,  2628,  2582,   680,   680,  3572,  1169,
    3630,  2465,   831,  2872,   367,    81,  2843,  2222,    81,  3223,
    2844,  1844,  2845,  3224,  5209,  1737,   824,  4190,   680,  4263,
     925,  1175,  2846,  3666,  1121,  1121,   943,  1121,  4070,  4865,
    2296,  1746,  2544,  3316,  2466,  3188,  4779,  1740,  4282,  1140,
    1186,   246,  3802,  1690,  3998,  3959,  1690,  1690,  3639,  1203,
    2588,  3960,  1026,  4007,  1746,  4290,  4295,  3573,  1196,  1214,
     825,  3961,  4795,  4796,  3225,  2952,  3317,  4071,  3045,  3664,
    1741,  3322,  4118,  4119,  4079,  2423,  3846,   208,  4305,  3666,
    1306,  2545,  1307,  2546,  4871,  2962,  3499,  2963,  3962,  1229,
    3963,  4809,  1001,  4264, -2681,  3318,  1196,  1196,  2049,  1742,
    3323,  1141,  1873,  1201,  1196,  3022,  3842,  1196,  2424,  3847,
    2964,  1196,  1002,  1690,  1743,  3054,  2898,  2542,  2050,  1196,
    1196,  3577,  3578,  3579,  3580,  3581,  3582,  1196,  1215,  4083,
    1196,  1196,  1196,  1196,  2225,  2226,  2595,  2425,  3848,  4349,
    1196,  1196,  2186,  1196,   215,  1196,  1196,  1744,  4265,  1196,
    4266,   208,  3975,  3577,  3578,  3579,  3580,  3581,  3582,  4350,
    1250,  3378,  2187,  3710,  3964,  1950,  1196,   411,  3734,  1142,
    1239,  1196,  1631,  2544,   223,  1196,  1745,  4539,  4912,  1196,
    2229,  1196,  1196,  1196,  1196,  1196,  1196,  1196,  1196,  1196,
    4603,  1196,  3133,  1348,  3136,  4365,  2060,   410,  3435,    35,
    2061,  1196,  1196,  3436,  3949,  1952,  2965,    41,    42,  3436,
     898,  2966,   233, -1443,  4538,  4366,  2967,  3776, -1443,  2217,
    4758,  3965,  2545,  2186,  2546,   236,  3966,  3666,  3574,  3575,
    3576,  5141,  3577,  3578,  3579,  3580,  3581,  3582,  3932,  4468,
    3461,  3837,  4082,  2187,  2220,  1482,  2261,  3071,  3570,  2262,
    1746,   410,  1642,   410,   409, -1396,  3838,  2188,  2542,   411,
     843,   246,  1243,  3967,  1196,  3382,  3127,  2060,   900,   831,
    1251,  2787,    79,  3192,  2222,    79,  2306,  3968,  2186,   883,
      35,   418, -1443,   824,    37,    38,    39,    40,    41,    42,
      43,    44,  3542,   974,  4185,    45,  2790,  4949,  2187,  3755,
    3756,  3533,  1293,    37,    38,    39,    40,  3536,  2940,   418,
      44,  2943,  2190,   411,  1296,   411,  1159,  3543,  3666, -1443,
    1314,  3544,  4186,    45,  1348,  1399,   418,   825,  2236,  2237,
    2238,  2239,  2240,  2241,   680,  2968,  1298,  4572,  1482,  1301,
    1853,  3570,  1321,  1063,  -409,  2969,   409,  1482,  -511,  4188,
    3570,  2629,    81,  4937,    81,  5167,   192,  1330,  4145,  3969,
    1950,  2175,  2176,  2630,  1950,  1950,   130,   131,  2236,  2237,
    2238,  2239,  2240,  2241,   680,  4258,  4259,  1854,   411,   680,
    4124,  3991,   680,    37,    38,    39,    40,  2631,  3248,  2280,
      44,  2362,  2363,  3268,    37,    38,    39,    40,  1331,  1326,
     409,    44,   409,  4691,   680,  4693,   907,  1196,   908,  4697,
    1855,  4698,  1337,  2626,  1856,  4499,  4500,  4501,  1196,    37,
      38,    39,    40,   980,  1332,  1196,    44,  1340,  4184,  1327,
    3572,  1968,  1887,  1482,  2362,  3080,  3570,   215,  3195,  1857,
    3059,  3060,   981,  3864,  4200,   680,   363,  -409,  4190,  1309,
    2544,  1310,  3667,  4545,   418,  3976,  1057,  3978,  3995,    74,
   -1467, -1467,   680,   680,  2913,   409,  1354,   223,  2544,  1950,
      37,    38,    39,    40,   982,  2544,  1924,    44,  2936,  1358,
     831,    37,    38,    39,    40,  3710,   411,   680,    44,  3573,
     411,  1366,  3259,  2216,   824,  1367,  2217,  4185,  3710,  2545,
    2281,  2546,  1329,   925,  1372,   233,  5001,  5002,   363,  5004,
    1381,  3667,   680,  3278,  3712,  3713,   680,  2545,   236,  2546,
    4031,  2220,  1387,  3572,  2545,  4186,  2546,  2221,   975,  2544,
    3397,  2069,  3572,  2070,   680,  2542,  1402,  4084,   825,  1441,
    4187,  3427,  3750,  4205,  4206,  4207,  3358,  2163,   680,  2430,
    4240,  2222,  4188,  2542,  5168,  2163,  4263,  2430,  1056,    45,
    2542,   680,  1348,  1620,  1348, -1945,  3596,  1621,  3598,  3599,
     680,  3278,  2307,   409,  2149,  4189,   246,   409,  2545,  1445,
    2546,  3984,  3573,  3987,  1455,  2312,  4414,  2313,   831,  4886,
    1461,  3573,   831,  4404,  4405,  4406,  1177,  1690,  5019,  3022,
    1462,  2960,   824,  2315,  1467,  2316,   824,  1468,  1178,  1179,
    2163,  1469,  1738,  1196,  2542,  1950,  1473,  1720,  3572,    79,
     940,    79,  1470,  2749,  1012,  2750,  3861,  1348,  1180,  4826,
    4264,  1181,   411,   205,  2789,  1471,  2790,  4512,  3278,  1472,
    2810,   192,  2811,  3278,  1012,  1477,   825,  2812,  5096,  2811,
     825,  4190,  4370,  2223,  2840,  1476,  2841,  2224,  1605,   215,
    3574,  3575,  3576,  1479,  3577,  3578,  3579,  3580,  3581,  3582,
    3044,  1613,  3045,  1111,  4758,  3278,  1608,  3573,  2225,  2226,
    1612,    37,    38,    39,    40,  4265,  1614,  4266,    44,   223,
    1950,  1115,  3868,   680,  1619,  2227,  4078,  1632,  4667,  4668,
    3203,  4670,  3204, -1444,  3264,  1639,  3265,  3871, -1444,  3370,
    4487,  3371,  1482,  1007,  1686,  3570,  2163,  1640,  2430,   409,
    1642,  2228,   215,  1649,  2229,  1159,  3383,   233,  3384,  2544,
     680,   983,  4546,   363,   831,  2136,  2137,  2230,  1196,  1643,
     236,  3652,  3653,  3654,  2544,  1182,  1664,  1665,   824,  1291,
    1116,  1669,   223,  3574,  3575,  3576,  1671,  3577,  3578,  3579,
    3580,  3581,  3582,  3450,  1675,  3451,  3577,  3578,  3579,  3580,
    3581,  3582, -1444,  3501,  3907,  2811,   984,   680,  2545,  4283,
    2546,  3603,  1183,  1111,  1676,  1680,  4416,  3610,  1690,  1950,
     233,  1679,   825,  2545,  1681,  2546,  1690,  3541,  1690,  2790,
     680,  1684,  1691,   236,  1196,  1682,  1683,  1349,   943, -1444,
    1196,  2544,  1692,  1685,  2542,  2232,  2544,  1117,  1694,    37,
      38,    39,    40,    35,   418,  1723,    44,  1196,  1196,  2542,
      45,    41,    42,  1196,    37,    38,    39,    40,    45,   246,
   -1188,    44,    80, -1188,  4306,  3551,  1724,  2790,  3574,  3575,
    3576,  1726,  3577,  3578,  3579,  3580,  3581,  3582,  1196,  1196,
    2545,  1764,  2546,  1196,  3555,  2545,  2790,  2546,  1732,  4402,
    4403,  4404,  4405,  4406,  1738,  1196,  1196,  1196,  1196,  4703,
    3559,  2544,  2790,   411,  4775,  4776,  4777,  4778,  1196,   411,
    3560,  1196,  2790,  1196,  1759,  1871,  2542,  3572,  1786,  1790,
    1457,  2542,  1816,  1196,  1196,  1818,  4527,  1196,  2233,  2234,
    2235,  1819,  2236,  2237,  2238,  2239,  2240,  2241,  1827,   367,
    1196,  2843,  1196,  1824,  4411,  2844,  1196,  2845,  1849,  1475,
    2545,  3586,  2546,  2790,  1118,  1862,  1876,  2846,  1587,  4418,
    1881,  1888,  1599,  1349,  1601,  1196,  4688,  3602,  1883,  2790,
    3710,  1882,  3607,  1210,  3608,  1196,  3573,  1890,  1196,  1196,
    1196, -1582, -1582, -1582, -1582,  3647,  2542,  3648, -1582,  3649,
     409,  3650,  4468,  3830,  1892,  3831,   409,  3835,   680,  3836,
    1898,  4025,  1196,  4026,  4088,   831,  2790,  2216,  1894,  4383,
    2217,   831,  4125,  1899,  4126,  1196,   670,  1904,  1906,   824,
    1196,  4135,  4147,  4136,  2790,   824,  1196,  2218,  4402,  4403,
    4404,  4405,  4406,  1909,  1196,  2220,  4407, -1589, -1589, -1589,
   -1589,  2221,  1914,  4225, -1589,  4226,  4229,  4239,  4230,  3114,
    4384,   679,   679,  1734,  1746,  4262,  1721,  2811,  1690,  4397,
    1956,  4398,  4338,   825,  4340,  2222,  1911,  1959,  4344,   825,
    1961,  4460,  1950,  2811,  4385,  1950,  4544,  1950,  2841,  4729,
    1971,  4605,  1950,  3114,   680,  4612,  1952,  4613,  4502,  4386,
    4618,  1972,  2811,  4387, -1580, -1580, -1580, -1580,  -183,   680,
     680, -1580,  4619,  1974,  2811,  1196,  1976, -1583, -1583, -1583,
   -1583,  1988,  1990,  4388, -1583,  4684,  4389,  4685,  1998,  4743,
    3667,  4744,  3667,  1996,   859,  4784,   680,  4785,  4390,   680,
    2006,  2014,  1950, -1581, -1581, -1581, -1581,  4786,  2019,  2790,
   -1581,  4794,  2020,  2841,  4599,  2021,  2023,  3574,  3575,  3576,
    2025,  3577,  3578,  3579,  3580,  3581,  3582,  4848,  4913,  4849,
    2811,  2026,  4938,  4951,  4939,  2841,  4959,  2223,  4960,  2033,
    2036,  2224,  1950,  4446,  4447,  2037,  4964,  4963,  3045,  4969,
    4971,  4005,  4005,  5013,  5045,  5014,  2275,  4963,  5050,  5061,
    5051,  2841,  2225,  2226,  5062,  5063,  3608,  2790,  2022,   411,
     411,   411,  5073,  5075,  3045,  4005,  4391,  2038,  5088,  2227,
    2841,  2913,  2913,  5094,  4392,  2841,  2913,  5095,  5109,  2841,
    5110,  2039,  5138,   680,  3045,  5182,  5211,  4005,  5212,  3667,
    5222,  1950,  5212,  1950,   680,  2228,  2041,  4571,  2229,  4574,
    1648,  5009,  1650,   680,  2047,  2046,  2048,  2053,  2067,  4393,
    2680,  2230,  2101,  2131,  2231,  2134,  2913,  2913,  2138,  2147,
    2140,  2141,  2148,  2156,  2159,  1690,  2160,  2166,  2161,  2162,
     246,  4875,  2168,  4161,  1349,  2171,  2172,  2248,    80,    80,
    2246,    80,  2173,  2174,  2179,  2250,   409,   409,   409,  2181,
    2182,  2183,  2279,  2184,  1950,  2185,  4046,  1349,  2192,  2253,
    2193,   831,   831,   831,  2195,  2196,  2197,  2198,  2199,  2200,
    4595,  2201,  2202,   680,  2291,   824,   824,   824,  1431,  1950,
    2275,  2311,  2320,  1652,   920,  4881,  4883,  2301,  1654,  2232,
    2349,  2351,  2359,  2361,  2368,  1148,  2382,  2384,  5074,  3926,
    1950,  2376,  2127,  2386,  2394,  2395,  2397,  2402,  2404, -2623,
    2406,  1229,   411,  1950,  2426,  2428,  2206,  4010,  2430,   825,
     825,   825,  2433,  2462,  1349,  2468,  4021,   680,  2489,   680,
    2960,  2427,  2431,  2432,  2493,  1111,  2434,  2495,  2435,  2456,
    4819,   680,  2497,   680,  2496,  2498,  2499,  4045,  2515,  3642,
      35,  1111,  2514,  2525,    37,    38,    39,    40,    41,    42,
    2535,    44,  4690,  2536,  3658,  2538,  4166,  4167,  4168,  4169,
    2541,  2539,  2542,  2540,  4717,   931,  2548,  1950,  2549,  2550,
    2551,  2562,  2233,  2234,  2235,  2555,  2236,  2237,  2238,  2239,
    2240,  2241,   680,  1950,  3033,  2564,  2556,  2210,  2568,   409,
    3034,  2569,  2572,   363,  1801,  2579,  1950,  2215,  2580,  2586,
    2587,  2600,    74,  2611,   831,  4829,  4872,  2601,  2612,  2613,
    2255,  2617,   680,  3658,  2616,  2622,  1110,  4995,   824,  2639,
    4998,  4818,  4130,  1012,  2640,  1012,  1196,  1012,  4823,   680,
    2625,  2652,  2654,  1012,  1429,  1430,  2665,  2655,  2667,  1349,
    2668,  2681,  2285,  2287,  2889,  2152,   680,  1349,  1349,   680,
    2163,  2169,  5005,  2684,  5007,  2685,  1012,  1012,  2688,  2689,
    5015,   893,   825,  2692,  2696,  1196,  2711,  1844,  1950,  2716,
    2731,  2732,  2739,  2744,  2742,  1196,  2745,  2752,  2763,  2766,
    4664,  1196,    35,  1196,  2765,  2746,  2767,  2768,  1950,  1196,
      41,    42,  1196,  1196,  1196,  1196,  1196,  1196,  1196,  1196,
    1196,  1196,  2781,  2782,  2806,  1196,  1196,  3413,  2823,  2807,
    2829,  2890,  2838,  1950,  2852,  1348,  2879,  2880,  1196,  2885,
    2922,  2923,  1196,  2935,   411,  2941,  1196,  2217,  2945,  2978,
    2946,   679,  2953,  2993,  2994,  4953,  1196,  2959,  2976,  1196,
    3007,  1196,  3025,  3024,  3035,  3027,  3032,  3030,  4875,  1950,
    1196,  1196,  1196,  3036,  3046,  3047,  1196,  1690,  1116,  1196,
    3055,  3056,  3057,  3270,  3058,  3089,  3086,  3066,  3088,  2891,
    1690,  2265,  2892,  1196,  3103,  1196,  3104,  1012,  3106,  3116,
    3117,  3118,  3129,  3134,  3137,  3158,  3139,  1196,  3159,  3141,
    3142,  3148,  3161,  1196,  1196,  3153,  1713,  3164,  3667,  3168,
    4927,  3172,  3667,  3180,  3183,  3201,  3196,  1602,  1606,  3250,
    3255,   409,  3266,  3271,  4326,  3263,  3267,  3327,  3279,  3305,
    3324,  3338,  3349,  3345,  3346,  3350,   831,  3351,  3353,  3354,
    3357,  3355,  3363,  3356,  3365,  3372,  3374,  3379,  1196,  3380,
     824,  1012,  4958,  3377,  1196,  3405,  3419,  3378,  3421,  3428,
    1196,  3385,  3248,  3437,  4303,  3434,  4837,  3442,  3444,  3445,
    3414,  3453,  3455,  2893,  3458,  3272,  1950,  3443,  3470,  3474,
    3473,  3476,  3475,  3478,  3479,  3488,  3491,  3494,  3503,  3493,
    3506,  2589,  1196,  3504,   825,  3505,  3045,  2054,  3515,  2853,
    3523,  3526,  3531,  3508,  4855,  3529,  1447,  1229,  3534,  3537,
    3538,  3535,  3539,  3553,  3557,  3554,  3604,  5066,  3556,  2790,
    5187,  3592,  3618,   680,  3623,  3645,  3558,  3675,  3561,  3562,
    3564,  3567,  1690,  3585,  1934,  3591,  3710,  3669,  -993,  3593,
    3720,  1211,  3717,  3594,  3638,  1229,  3601,  1233,  4382,  3737,
    3616,  3617,  3631,  3748,  3641,  3643,  3644,  2660,  1247,   411,
    3674,  3726,  3736,  2060,   411,  1950,   411,  3273,  3754,  3722,
    3732,  3738,  2894,  3741,  3742,  3757,  3768,  3759,  3760,  3771,
    3773,  3795,  3796,  3806,  3780,  3764,  1308,  3765,  3807,  3809,
    1315,  3810,  3819,  3821,  3834,  3859,  3860,  3866,  3863,  3867,
    3872,  1325,   680,   363,   680,  3865,  3415,  3874,   680,  3876,
    3873,  3880,   363,   680,  3882,  3883,   680,  3884,  3885,  3887,
    3886,  2707,  3888,  3898,  3902,  3889,  3890,  3891,    74,    74,
    1348,    74,  2913,   363,  3900,  2913,  2913,  2913,  2913,  2913,
    2913,  2913,  2913,  2913,  2913,  3416,   409,  1012,  3893,  3895,
     411,   409,  3904,   409,  2609,  3906,  3892,  3894,  3912,  3918,
    3919,   831,  4720,  3937,  2216,  4128,   831,  2217,   831,  3922,
    3274,  3938,  2379,  3950,  2856,   824,  3946,  3951,  3275,  3989,
     824,  3276,   824,  3983,  2218,  3992,  3996,  3994,  4016,  4011,
    1196,  4476,  2220,  3982,  2913,  2913,  4043,  2129,  2221,  4004,
    4017,  4020,  4062,  4023,    80,  4063,  4005,    80,  4013,  4068,
    4074,  4052,  4054,   680,   680,  1767,  4064,  1950,  4065,   825,
     680,  2857,  2222,  4073,   825,  5085,   825,  4075,  2149,  4086,
    4091,  3588,  3570,  4045,  3587,  2211,  4121,   409,  4122,  4123,
    4129,  4149,  4137,  4150,  1117,  4162,  4202,  1768,  4175,  4221,
    2858,  4158,   831,  4197,  1950,  1196,  1196,  4242,  4704,  4249,
    4270,  4183,  4272,  4273,  4284,  1131,   824,  4285,  4307,  4213,
    4308,  2859,  4199,  4309,  4310,  4296,  4211,  4322,  4235,  4320,
    4321,  4608,  2860,  4342,  4212,  4346,  4362,  3667,  4214,  4217,
    4218,  4291,  3667,  4323,  4287,  4364,  4324,  3667,  2206,   680,
    3667,  4325,  2861,  1769,  4367,  4373,  4375,  2862,  4606,  4376,
     825,  4399,  4173,  4035,  4176,  2897,  4401,  1196,  4434,  4426,
    4437,  4442,  4444,  4454,  2223,  2811,  4449,  4453,  2224,  4456,
    4471,  4473,  1690,  4457,  5082,  1770,  4474,  4488,  3667,  4485,
    4490,  4498,  1012,  4503,  4505,  4492,  4507,  1012,  1012,  2225,
    2226,   670,   670,  2863,  1196,  4508,  4484,  4509,  4638,  4510,
    4511,  4516,  4519,  4523,  1196,  1196,  2227,  1950,  4524,  4528,
    4529,  1771,  1196,  1196,  2864,  1229,  4854,  1196,  1950,  4530,
    4531,  4536,  4532,  1196,  1196,  4567,  4552,  1196,  4563,  4562,
    1196,  4565,  2228,  4568,  4575,  2229,  4597,  4578,  4580,  4581,
    4596,  1772,  4604,  4600,  4607,  4583,  4584,  4609,  2230,  4585,
    4614,  1196,  4615,  4623,  4636,  1196,  4637,  4643,  4671,   677,
    4678,  2377,  4654,  1430,  2381,  1210,  4657,  1196,  4661,  1773,
    4699,  3029,  1196,  4702,   859,  4718,  4710,  1196,  4723,  4728,
    4730,  2391,  4734,  4736,  4745,  4747,  4753,  4755,  2398,  2400,
    4764,  4756,  4772,  4780,  4788,  4781,  4783,  1348,  4790,  4791,
    4792,  2865,  1774,    81,  4793,  4805,   208,  2866,  3463,  4799,
    1775,  4812,  4821,  2867,  4827,  4712,  1776,  4815,  4831,  4843,
    1196,  3667,  4868,  1777,  4847,  4846,  2232,  1767,  4852,  4857,
    4869,  1778,  4858,  4873,  4880,  4887,  4895,  1014,  1950,  4890,
    1779,  4897,  2868,  4433,  2869,  1012,  4898,  4900,  1780,  4920,
    4901,  4921,  4902,  1012,  4929,   411,  4919,  1014,  4923,  1768,
    4930,  2870,  4925,  2913,  1950,  4946,  4954,  4957,  2914,  4961,
    4972,  2470,  4976,   679,  4966,  4982,   680,  3667,  4991,  5020,
    5025,  1950,  2914,  5029,  5030,  5032,  2871,  5034,   680,  1721,
    5047,    80,  5035,    80,  2558,  5040,  5048,  5049,  5054,  5055,
    1781,  5060,  5064,  1690,  2471,  1012,  5065,   410,  1012,  1012,
     680,  5072,  5076,  5077,  5078,  1769,  5080,  2472,  5091,  2233,
    2234,  2235,  4996,  2236,  2237,  2238,  2239,  2240,  2241,  5099,
    2473,  5097,  5100,  2998,  5103,  1950,  5113,  5105,  5114,  5148,
    3463,  5120,   409,  5151,  5108,  5121,  5136,  1770,  4163,  5101,
     680,  5102,  5159,  5190,  5143,  5207,  5177,   831,  5145,  1767,
    5158,  5163,  5210,  5216,  5220,  5031,  1129,  1847,  2474,   411,
    2638,   824,  1823,  1789,  2623,  1012,  3464,  3423,  3702,  2475,
    3254,  3816,  4301,  1771,  2298,  3921,  4379,  3337,  5011,  4874,
    1601,  1768,  5098,  4922,  1196,  4445,  4924,  4910,  4715,  2476,
    3762,  3502,  5146,  4835,  2477,  1196,  5186,  5106,  5104,  5157,
    5043,  3767,  4441,  1772,  3403,   825,  3404,   363,  4299,  3828,
    2708,  3386,  4000,  5189,  5221,  3667,  5217,  4899,  3947,  3925,
    4856,  5161,  2691,  5093,  5149,  2683,  4859,  2121,  1031,  4504,
    4977,  2133,  4480,  3109,  3749,  2913,  2913,  1769,  4592,  4481,
    5053,  5170,  3901,  1950,  5218,  3463,   409,  1350,  1616,   363,
    3040,  2796,  4463,  3041,  3707,  4598,  2068,  4231,  3498,  1638,
      79,  2478,  2317,  3708,  1767,   680,  3065,  2345,   208,  1770,
    2346,  3718,  3465,  2747,  3716,  2350,  1767,  1196,  1776,  3064,
    4561,  1950,  4178,  3731,  3719,  1777,  1196,  4573,  2755,  4968,
    4174,  4828,  2479,  2508,  2355,  5116,  1768,  5071,  3464,  5070,
    4141,  4232,  1779,  1196,  1196,  1771,  3667,  1196,  1768,  4952,
    1780,  4131,  5139,  5135,  5140,  3711,  3636,  3548,  1624,  3634,
    1196,   859,  1162,  3360,    74,  1196,  4228,    74,  4044,  3009,
    1196,  3360,  3472,  1196,  2748,  1772,  5128,  3090,  1196,  1196,
     370,  4382,  2367,  5147,  1791,  2008,   370,  1132,  1731,  2360,
    1792,   673,  1769,  3081,  2480,  1398,  2128,  1702,  3094,  3097,
    2481,  3697,  1781,  2482,  1769,   680,  3466,   680,  4237,  3095,
    3658,  1196,  4588,  2264,  3658,  1828,  4238,  4216,  1703,   370,
    3500,  1155,  3101,  2808,  1770,  2364,    83,     0,  3429,  2483,
    1793,  1436,  2057,     0,     0,  2484,  1770,     0,     0,     0,
     208,  1950,     0,     0,  1775,     0,     0,  1690,  2485,  1196,
    1776,   670,   363,  3464,     0,     0,  3457,  1777,     0,     0,
    1771,  1829,  1349,     0,   370,  2508,     0,     0,  2886,  2887,
       0,  4914,  1771,  2486,  1779,     0,  2899,     0,     0,  1794,
    2902,  2903,  1780,   411,     0,   680,  1795,     0,     0,  1796,
    1772,     0,     0,     0,     0,  2924,     0,  2925,  1196,  1349,
       0,     0,  1772,     0,     0,     0,     0,     0,     0,     0,
    1052,  5219,     0,     0,     0,     0,     0,     0,  1052,  2947,
    1052,  2948,     0,     0,     0,  2950,     0,     0,     0,     0,
       0,     0,   370,     0,  1781,     0,  1791,     0,  3466,  4035,
    1830,     0,  1792,  1797,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1196,   208,  1950,     0,     0,  1775,
       0,     0,     0,     0,     0,  1776,     0,   208,     0,  2507,
     409,  1775,  1777,  2391,     0,     0,     0,  1776,  1196,  1950,
    2508,  1196,  1793,  1196,  1777,   831,     0,     0,  1831,  1779,
    1832,     0,  2508,     0,     0,     0,     0,  1780,     0,   824,
    1833,  1779,  1799,     0,     0,     0,  1196,     0,     0,  1780,
    1196,     0,  1800,     0,     0,  1950,     0,     0,     0,     0,
    1801,     0,     0,     0,     0,     0,     0,     0,  2621,  1834,
    1802,  1794,     0,     0,     0,     0,     0,  1012,  1795,     0,
       0,  1796,     0,   825,     0,     0,     0,   411,     0,  1781,
    2913,  1950,     0,  3466,  4825,  1950,  1950,     0,     0,  4787,
       0,  1781,  5041,  1835,     0,     0,  1804,  1805,  1836,     0,
       0,     0,     0,     0,     0,     0,  2913,  2913,     0,     0,
       0,     0,     0,   370,     0,     0,     0,     0,     0,  1012,
       0,     0,  1837,     0,     0,  1797,     0,     0,  1196,     0,
       0,     0,     0,  1838,     0,     0,     0,     0,  1690,  1713,
       0,    74,     0,    74,     0,     0,     0,  1196,   370,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2697,
       0,     0,  5206,     0,   409,     0,     0,  1950,     0,     0,
       0,     0,     0,     0,  5059,  2621,     0,  1349,     0,   831,
    1807,     0,  1798,     0,  1799,  1196,     0,     0,  1196,     0,
       0,     0,     0,   824,  1800,     0,     0,     0,     0,     0,
       0,     0,  1801,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1802,  2762,     0,     0,     0,     0,     0,  1196,
       0,     0,     0,     0,  3658,     0,     0,     0,     0,  3658,
       0,     0,  3658,     0,     0,     0,  2621,   825,     0,     0,
       0,     0,   680,     0,     0,  1803,     0,     0,  1804,  1805,
       0,     0,     0,     0,     0,  2914,  2914,     0,     0,  3210,
    2914,     0,     0,     0,     0,     0,     0,     0,  1196,     0,
       0,     0,     0,     0,  1806,     0,     0,     0,     0,  1196,
     367,     0,  5172,     0,     0,  5162,  5173,     0,  5174,  5197,
       0,     0,     0,     0,     0,  1196,  1196,     0,  5175,     0,
    2914,  2914,     0,     0,     0,     0,   680,     0,  1349,     0,
    1012,     0,     0,     0,     0,     0,  1196,     0,  1012,     0,
    1012,   367,     0,  5172,     0,     0,  1014,  5173,  1014,  5174,
    1014,     0,  1807,     0,     0,     0,  1014,     0,  5197,  5175,
       0,  2913,     0,     0,     0,     0,  5197,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1196,     0,  1014,
    1014,     0,     0,     0,     0,     0,     0,   367,     0,  5172,
       0,  1196,     0,  5173,     0,  5174,     0,     0,     0,     0,
       0,     0,     0,     0,  3833,  5175,     0,   363,     0,     0,
       0,   411,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3376,     0,     0,     0,     0,
    3381,     0,     0,     0,     0,     0,     0,    35,     0,     0,
    3862,  2216,     0,     0,  2217,    41,    42,     0,     0,     0,
       0,  2216,     0,     0,  2217,  1196,     0,     0,     0,     0,
     411,  2218,     0,     0,  1196,  3048,     0,     0,   411,  2220,
       0,  2218,     0,     0,  2219,  2221,     0,     0,     0,  2220,
       0,     0,     0,     0,     0,  2221,     0,     0,  2216,  3658,
       0,  2217,     0,     0,     0,  3899,     0,     0,   409,  2222,
    1014,     0,     0,     0,     0,     0,     0,     0,     0,  2222,
       0,     0,     0,   831,   677,   677,  2220,  3360,     0,  1718,
    3360,  3360,  2221,     0,  3360,     0,     0,   824,     0,     0,
    3360,     0,     0,     0,     0,     0,     0,     0,     0,  3935,
       0,     0,     0,     0,  3049,  3944,  2222,   409,     0,     0,
       0,     0,  3935,     0,     0,   409,     0,     0,     0,     0,
       0,     0,   831,     0,  1014,     0,  1349,     0,  1349,     0,
     831,   825,     0,     0,     0,     0,   824,     0,     0,     0,
    1012,     0,     0,     0,   824,     0,     0,     0,   370,     0,
       0,     0,   370,   670,     0,     0,     0,     0,   363,  3524,
       0,  2223,     0,     0,  4003,  2224,   673,     0,  3621,     0,
       0,  2223,   673,     0,     0,  2224,     0,     0,     0,     0,
     825,     0,     0,   673,     0,     0,  2225,  2226,   825,     0,
    4030,  1349,     0,  3119,     0,     0,  2225,  2226,  3123,     0,
       0,  3126,     0,  2227,     0,     0,     0,     0, -2681,     0,
       0,   673,  2224,  2227,     0,   673,     0,     0,     0,     0,
       0,     0,     0,  3149,     0,     0,   673,     0,     0,  2228,
       0,     0,  2229,  2225,  2226,     0,     0,     0,  5198,  2228,
       0,     0,  2229,     0,     0,  2230,     0,     0,  2231,     0,
   -2681,     0,   673,     0,     0,  2230,     0,     0,  2231,     0,
       0,     0,     0,     0,  3199,     0,     0,   673,     0,     0,
       0,     0,   673,     0,     0,     0,     0,     0,     0,  2229,
       0,  3205,   673,     0,     0,     0,     0,  5198,     0,     0,
       0,     0,  2230,     0,     0,  5198,   673,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3239,     0,     0,     0,
       0,     0,     0,   371,     0,     0,     0,     0,     0,   371,
    1014,     0,     0,  2232,   674,     0,     0,     0,     0,     0,
       0,  3269,     0,  2232,     0,  3280,     0,     0,     0,     0,
       0,     0,  2391,     0,  4142,  3700,     0,  1012,     0,     0,
       0,   363,   371,  3292,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   363,     0,     0,  3308,     0,     0,
   -2681,     0,     0,     0,  3050,     0,     0,     0,     0,     0,
    3332,     0,     0,     0,     0,     0,  1052,     0,   673,  3339,
    1052,     0,     0,     0,     0,     0,     0,   371,     0,     0,
       0,     0,     0,     0,     0,  5205,     0,     0,     0,   370,
       0,     0,     0,     0,     0,     0,  2233,  2234,  2235,     0,
    2236,  2237,  2238,  2239,  2240,  2241,  2233,  2234,  2235,     0,
    2236,  2237,  2238,  2239,  2240,  2241,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   363,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   371,     0,  2236,  2237,  2238,
    2239,  2240,  2241,     0,     0,     0,   673,   673,     0,     0,
       0,     0,  3778,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2914,     0,     0,  2914,
    2914,  2914,  2914,  2914,  2914,  2914,  2914,  2914,  2914,     0,
       0,     0,     0,     0,     0,  1014,     0,     0,     0,     0,
    1014,  1014,     0,     0,     0,     0,     0,     0,     0,  2914,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1052,     0,     0,  2216,     0,     0,  2217,  2914,  2914,
       0,     0,     0,     0,  3935,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2218,     0,     0,     0,     0,     0,
       0,  3854,  2220,  3856,     0,     0,     0,  4327,  2221,     0,
    4328,     0,  4329,     0,     0,     0,  3514,     0,     0,     0,
       0,     0,     0,     0,   677,     0,     0,     0,  2216,     0,
       0,  2217,  2222,     0,     0,     0,   371,     0,     0,  3514,
       0,     0,     0,     0,     0,     0,     0,     0,  2218,     0,
       0,     0,     0,     0,     0,     0,  2220,     0,     0,  3360,
       0,     0,  2221,     0,  3897,  3360,  3360,     0,  2660,     0,
       0,   371,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2216,     0,     0,  2217,  2222,     0,  3944,  3911,
       0,     0,     0,     0,     0,     0,     0,     0,  1014,  4413,
    4415,  4417,  4419,     0,   673,     0,  1014,     0,     0,  1012,
    2220,     0,     0,     0,  3939,  3942,  2221,     0,     0,   673,
    1791,     0,  1012,     0,     0,     0,  1792,     0,   672,     0,
       0,     0,     0,     0,  2223,     0,     0,     0,  2224,     0,
    2222,     0,   673,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3988,     0,     0,   822,     0,  1014,  2225,
    2226,  1014,  1014,     0,     0,     0,  1793,     0,     0,     0,
    4479,     0,  2040,     0,     0,     0,  2227,     0,   673,     0,
       0,     0,     0,  2055,     0,     0,     0,  3210,  2223,     0,
       0,     0,  2224,   673,     0,     0,     0,     0,     0,     0,
       0,   822,  2228,     0,     0,  2229,   673,     0,     0,   673,
       0,     0,     0,  2225,  2226,  1794,  4048,     0,  2230,     0,
       0,  2231,  1795,     0,     0,  1796,     0,     0,  1014,     0,
    2227,     0,     0,  4514,     0,     0,     0,     0,     0,     0,
       0,     0,  2223,     0,     0,     0,  2224,  1051,     0,     0,
       0,     0,     0,     0,     0,  1051,  2228,  1051,     0,  2229,
       0,     0,     0,     0,     0,     0,     0,  2225,  2226,   822,
       0,     0,  2230,     0,  1012,  2231,     0,     0,     0,  1797,
       0,     0,     0,     0,  2227,     0,     0,     0,  4092,     0,
       0,     0,     0,     0,     0,     0,  2232,     0,     0,     0,
       0,     0,     0,  3751,     0,     0,     0,  2914,  4098,     0,
       0,     0,     0,  2229,     0,     0,     0,     0,     0,  1791,
       0,     0,     0,     0,     0,  1792,  2230,     0,     0,     0,
       0,     0,     0,  4120,   673,     0,  1798,     0,  1799,     0,
       0,     0,   673,   673,     0,  3774,     0,     0,  1800,     0,
    2232,     0,     0,   370,     0,     0,  1801,     0,  4587,     0,
    4593,  4594,     0,     0,     0,  1793,  1802,     0,     0,  2129,
       0,  1791,     0,     0,     0,     0,     0,  1792,     0,     0,
       0,     0,    80,     0,     0,     0,     0,     0,     0,  2233,
    2234,  2235,     0,  2236,  2237,  2238,  2239,  2240,  2241,  1850,
       0,     0,  1804,  1805,  2232,  3563,   370,   370,   370,     0,
       0,     0,     0,     0,  1794,     0,     0,  1793,     0,     0,
       0,  1795,     0,     0,  1796,     0,   673,     0,  1851,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3839,  2233,  2234,  2235,     0,  2236,  2237,  2238,
    2239,  2240,  2241,  3857,     0,     0,   370,     0,     0,  3611,
       0,     0,     0,   370,     0,     0,  1794,     0,     0,     0,
     370,  4234,     0,  1795,     0,     0,  1796,  1052,  1797,     0,
       0,     0,     0,     0,     0,     0,  1807,     0,     0,  2914,
    2914,   371,     0,     0,     0,   371,     0,  2233,  2234,  2235,
       0,  2236,  2237,  2238,  2239,  2240,  2241,     0,     0,   674,
    1052,     0,  4673,  4674,     0,   674,     0,     0,  1791,     0,
       0,     0,  3360,  3360,  1792,     0,   674,     0,     0,  1349,
    1797,     0,  3908,  4692,     0,  1798,     0,  1799,     0,  2216,
       0,     0,  2217,     0,     0,     0,     0,  1800,     0,  3944,
    3944,  3944,  3944,  3944,   674,  1801,     0,     0,   674,  2218,
       0,     0,     0,     0,  1793,  1802,     0,  2220,     0,   674,
       0,     0,     0,  2221,  1012,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1798,     0,  1799,
       0,     0,     0,     0,     0,   674,  1012,  2222,  1877,  1800,
       0,  1804,  1805,   673,  4738,  1052,     0,  1801,     0,     0,
     674,     0,     0,  1794,     0,   674,     0,  1802,     0,     0,
    1795,     0,     0,  1796,     0,   674,     0,  1878,     0,     0,
       0,  4757,     0,     0,     0,     0,     0,     0,     0,   674,
    1791,     0,     0,     0,     0,     0,  1792,     0,     0,     0,
    2490,     0,     0,  1804,  1805,  4514,  4514,  4514,  4514,     0,
    1014,     0,     0,     0,     0,  1429,  1430,     0,     0,     0,
       0,     0,     0,     0,  4396,     0,     0,  1797,  3942,  2491,
       0,  2621,     0,     0,   370,  1807,  1793,     0,     0,  4412,
       0,     0,     0,     0,     0,     0,     0,     0,  4069,  2223,
       0,     0,     0,  2224,   673,     0,     0,     0,     0,     0,
       0,     0,  1014,     0,     0,     0,   677,     0,  4081,     0,
     673,     0,     0,     0,  2225,  2226,     0,  4448,     0,     0,
       0,   674,  1718,     0,  1798,  1794,  1799,  1807,     0,     0,
       0,  2227,  1795,     0,     0,  1796,  1800,     0,     0,     0,
       0,     0,   371,     0,  1801,     0,     0,   673,   673,     0,
       0,     0,     0,     0,  1802,     0,     0,  2228,   673,     0,
    2229,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     673,   673,     0,  2230,     0,     0,  2231,     0,     0,     0,
    3935,     0,     0,     0,     0,     0,     0,  2552,     0,  1797,
    1804,  1805,   673,     0,     0,  1012,     0,     0,     0,  2754,
       0,     0,     0,     0,     0,     0,     0,     0,  2760,   674,
     674,     0,  2764,     0,     0,  3360,  2553,     0,  2770,  2771,
       0,     0,     0,     0,  1349,     0,     0,     0,  4878,     0,
    4879,  1791,     0,     0,  4884,  4885,  2783,  1792,     0,     0,
       0,     0,     0,     0,     0,     0,  1798,     0,  1799,     0,
       0,  2232,     0,     0,  2914,     0,     0,     0,  1800,     0,
       0,     0,     0,  2914,     0,   822,  1801,     0,     0,     0,
       0,     0,     0,     0,  1807,     0,  1802,  1793,  2129,     0,
    2914,  2914,     0,   672,     0,     0,     0,     0,     0,   672,
       0,     0,     0,  1014,     0,     0,     0,     0,     0,     0,
     672,  1014,     0,  1014,     0,     0,     0,     0,     0,  3207,
       0,     0,  1804,  1805,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1794,     0,   672,     0,
       0,     0,   672,  1795,     0,     0,  1796,     0,  1806,     0,
    2391,   370,     0,   672,  2233,  2234,  2235,     0,  2236,  2237,
    2238,  2239,  2240,  2241,     0,     0,     0,     0,  2944,     0,
       0,     0,    74,     0,     0,     0,     0,     0,     0,   672,
    1012,     0,  4279,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   672,     0,     0,     0,  1791,   672,
    1797,     0,     0,     0,  1792,     0,  1807,     0,  4627,   672,
       0,     0,     0,     0,     0,  1197,  1199,     0,     0,  1202,
    5012,  1204,     0,   672,     0,     0,     0,   674,     0,     0,
    1012,     0,     0,     0,  4640,     0,     0,     0,     0,     0,
    1245,     0,   674,   370,  1793,     0,     0,     0,  4651,  4652,
       0,  4653,     0,  4655,  4656,     0,     0,  1798,     0,  1799,
    1297,     0,     0,     0,  1300,   674,     0,     0,     0,  1800,
       0,     0,  4351,     0,     0,  4354,     0,  1801,     0,     0,
       0,  1323,     0,     0,     0,     0,     0,  1802,     0,  1791,
       0,     0,     0,  1794,     0,  1792,     0,   370,     0,   370,
    1795,   674,     0,  1796,  3037,  4675,     0,     0,     0,     0,
       0,     0,     0,  1051,     0,   672,   674,  1051,   673,  1012,
    3294,     0,     0,  1804,  1805,  2914,     0,     0,     0,   674,
    1791,     0,   674,     0,     0,  1793,  1792,     0,     0,  3942,
    3942,  3942,  3942,  3942,     0,     0,     0,  1012,     0,  3295,
       0,     0,     0,  1014,     0,     0,     0,  1797,   673,     0,
       0,  1349,   370,   673,     0,     0,   673,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1793,     0,     0,  4451,
       0,     0,     0,     0,  1794,     0,     0,     0,   673,     0,
       0,  1795,     0,     0,  1796,     0,     0,     0,     0,     0,
       0,     0,     0,   672,   672,     0,     0,  1807,     0,     0,
       0,     0,     0,     0,  1798,     0,  1799,     0,     0,     0,
       0,     0,     0,     0,     0,  1794,  1800,     0,     0,   673,
       0,     0,  1795,     0,  1801,  1796,     0,     0,     0,     0,
    1052,     0,     0,     0,  1802,     0,   673,   673,  1797,     0,
       0,     0,     0,     0,     0,     0,     0,   674,  3514,     0,
       0,  2129,     0,     0,     0,   674,   674,     0,     0,     0,
     370,   673,     0,     0,   370,     0,   371,  3340,  1051,     0,
    1804,  1805,     0,     0,     0,     0,     0,     0,     0,  1797,
       0,     0,     0,     0,     0,     0,   673,     0,     0,     0,
     673,     0,     0,     0,     0,  1798,  3341,  1799,     0,     0,
    5199,     0,     0,     0,     0,     0,     0,  1800,   673,     0,
       0,     0,     0,     0,     0,  1801,  4824,     0,     0,   371,
     371,   371,   673,     0,     0,  1802,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   673,  1798,     0,  1799,   674,
       0,     0,     0,     0,   673,     0,     0,     0,  1800,  5199,
    1014,     0,     0,     0,  1807,     0,  1801,  5199,  3800,     0,
       0,  1804,  1805,     0,     0,     0,  1802,     0,     0,   371,
    1012,     0,     0,     0,     0,     0,   371,  1814,  1815,     0,
       0,     0,     0,   371,     0,     0,     0,  3801,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2216,     0,  3840,
    2217,   672,  1804,  1805,     0,     0,   370,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   672,  2218,     0,     0,
    2216,     0,     0,  2217,     0,  2220,     0,     0,  3841,     0,
       0,  2221,     0,     0,     0,     0,     0,     0,     0,   672,
    2218,     0,     0,     0,     0,  1807,     0,     0,  2220,     0,
    1907,     0,     0,     0,  2221,  2222,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   673,     0,     0,
       0,  1965,  1966,     0,     0,   672,     0,     0,  2222,     0,
       0,     0,     0,     0,     0,  4648,  1807,     0,     0,     0,
     672,  1997,     0,     0,     0,     0,     0,  4658,     0,     0,
       0,     0,  2216,   672,   673,  2217,   672,     0,     0,  2129,
       0,     0,     0,     0,     0,     0,   674,     0,     0,     0,
       0,     0,  2218,     0,     0,     0,     0,     0,  2030,  2032,
    2220,     0,     0,     0,     0,     0,  2221,     0,     0,     0,
       0,     0,  3480,     0,     0,  3897,     0,     0,     0,     0,
       0,   673,     0,     0,     0,     0,     0,  2223,  3489,  3490,
    2222,  2224,  3492,     0,     0,     0,     0,     0,  3496,     0,
       0,     0,     0,     0,   673,     0,     0,     0,     0,     0,
    2223,  2129,  2225,  2226,  2224,  2129,  2129,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   371,     0,  2227,
       0,     0,     0,     0,     0,  2225,  2226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   674,     0,     0,
       0,     0,  2227,     0,     0,  2228,     0,     0,  2229,     0,
       0,   672,     0,   674,     0,     0,     0,     0,  3532,   672,
     672,  2230,     0,     0,  2231,     0,     0,     0,  2228,     0,
     822,  2229,     0,     0,     0,     0,     0,   370,     0,     0,
       0,     0,  2223,   370,  2230,     0,  2224,  2231,     0,     0,
     674,   674,     0,  5057,     0,     0,     0,     0,     0,     0,
       0,   674,     0,     0,  3514,     0,     0,  2225,  2226,     0,
       0,     0,  1014,   674,   674,     0,     0,     0,     0,     0,
       0,     0,     0,   822,  2227,  1014,     0,  2216,     0,     0,
    2217,     0,     0,     0,     0,   674,     0,     0,     0,  2232,
       0,     0,     0,   672,     0,     0,     0,     0,     0,     0,
    2228,     0,     0,  2229,     0,  2220,     0,     0,     0,     0,
       0,  2221,  2232,     0,     0,     0,  2230,     0,  2216,  2231,
       0,  2217,   673,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2222,     0,   822,  2218,     0,
       0,     0,     0,     0,  1051,     0,  2220,     0,     0,     0,
       0,     0,  2221,     0,  3514,     0,  3514,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2222,  1051,     0,     0,
       0,     0,  2233,  2234,  2235,     0,  2236,  2237,  2238,  2239,
    2240,  2241,     0,     0,  2232,     0,  3936,  3632,     0,     0,
       0,     0,     0,     0,     0,  2233,  2234,  2235,   673,  2236,
    2237,  2238,  2239,  2240,  2241,     0,     0,     0,     0,  4093,
       0,     0,     0,   673,   673,     0,     0,  1014,     0,     0,
       0,     0,     0,     0,   371,     0,     0, -2681,  1791,     0,
       0,  2224,     0,     0,  1792,     0,     0,     0,     0,     0,
     673,     0,     0,   673,     0,     0,     0,     0,     0,     0,
    5196,     0,  2225,  2226,     0,     0,     0,     0,     0,     0,
     672,     0,  1051,     0,     0,     0,     0,     0,  2223, -2681,
       0,     0,  2224,     0,  1793,     0,     0,  2233,  2234,  2235,
       0,  2236,  2237,  2238,  2239,  2240,  2241,     0,     0,  4215,
       0,  3772,     0,  2225,  2226,     0,     0,     0,  2229,  5196,
       0,     0,     0,     0,     0,     0,     0,  5196,     0,     0,
    2227,  2230,     0,   370,   370,   370,   371,     0,     0,     0,
    2537,     0,     0,  1794,     0,     0,     0,     0,     0,     0,
    1795,     0,     0,  1796,     0,     0,  2228,   673,     0,  2229,
       0,   822,     0,     0,     0,     0,     0,     0,   673,     0,
       0,     0,  2230,     0,     0,  2231,     0,   673,     0,     0,
       0,   672,     0,  3820,     0,  3822,     0,     0,     0,     0,
     371,     0,   371,     0,     0,     0,     0,   672,  2604,  2605,
    2606,  2607,     0,     0,     0,     0, -2186,  1797,     0, -2681,
       0,   674,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   672,   672,     0,     0,     0,     0,
    2643,  2644,     0,     0,     0,   672,  2653,   673,     0,     0,
    2232,   674,     0, -2186,     0,   371,   674,   672,   672,   674,
       0,     0,     0,     0,  1798, -2186,  1799,     0,     0,  1947,
   -2186,     0,     0,     0,     0, -2186,  1800,     0,     0,   672,
   -2186,   674,     0, -2186,  1801, -2186,   370,     0,     0,  3896,
       0,  2677,     0,     0,  1802,  3903,     0,     0,     0,     0,
       0,   673,     0,   673,     0,     0,  2236,  2237,  2238,  2239,
    2240,  2241, -2186,     0,     0,   673,     0,   673,  2712,  2713,
    2714,  2715,   674,     0,     0,     0,     0,     0,     0,     0,
    1804,  1805,     0,     0, -2186,     0,     0,  1014,     0,   674,
     674,     0,     0,  2233,  2234,  2235,     0,  2236,  2237,  2238,
    2239,  2240,  2241,     0,     0,     0,  1806,  4140,     0,  1014,
       0,     0,     0,   371,   674,     0,   673,   371,     0,     0,
       0, -2186,     0,     0,     0,     0,     0,     0,  2774, -2186,
       0,  2216,     0,     0,  2217,     0,     0,  2778,     0,   674,
       0,     0,     0,   674,  2785,     0,   673,     0,     0,     0,
       0,  2218,     0,     0,     0,     0,     0,     0,     0,  2220,
       0,   674,     0,   673,  1807,  2221,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   674,     0, -2186,   822,     0,
     673,     0,  1947,   673,     0,  3514,     0,     0,   674,  2222,
       0,  4047,     0,     0,     0,  4050,  4051,   674,  4053,     0,
    4055,  4056,     0,     0,     0,     0,     0,     0,     0,  4061,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1027,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2216,     0,     0,  2217,     0,     0,
       0,     0,     0,     0,  4080,     0, -2186,     0,     0,     0,
       0,     0,     0,     0,  2218,     0,     0,     0,   370,   371,
       0,     0,  2220,     0,     0,     0,     0,     0,  2221,     0,
   -2186,     0, -2186, -2186,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2223,  2222,     0,  2216,  2224,     0,  2217,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2186,     0,     0,
   -2186, -2186,  2957, -2186,  2218,     0,  2225,  2226,  1014,     0,
     674,     0,  2220,     0,     0,     0,     0,     0,  2221,     0,
       0,     0,     0,  2227,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   672,     0,     0,     0,     0,
       0,     0,  2222,     0,     0,     0,     0,   674,     0,  2228,
       0,     0,  2229,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2230,     0,     0,  2231,     0,
       0,     0,     0,     0,     0,   672,     0,     0,     0,   822,
     672,     0,     0,   672,  2223,     0,     0,     0,  2224,     0,
       0,     0,     0,     0,   674,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   672,     0,     0,     0,  2225,
    2226,     0,     0,     0,     0,     0,     0,   674,     0,     0,
       0,     0,     0,  3587,     0,     0,  2227,     0,  3588,     0,
       0,     0,     0,     0,     0,     0,     0,   673,     0,     0,
       0,     0,     0,  2232,  2223,  2422,   672,     0,  2224,     0,
       0,     0,  2228,     0,     0,  2229,     0,  1051,     0,     0,
       0,     0,     0,   672,   672,     0,     0,     0,  2230,  2225,
    2226,  2231,     0,   370,     0,     0,     0,     0,   370,     0,
     370,     0,     0,  1014,     0,     0,  2227,   822,   672,     0,
       0,   822,     0,     0,     0,     0,     0,     0,     0,  2422,
     371,     0,     0,     0,     0,     0,   371,     0,     0,     0,
       0,     0,  2228,   672,     0,  2229,   673,   672,   673,     0,
       0,     0,   673,     0,     0,     0,     0,   673,  2230,  1947,
     673,  2231,     0,  1014,     0,   672,  2233,  2234,  2235,     0,
    2236,  2237,  2238,  2239,  2240,  2241,  2232,     0,     0,   672,
    4220,     0,  3165,  3166,  3167,     0,     0,     0,     0,     0,
       0,  3177,   672,  3179,   370,  3181,  3182,     0,     0,     0,
       0,   672,     0,     0,  2216,     0,     0,  2217,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2218,   674,     0,     0,     0,     0,
       0,     0,  2220,     0,     0,  1947,  2232,     0,  2221,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1014,     0,  2422,     0,     0,   673,   673,     0,
       0,     0,  2222,   822,   673,     0,     0,     0,     0,  2233,
    2234,  2235,  1947,  2236,  2237,  2238,  2239,  2240,  2241,     0,
    1014,     0,     0,  4251,     0,     0,     0,     0,     0,  3287,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1947,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   674,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   672,     0,   674,   674,     0,  2233,
    2234,  2235,     0,  2236,  2237,  2238,  2239,  2240,  2241,     0,
       0,     0,     0,   673,     0,     0,     0,     0,     0,  3352,
       0,     0,     0,   674,     0,     0,   674,  3361,     0,     0,
       0,   672,  3362,  1947,  2223,     0,     0,     0,  2224,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4493,     0,     0,     0,     0,     0,  2225,
    2226,  4496,  4497,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2227,     0,   672,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   371,   371,   371,     0,
       0,   672,  2228,     0,     0,  2229,     0,     0,     0,     0,
       0,     0,     0,  3447,     0,     0,     0,     0,  2230,     0,
     674,  2231,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   674,     0,     0,     0,     0,     0,     0,     0,     0,
     674,     0,     0,     0,     0,  3483,  2216,  3485,     0,  2217,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2216,     0,     0,  2217,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2220,     0,     0,     0,     0,     0,
    2221,  2218,     0,  1014,   822,     0,     0,     0,     0,  2220,
     822,     0,     0,     0,     0,  2221,  2232,     0,     0,     0,
    2216,     0,     0,  2217,  2222,     0,     0,     0,     0,     0,
     674,     0,     0,     0,     0,     0,     0,     0,     0,  2222,
    2218,     0,     0,     0,     0,     0,     0,     0,  2220,   370,
    1947,     0,     0,     0,  2221,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   371,
     673,     0,     0,  3540,     0,     0,     0,     0,  2222,     0,
       0,     0,   673,     0,   674,     0,   674,  3019,     0,     0,
       0,     0,  4626,     0,     0,     0,     0,     0,   674,   672,
     674,     0,     0,     0,   673,     0,     0,     0,     0,  2233,
    2234,  2235,     0,  2236,  2237,  2238,  2239,  2240,  2241,     0,
       0,  4641,  4642,  4517,     0,     0,  2223,     0,     0,     0,
    2224,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2223,     0,     0,   673,  2224,     0,     0,     0,   674,
       0,  2225,  2226,     0,     0,     0,     0,     0,  5180,     0,
       0,     0,     0,   370,     0,     0,  2225,  2226,  2227,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   674,
    2223,     0,     0,  2227,  2224,   672,     0,     0,     0,     0,
       0,     0,  4676,  4677,     0,     0,   674,  2229,     0,     0,
     672,   672,     0,     0,     0,  2225,  2226,     0,     0,  2228,
    2230,     0,  2229,   674,     0,     0,   674,     0,     0,     0,
       0,     0,  2227,     0,     0,  2230,     0,   672,  2231,     0,
     672,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3105,     0,     0,  2228,  2422,
    3111,  2229,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2230,     0,     0,  2231,     0,   673,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  5181,     0,     0,  2232,     0,
       0,   371,     0,     0,     0,     0,     0,     0,     0,     0,
     822,   822,   822,  2232,     0,     0,  5058,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4768,     0,  4769,  4770,
       0,     0,     0,     0,   672,     0,     0,     0,     0,     0,
    4773,     0,     0,     0,     0,   672,     0,     0,     0,     0,
       0,     0,  2232,     0,   672,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1947,     0,   718,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   673,
    3781,   673,  3782,  3783,  3784,     0,     0,     0,     0,     0,
       0,     0, -2681, -2681,     0,  2236,  2237,  2238,  2239,  2240,
    2241,     0,     0,     0,   718,     0,  2233,  2234,  2235,     0,
    2236,  2237,  2238,  2239,  2240,  2241,     0,     0,     0,     0,
    4551,     0,     0,     0,   672,   718,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1023,     0,  2233,  2234,  2235,     0,  2236,
    2237,  2238,  2239,  2240,  2241,     0,  1024,   370,     0,   673,
       0,     0,     0,   822,  1032,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   672,  1043,
     672,  1023,     0,     0,     0,  1064,     0,     0,     0,     0,
     674,     0,   672,     0,   672,  1095,     0,     0,     0,     0,
       0,     0,     0,  1100,  2216,     0,     0,  2217,     0,     0,
    1947,  1791,     0,     0,     0,     0,     0,  1792,     0,     0,
       0,     0,     0,     0,  2218,     0,   371,     0,     0,     0,
       0,   371,  2220,   371,     0,     0,     0,     0,  2221,     0,
       0,     0,  1828,   672,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1793,     0,     0,
       0,     0,  2222,     0,     0,     0,     0,     0,     0,   674,
       0,   674,     0,   672,     0,   674,     0,     0,     0,     0,
     674,     4,     0,   674,     0,  2422,     0,     0,  1829,     0,
     672,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     5,     0,     0,     0,     0,  1794,   672,  4948,     0,
     672,     6,     7,  1795,     0,     0,  1796,   371,     0,     9,
      10,   370,     0,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,     0,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,     0,
       0,     0,    45,     0,  2223,     0,  4979,  1830,  2224,     0,
    1797,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     674,   674,     0,     0,  1947,   822,     0,   674,     0,  2225,
    2226,     0,     0,     0,     0,     0,     0,     0,  4057,     0,
       0,  4058,     0,     0,  5010,     0,  2227,     0,     0,     0,
      46,     0,     0,     0,     0,  1831,     0,  1832,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1833,     0,  1799,
       0,     0,  2228,     0,     0,  2229,     0,     0,     0,  1800,
       0,     0,     0,     0,     0,     0,     0,  1801,  2230,  4085,
       0,  2231,     0,     0,     0,     0,  1834,  1802,     0,     0,
       0,     0,     0,     0,     0,     0,   674,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,     0,     0,     0,   673,     0,     0,     0,
    3282,     0,     0,  1804,  1805,  1836,     0,     0,    48,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    49,  3283,
       0,     0,     0,     0,     0,     0,  2232,     0,     0,     0,
    1838,  2216,     0,     0,  2217,     0,     0,     0,     0,     0,
      50,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     673,  2218,     0,  3019,  3019,  3019,     0,     0,     0,  2220,
       0,     0,     0,     0,     0,  2221,     0,     0,     0,     0,
       0,     0,     0,     0,   672,     0,    51,  1807,     0,    52,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2222,
       0,     0,     0,     0,    53,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   718,     0,
     822,     0,     0,     0,     0,   822,     0,   822,     0,  2233,
    2234,  2235,     0,  2236,  2237,  2238,  2239,  2240,  2241,     0,
       0,     0,     0,  4789,     0,   370,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2422,     0,     0,
    3111,     0,  3111,   672,     0,   672,     0,  2422,     0,   672,
       0,     0,     0,     0,   672,     0,     0,   672,     0,     0,
      54,     0,     0,     0,     0,  5183,     0,     0,     0,     0,
       0,     0,   371,     0,   370,     0,     0,     0,     0,     0,
       0,  2223,   370,     0,     0,  2224,  4274,  4275,  4276,  4277,
       0,   822,     0,   674,     0,     0,     0,  1947,     0,     0,
       0,     0,    55,     0,     0,   674,  2225,  2226,     0,     0,
       0,     0,     0,     0,     0,     0,    56,     0,     0,     0,
       0,     0,     0,  2227,     0,     0,     0,   674,     0,     0,
       0,    57,     0,     0,     0,     0,     0,  2422,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2228,
       0,     0,  2229,     0,   672,   672,     0,     0,     0,    58,
       0,   672,     0,     0,     0,  2230,    59,   674,  2231,     0,
      60,    61,    62,    63,    64,     0,     0,    65,    66,  1391,
       0,     0,     0,     0,    71,  1392,   371,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1947,     0,  1947,     0,
       0,     0,     0,     0,     0,     0,  1192,  1198,  1198,   718,
       0,  1198,     0,  1206,     0,  1192,     0,  1095,     0,     0,
    1231,     0,     0,     0,     0,  1095,     0,     0,  1095,     0,
       0,     0,  1198,     0,  1095,     0,     0,     0,     0,     0,
     672,     0,  1261,  2232,     0,     0,     0,  1095,     0,  1192,
       0,     0,  1198,     0,   718,     0,  1198,     0,     0,  1947,
    4427,     0,     0,  1231,     0,     0,  1318,     0,     0,     0,
       0,     0,     0,  1198,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1947,     0,     0,     0,     0,     0,
       0,     0,   674,  2216,     0,     0,  2217,     0,     0,     0,
       0,     0,     0,     0,     0,  3111,  1192,     0,     0,     0,
       0,   718,     0,  2218,     0,     0,  1192,     0,  3111,     0,
    1231,  2220,     0,     0,     0,     0,     0,  2221,     0,     0,
       0,     0,     0,     0,     0,  1198,  2233,  2234,  2235,     0,
    2236,  2237,  2238,  2239,  2240,  2241,     0,     0,     0,     0,
    4798,  2222,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2216,     0,     0,  2217,     0,     0,
       0,     0,  1947,     0,     0,     0,     0,     0,     0,     0,
    1095,     0,   674,     0,   674,     0,     0,  2216,  3111,     0,
    2217,     0,  2220,  1095,  1466,     0,     0,     0,  2221,     0,
       0,  1947,     0,     0,     0,     0,     0,  2218,     0,     0,
       0,     0,     0,     0,     0,  2220,     0,     0,     0,     0,
    1576,  2221,  2222,     0,   718,  1095,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2223,  1095,  2222,   822,  2224,  1095,     0,
       0,     0,     0,     0,     0,     0,  1576,     0,     0,     0,
     371,     0,   674,     0,     0,     0,  1095,   672,  2225,  2226,
       0,     0,     0,  1947,     0,     0,     0,     0,  1095,   672,
       0,     0,     0,     0,  4155,  2227,     0,     0,     0,     0,
       0,     0,     0,  1947,     0,     0,     0,     0,     0,     0,
       0,   672,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2228,     0,     0,  2229,     0,     0,     0,  1947,     0,
       0,     0,     0,     0, -2681,     0,     0,  2230,  2224,     0,
    2231,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   672,     0,     0,     0,     0,     0,  2223,     0,  2225,
    2226,  2224,     0,     0,  1947,     0,     0,     0,     0,     0,
    1095,     0,     0,     0,     0,     0, -2681,  1095,     0,  1198,
    1198,     0,  2225,  2226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2227,
       0,     0,     0,     0,     0,  2229,     0,     0,     0,  3019,
       0,     0,     0,     0,     0,  2232,     0,     0,  2230,     0,
       0,     0,     0,     0,  1192,  2228,     0,     0,  2229,     0,
       0,     0,     0,     0,   371,  1192,     0,     0,     0,  1231,
       0,  2230,     0,     0,  2231,     0,     0,     0,  4669,     0,
       0,     0,  1198,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4672,     0,     0,     0,     0,  1095,     0,     0,
       0,     0,     0,  1198,  1198,     0,   672,     0,     0,     0,
       0,  2422,     0,     0,     0,     0,     0,     0,     0,  1095,
    1095,  1095,     0,  1198,     0,  1192, -2681,     0,     0,  2005,
       0,     0,     0,     0,     0,     0,     0,     0,  2233,  2234,
    2235,     0,  2236,  2237,  2238,  2239,  2240,  2241,     0,  2232,
       0,     0,  4833,     0,     0,     0,  2216,     0,  1198,  2217,
    1198,  1198,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2220,     0,     0,     0,     0,     0,
    2221,  4740,     0,     0,  1576,     0,     0,     0,     0,     0,
    3111,     0,     0,     0,     0,     0,   672,     0,   672,     0,
       0,     0,     0,     0,  2222,     0,     0,     0,     0,     0,
       0,     0,     0,  2236,  2237,  2238,  2239,  2240,  2241,   674,
       0,     0,  2104,  2104,     0,     0,     0,  1095,     0,  1023,
       0,     0,  2233,  2234,  2235,     0,  2236,  2237,  2238,  2239,
    2240,  2241,     0,     0,     0,     0,  4893,     0,     0,     0,
       0,     0,  2139,     0,     0,  1095,  2216,     0,  2145,  2217,
       0,     0,     0,     0,     0,     0,  4156,     0,     0,     0,
    1576,     0,     0,     0,   822,     0,   672,     0,     0,     0,
       0,     0,     0,   674,  2220,     0,     0,     0,     0,     0,
    2221,     0,  2216,     0,     0,  2217,     0,     0,     0,  1576,
       0,     0,     0,     0,     0,     0, -2681,     0,     0,     0,
    2224,     0,  2218,     0,  2222,     0,     0,     0,     0,     0,
    2220,     0,     0,     0,     0,     0,  2221,  1576,  1576,     0,
    1576,  2225,  2226,     0,     0,  4838,  4840,  4840,     0,     0,
       0,     0,  1947,     0,     0,     0,     0,     0, -2681,  1576,
    2222,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   371,     0,
     718,   718,     0,     0,     0,     0,  4159,  2229,     0,  2422,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2230,     0,     0,     0,   887,     0,     0,     0,     0,  1095,
       0,     0,  1576,     0,     0,     0,   888,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2681,   371,     0,     0,
    2224,     0,     0,     0,     0,   371,     0,   889,     0,     0,
       0,  1576,     0,     0,     0,  1576,  1576,     0,   822,     0,
     890,  2225,  2226,     0,     0,     0,  1095,  1095,  2358,   891,
       0,     0,  2223,  -745,     0,     0,  2224,     0, -2681,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2681,     0,
     892,     0,     0,     0,   718,  4934,   893,  2225,  2226,     0,
       0,     0,     0,     0,     0,     0,     0,  2229,     0,     0,
       0,   894,  1947,     0,  2227,     0,     0,     0,     0,     0,
    2230,     0,   895,  1947,     0,     0,     0,     0,     0,     0,
     896,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2228,     0,   897,  2229,     0,     0,     0,     0,     0,   898,
       0,     0,     0,   899,     0,     0,  2230,     0,     0,  2231,
       0,     0,     0,     0,     0,     0,     0,     0,  -947,     0,
       0,     0,  3019,     0,     0,     0,     0,  3019,     0,  4983,
       0,     0,  3019,     0,     0,  2236,  2237,  2238,  2239,  2240,
    2241,     0,  1095,  2521,     0,     0,     0,     0, -2681,  1095,
       0,     0,  1198,     0,     0,     0,  5006,   900,  5008,     0,
       0,     0,     0,     0,  -512,     0,     0,     0,     0,     0,
    1231,     0,     0,   672,     0,     0,  1095,     0,     0,  1095,
       0,     0,     0,     0,  2232,     0,     0,     0,     0,     0,
       0,     0,     0,  1947,     0,   901,  2216,     0,   902,  2217,
       0,  1095,     0,     0,     0,     0,     0,     0,     0,     0,
    1198,  1198,  1198,  1198,  1095,     0,  2218,     0,     0,  1947,
       0,     0,     0,     0,  2220,     0,     0,     0,  1095,     0,
    2221,     0,     0,  -409,     0,     0,  1947,   672,     0,     0,
    2635,     0,  1095,     0,     0,  2236,  2237,  2238,  2239,  2240,
    2241,   903,  1198,  1198,  2222,     0,     0,   904,  1198,     0,
       0,     0,     0,  -409,     0,     0,   905,     0,     0,     0,
    4840,     0,     0,     0,     0,     0,     0,  2233,  2234,  2235,
       0,  2236,  2237,  2238,  2239,  2240,  2241,     0,     0,     0,
    1947,  5115,  -409,     0,   906,   907,     0,   908,   909,     0,
       0,     0,     0,  1198,     0,     0,   910,     0,     0,     0,
       0,   911,     0,     0,     0,     0,     0,   912,     0,     0,
     913,     0,   822,   914,     0,  5112,     0,     0,     0,     0,
    1198,  1198,  1198,  1198,     0,     0,  -409,     0,     0,     0,
       0,     0,  1095,     0,     0,     0,     0,     0,  1095,     0,
       0,  2635,     0,     0,     0,     0,  2223,     0,     0,     0,
    2224,     0,     0,     0,     0,     0,  1192,     0,     0,     0,
       0,   822,     0,   718,     0,  1192,     0,     0,     0,   822,
       0,  2225,  2226,     0,     0,  1231,     0,  5150,     0,     0,
    1198,     0,     0,     0,     0,     0,     0,     0,  2227,  1198,
       0,     0,     0,     0,     0,  1198,  1198,     0,  4761,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1095,
       0,     0,     0,     0,  2228,     0,     0,  2229,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  5188,     0,
    2230,     0,     0,  2231,  2216,     0,  1947,  2217,     0,     0,
       0,     0,     0,  2104,     0,     0,     0,     0,     0,     0,
    1198,     0,  1192,     0,  2218,     0,  1095,  1095,     0,  1198,
       0,     0,  2220,     0,     0,  1095,     0,     0,  2221,     0,
       0,     0,     0,     0,     0,  1095,     0,     0,     0,     0,
       0,     0,  1023,  1023,     0,     0,  2855,     0,     0,     0,
    1576,  1576,  2222,     0,     0,     0,     0,     0,  1576,     0,
       0,  1576,     0,     0,     0,  1576,     0,     0,  2232,     0,
       0,     0,     0,  1576,  1576,     0,     0,     0,     0,     0,
       0,  1576,     0,  1231,  1576,  1576,  1576,  1576,     0,     0,
       0,     0,     0,     0,  1576,  1576,     0,  1576,     0,  1576,
    1576,     0,     0,  1576,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3111,     0,     0,     0,
    1576,     0,     0,     0,  1198,  1576,     0,     0,     0,  1576,
       0,     0,     0,  1576,     0,  1576,  1576,  1576,  1576,  1576,
    1576,  1576,  1576,  1576,     0,  1576,     0,     0,     0,     0,
       0,     0,  1095,     0,  2223,  1576,  1576,     0,  2224,     0,
       0,  2233,  2234,  2235,     0,  2236,  2237,  2238,  2239,  2240,
    2241,     0,     0, -2188,     0,  5208,     0,  1095,     0,  2225,
    2226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2227,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1095,     0,  1095,     0,  1576,     0,
   -2188,     0,  2228,     0,     0,  2229,     0,     0,     0,     0,
       0,  3111, -2188,     0,     0,     0,     0, -2188,  2230,     0,
       0,  2231, -2188,     0,     0,     0,     0, -2188,     0,     0,
   -2188,     0, -2188,  1095,  1947,     0,  3565,     0,     0,  3072,
    2216,  3079,     0,  2217,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -2188,
    2218,     0,     0,  3550,     0,     0,     0,     0,  2220,     0,
    1947,     0,     0,     0,  2221,     0,     0,     0,     0,     0,
       0, -2188,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2232,     0,  2222,     0,
       0,     0,     0,     0,     0,     0,  1947,     0,     0,     0,
    1947,  1947,     0,     0,     0,     0,     0,   718, -2188,     0,
       0,     0,  1023,     0,  1023,     0, -2188,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1576,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1192,     0,  1198,  1198,  1198,     0,     0,  1192,
       0,  1231,     0,  1198,     0,  1198,     0,  1198,  1198,     0,
       0,  1095,     0,     0, -2188,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2233,
    2234,  2235,  4761,  2236,  2237,  2238,  2239,  2240,  2241,  2521,
    2223,     0,     0,     0,  2224,     0,  3212,     0,     0,     0,
       0,  3221,     0,     0,     0,     0,     0,  1095,     0,  1027,
       0,     0,     0,     0,     0,  2225,  2226,     0,     0,     0,
       0,     0,     0,  1095,     0,     0,     0,  3261,  3261,     0,
       0,     0,  2227, -2188,   718,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1198,     0,     0,     0,     0,     0, -2188,  2228, -2188,
   -2188,  2229,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2230,     0,     0,  2231,     0,     0,
       0,  3326,     0,  3329,  3331,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2188,     0,     0, -2188, -2188,     0,
   -2188,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1198,     0,     0,     0,     0,     0,     0,     0,  1198,
       0,     0,     0,     0,  1198,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1576,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2232,     0,     0,     0,     0,     0,     0,     0,
       0,  2521,     0,     0,  3261,     0,  1095,     0,  3424,     0,
       0,  1023,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3326,     0,     0,
       0,     0,     0,     0,  1213,  1198,  3449,     0,     0,     0,
       0,     0,  1237,     0,     0,     0,     0,     0,  2005,     0,
       0,  1249,     0,     0,     0,     0,     0,     0,     0,  1259,
       0,     0,     0,     0,  1292,  1198,     0,  1198,  3261,  1198,
    3261,     0,     0,     0,     0,  2233,  2234,  2235,     4,  2236,
    2237,  2238,  2239,  2240,  2241,     0,     0,     0,     0,     0,
       0,     0,  1576,     0,     0,     0,     0,     0,     5,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     6,     7,
       0,     0,     0,  2104,     8,     0,     9,    10,     0,     0,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,     0,    36,     0,    37,    38,
      39,    40,    41,    42,    43,    44,     0,     0,  1192,    45,
       0,     0,     0,     0,  1192,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1198,     0,     0,     0,     0,
    2216,  1576,  1576,  2217,     0,     0,     0,  1576,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2218,     0,     0,     0,     0,     0,     0,    46,  2220,     0,
       0,     0,  1576,  1576,  2221,     0,     0,  1576,     0,     0,
    1465,  2216,     0,     0,  2217,     0,     0,     0,     0,  1576,
    1576,  1576,  1576,     0,     0,     0,     0,     0,  2222,     0,
       0,  2218,  1576,     0,  3595,  1576,     0,  1576,  3615,  2220,
       0,     0,  1594,     0,     0,  2221,     0,  1576,  1576,     0,
       0,  1576,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1618,     0,     0,  1576,     0,  1576,    47,  1231,  2222,
    1576,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1644,     0,    48,     0,     0,     0,  1576,
       0,     0,     0,  1095,     0,     0,     0,     0,     0,  3668,
       0,     0,  1576,  1576,  1576,    49,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2216,     0,
       0,  2217,     0,     0,     0,     0,  1576,    50,     0,     0,
    2223,     0,     0,     0,  2224,     0,     0,     0,     0,  1576,
       0,     0,     0,     0,  1576,     0,  2220,     0,     0,     0,
    1576,     0,  2221,     0,     0,  2225,  2226,     0,  3668,     0,
       0,  3725,     0,    51,     0,  3079,    52,     0,     0,     0,
       0,  2223,  2227,     0,     0,  2224,  2222,     0,     0,     0,
       0,    53,     0,     0,  1813,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2225,  2226,  2228,     0,
       0,  2229,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2227,  2230,     0,     0,  2231,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1576,
       0,  3261,     0,     0,     0,     0,  2104,  4132,  4549,  2228,
       0,     0,  2229,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2230,     0,    54,  2231,     0,
       0,     0,  1198,     0,  1198,  1198,  1198,     0,     0,     0,
       0,     0,     0,     0,  1963,     0,     0,     0, -2681,     0,
       0,     0,  2224,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2232,     0,     0,     0,  1991,  1994,  1995,    55,
       0,     0,     0,  2225,  2226,     0,  4133,     0,     0,     0,
       0,     0,     0,    56,     0,     0,     0,     0,     0,     0,
   -2681,     0,     0,     0,     0,     0,     0,     0,    57,     0,
       0,     0,     0,  2232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2229,
       0,     0,     0,     0,     0,     0,    58,     0,     0,     0,
       0,     0,  2230,    59,     0,     0,     0,    60,    61,    62,
      63,    64,     0,     0,    65,    66,    67,    68,     0,    69,
      70,    71,    72,    73,     0,  2233,  2234,  2235,     0,  2236,
    2237,  2238,  2239,  2240,  2241,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1594,   830,     0,  2216,     0,     0,
    2217,     0,     0,     0,     0,     0,  2233,  2234,  2235,     0,
    2236,  2237,  2238,  2239,  2240,  2241,     0,  2218,     0,     0,
   -2681,     0,  1594,     0,     0,  2220,     0,  3261,  3261,     0,
       0,  2221,     0,     0,     0,     0,     0,     0,     0,     0,
     830,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3943,     0,     0,     0,     0,  2222,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1095,  1095,     0,
       0,     0,     0,     0,     0,     0,  1055,     0,     0,     0,
       0,     0,     0,  1095,  1055,     0,  1055,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2104,  1095,   830,     0,
       0,     0,     0,     0,     0,  2104,  1095,  2236,  2237,  2238,
    2239,  2240,  2241,     0,     0,     0,     0,     0,     0,     0,
    1095,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3600,     0,     0,     0,   718,     0,  2216,     0,     0,
    2217,     0,     0,     0,     0,     0,     0,  2223,     0,     0,
    1198,  2224,     0,  1198,     0,     0,  2302,  2218,     0,     0,
    3606,     0,     0,     0,     0,  2220,     0,     0,     0,     0,
    1192,  2221,  2225,  2226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2227,
       0,  1095,     0,     0,     0,  2222,     0,     0,     0,     0,
       0,  1198,     0,     0,  2356,     0,     0,     0,     0,  1576,
       0,     0,     0,     0,     0,  2228,     0,     0,  2229,  1576,
       0,     0,     0,     0,     0,  1576,     0,  1576,     0,     0,
       0,  2230,     0,  1576,  2231,     0,  1576,  1576,  1576,  1576,
    1576,  1576,  1576,  1576,  1576,  1576,     0,     0,     0,  1576,
    1576,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1576,     0,     0,     0,  1576,     0,     0,     0,
    1576,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1576,     0,     0,  1576,     0,  1576,     0,     0,     0,     0,
       0,     0,     0,     0,  1576,  1576,  1576,  2223,     0,     0,
    1576,  2224,     0,  1576,     0,     0,     0,  4165,     0,  2232,
       0,     0,     0,     0,  1095,  1095,  1095,  1192,     0,  3668,
    4182,     0,  2225,  2226,  4182,  4196,     0,     0,     0,  2516,
       0,  1576,     0,     0,     0,     0,  2534,  1576,  1576,  2227,
       0,  2216,     0,     0,  2217,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2218,     0,  2567,  4139,  2228,  2570,     0,  2229,  2220,
       0,     0,     0,     0,     0,  2221,     0,     0,     0,     0,
       0,  2230,  1576,     0,  2231,     0,     0,     0,  1576,     0,
       0,     0,  3079,     0,  1576,     0,     0,     0,     0,  2222,
       0,  2608,  2233,  2234,  2235,     0,  2236,  2237,  2238,  2239,
    2240,  2241,     0,     0,     0,  2624,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4257,  2104,  2104,  2636,
    2635,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1198,  1198,
    1198,  1198,     0,  2216,     0,     0,  2217,     0,     0,  2232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2218,     0,     0,     0,     0,     0,     0,
       0,  2220,     0,  4298,     0,     0,     0,  2221,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2223,     0,     0,     0,  2224,     0,     0,     0,     0,
       0,  2222,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2225,  2226,     0,  2728,
       0,     0,     0,     0,     0,  2738,     0,     0,     0,     0,
       0,     0,     0,  2227,     0,     0,     0,     0,     0,     0,
       0,     0,  2233,  2234,  2235,     0,  2236,  2237,  2238,  2239,
    2240,  2241,     0,     0,  4368,     0,     0,     0,     0,  2228,
       0,     0,  2229,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2230,     0,     0,  2231,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3943,     0,     0,  2793,     0,     0,     0,
       0,  1095,     0,  2223,     0,     0,     0,  2224,     0,     0,
       0,     0,  1198,     0,  1576,     0,     0,     0,     0,     0,
    1095,     0,     0,     0,     0,     0,  4440,     0,  2225,  2226,
       0,     0,     0,     0,     0,  2521,     0,     0,     0,     0,
       0,     0,     0,  1594,  1594,  2227,     0,  1095,     0,     0,
       0,     0,     0,  2232,     0,     0,     0,  3326,     0,     0,
       0,     0,  2848,  4469,     0,     0,     0,     0,     0,     0,
       0,  2228,     0,     0,  2229,     0,     0,     0,     0,  1576,
    1576,     0,     0,     0,     0,     0,     0,  2230,     0,     0,
    2231,     0,     0,     0,   830,     0,     0,     0,     0,     0,
       0,     0,  1194,     0,  3261,     0,  3261,     0,     0,     0,
       0,  1194,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2216,
       0,     0,  2217,     0,     0,     0,     0,     0,     0,     0,
       0,  1576,     0,     0,     0,  1194,  2233,  2234,  2235,  2218,
    2236,  2237,  2238,  2239,  2240,  2241,     0,  2220,     0,     0,
       0,     0,     0,  2221,     0,  2232,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1576,  3006,
       0,     0,     0,     0,     0,     0,     0,  2222,  1576,  1576,
       0,  4089,     0,     0,     0,     0,  1576,  1576,     0,     0,
       0,  1576,  1194,     0,  3026,     0,     0,  1576,  1576,     0,
       0,  1576,  1194,     0,  1576,  4555,     0,     0,  1095,  1095,
    1095,  1095,     0,     0,     0,  4182,  4196,     0,  4182,     0,
       0,  4564,     0,     0,     0,  3668,     0,     0,     0,  3668,
       0,  3039,     0,  3042,     0,  4577,     0,     0,     0,     0,
       0,  1576,     0,     0,     0,     0,  1576,     0,  2233,  2234,
    2235,  1576,  2236,  2237,  2238,  2239,  2240,  2241,     0,     0,
    1231,     0,     0,     0,  1262,     0,     0,     0,  3725,     0,
    1594,     0,  3079,     0,     0,     0,     0,     0,     0,  2223,
       0,     0,     0,  2224,     0,     0,     0,     0,     0,     0,
       0,  1023,     0,     0,  1576,     0,     0,  1263,     0,     0,
       0,     0,     0,     0,  2225,  2226,     0,     0,     0,     0,
    1264,  1265,     0,     0,  3261,  3261,  1194,     0,     0,  1266,
       0,  2227,  1055,  1267,     0,     0,  1055,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4639,     0,     0,     0,
    1268,     0,     0,     0,     0,     0,     0,  2228,     0,     0,
    2229,     0,  1194,     0,     0,     0,     0,     0,     0,     0,
       0,  1269,     0,  2230,     0,     0,  2231,     0,     0,     0,
       0,     0,  1270,     0,     0,     0,     0,     0,     0,     0,
    1271,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1198,     0,  1272,     0,     0,     0,     0,  1273,     0,     0,
       0,     0,     0,     0,  1198,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2232,     0,  1275,  3943,  3943,  3943,  3943,  3943,     0,
       0,     0,     0,     0,  3230,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1276,     0,     0,     0,  1576,     0,
    3256,     0,     0,     0,     0,     0,     0,     0,     0,  1192,
       0,     0,     0,     0,  2521,     0,     0,  1055,     0,     0,
       0,  2104,     0,     0,     0,  1277,     0,     0,     0,     0,
       0,     0,     0,  1198,  2521,  1945,     0,     0,     0,     0,
    1194,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1194,     0,     0,   859,     0,     0,     0,     0,     0,
    1095,     0,  4767,     0,  2233,  2234,  2235,     0,  2236,  2237,
    2238,  2239,  2240,  2241,  1948,     0,     0,     0,     0,     0,
       0,  1278,     0,     0,     0,  1279,   844,  1280,     0,     0,
       0,  1576,     0,  1281,     0,     0,  1282,     0,     0,     0,
    1576,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1194,     0,     0,     0,     0,     0,  1576,  1576,     0,
       0,  1576,  1283,     0,  1284,     0,     0,     0,  1285,     0,
       0,     0,   845,     0,  1192,  4182,  1286,     0,     0,  3668,
       0,  1287,     0,  3422,  3668,   846,     0,  3668,  3326,     0,
    4817,     0,  1576,  1576,     0,     0,     0,     0,     0,     0,
       0,     0,   847,     0,     0,     0,  1288,     0,   848,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1194,     0,     0,   849,     0,  4257,  1231,  1198,  1198,  1198,
       0,     0,     0,     0,   850,     0,     0,     0,  1945,     0,
       0,     0,   851,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   852,     0,     0,     0,     0,   853,
       0,     0,     0,  1192,  1231,   854,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1948,     0,     0,
     855,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   856,  1194,  2104,  2104,     0,
       0,     0,  1192,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1095,     0,     0,     0,   857,     0,     0,     0,
       0,     0,     0,  4440,     0,  1194,     0,     0,     0,     0,
    3261,     0,     0,     0,  2521,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4469,   858,     0,  1095,
       0,     0,     0,  1194,  1194,     0,  1194,  1198,  4257,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2284,  1194,   859,     0,     0,     0,
       0,     0,  1576,     0,     0,  1576,     0,  1576,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   860,     0,     0,     0,   861,     0,   862,
    1576,     0,     0,     0,  3668,   863,     0,  4817,   864,     0,
       0,     0,     0,  4975,     0,     0,     0,     0,  1194,   830,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1198,     0,   865,   866,  1095,   867,     0,     0,     0,
     868,     0,     0,     0,     0,     0,     0,  1194,   869,     0,
       0,  1194,  1194,   870,     0,     0,     0,  1198,  1198,  1198,
    1198,     0,     0,     0,     0,   871,     0,     0,     0,     0,
    3651,     0,  2104,     0,     0,     0,     0,     0,   872,     0,
       0,     0,     0,   944,     0,     0,     0,     0,     0,     0,
       0,  1945,  1192,     0,     0,   945,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1576,     0,     0,     0,     0,   946,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   947,
    1948,     0,     0,     0,     0,     0,   830,     0,     0,     0,
       0,     0,   948,  1055,     0,  1945,     0,     0,     0,  1576,
       0,     0,  1192,     0,     0,     0,     0,     0,     0,   949,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2201,  1198,     0,  1231,  1945,  1055,     0,     0,     0,
     950,     0,     0,  1576,  1948,     0,     0,     0,     0,     0,
       0,   951,     0,     0,     0,     0,     0,     0,     0,   952,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   953,     0,     0,  1948,     0,   954,     0, -2201,     0,
       0,     0,   955,     0,     0,     0,     0,  1198,     0,     0,
   -2201,     0,  1192,     0,     0, -2201,     0,   956,     0,     0,
   -2201,     0,     0,  4257,     0, -2201,     0,     0, -2201,     0,
   -2201,  1945,  4767,     0,     0,     0,     0,     0,     0,  1576,
    1576,     0,     0,     0,  3326,     0,     0,     0,  4975,     0,
    1945,  1055,     0,     0,     0,     0,  1937, -2201,     0,     0,
    1192,     0,     0,   957,     0,     0,     0,     0,  1945,  1198,
    1948,     0,     0,     0,     0,     0,     0,     0,     0, -2201,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1948,
       0,     0,     0,     0,   958,     0,  1945,     0,     0,     0,
       0,  1576,     0,     0,     0,   959,     0,  1948,     0,     0,
       0,     0,     0,     0,     0,  1576, -2201,     0,     0,     0,
    1198,     0,     0,   859, -2201,     0,     0,     0,     0,     0,
     830,     0,     0,     0,     0,  1948,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     960,     0,     0,     0,   961,     0,   962,     0,     0,  1945,
       0,     0,   963,     0,     0,   964,     0,     0,     0,     0,
       0,     0, -2201,     0,     0,     0,     0,     0,     0,  1576,
       0,     0,     0,     0,     0,     0,     0,     0,  1192,     0,
       0,   965,  1194,   966,     0,     0,     0,   967,  1948,     0,
       0,  1194,     0,     0,     0,   968,     0,     0,     0,     0,
     969,     0,     0,     0,     0,     0,     0,  1027,     0,  1937,
       0,     0,   970,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   971,     0,     0,     0,     0,
       0, -2201,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3980,  3981,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -2201,     0, -2201, -2201,     0,
    3990,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3999,     0,     0,     0,  1194,     0,
       0,     0,     0,  4008,     0,     0,     0,     0,     0,     0,
       0,     0, -2201,     0,     0, -2201, -2201,  4024, -2201,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1194,  1194,     0,     0,
       0,     0,     0,     0,  1194,     0,     0,  1194,     0,     0,
       0,  1194,     0,     0,     0,     0,     0,     0,     0,  1194,
    1194,     0,     0,     0,     0,     0,  1945,  1194,     0,     0,
    1194,  1194,  1194,  1194,     0,     0,     0,     0,     0,     0,
    1194,  1194,     0,  1194,     0,  1194,  1194,     0,  1594,  1194,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1948,  1194,   830,     0,     0,
       0,  1194,     0,     0,     0,  1194,     4,     0,     0,  1194,
       0,  1194,  1194,  1194,  1194,  1194,  1194,  1194,  1194,  1194,
       0,  1194,     0,     0,     0,     0,     5,     0,     0,     0,
       0,  1194,  1194,     0,     0,     0,     6,     7,     0,     0,
       0,     0,     0,     0,     9,    10,     0,     0,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,     0,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,     0,     0,     0,    45,     0,     0,
       0,     0,  1937,     0,  1194,     0,     0,     0,     0,     0,
       0,  4170,  4171,  4172,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1937,     0,     0,     0,
       0,  1945,     0,     0,     0,  1945,  1945,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1937,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1948,     0,     0,     0,  1948,  1948,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,     0,     0,   830,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    48,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1194,     0,     0,
       0,     0,     0,    49,     0,     0,     0,     0,  1194,     0,
       0,     0,  1937,     0,     0,  1194,     0,     0,     0,     0,
    1945,     0,     0,     0,     0,    50,     0,     0,     0,     0,
       0,  1937,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1055,     0,     0,  1937,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1948,
       0,    51,     0,     0,    52,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   830,  1937,     0,    53,
     830,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1937,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    54,     0,     0,  4409,     0,
       0,     0,     0,     0,     0,     0,  1945,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4435,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    55,     0,     0,
       0,     0,     0,  1194,  4452,  1948,     0,     0,     0,     0,
       0,    56,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   830,     0,     0,     0,    57,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1945,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    58,     0,     0,     0,     0,     0,
       0,    59,     0,     0,     0,    60,    61,    62,    63,    64,
       0,     0,    65,    66,  1391,  2056,     0,     0,     0,    71,
    1948,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1194,     0,
       0,     0,     0,     0,     0,     0,     0,  1937,     0,     0,
    1945,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4556,  4557,  4558,  4559,  1948,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1194,     0,     0,     0,     0,     0,
    1194,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1194,  1194,     0,
       0,     0,     0,  1194,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1194,  1194,
       0,     0,     0,  1194,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1194,  1194,  1194,  1194,     0,
       0,     0,     0,   830,     0,     0,     0,     0,  1194,   830,
       0,  1194,     0,  1194,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1194,  1194,  1053,     0,  1194,     0,     0,
       0,     0,     0,  1053,     0,  1053,     0,     0,     0,     0,
    1194,     0,  1194,     0,     0,     0,  1194,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1937,     0,     0,  1194,  1937,  1937,     0,     0,
       0,     0,     0,     0,     0,  1194,     0,     0,  1194,  1194,
    1194,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1194,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1194,     0,     0,     0,     0,
    1194,     0,     0,     0,     0,     0,  1194,     0,     0,     0,
       0,     0,     0,  1945,  1194,     0,  1945,     0,  1945,     0,
       0,     0,     0,  1945,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1937,  1948,     0,     0,  1948,     0,  1948,     0,     0,
       0,     0,  1948,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1945,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1194,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4763,     0,     0,
       0,     0,  1948,  1945,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1948,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1945,     0,  1945,     0,     0,     0,     0,   830,
     830,   830,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1937,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1948,     0,  1948,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1945,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1945,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1937,     0,  1948,     0,     0,     0,     0,     0,
       0,  1945,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1945,     0,     0,     0,     0,  1948,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1948,     0,     0,     0,     0,     0,     0,     0,     0,  4891,
       0,     0,   830,  1948,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1945,     0,
       0,     0,     0,     0,     0,     0,  1594,     0,     0,     0,
       0,  1937,     0,     0,  1945,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1945,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1948,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1948,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1948,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1194,     0,     0,  1945,
       0,     0,  4986,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1945,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1194,     0,     0,  1948,     0,
       0,     0,     0,     0,  1945,  1194,     0,     0,     0,     0,
       0,  1194,     0,  1194,     0,     0,     0,     0,  1948,  1194,
       0,     0,  1194,  1194,  1194,  1194,  1194,  1194,  1194,  1194,
    1194,  1194,     0,     0,     0,  1194,  1194,     0,     0,     0,
    1945,  1190,     0,  1948,     0,     0,     0,     0,  1194,     0,
    1190,     0,  1194,     0,   830,     0,  1194,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1194,     0,     0,  1194,
       0,  1194,     0,     0,     0,     0,     0,     0,     0,  1948,
    1194,  1194,  1194,     0,  1190,     0,  1194,     0,     0,  1194,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1194,     0,  1194,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1194,     0,     0,
       0,     0,     0,  1194,  1194,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1937,     0,     0,  1937,     0,  1937,
       0,  1190,     0,     0,  1937,     0,     0,     0,     0,     0,
       0,  1190,     0,     0,     0,     0,     0,  1945,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1194,     0,
       0,     0,     0,     0,  1194,     0,     0,     0,     0,     0,
    1194,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1937,     0,  1948,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1194,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1937,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1945,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1190,     0,     0,     0,     0,
       0,  1053,     0,     0,     0,  1053,     0,     0,     0,   830,
       0,     0,     0,     0,   830,  1948,   830,     0,     0,     0,
       0,     0,     0,  1937,     0,  1937,     0,     0,     0,     0,
       0,  1190,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1937,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     830,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1937,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1945,     0,
       0,     0,  1937,     0,     0,     0,     0,     0,     0,     0,
    1194,     0,     0,     0,     0,  1937,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1945,  1053,  1948,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1190,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1190,     0,     0,     0,  1948,  1194,  1194,     0,     0,  1937,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1946,     0,  1937,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1937,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1190,     0,     0,     0,     0,     0,     0,  1194,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1945,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1945,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1194,     0,     0,     0,     0,     0,
    1937,     0,     0,     0,  1194,  1194,     0,  1948,     0,     0,
       0,     0,  1194,  1194,     0,     0,     0,  1194,  1948,  1190,
    1937,     0,     0,  1194,  1194,     0,     0,  1194,     0,     0,
    1194,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1937,     0,     0,     0,     0,
       0,  1194,     0,     0,     0,  1194,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1194,     0,     0,
       0,     0,  1194,     0,     0,     0,  1946,  1194,     0,     0,
       0,  1937,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1945,
       0,     0,     0,     0,     0,  1190,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1194,     0,     0,     0,     0,  1945,     0,     0,     0,     0,
       0,     0,     0,     0,  1190,     0,     0,     0,  1948,     0,
       0,     0,  1945,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   830,     0,     0,     0,     0,
       0,     0,  1190,  1190,  1948,  1190,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1948,     0,     0,  1190,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1945,     0,  1937,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1948,     0,  1190,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1190,     0,     0,     0,
    1190,  1190,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1937,     0,     0,
       0,     0,     0,     0,  1194,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1194,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1946,
       0,     0,  1945,  1948,     0,     0,     0,     0,     0,     0,
       0,     0,  1053,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1194,     0,     0,
       0,  1948,     0,     0,     0,  1053,  1194,     0,     0,     0,
       0,     0,     0,  1946,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1194,  1194,     0,     0,  1194,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1194,     0,     0,  1946,     0,  1194,     0,     0,     0,  1937,
    1194,     0,     0,  1194,     0,     0,     0,     0,  1194,  1194,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1945,     0,     0,     0,  1937,     0,     0,     0,
       0,  1194,     0,     0,     0,     0,     0,     0,     0,     0,
    1053,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1946,
       0,  1948,     0,     0,     0,     0,  1939,     0,     0,  1194,
       0,     0,     0,     0,     0,     0,     0,     0,  1946,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1946,     0,     0,     0,
       0,     0,     0,   830,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1194,     0,
       0,     0,     0,     0,  1946,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1945,     0,  1937,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1937,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1945,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1194,     0,  1948,     0,     0,     0,
       0,  1190,     0,     0,     0,     0,     0,  1946,     0,     0,
    1190,     0,     0,     0,     0,     0,  1945,     0,  1194,  1948,
       0,  1194,     0,  1194,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1194,     0,     0,  1939,
    1194,     0,  1945,     0,     0,  1948,  1945,  1945,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   830,     0,     0,
    1937,  1948,     0,     0,     0,  1948,  1948,  1190,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1937,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1937,     0,  1190,  1190,     0,  1194,     0,
       0,     0,     0,  1190,     0,     0,  1190,     0,     0,     0,
    1190,     0,     0,     0,     0,     0,     0,  1194,  1190,  1190,
       0,     0,     0,     0,     0,     0,  1190,     0,     0,  1190,
    1190,  1190,  1190,     0,     0,     0,     0,  1948,     0,  1190,
    1190,     0,  1190,     0,  1190,  1190,     0,  1937,  1190,     0,
       0,     0,     0,     0,     0,  1194,     0,     0,  1194,     0,
       0,     0,     0,     0,  1946,  1190,     0,     0,     0,     0,
    1190,     0,     0,     0,  1190,     0,     0,     0,  1190,     0,
    1190,  1190,  1190,  1190,  1190,  1190,  1190,  1190,  1190,  1194,
    1190,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1190,  1190,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1194,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1194,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1190,     0,  1194,  1194,  1940,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1939,     0,     0,     0,  1194,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1937,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1194,     0,     0,
       0,     0,     0,     0,     0,     0,  1939,     0,     0,     0,
       0,  1194,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1946,
       0,   830,     0,  1946,  1946,     0,  1939,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1194,  1190,     0,     0,     0,
     830,     0,     0,     0,  1194,     0,     0,  1190,   830,     0,
       0,     0,     0,  1937,  1190,     0,     0,     0,     0,     0,
    1940,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1939,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1053,     0,     0,     0,     0,
       0,  1939,     0,     0,     0,     0,     0,     0,  1946,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1939,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1939,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1937,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1937,     0,     0,     0,     0,     0,     0,     0,     0,
    1939,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1937,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1190,     0,  1946,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1937,     0,     0,     0,  1937,  1937,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   930,     0,     0,
       0,     0,     0,     0,     0,     0,   930,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1946,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1940,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   930,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1190,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1109,
       0,     0,     0,     0,     0,     0,     0,  1940,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1939,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1940,  1946,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1190,     0,     0,     0,     0,     0,  1190,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1190,  1190,     0,     0,
       0,     0,  1190,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1190,  1190,     0,
       0,     0,  1190,  1940,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1190,  1190,  1190,  1190,     0,     0,
       0,     0,  1940,     0,     0,     0,     0,  1190,     0,     0,
    1190,     0,  1190,     0,     0,     0,     0,     0,     0,     0,
    1940,     0,  1190,  1190,     0,     0,  1190,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1190,
       0,  1190,     0,     0,     0,  1190,     0,     0,  1940,     0,
    1158,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1190,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1190,     0,     0,  1190,  1190,  1190,
       0,     0,  1939,     0,     0,     0,  1939,  1939,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1190,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1940,     0,     0,  1190,     0,     0,     0,     0,  1190,
       0,     0,     0,     0,     0,  1190,     0,     0,     0,     0,
       0,     0,     0,  1190,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1946,     0,     0,  1946,     0,  1946,     0,     0,     0,
       0,  1946,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1939,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1190,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,     0,     0,     0,   722,     0,
     722,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     722,  1946,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   722,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   722,     0,     0,     0,
       0,  1946,     0,     0,     0,     0,     0,   722,   722,     0,
       0,   722,     0,     0,     0,     0,     0,   722,     0,     0,
       0,  1015,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1940,     0,
       0,  1015,     0,     0,     0,   930,   930,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   722,     0,     0,     0,
    1946,     0,  1946,     0,     0,     0,     0,  1939,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1158,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1946,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1939,     0,     0,     0,     0,     0,  1946,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1946,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1946,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1942,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1205,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1234,  1235,     0,  1238,     0,     0,
    1242,     0,  1244,  1940,     0,     0,     0,  1940,  1940,     0,
       0,  1939,     0,     0,     0,     0,  1946,     0,     0,     0,
       0,  1295,     0,     0,     0,     0,     0,     0,     0,  1303,
       0,     0,  1946,     0,     0,     0,     0,     0,  1319,  1320,
       0,   722,     0,  1322,     0,  1946,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1158,     0,   930,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1190,     0,     0,  1353,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1376,     0,     0,  1378,     0,  1380,
       0,  1383,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1940,     0,  1190,   930,     0,  1946,     0,     0,
       0,     0,     0,     0,  1190,     0,     0,  1942,     0,     0,
    1190,     0,  1190,     0,     0,     0,     0,  1946,  1190,     0,
       0,  1190,  1190,  1190,  1190,  1190,  1190,  1190,  1190,  1190,
    1190,     0,     0,     0,  1190,  1190,     0,     0,     0,     0,
       0,     0,  1946,     0,     0,     0,     0,  1190,     0,     0,
    1463,  1190,  1464,     0,     0,  1190,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1190,     0,     0,  1190,     0,
    1190,     0,     0,     0,     0,     0,     0,     0,  1946,  1190,
    1190,  1190,     0,  1158,     0,  1190,     0,     0,  1190,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1190,     0,  1190,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1190,     0,     0,  1109,
       0,     0,  1190,  1190,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1940,     0,
     722,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1939,     0,     0,  1939,     0,  1939,
       0,     0,     0,     0,  1939,     0,     0,  1190,     0,     0,
       0,     0,     0,  1190,     0,     0,     0,     0,     0,  1190,
       0,     0,     0,     0,     0,     0,   722,   722,     0,     0,
    1725,     0,  1727,     0,     0,  1946,  1729,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1190,     0,  1940,  1939,     0,  1758,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   722,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1939,     0,     0,     0,     0,     0,
       0,     0,     0,  1880,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1893,
    1942,     0,     0,     0,  1946,     0,     0,     0,     0,     0,
       0,     0,  1903,     0,     0,     0,     0,     0,     0,  1905,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1954,  1940,  1939,  1958,  1939,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1942,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2001,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1942,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1939,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1939,     0,     0,     0,     0,     0,     0,     0,  1190,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1939,     0,     0,     0,     0,     0,     0,     0,
    1341,   722,     0,   722,     0,  1939,  1946,     0,     0,     0,
    1942,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1942,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1946,  1190,  1190,     0,  1942,     0,     0,
       0,     0,   722,     0,     0,   722,   722,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1939,
     678,     0,  1015,     0,  1015,  1942,     0,     0,     0,     0,
     678,     0,     0,     0,   722,  1939,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1939,     0,
       0,     0,     0,  1015,  1015,     0,  1190,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1942,     0,
       0,     0,     0,  1190,   722,  1940,   722,     0,  1940,     0,
    1940,     0,     0,  1190,  1190,  1940,  1946,     0,     0,     0,
       0,  1190,  1190,     0,     0,     0,  1190,  1946,     0,     0,
    1939,     0,  1190,  1190,     0,     0,  1190,     0,     0,  1190,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1939,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1190,     0,     0,     0,  1190,  1940,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1939,  1190,     0,     0,     0,
       0,  1190,  1109,  2319,   678,     0,  1190,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   678,   678,
       0,     0,  1707,     0,     0,  1940,     0,     0,     0,     0,
       0,  1939,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1190,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2389,     0,     0,  2389,     0,     0,     0,  1946,   678,     0,
       0,  2396,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1940,     0,  1940,     0,     0,  2405,
       0,     0,     0,  1946,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1946,     0,     0,     0,     0,  1942,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2488,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1940,  1939,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1946,     0,     0,     0,     0,     0,
       0,     0,  1940,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1940,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1940,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1190,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1190,     0,     0,  1939,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,     0,     0,     0,   722,
    1940,   722,     0,     0,   722,     0,   722,     0,     0,   722,
     722,   722,  1946,     0,     0,  2099,  1940,     0,     0,     0,
       0,     0,   722,     0,     0,     0,     0,     0,     0,  1940,
       0,     0,     0,     0,     0,   722,     0,   722,     0,     0,
    1942,     0,   722,     0,  1942,  1942,  1190,     0,     0,     0,
    1946,     0,     0,     0,  2687,  1190,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2710,
       0,     0,  1190,  1190,     0,     0,  1190,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1190,
       0,     0,     0,     0,  1190,     0,     0,     0,     0,  1190,
       0,  1940,  1190,     0,     0,     0,     0,  1190,  1190,     0,
       0,     0,     0,     0,     0,  2758,     0,     0,     0,  1939,
       0,  1940,     0,     0,     0,     0,     0,     0,     0,     0,
    2773,     0,  2775,     0,  2776,     0,     0,     0,     0,  2777,
    1190,     0,     0,     0,     0,     0,  1940,     0,     0,  1942,
       0,     0,     0,     0,     0,     0,  1939,     0,     0,     0,
       0,     0,     0,  2259,     0,     0,     0,     0,     0,     0,
    1946,     0,   722,   722,     0,     0,     0,     0,  1190,     0,
       0,     0,  1940,     0,     0,     0,     0,     0,  2805,   678,
       0,     0,     0,     0,   678,   678,     0,     0,     0,     0,
    2319,     0,     0,     0,  2319,     0,  2319,     0,     0,  2319,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1190,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1939,
       0,     0,     0,     0,     0,     0,   722,     0,   678,     0,
    1939,     0,     0,  1190,     0,  1946,     0,     0,  2393,     0,
       0,     0,     0,     0,     0,  1942,     0,     0,     0,  1940,
       0,     0,     0,     0,     0,     0,     0,  1190,  1946,     0,
    1190,     0,  1190,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1190,     0,     0,     0,  1190,
       0,     0,     0,     0,  1946,     0,     0,     0,     0,     0,
    3020,     0,   678,     0,     0,     0,     0,     0,     0,     0,
     678,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1942,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1946,     0,     0,     0,  1946,  1946,     0,     0,  1940,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1939,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,     0,   678,   678,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1939,  1190,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1939,     0,     0,  1190,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1946,     0,     0,  1942,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,  1190,     0,     0,  1190,     0,     0,
    1158,     0,     0,     0,     0,     0,     0,  1939,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1190,     0,
    3120,  3121,     0,     0,     0,  3124,  3125,     0,     0,  3128,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3138,
    1940,     0,     0,     0,     0,     0,  3147,     0,     0,     0,
    3150,  3151,     0,     0,  3154,  3155,     0,     0,     0,     0,
       0,  3160,     0,     0,     0,     0,     0,  1190,     0,     0,
       0,     0,     0,  3176,     0,  3178,     0,  1940,  1190,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3200,     0,     0,  1190,  1190,  3202,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1190,  3211,     0,  3213,  3214,
    3217,  3219,     0,     0,     0,  3226,  3229,     0,     0,     0,
       0,     0,     0,  3240,     0,     0,     0,  3249,     0,     0,
       0,  3253,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1939,     0,     0,  1190,     0,     0,     0,
       0,     0,  3281,   722,     0,   722,     0,     0,     0,   722,
    1190,   722,     0,  3288,   722,  3290,     0,     0,   722,     0,
    3293,     0,     0,  2259,     0,  3297,  3298,  3299,  3300,     0,
    1940,     0,     0,     0,  3309,     0,     0,     0,     0,     0,
       0,  1940,     0,     0,     0,     0,     0,  3333,  3334,  3335,
       0,     0,     0,     0,     0,     0,     0,     0,  3343,  3344,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1942,     0,  1190,  1942,     0,  1942,     0,     0,
       0,     0,  1942,  1190,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1939,     0,     0,     0,     0,  3398,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1942,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1940,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1942,     0,  2099,     0,     0,     0,     0,     0,
       0,  3021,     0,     0,     0,     0,     0,  1940,     0,     0,
    2393,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1940,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1939,     0,
       0,  1942,     0,  1942,     0,     0,     0,     0,     0,  1158,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1939,  2319,     0,   678,     0,     0,     0,  1940,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3525,     0,     0,     0,     0,     0,  1195,  1939,     0,     0,
       0,     0,     0,     0,  1942,  1195,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,     0,     0,
     678,     0,     0,     0,     0,     0,  3093,     0,  1707,  1942,
       0,   722,     0,  1939,     0,     0,     0,  1939,  1939,  1195,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1942,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1942,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1195,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1195,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1940,     0,     0,  1942,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1942,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1942,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3706,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   678,     0,     0,
    1195,     0,     0,     0,     0,     0,     0,     0,  1942,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1940,     0,     0,     0,  1942,     0,
       0,     0,     0,     0,     0,     0,  1195,     0,     0,     0,
    3752,  3753,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1942,     0,     0,     0,  2319,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3775,     0,     0,     0,     0,     0,     0,  1942,
       0,  3779,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3790,  3792,     0,     0,
       0,  3792,     0,     0,     0,     0,  3803,  3804,  3805,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1940,
       0,     0,     0,     0,     0,  3823,  3824,  3825,  3826,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1940,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3843,  3844,  3845,     0,     0,     0,     0,     0,     0,     0,
    3858,     0,     0,     0,  1195,     0,     0,     0,  1940,     0,
       0,     0,     0,     0,     0,  1195,  1942,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     722,  2099,     0,     0,     0,  3875,     0,  3877,  1949,     0,
    3881,     0,     0,     0,  1940,     0,     0,   678,  1940,  1940,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3905,     0,     0,     0,  1195,     0,     0,     0,  3909,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1942,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3977,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1195,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1561,     0,     0,     0,
       0,     0,     0,     0,     0,  4006,     0,     0,  4009,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1949,  1635,     0,     0,     0,     0,     0,     0,   930,
       0,     0,  4049,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4059,     0,     0,     0,
    1195,     0,     0,     0,     0,     0,     0,     0,     0,  2319,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2393,
       0,     0,     0,     0,   678,     0,     0,  1942,     0,  1195,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       4,     0,     0,     0,     0,     0,     0,  1195,  1195,     0,
    1195,     0,     0,     0,  1942,     0,     0,     0,     0,     0,
       5,     0,     0,     0,     0,     0,     0,     0,     0,  1195,
       6,     7,     0,     0,     0,     0,     0,     0,     9,    10,
       0,     0,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,     0,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,     0,     0,
       0,    45,  1195,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1195,     0,     0,     0,  1195,  1195,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1942,     0,    46,
       0,     0,     0,     0,     0,     0,     0,     0,  1942,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1949,     0,     0,     0,     0,    47,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    48,     0,     0,
       0,     0,     0,     0,  4268,     0,  4269,     0,     0,     0,
       0,     0,     0,  4271,     0,     0,     0,    49,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1949,  4280,
       0,     0,     0,     0,     0,     0,     0,     0,  1942,    50,
       0,     0,  4286,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4297,     0,     0,     0,     0,     0,  1949,     0,
       0,     0,     0,     0,  1942,     0,     0,  4300,     0,     0,
       0,     0,     0,     0,     0,    51,     0,     0,    52,     0,
       0,  1942,     0,     0,     0,     0,  2154,     0,     0,     0,
       0,     0,     0,    53,     0,     0,   678,     0,     0,  4330,
    4331,  4332,  4333,  4334,  4335,  4336,  4337,     0,     0,   678,
       0,     0,  4343,     0,     0,  2178,     0,     0,     0,  4352,
    4353,     0,  4355,  4356,  4357,  4358,  4359,  4360,  4361,     0,
       0,     0,     0,     0,  1949,  1942,     0,  4369,     0,  4371,
    4372,     0,     0,  2203,  2204,     0,  2207,     0,     0,     0,
       0,     0,     0,  1949,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2249,     0,     0,     0,    54,
       0,  1949,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4421,
    4423,  4425,     0,     0,  4428,     0,     0,     0,     0,  1949,
     722,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    55,     0,     0,     0,     0,     0,     0,  2303,     0,
       0,     0,     0,     0,     0,    56,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      57,     0,     0,     0,     0,     0,     0,  2326,     0,     0,
       0,  2338,  2341,     0,     0,     0,  1195,     0,     0,     0,
       0,   678,  1949,     0,     0,  1195,     0,     0,    58,     0,
       0,     0,     0,     0,     0,    59,  3792,     0,     0,    60,
      61,    62,    63,    64,     0,     0,    65,    66,  1391,  2786,
       0,  1942,     0,    71,     0,     0,  2319,  2319,  2319,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1195,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1195,  1195,     0,     0,     0,     0,     0,     0,  1195,     0,
       0,  1195,     0,     0,     0,  1195,     0,     0,     0,     0,
       0,  1942,     0,  1195,  1195,     0,     0,     0,     0,     0,
       0,  1195,     0,     0,  1195,  1195,  1195,  1195,     0,     0,
       0,     0,     0,     0,  1195,  1195,     0,  1195,     0,  1195,
    1195,     0,     0,  1195,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1949,
    1195,  3093,     0,     0,     0,  1195,     0,     0,     0,  1195,
       0,     0,     0,  1195,     0,  1195,  1195,  1195,  1195,  1195,
    1195,  1195,  1195,  1195,     0,  1195,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1195,  1195,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4630,  4631,  4632,  4633,     0,     0,
       0,     0,     0,     0,     0,     0,  1942,     0,     0,     0,
       0,     0,  1943,     0,     0,     0,     0,  4644,  4645,  4646,
    4647,     0,  4649,  4650,     0,     0,     0,     0,     0,  1942,
       0,     0,     0,     0,  4659,  4660,     0,     0,  1195,     0,
       0,   678,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2319,
    2319,     0,  2319,   678,     0,  1942,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1942,     0,     0,     0,  1942,  1942,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1949,     0,     0,     0,  1949,  1949,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4727,     0,     0,
       0,     0,     0,     0,     0,     0,  4733,     0,     0,     0,
       0,     0,     0,     0,     0,  1943,     0,     0,     0,     0,
       0,  1195,     0,     0,     0,     0,     0,  4752,     0,     0,
       0,     0,  1195,     0,     0,     0,     0,     0,     0,  1195,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4771,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2883,     0,     0,     0,     0,     0,
       0,     0,     0,  1949,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2906,     0,     0,
    2908,     0,     0,  2919,     0,     0,     0,     0,     0,     0,
    2926,  2931,   678,     0,     0,     0,  2937,     0,  2319,  2942,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2319,     0,     0,     0,     0,  2951,     0,     0,     0,
       0,  2958,     0,     0,     0,  2970,     0,     0,     0,  2977,
       0,  2979,  2980,  2981,  2982,  2983,  2984,  2985,  2986,  2987,
       0,  2988,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1561,  3016,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4860,  4861,  4862,     0,     0,  4864,
       0,     0,     0,     0,     0,     0,     0,  1195,     0,  1949,
       0,     0,     0,     0,  1635,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2393,  2243,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   678,  1943,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1949,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3792,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2243,     0,     0,     0,     0,   678,     0,     0,
       0,     0,  1943,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1195,     0,     0,     0,     0,     0,  2319,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2319,     0,
       0,     0,  1943,     0,     0,     0,     0,  3152,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4989,     0,     0,  1949,     0,  4993,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  5003,     0,  1195,     0,
       0,     0,  2319,     0,  1195,     0,   678,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1195,  1195,     0,     0,     0,     0,  1195,  1943,     0,
       0,     0,     0,     0,   678,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1943,     0,     0,
       0,     0,  1195,  1195,     0,     0,     0,  1195,     0,     0,
       0,     0,     0,     0,     0,  1943,     0,     0,     0,  1195,
    1195,  1195,  1195,     0,     0,     0,  3792,     0,     0,     0,
       0,     0,  1195,     0,     0,  1195,     0,  1195,     0,     0,
       0,     0,     0,  1943,     0,     0,     0,  1195,  1195,  2319,
       0,  1195,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1195,     0,  1195,     0,     0,     0,
    1195,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1195,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1195,
       0,     0,  1195,  1195,  1195,     0,  1943,     0,     0,     0,
       0,     0,  5107,  3373,     0,     0,     0,  5111,     0,     0,
       0,     0,     0,     0,     0,     0,  1195,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1195,
       0,     0,     0,     0,  1195,     0,     0,     0,     0,     0,
    1195,     0,     0,     0,     0,     0,     0,     0,  1195,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     722,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1949,     0,     0,  1949,
       0,  1949,     0,     0,     0,     0,  1949,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1195,
       0,     0,     0,     0,     0,     0,     0,     0,  3497,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1949,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1944,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2243,
       0,     0,     0,     0,     0,     0,  1949,     0,     0,     0,
       0,     0,     0,  1943,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3546,     0,
       0,     0,     0,  3552,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1949,     0,  1949,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2931,     0,  2931,  2931,     0,
       0,  2243,     0,     0,     0,     0,     0,     0,  3609,     0,
       0,  3612,     0,  3614,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2243,     0,     0,     0,     0,
    2915,     0,     0,     0,     0,     0,     0,     0,  1949,     0,
    3635,     0,  3637,     0,     0,     0,  3640,     0,     0,     0,
    2243,  2243,     0,     0,  2243,     0,  1944,     0,     0,     0,
       0,     0,     0,  1949,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3016,  3016,
    3016,     0,     0,     0,  1949,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2243,  1949,     0,     0,
       0,     0,  3703,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2326,     0,     0,  1943,     0,
    3715,     0,  1943,  1943,     0,     0,  2341,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2243,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1949,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2243,     0,     0,     0,  1949,     0,     0,
       0,     0,     0,     0,     0,  2243,     0,     0,  2243,     0,
    1949,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3761,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1195,     0,     0,     0,     0,     0,     0,  1943,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1195,
       0,     0,  1949,     0,     0,     0,     0,     0,     0,  1195,
       0,     0,     0,     0,     0,  1195,     0,  1195,     0,     0,
       0,     0,  1949,  1195,     0,     0,  1195,  1195,  1195,  1195,
    1195,  1195,  1195,  1195,  1195,  1195,     0,     0,     0,  1195,
    1195,     0,     0,     0,     0,     0,     0,  1949,     0,     0,
       0,     0,  1195,     0,     0,     0,  1195,     0,     0,     0,
    1195,     0,     0,     0,     0,     0,     0,     0,     0,  1944,
    1195,     0,     0,  1195,     0,  1195,     0,     0,     0,     0,
       0,     0,     0,  1949,  1195,  1195,  1195,     0,     0,     0,
    1195,     0,     0,  1195,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1195,     0,  1195,
       0,     0,     0,  1943,     0,     0,     0,     0,     0,     0,
       0,  1195,     0,  1944,     0,     0,     0,  1195,  1195,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1944,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1195,     0,     0,     0,     0,     0,  1195,     0,
       0,     0,     0,     0,  1195,     0,     0,     0,  1943,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1949,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1195,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1944,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1944,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1944,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1943,     0,  1949,
       0,     0,     0,     0,  1944,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4090,     0,  1944,     0,     0,
       0,     0,     0,     0,     0,  4094,     0,     0,     0,     0,
       0,  4095,     0,  4096,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4114,  4115,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1195,     0,  2937,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4143,     0,     0,  4146,
       0,  4148,     0,     0,     0,     0,     0,     0,     0,     0,
    4152,  1949,     0,     0,     0,     0,  4157,     0,     0,  4160,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2243,     0,     0,     0,     0,     0,     0,  4201,  1949,  1195,
    1195,     0,     0,  4208,  3016,     0,     0,     0,     0,     0,
       0,     0,     0,  2243,     0,  2243,     0,  2915,  2915,  3583,
       0,     0,  2915,     0,     0,     0,  2243,     0,     0,     0,
       0,     0,     0,  2243,     0,     0,     0,     0,  2243,     0,
       0,     0,     0,     0,  2243,     0,     0,     0,  4223,  2243,
       0,     0,     0,     0,  1561,     0,     0,     0,  2243,     0,
    1635,  1195,  2915,  2915,     0,  2243,     0,     0,     0,     0,
    1943,     0,     0,  1943,  1944,  1943,     0,  2243,     0,     0,
    1943,     0,     0,     0,  2243,     0,  2243,  2243,  2243,  2243,
    2243,  2243,  2243,  2243,  2243,  2243,     0,     0,  1195,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1195,  1195,
       0,  1949,     0,     0,     0,     0,  1195,  1195,     0,     0,
       0,  1195,  1949,  2243,     0,     0,     0,  1195,  1195,     0,
    1943,  1195,     0,     0,  1195,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1195,     0,     0,     0,  1195,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1943,  1195,     0,     0,     0,     0,  1195,     0,     0,     0,
       0,  1195,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1195,     0,     0,     0,     0,  1943,
       0,  1943,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1949,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2243,
       0,     0,     0,     0,     0,     0,     0,     0,  1949,  1944,
       0,     0,     0,  1944,  1944,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1949,     0,     0,     0,     0,
       0,     0,  1943,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1943,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1943,  1949,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1943,     0,     0,     0,  4482,  4483,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1944,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1195,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1195,
       0,     0,     0,     0,     0,  1943,     0,  4515,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1943,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1943,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1949,     0,     0,
       0,     0,     0,     0,  4533,  4535,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4542,     0,     0,
    2243,     0,     0,  4547,  4548,     0,     0,  4550,     0,     0,
    4553,  1195,     0,     0,     0,  1949,     0,     0,     0,     0,
    1195,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1943,  1195,  1195,     0,
       0,  1195,     0,     0,  1944,     0,     0,  3016,     0,     0,
       0,     0,  3016,     0,  1195,     0,  1943,  3016,     0,  1195,
       0,     0,     0,     0,  1195,     0,     0,  1195,     0,     0,
       0,     0,  1195,  1195,     0,     0,     0,     0,     0,     0,
       0,  1943,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4611,     0,     0,     0,     0,  1195,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1943,     0,  1944,
       0,     0,     0,     0,  2243,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1949,     0,     0,     0,     0,
       0,     0,     0,  1195,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2243,     0,     0,     0,     0,     0,  2243,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1195,     0,     0,  3583,  3583,     0,  2915,     0,
       0,  2915,  2915,  2915,  2915,  2915,  2915,  2915,  2915,  2915,
    2915,  3583,     0,     0,     0,     0,     0,     0,  1944,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1943,     0,  2243,     0,     0,  2243,
       0,  2243,     0,     0,     0,     0,  3583,  3583,  1195,     0,
    1949,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2915,  2915,  2243,     0,  2243,     0,     0,  2243,     0,     0,
       0,     0,  1195,  1949,  4713,  1195,     0,  1195,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1195,     0,     0,     0,  1195,     0,     0,     0,     0,  1949,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1943,     0,     0,     0,     0,     0,     0,
    2243,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2243,     0,     0,  1949,     0,     0,     0,  1949,
    1949,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2243,     0,
       0,     0,  1195,     0,     0,     0,     0,  4797,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1195,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4820,
       0,  1949,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1195,
       0,     0,  1195,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1943,     0,     0,     0,     0,
       0,  1944,     0,  1195,  1944,     0,  1944,     0,     0,     0,
       0,  1944,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1943,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1195,     0,     0,     0,     0,     0,     0,     0,
       0,  1944,     0,  1195,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1195,
    1195,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1195,  1944,     0,     0,     0,     0,     0,     0,     0,  2915,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1195,     0,     0,     0,  1943,     0,     0,     0,     0,
       0,  2937,     0,     0,     0,  1195,  1943,     0,     0,     0,
    1944,     0,  1944,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4965,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1195,
       0,     0,     0,  1944,     0,     0,     0,     0,  1195,     0,
       0,     0,     0,     0,     0,     0,     0,  2243,     0,     0,
       0,  2243,  2243,  2243,     0,     0,  3583,     0,  1944,     0,
       0,  3583,  3583,  3583,  3583,  3583,  3583,  3583,  3583,  3583,
    3583,  2243,  2243,     0,     0,     0,     0,     0,     0,  1944,
       0,     0,     0,     0,     0,     0,  1943,     0,     0,     0,
       0,     0,  1944,     0,     0,     0,     0,  5039,     0,     0,
    2243,  2915,  2915,  2243,     0,  2243,     0,     0,     0,  2243,
    3583,  3583,  1943,     0,  2243,     0,     0,  2243,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1943,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1944,     0,  2243,     0,
       0,     0,     0,     0,     0,  2243,     0,     0,     0,  5087,
       0,     0,  1944,     0,     0,     0,     0,     0,     0,     0,
    2243,     0,     0,  1943,     0,  1944,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    85,     0,     0,     0,     0,
       0,    89,     0,     0,     0,    93,     0,    94,     0,    96,
      97,     0,     0,     0,     0,  5132,  5132,     0,     0,     0,
     106,     0,     0,     0,     0,     0,     0,  1944,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   119,   120,     0,
       0,     0,     0,     0,     0,     0,     0,  1944,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1944,     0,     0,     0,     0,  5132,     0,     0,
       0,     0,     0,   128,     0,     0,     0,     0,     0,     0,
       0,  5185,     0,   129,     0,   130,   131,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1944,  1943,
    1128,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     141,     0,   142,   143,     0,     0,     0,     0,   146,     0,
     147,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     149,     0,   150,     0,     0,  5132,  3583,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   153,     0,   154,     0,
       0,   157,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   158,     0,   159,     0,     0,     0,   160,
       0,     0,     0,     0,     0,   161,     0,     0,     0,     0,
       0,     0,     0,   163,     0,   165,     0,     0,     0,  2243,
    2243,   167,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1944,   171,     0,     0,  1943,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2243,     0,     0,     0,  2915,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2243,     0,  2243,     0,     0,     0,     0,  3583,  3583,  2243,
       0,     0,  2915,  2915,  2243,  2243,     0,  2243,     0,     0,
    2243,   184,   185,     0,     0,     0,     0,   186,     0,     0,
       0,     0,     0,     0,     0,     0,   187,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   192,     0,     0,
       0,     0,     0,     0,  1944,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2243,     0,
       0,     0,     0,     0,  1943,   202,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   204,     0,     0,
       0,     0,   205,   206,     0,   207,     0,  1943,     0,     0,
     208,     0,     0,     0,     0,   209,     0,     0,   211,     0,
       0,     0,   213,     0,     0,     0,     0,   214,   215,     0,
       0,     0,     0,     0,     0,   216,     0,     0,   218,     0,
       0,     0,     0,  1943,     0,     0,   221,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   223,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   228,     0,   229,     0,  1943,
    2243,     0,     0,  1943,  1943,   231,     0,     0,     0,     0,
       0,   232,     0,     0,     0,     0,   233,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1944,     0,     0,   236,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1944,     0,   246,  3583,  2915,     0,  -138,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3583,  3583,  2243,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    85,     0,     0,    86,
      87,    88,    89,    90,    91,    92,    93,  2243,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   106,     0,     0,   107,   108,   109,   110,     0,   111,
     112,   113,   114,   115,     0,   116,   117,   118,   119,   120,
       0,     0,     0,   121,   122,     0,     0,     0,     0,   123,
       0,     0,     0,     0,     0,     0,     0,     0,   124,     0,
     125,     0,   126,   127,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,  1944,     0,     0,     0,
       0,     0,     0,     0,   128,     0,     0,  1944,     0,     0,
       0,     0,     0,     0,   129,     0,   130,   131,     0,     0,
       0,     0,     0,     0,     0,     0,   132,     0,   133,     0,
       0,   134,   135,   136,   137,   138,   139,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   140,     0,
       0,   141,     0,   142,   143,   144,  3583,   145,     0,   146,
       0,   147,     0,   148,     0,     0,     0,     0,     0,     0,
       0,   149,  2243,   150,   151,     0,     0,     0,     0,     0,
     152,     0,     0,     0,     0,     0,     0,   153,     0,   154,
     155,   156,   157,     0,     0,     0,     0,     0, -1421,     0,
       0,     0,     0,     0,   158,     0,   159,     0,     0,     0,
     160,     0,     0,     0,     0,     0,   161,   162,     0,     0,
       0,     0,     0,     0,   163,   164,   165,  1944,     0,   166,
       0,     0,   167,     0,     0,   168,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,  2243,   171,     0,   172,
       0,     0,     0,  1944,     0,     0,     0,     0,   173,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1944,   174,   175,     0,     0, -1421,     0,     0,   176,     0,
     177,     0,     0,   178,   179,     0,   180,     0,     0,     0,
       0,     0,     0,     0,  2243,     0,     0,   181,   182,     0,
     183,     0,   184,   185,     0,     0,     0,     0,   186,     0,
       0,     0,     0,     0,     0,     0,     0,   187,     0,     0,
     188,   189,   190,     0,  1944,   191,     0,     0,   192,   193,
       0,     0,   194,     0,   195,     0,     0,     0,     0,  2243,
       0,     0,     0,     0,     0,     0,     0,     0,   196,   197,
       0,   198,   199,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   200,     0,   201,     0,   202,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,   208,  2243,     0,     0,     0,   209,   210,     0,   211,
     212,     0,     0,   213,     0,     0,     0,     0,   214,   215,
       0,     0,     0,     0,     0,     0,   216,   217,     0,   218,
     219,     0,   220,     0,     0,     0,     0,   221,     0,     0,
       0,     0,     0,     0,     0,   222,     0,     0,     0,   223,
       0,     0,     0,     0,     0,     0,     0,   224,   225,     0,
       0,     0,   226,     0,   227,     0,   228,     0,   229,     0,
       0,     0,     0,   230,     0,     0,   231,     0,     0, -1421,
       0,     0,   232,     0,     0,     0,     0,   233,   234,     0,
    1944,   235,     0,     0,     0,     0,     0,     0,     0,     0,
     236,     0,     0,     0,     0,     0,     0,   237,   238,   239,
     240,   241,   242,   243,   244,   245,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   246,     0,     0,     0,
    -138,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1944,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1944,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1944,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   732,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,  1944,    98,    99,   100,   101,   102,
     103,   733,   104,   105,   687,   734,     0,   107,   108,   109,
     110,   735,   736,   112,   113,   114,   115,     0,   116,   737,
     738,   688,   689,     0,     0,     0,   690,   691,     0,     0,
    1944,     0,   692,     0,  1944,  1944,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,   739,   427,   428,   429,   740,
     741,   742,   743,   744,   745,   746,   430,   431,   747,   432,
     433,   133,   434,   435,   436,   135,   136,   137,   138,   139,
     748,   437,   438,   439,   440,   441,   749,   750,   442,   443,
     751,   140,   444,   752,   445,   446,   447,   448,   144,   753,
     145,   754,   449,   450,   451,   452,   148,   453,   755,   756,
     454,   455,   456,   457,   458,   459,   757,   151,   460,   758,
     759,   760,   761,   152,   762,   763,   764,   461,   462,   463,
     464,   701,   465,   155,   156,   466,   765,   467,   766,   468,
     469,   470,   471,   472,   767,   473,   474,   475,   768,   769,
     476,   477,   478,   479,   480,   770,   481,   482,   483,   771,
     484,   485,   486,   772,   487,   488,   489,   490,   164,   491,
     492,   493,   166,   773,   494,   774,   495,   496,   168,   497,
     775,   498,   776,   499,   169,   777,   170,   500,   501,   502,
     778,   503,   172,   779,   504,   780,   505,   506,   703,   507,
     508,   173,   509,   510,   511,   781,   512,   513,   514,   515,
     516,   517,   782,   518,   174,   175,   783,   519,   520,   521,
     784,   176,   785,   177,   786,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,   787,   529,   530,   788,   531,
     181,   182,   532,   183,   789,   533,   534,   535,   790,   791,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,   189,   190,   547,   548,   191,   792,
     549,   550,   193,   551,   793,   194,   552,   195,   553,   554,
     555,   794,   556,   795,   796,   557,   558,   559,   797,   798,
     560,   196,   197,   561,   198,   199,   562,   563,   564,   565,
     566,   567,   568,   799,   569,   200,   570,   201,   571,   572,
     573,   800,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,   801,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,   802,   597,   598,
     210,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,   803,   608,   609,   610,   611,   612,   804,   613,
     217,   614,   615,   219,   616,   220,   617,   805,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,   806,
     628,   629,   807,   630,   631,   632,   633,   634,   635,   808,
     224,   225,   809,   810,   637,   226,   638,   227,   811,   639,
     640,   641,   642,   643,   644,   645,   812,   813,   646,   647,
     648,   649,   650,   814,   815,   651,   652,   653,   654,   655,
     816,   234,   817,   656,   235,   657,   658,   659,   660,   818,
     819,   661,   820,   821,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,     0,    90,    91,    92,     0,
       0,     0,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,     0,   975,     0,   107,   108,   109,
     110,     0,   111,   112,   113,   114,   115,     0,   116,   117,
     118,     0,     0,     0,     0,     0,   121,   122,     0,     0,
       0,     0,   123,     0,     0,     0,     0,     0,     0,     0,
       0,   124,     0,   125,     0,   126,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   133,     0,     0,     0,   135,   136,   137,   138,   139,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   140,     0,     0,     0,     0,     0,     0,   144,     0,
     145,     0,     0,     0,     0,     0,   148,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   151,     0,     0,
       0,     0,     0,   152,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   155,   156,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     162,     0,     0,     0,     0,     0,     0,     0,   164,     0,
       0,     0,   166,     0,     0,     0,     0,     0,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   172,     0,     0,     0,     0,     0,     0,     0,
       0,   173,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   174,   175,     0,     0,     0,     0,
       0,   176,     0,   177,     0,     0,   178,   179,     0,   180,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     181,   182,     0,   183,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   188,   189,   190,     0,     0,   191,     0,
       0,     0,   193,     0,     0,   194,     0,   195,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   196,   197,     0,   198,   199,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   200,     0,   201,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     203,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     210,     0,     0,   212,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     217,     0,     0,   219,     0,   220,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   222,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     224,   225,     0,     0,     0,   226,     0,   227,     0,     0,
       0,     0,     0,     0,     0,     0,   230,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   234,     0,     0,   235,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     237,   238,   239,   240,   241,   242,   243,   244,   245,     0,
       0,     0,    86,    87,    88,     0,    90,    91,    92,     0,
       0,     0,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,     0,     0,  3083,   107,   108,   109,
     110,     0,   111,   112,   113,   114,   115,     0,   116,   117,
     118,     0,     0,     0,     0,     0,   121,   122,     0,     0,
       0,     0,   123,     0,     0,     0,     0,     0,     0,     0,
       0,   124,     0,   125,     0,   126,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   133,     0,     0,     0,   135,   136,   137,   138,   139,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   140,     0,     0,     0,     0,     0,     0,   144,     0,
     145,     0,     0,     0,     0,     0,   148,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   151,     0,     0,
       0,     0,     0,   152,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   155,   156,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     162,     0,     0,     0,     0,     0,     0,     0,   164,     0,
       0,     0,   166,     0,     0,     0,     0,     0,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   172,     0,     0,     0,     0,     0,     0,     0,
       0,   173,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   174,   175,     0,     0,     0,     0,
       0,   176,     0,   177,     0,     0,   178,   179,     0,   180,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     181,   182,     0,   183,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   188,   189,   190,     0,     0,   191,     0,
       0,     0,   193,     0,     0,   194,     0,   195,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   196,   197,     0,   198,   199,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   200,     0,   201,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     203,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     210,     0,     0,   212,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     217,     0,     0,   219,     0,   220,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   222,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     224,   225,     0,     0,     0,   226,     0,   227,     0,     0,
       0,     0,     0,     0,     0,     0,   230,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   234,     0,     0,   235,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     4,     0,     0,     0,     0,
     237,   238,   239,   240,   241,   242,   243,   244,   245,     0,
       0,     0,     0,     0,     0,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     6,     7,     0,     0,     0,
       0,     0,     0,     9,    10,     0,  3085,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,     0,     0,     0,    45,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    48,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    49,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    50,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      51,     0,     0,    52,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    53,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    54,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    55,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      56,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    57,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    58,     0,     0,     0,     0,     0,     0,
      59,     0,     0,     0,    60,    61,    62,    63,    64,     0,
       0,    65,    66,  1391,     0,     0,     0,     0,    71,   732,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   733,
     104,   105,   687,   734,     0,   107,   108,   109,   110,   735,
     736,   112,   113,   114,   115,     0,   116,   737,   738,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1480,  1481,  1482,
      45,  1483,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,  3010,   427,   428,   429,     0,     0,     0,
       0,  1484,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,   135,  1485,   137,  1486,  1487,     0,   437,
     438,   439,   440,   441,  1488,  1489,   442,   443,  1490,  1491,
     444,     0,   445,   446,   447,   448,  1492,     0,  1493,     0,
     449,   450,   451,   452,   148,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,  1494,  1495,
    1496,  1497,  1498,  1499,  1500,   461,   462,   463,   464,   701,
     465,  1501,  1502,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,  3011,     0,   476,   477,
    1503,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,  1504,   491,   492,   493,
    1505,  1506,   494,     0,   495,   496,  1507,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1508,     0,   504,     0,   505,   506,   703,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,   175,     0,   519,   520,   521,  1509,  1510,
       0,  1511,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,  1512,   182,
     532,   183,     0,   533,   534,   535,  1513,  1514,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,  1515,   189,  1516,   547,   548,   191,  1517,   549,   550,
     193,   551,  1518,  1519,   552,  1520,   553,   554,   555,     0,
     556,     0,     0,  1521,   558,   559,     0,     0,   560,   196,
     197,   561,   198,  1522,   562,   563,   564,   565,   566,   567,
     568,     0,   569,  1523,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,  1524,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,  1525,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,  1526,   613,   217,   614,
     615,   219,   616,  1527,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,  1528,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,  1529,  1530,
       0,     0,   637,  1531,   638,  1532,  1533,   639,   640,   641,
     642,   643,   644,   645,     0,  1534,   646,   647,   648,   649,
     650,  1535,     0,   651,   652,   653,   654,   655,   707,  1536,
    3012,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,  1537,
    1538,  1539,  1540,  1541,  1542,  1543,  1544,   708,   668,   669,
       0,     0,     0,     0,     0,     0,     0,     0,  1545,  1546,
    3013,     0,     0,     0,     0,     0,     0,  1548,  3014,   732,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   733,
     104,   105,   687,   734,     0,   107,   108,   109,   110,   735,
     736,   112,   113,   114,   115,     0,   116,   737,   738,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1480,  1481,  1482,
      45,  1483,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,  1484,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,   135,  1485,   137,  1486,  1487,     0,   437,
     438,   439,   440,   441,  1488,  1489,   442,   443,  1490,  1491,
     444,     0,   445,   446,   447,   448,  1492,     0,  1493,     0,
     449,   450,   451,   452,   148,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,  1494,  1495,
    1496,  1497,  1498,  1499,  1500,   461,   462,   463,   464,   701,
     465,  1501,  1502,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
    1503,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,  1504,   491,   492,   493,
    1505,  1506,   494,     0,   495,   496,  1507,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1508,     0,   504,     0,   505,   506,   703,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,   175,     0,   519,   520,   521,  1509,  1510,
       0,  1511,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,  1512,   182,
     532,   183,     0,   533,   534,   535,  1513,  1514,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,  1515,   189,  1516,   547,   548,   191,  1517,   549,   550,
     193,   551,  1518,  1519,   552,  1520,   553,   554,   555,     0,
     556,     0,     0,  1521,   558,   559,     0,     0,   560,   196,
     197,   561,   198,  1522,   562,   563,   564,   565,   566,   567,
     568,     0,   569,  1523,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,  1524,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,  1525,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,  1526,   613,   217,   614,
     615,   219,   616,  1527,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,  1528,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,  1529,  1530,
       0,     0,   637,  1531,   638,  1532,  1533,   639,   640,   641,
     642,   643,   644,   645,     0,  1534,   646,   647,   648,   649,
     650,  1535,     0,   651,   652,   653,   654,   655,   707,  1536,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,  1537,
    1538,  1539,  1540,  1541,  1542,  1543,  1544,   708,   668,   669,
       0,     0,     0,     0,     0,     0,     0,     0,  1545,  1546,
       0,     0,     0,     0,     0,     0,     0,  1548,  2917,   732,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   733,
     104,   105,   687,   734,     0,   107,   108,   109,   110,   735,
     736,   112,   113,   114,   115,     0,   116,   737,   738,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,     0,  1915,   137,  1916,  1917,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,  1918,  1919,
     444,     0,   445,   446,   447,   448,     0,     0,   145,     0,
     449,   450,   451,   452,   148,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,     0,     0,
       0,   152,     0,     0,     0,   461,   462,   463,   464,   701,
     465,  1920,  1921,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
    1503,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,     0,   491,   492,   493,
       0,     0,   494,     0,   495,   496,  1922,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
       0,     0,   504,     0,   505,   506,   703,   507,   508,   173,
     509,   510,   511,  2408,   512,   513,   514,   515,   516,   517,
       0,   518,   174,  2409,     0,   519,   520,   521,  1509,  1923,
       0,  1924,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,     0,   182,
     532,   183,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,  1925,   189,  1926,   547,   548,     0,     0,   549,   550,
     193,   551,     0,     0,   552,  1927,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,  2411,
     197,   561,   198,     0,   562,   563,   564,   565,   566,   567,
     568,     0,   569,     0,   570,     0,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,  1928,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,     0,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,  2412,   614,
     615,   219,   616,  1930,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,     0,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,  1931,  1932,
       0,     0,   637,     0,   638,     0,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,     0,  1933,
    2413,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   708,   668,   669,
       0,     0,     0,     0,     0,   732,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,  2511,    98,
      99,   100,   101,   102,   103,   733,   104,   105,   687,   734,
       0,   107,   108,   109,   110,   735,   736,   112,   113,   114,
     115,     0,   116,   737,   738,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,     0,
    1915,   137,  1916,  1917,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,  1918,  1919,   444,     0,   445,   446,
     447,   448,     0,     0,   145,     0,   449,   450,   451,   452,
     148,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,     0,     0,     0,   152,     0,     0,
       0,   461,   462,   463,   464,   701,   465,  1920,  1921,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,  1503,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,     0,   491,   492,   493,     0,     0,   494,     0,
     495,   496,  1922,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,     0,     0,   504,     0,
     505,   506,   703,   507,   508,   173,   509,   510,   511,  2408,
     512,   513,   514,   515,   516,   517,     0,   518,   174,  2409,
       0,   519,   520,   521,  1509,  1923,     0,  1924,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,     0,   182,   532,   183,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,  1925,   189,  1926,
     547,   548,     0,     0,   549,   550,   193,   551,     0,     0,
     552,  1927,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,  2411,   197,   561,   198,     0,
     562,   563,   564,   565,   566,   567,   568,     0,   569,     0,
     570,     0,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,  1928,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,     0,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,  2412,   614,   615,   219,   616,  1930,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,     0,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,  1931,  1932,     0,     0,   637,     0,
     638,     0,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,     0,  1933,  2413,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   708,   668,   669,     0,     0,     0,     0,
       0,   732,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,  3459,    98,    99,   100,   101,   102,
     103,   733,   104,   105,   687,   734,     0,   107,   108,   109,
     110,   735,   736,   112,   113,   114,   115,     0,   116,   737,
     738,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,   418,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1480,
    1481,  1482,    45,  1483,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,  1484,     0,     0,   430,   431,     0,   432,
     433,   133,   434,   435,   436,   135,  1485,   137,  1486,  1487,
    2927,   437,   438,   439,   440,   441,  1488,  1489,   442,   443,
    1490,  1491,   444,     0,   445,   446,   447,   448,  1492,     0,
    1493,     0,   449,   450,   451,   452,   148,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,   151,   460,     0,
    1494,  1495,  1496,  1497,  1498,  1499,  1500,   461,   462,   463,
     464,   701,   465,  1501,  1502,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,  1503,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,  1504,   491,
     492,   493,  1505,  1506,   494,     0,   495,   496,  1507,   497,
       0,   498,     0,   499,   169,  2928,   170,   500,   501,   502,
       0,   503,  1508,     0,   504,     0,   505,   506,   703,   507,
     508,   173,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,   174,   175,     0,   519,   520,   521,
    1509,  1510,     0,  1511,     0,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,     0,   529,   530,  2929,   531,
    1512,   182,   532,   183,     0,   533,   534,   535,  1513,  1514,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,  1515,   189,  1516,   547,   548,   191,  1517,
     549,   550,   193,   551,  1518,  1519,   552,  1520,   553,   554,
     555,     0,   556,     0,     0,  1521,   558,   559,     0,     0,
     560,   196,   197,   561,   198,  1522,   562,   563,   564,   565,
     566,   567,   568,     0,   569,  1523,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
    1524,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     210,   599,   600,  1525,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,  1526,   613,
     217,   614,   615,   219,   616,  1527,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,  1528,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
    1529,  1530,     0,  2930,   637,  1531,   638,  1532,  1533,   639,
     640,   641,   642,   643,   644,   645,     0,  1534,   646,   647,
     648,   649,   650,  1535,     0,   651,   652,   653,   654,   655,
     707,  1536,     0,   656,   235,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,  1537,  1538,  1539,  1540,  1541,  1542,  1543,  1544,   708,
     668,   669,     0,     0,     0,     0,     0,     0,     0,     0,
    1545,  1546,     0,     0,     0,     0,     0,     0,     0,  1548,
     732,    86,    87,    88,   684,    90,    91,    92,   685,     0,
     686,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     733,   104,   105,   687,   734,     0,   107,   108,   109,   110,
     735,   736,   112,   113,   114,   115,     0,   116,   737,   738,
     688,   689,     0,     0,     0,   690,   691,     0,     0,     0,
       0,   692,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,   694,     0,   695,   696,    35,   418,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1480,  1481,
    1482,    45,  1483,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,   429,     0,     0,
       0,     0,  1484,     0,     0,   430,   431,     0,   432,   433,
     133,   434,   435,   436,   135,  1485,   137,  1486,  1487,     0,
     437,   438,   439,   440,   441,  1488,  1489,   442,   443,  1490,
    1491,   444,     0,   445,   446,   447,   448,  1492,     0,  1493,
       0,   449,   450,   451,   452,   148,   453,   699,     0,   454,
     455,   456,   457,   458,   459,     0,   151,   460,     0,  1494,
    1495,  1496,  1497,  1498,  1499,  1500,   461,   462,   463,   464,
     701,   465,  1501,  1502,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,  1503,   479,   480,     0,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,   489,   490,  1504,   491,   492,
     493,  1505,  1506,   494,     0,   495,   496,  1507,   497,     0,
     498,     0,   499,   169,     0,   170,   500,   501,   502,     0,
     503,  1508,     0,   504,     0,   505,   506,   703,   507,   508,
     173,   509,   510,   511,     0,   512,   513,   514,   515,   516,
     517,     0,   518,   174,   175,     0,   519,   520,   521,  1509,
    1510,     0,  1511,     0,   522,   178,   179,   523,   180,   524,
     525,   526,   527,   528,     0,   529,   530,     0,   531,  1512,
     182,   532,   183,     0,   533,   534,   535,  1513,  1514,   536,
     537,   538,   539,   540,   541,   704,   542,   543,   705,   544,
     545,   546,  1515,   189,  1516,   547,   548,   191,  1517,   549,
     550,   193,   551,  1518,  1519,   552,  1520,   553,   554,   555,
       0,   556,     0,     0,  1521,   558,   559,     0,     0,   560,
     196,   197,   561,   198,  1522,   562,   563,   564,   565,   566,
     567,   568,     0,   569,  1523,   570,   201,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,  1524,
     582,   583,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,   210,
     599,   600,  1525,   601,   602,   603,   604,   605,   606,   706,
     607,   215,   608,   609,   610,   611,   612,  1526,   613,   217,
     614,   615,   219,   616,  1527,   617,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,  1528,     0,   628,
     629,   223,   630,   631,   632,   633,   634,   635,     0,  1529,
    1530,     0,     0,   637,  1531,   638,  1532,  1533,   639,   640,
     641,   642,   643,   644,   645,     0,  1534,   646,   647,   648,
     649,   650,  1535,     0,   651,   652,   653,   654,   655,  2205,
    1536,     0,   656,   235,   657,   658,   659,   660,     0,     0,
     661,     0,   236,   662,   663,   664,   665,   666,   667,   237,
    1537,  1538,  1539,  1540,  1541,  1542,  1543,  1544,   708,   668,
     669,     0,     0,     0,     0,     0,     0,     0,     0,  1545,
    1546,     0,     0,     0,     0,     0,     0,     0,  1548,   732,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   733,
     104,   105,   687,   734,     0,   107,   108,   109,   110,   735,
     736,   112,   113,   114,   115,     0,   116,   737,   738,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1480,  1481,  1482,
      45,  1483,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,  1484,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,   135,  1485,   137,  1486,  1487,     0,   437,
     438,   439,   440,   441,  1488,  1489,   442,   443,  1490,  1491,
     444,     0,   445,   446,   447,   448,  1492,     0,  1493,     0,
     449,   450,   451,   452,   148,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,  1494,  1495,
    1496,  1497,  1498,  1499,  1500,   461,   462,   463,   464,   701,
     465,  1501,  1502,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
    1503,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,  1504,   491,   492,   493,
    1505,  1506,   494,     0,   495,   496,  1507,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1508,     0,   504,     0,   505,   506,   703,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,   175,     0,   519,   520,   521,  1509,  1510,
       0,  1511,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,  1512,   182,
     532,   183,     0,   533,   534,   535,  1513,  1514,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,  1515,   189,  1516,   547,   548,   191,  1517,   549,   550,
     193,   551,  1518,  1519,   552,  1520,   553,   554,   555,     0,
     556,     0,     0,  1521,   558,   559,     0,     0,   560,   196,
     197,   561,   198,  1522,   562,   563,   564,   565,   566,   567,
     568,     0,   569,  1523,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,  1524,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,  1525,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,  1526,   613,   217,   614,
     615,   219,   616,  1527,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,  1528,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,  1529,  1530,
       0,     0,   637,  1531,   638,  1532,  1533,   639,   640,   641,
     642,   643,   644,   645,     0,  1534,   646,   647,   648,   649,
     650,  1535,     0,   651,   652,   653,   654,   655,   707,  1536,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,  1537,
    1538,  1539,  1540,  1541,  1542,  1543,  1544,   708,   668,   669,
       0,     0,     0,     0,     0,     0,     0,     0,  1545,  1546,
       0,     0,     0,     0,     0,  2149,  2875,  1548,   732,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   733,   104,
     105,   687,   734,     0,   107,   108,   109,   110,   735,   736,
     112,   113,   114,   115,     0,   116,   737,   738,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,   418,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1480,  1481,  1482,    45,
    1483,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
    1484,     0,     0,   430,   431,     0,   432,   433,   133,   434,
     435,   436,   135,  1485,   137,  1486,  1487,     0,   437,   438,
     439,   440,   441,  1488,  1489,   442,   443,  1490,  1491,   444,
       0,   445,   446,   447,   448,  1492,     0,  1493,     0,   449,
     450,   451,   452,   148,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0,   151,   460,     0,  1494,  1495,  1496,
    1497,  1498,  1499,  1500,   461,   462,   463,   464,   701,   465,
    1501,  1502,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,  1503,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,  1504,   491,   492,   493,  1505,
    1506,   494,     0,   495,   496,  1507,   497,     0,   498,     0,
     499,   169,     0,   170,   500,   501,   502,     0,   503,  1508,
       0,   504,     0,   505,   506,   703,   507,   508,   173,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518,   174,   175,     0,   519,   520,   521,  1509,  1510,     0,
    1511,     0,   522,   178,   179,   523,   180,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,  1512,   182,   532,
     183,     0,   533,   534,   535,  1513,  1514,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
    1515,   189,  1516,   547,   548,   191,  1517,   549,   550,   193,
     551,  1518,  1519,   552,  1520,   553,   554,   555,     0,   556,
       0,     0,  1521,   558,   559,     0,     0,   560,   196,   197,
     561,   198,  1522,   562,   563,   564,   565,   566,   567,   568,
       0,   569,  1523,   570,   201,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,  1524,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,   210,   599,   600,
    1525,   601,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,  1526,   613,   217,   614,   615,
     219,   616,  1527,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,  1528,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,  1529,  1530,     0,
       0,   637,  1531,   638,  1532,  1533,   639,   640,   641,   642,
     643,   644,   645,     0,  1534,   646,   647,   648,   649,   650,
    1535,     0,   651,   652,   653,   654,   655,   707,  1536,     0,
     656,   235,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,   237,  1537,  1538,
    1539,  1540,  1541,  1542,  1543,  1544,   708,   668,   669,     0,
       0,     0,     0,     0,     0,     0,     0,  1545,  1546,  1547,
       0,     0,     0,     0,     0,     0,  1548,   732,    86,    87,
      88,   684,    90,    91,    92,   685,     0,   686,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   733,   104,   105,
     687,   734,     0,   107,   108,   109,   110,   735,   736,   112,
     113,   114,   115,     0,   116,   737,   738,   688,   689,     0,
       0,     0,   690,   691,     0,     0,     0,     0,   692,     0,
       0,     0,     0,     0,     0,     0,     0,   693,     0,   694,
       0,   695,   696,    35,   418,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1480,  1481,  1482,    45,  1483,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,   429,     0,     0,     0,     0,  1484,
       0,     0,   430,   431,     0,   432,   433,   133,   434,   435,
     436,   135,  1485,   137,  1486,  1487,     0,   437,   438,   439,
     440,   441,  1488,  1489,   442,   443,  1490,  1491,   444,     0,
     445,   446,   447,   448,  1492,     0,  1493,     0,   449,   450,
     451,   452,   148,   453,   699,     0,   454,   455,   456,   457,
     458,   459,     0,   151,   460,     0,  1494,  1495,  1496,  1497,
    1498,  1499,  1500,   461,   462,   463,   464,   701,   465,  1501,
    1502,   466,  1634,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,  1503,   479,
     480,     0,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,   489,   490,  1504,   491,   492,   493,  1505,  1506,
     494,     0,   495,   496,  1507,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,  1508,     0,
     504,     0,   505,   506,   703,   507,   508,   173,   509,   510,
     511,     0,   512,   513,   514,   515,   516,   517,     0,   518,
     174,   175,     0,   519,   520,   521,  1509,  1510,     0,  1511,
       0,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,     0,   529,   530,     0,   531,  1512,   182,   532,   183,
       0,   533,   534,   535,  1513,  1514,   536,   537,   538,   539,
     540,   541,   704,   542,   543,   705,   544,   545,   546,  1515,
     189,  1516,   547,   548,   191,  1517,   549,   550,   193,   551,
    1518,  1519,   552,  1520,   553,   554,   555,     0,   556,     0,
       0,  1521,   558,   559,     0,     0,   560,   196,   197,   561,
     198,  1522,   562,   563,   564,   565,   566,   567,   568,     0,
     569,  1523,   570,   201,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,  1524,   582,   583,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   210,   599,   600,  1525,
     601,   602,   603,   604,   605,   606,   706,   607,     0,   608,
     609,   610,   611,   612,  1526,   613,   217,   614,   615,   219,
     616,  1527,   617,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,  1528,     0,   628,   629,     0,   630,
     631,   632,   633,   634,   635,     0,  1529,  1530,     0,     0,
     637,  1531,   638,  1532,  1533,   639,   640,   641,   642,   643,
     644,   645,     0,  1534,   646,   647,   648,   649,   650,  1535,
       0,   651,   652,   653,   654,   655,   707,  1536,     0,   656,
     235,   657,   658,   659,   660,     0,     0,   661,     0,     0,
     662,   663,   664,   665,   666,   667,   237,  1537,  1538,  1539,
    1540,  1541,  1542,  1543,  1544,   708,   668,   669,     0,     0,
       0,     0,     0,     0,     0,     0,  1545,  1546,     0,     0,
       0,     0,     0,     0,     0,  1548,   732,    86,    87,    88,
     684,    90,    91,    92,   685,     0,   686,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   733,   104,   105,   687,
     734,     0,   107,   108,   109,   110,   735,   736,   112,   113,
     114,   115,     0,   116,   737,   738,   688,   689,     0,     0,
       0,   690,   691,     0,     0,     0,     0,   692,     0,     0,
       0,     0,     0,     0,     0,     0,   693,     0,   694,     0,
     695,   696,    35,   418,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1480,  1481,  1482,    45,  1483,     0,
       0,     0,   419,   420,   421,   422,   423,   424,   425,   426,
    2336,   427,   428,   429,     0,     0,     0,     0,  1484,     0,
       0,   430,   431,     0,   432,   433,   133,   434,   435,   436,
     135,  1485,   137,  1486,  1487,     0,   437,   438,   439,   440,
     441,  1488,  1489,   442,   443,  1490,  1491,   444,     0,   445,
     446,   447,   448,  1492,     0,  1493,     0,   449,   450,   451,
     452,   148,   453,   699,     0,   454,   455,   456,   457,   458,
     459,     0,   151,   460,     0,  1494,  1495,  1496,  1497,  1498,
    1499,  1500,   461,   462,   463,   464,   701,   465,  1501,  1502,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,  1503,   479,   480,
       0,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,   489,   490,  1504,   491,   492,   493,  1505,  1506,   494,
       0,   495,   496,  1507,   497,     0,   498,     0,   499,   169,
       0,   170,   500,   501,   502,     0,   503,  1508,     0,   504,
       0,   505,   506,   703,   507,   508,   173,   509,   510,   511,
       0,   512,   513,   514,   515,   516,   517,     0,   518,   174,
     175,     0,   519,   520,   521,  1509,  1510,     0,  1511,     0,
     522,   178,   179,   523,   180,   524,   525,   526,   527,   528,
       0,   529,   530,     0,   531,  1512,   182,   532,   183,     0,
     533,   534,   535,  1513,  1514,   536,   537,   538,   539,   540,
     541,   704,   542,   543,   705,   544,   545,   546,  1515,   189,
    1516,   547,   548,   191,  1517,   549,   550,   193,   551,  1518,
    1519,   552,  1520,   553,   554,   555,     0,   556,     0,     0,
    1521,   558,   559,     0,     0,   560,   196,   197,   561,   198,
    1522,   562,   563,   564,   565,   566,   567,   568,     0,   569,
    1523,   570,   201,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,  1524,   582,   583,   584,   585,
       0,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,   210,   599,   600,  1525,   601,
     602,   603,   604,   605,   606,   706,   607,     0,   608,   609,
     610,   611,   612,  1526,   613,   217,   614,   615,   219,   616,
    1527,   617,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,  1528,     0,   628,   629,     0,   630,   631,
     632,   633,   634,   635,     0,  1529,  1530,     0,     0,   637,
    1531,   638,  1532,  1533,   639,   640,   641,   642,   643,   644,
     645,     0,  1534,   646,   647,   648,   649,   650,  1535,     0,
     651,   652,   653,   654,   655,   707,  1536,     0,   656,   235,
     657,   658,   659,   660,     0,     0,   661,     0,     0,   662,
     663,   664,   665,   666,   667,   237,  1537,  1538,  1539,  1540,
    1541,  1542,  1543,  1544,   708,   668,   669,     0,     0,     0,
       0,     0,     0,     0,     0,  1545,  1546,     0,     0,     0,
       0,     0,     0,     0,  1548,   732,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   733,   104,   105,   687,   734,
       0,   107,   108,   109,   110,   735,   736,   112,   113,   114,
     115,     0,   116,   737,   738,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1480,  1481,  1482,    45,  1483,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,  1484,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,   135,
    1485,   137,  1486,  1487,     0,   437,   438,   439,   440,   441,
    1488,  1489,   442,   443,  1490,  1491,   444,     0,   445,   446,
     447,   448,  1492,     0,  1493,     0,   449,   450,   451,   452,
     148,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,  1494,  1495,  1496,  1497,  1498,  1499,
    1500,   461,   462,   463,   464,   701,   465,  1501,  1502,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,  1503,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,  1504,   491,   492,   493,  1505,  1506,   494,     0,
     495,   496,  1507,   497,     0,   498,     0,   499,   169,  2928,
     170,   500,   501,   502,     0,   503,  1508,     0,   504,     0,
     505,   506,   703,   507,   508,   173,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,   175,
       0,   519,   520,   521,  1509,  1510,     0,  1511,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,  1512,   182,   532,   183,     0,   533,
     534,   535,  1513,  1514,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,  1515,   189,  1516,
     547,   548,   191,  1517,   549,   550,   193,   551,  1518,  1519,
     552,  1520,   553,   554,   555,     0,   556,     0,     0,  1521,
     558,   559,     0,     0,   560,   196,   197,   561,   198,  1522,
     562,   563,   564,   565,   566,   567,   568,     0,   569,  1523,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,  1524,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,  1525,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,  1526,   613,   217,   614,   615,   219,   616,  1527,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,  1528,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,  1529,  1530,     0,     0,   637,  1531,
     638,  1532,  1533,   639,   640,   641,   642,   643,   644,   645,
       0,  1534,   646,   647,   648,   649,   650,  1535,     0,   651,
     652,   653,   654,   655,   707,  1536,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,  1537,  1538,  1539,  1540,  1541,
    1542,  1543,  1544,   708,   668,   669,     0,     0,     0,     0,
       0,     0,     0,     0,  1545,  1546,     0,     0,     0,     0,
       0,     0,     0,  1548,   732,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   733,   104,   105,   687,   734,     0,
     107,   108,   109,   110,   735,   736,   112,   113,   114,   115,
       0,   116,   737,   738,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,   418,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1480,  1481,  1482,    45,  1483,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,  1484,     0,     0,   430,
     431,     0,   432,   433,   133,   434,   435,   436,   135,  1485,
     137,  1486,  1487,     0,   437,   438,   439,   440,   441,  1488,
    1489,   442,   443,  1490,  1491,   444,     0,   445,   446,   447,
     448,  1492,     0,  1493,     0,   449,   450,   451,   452,   148,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
     151,   460,     0,  1494,  1495,  1496,  1497,  1498,  1499,  1500,
     461,   462,   463,   464,   701,   465,  1501,  1502,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,  1503,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,  1504,   491,   492,   493,  1505,  1506,   494,     0,   495,
     496,  1507,   497,     0,   498,     0,   499,   169,     0,   170,
     500,   501,   502,     0,   503,  1508,     0,   504,     0,   505,
     506,   703,   507,   508,   173,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,   174,   175,     0,
     519,   520,   521,  1509,  1510,     0,  1511,     0,   522,   178,
     179,   523,   180,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,  1512,   182,   532,   183,     0,   533,   534,
     535,  1513,  1514,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,  1515,   189,  1516,   547,
     548,   191,  1517,   549,   550,   193,   551,  1518,  1519,   552,
    1520,   553,   554,   555,     0,   556,     0,     0,  1521,   558,
     559,     0,     0,   560,   196,   197,   561,   198,  1522,   562,
     563,   564,   565,   566,   567,   568,     0,   569,  1523,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,  1524,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,   210,   599,   600,  1525,   601,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,  1526,   613,   217,   614,   615,   219,   616,  1527,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1528,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,  1529,  1530,     0,     0,   637,  1531,   638,
    1532,  1533,   639,   640,   641,   642,   643,   644,   645,     0,
    1534,   646,   647,   648,   649,   650,  1535,     0,   651,   652,
     653,   654,   655,   707,  1536,  4209,   656,   235,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,   237,  1537,  1538,  1539,  1540,  1541,  1542,
    1543,  1544,   708,   668,   669,     0,     0,     0,     0,     0,
       0,     0,     0,  1545,  1546,     0,     0,     0,     0,     0,
       0,     0,  1548,   732,    86,    87,    88,   684,    90,    91,
      92,   685,     0,   686,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   733,   104,   105,   687,   734,     0,   107,
     108,   109,   110,   735,   736,   112,   113,   114,   115,     0,
     116,   737,   738,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
     418,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1480,  1481,  1482,    45,  1483,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,  1484,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,   135,  1485,   137,
    1486,  1487,     0,   437,   438,   439,   440,   441,  1488,  1489,
     442,   443,  1490,  1491,   444,     0,   445,   446,   447,   448,
    1492,     0,  1493,     0,   449,   450,   451,   452,   148,   453,
     699,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,  4222,  1494,  1495,  1496,  1497,  1498,  1499,  1500,   461,
     462,   463,   464,   701,   465,  1501,  1502,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,  1503,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
    1504,   491,   492,   493,  1505,  1506,   494,     0,   495,   496,
    1507,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1508,     0,   504,     0,   505,   506,
     703,   507,   508,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,   175,     0,   519,
     520,   521,  1509,  1510,     0,  1511,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,  1512,   182,   532,   183,     0,   533,   534,   535,
    1513,  1514,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,  1515,   189,  1516,   547,   548,
     191,  1517,   549,   550,   193,   551,  1518,  1519,   552,  1520,
     553,   554,   555,     0,   556,     0,     0,  1521,   558,   559,
       0,     0,   560,   196,   197,   561,   198,  1522,   562,   563,
     564,   565,   566,   567,   568,     0,   569,  1523,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,  1524,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,  1525,   601,   602,   603,   604,
     605,   606,   706,   607,     0,   608,   609,   610,   611,   612,
    1526,   613,   217,   614,   615,   219,   616,  1527,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
    1528,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,  1529,  1530,     0,     0,   637,  1531,   638,  1532,
    1533,   639,   640,   641,   642,   643,   644,   645,     0,  1534,
     646,   647,   648,   649,   650,  1535,     0,   651,   652,   653,
     654,   655,   707,  1536,     0,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,   237,  1537,  1538,  1539,  1540,  1541,  1542,  1543,
    1544,   708,   668,   669,     0,     0,     0,     0,     0,     0,
       0,     0,  1545,  1546,     0,     0,     0,     0,     0,     0,
       0,  1548,   732,    86,    87,    88,   684,    90,    91,    92,
     685,     0,   686,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   733,   104,   105,   687,   734,     0,   107,   108,
     109,   110,   735,   736,   112,   113,   114,   115,     0,   116,
     737,   738,   688,   689,     0,     0,     0,   690,   691,     0,
       0,     0,     0,   692,     0,     0,     0,     0,     0,     0,
       0,     0,   693,     0,   694,     0,   695,   696,    35,   418,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1480,  1481,  1482,    45,  1483,     0,     0,     0,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,   429,
       0,     0,     0,     0,  1484,     0,     0,   430,   431,     0,
     432,   433,   133,   434,   435,   436,  5129,  1485,   137,  1486,
    1487,     0,   437,   438,   439,   440,   441,  1488,  1489,   442,
     443,  1490,  1491,   444,     0,   445,   446,   447,   448,  1492,
       0,  1493,     0,   449,   450,   451,   452,   148,   453,   699,
       0,   454,   455,   456,   457,   458,   459,     0,   151,   460,
    5130,  1494,  1495,  1496,  1497,  1498,  1499,  1500,   461,   462,
     463,   464,   701,   465,  1501,  1502,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,  1503,   479,   480,     0,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,   489,   490,  1504,
     491,   492,   493,  1505,  1506,   494,     0,   495,   496,  1507,
     497,     0,   498,     0,   499,   169,     0,   170,   500,   501,
     502,     0,   503,  1508,     0,   504,     0,   505,   506,   703,
     507,   508,   173,   509,   510,   511,     0,   512,   513,   514,
     515,   516,   517,     0,   518,   174,   175,     0,   519,   520,
     521,  1509,  1510,     0,  1511,     0,   522,   178,   179,   523,
     180,   524,   525,   526,   527,   528,     0,   529,   530,     0,
     531,  1512,   182,   532,   183,     0,   533,   534,   535,  1513,
    1514,   536,   537,   538,   539,   540,   541,   704,   542,   543,
     705,   544,   545,   546,  1515,   189,  1516,   547,   548,   191,
    1517,   549,   550,   193,   551,  1518,  1519,   552,  1520,   553,
     554,   555,     0,   556,     0,     0,  1521,   558,   559,     0,
       0,   560,   196,   197,   561,   198,  1522,   562,   563,   564,
     565,   566,   567,   568,     0,   569,  1523,   570,   201,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,  1524,   582,   583,   584,   585,     0,   586,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,   210,   599,   600,  1525,   601,   602,   603,   604,   605,
     606,   706,   607,     0,   608,   609,   610,   611,   612,  1526,
     613,   217,   614,   615,   219,   616,  1527,   617,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,  1528,
       0,   628,   629,     0,   630,   631,   632,   633,   634,   635,
       0,  1529,  1530,     0,     0,   637,  1531,   638,  1532,  1533,
     639,   640,   641,   642,  5131,   644,   645,     0,  1534,   646,
     647,   648,   649,   650,  1535,     0,   651,   652,   653,   654,
     655,   707,  1536,     0,   656,   235,   657,   658,   659,   660,
       0,     0,   661,     0,     0,   662,   663,   664,   665,   666,
     667,   237,  1537,  1538,  1539,  1540,  1541,  1542,  1543,  1544,
     708,   668,   669,     0,     0,     0,     0,     0,     0,     0,
       0,  1545,  1546,     0,     0,     0,     0,     0,     0,     0,
    1548,   732,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   733,   104,   105,   687,   734,     0,   107,   108,   109,
     110,   735,   736,   112,   113,   114,   115,     0,   116,   737,
     738,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,   418,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1480,
    1481,  1482,    45,  1483,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,  1484,     0,     0,   430,   431,     0,   432,
     433,   133,   434,   435,   436,   135,  1485,   137,  1486,  1487,
       0,   437,   438,   439,   440,   441,  1488,  1489,   442,   443,
    1490,  1491,   444,     0,   445,   446,   447,   448,  1492,     0,
    1493,     0,   449,   450,   451,   452,   148,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,   151,   460,  5130,
    1494,  1495,  1496,  1497,  1498,  1499,  1500,   461,   462,   463,
     464,   701,   465,  1501,  1502,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,  1503,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,  1504,   491,
     492,   493,  1505,  1506,   494,     0,   495,   496,  1507,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,  1508,     0,   504,     0,   505,   506,   703,   507,
     508,   173,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,   174,   175,     0,   519,   520,   521,
    1509,  1510,     0,  1511,     0,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
    1512,   182,   532,   183,     0,   533,   534,   535,  1513,  1514,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,  1515,   189,  1516,   547,   548,   191,  1517,
     549,   550,   193,   551,  1518,  1519,   552,  1520,   553,   554,
     555,     0,   556,     0,     0,  1521,   558,   559,     0,     0,
     560,   196,   197,   561,   198,  1522,   562,   563,   564,   565,
     566,   567,   568,     0,   569,  1523,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
    1524,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     210,   599,   600,  1525,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,  1526,   613,
     217,   614,   615,   219,   616,  1527,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,  1528,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
    1529,  1530,     0,     0,   637,  1531,   638,  1532,  1533,   639,
     640,   641,   642,  5131,   644,   645,     0,  1534,   646,   647,
     648,   649,   650,  1535,     0,   651,   652,   653,   654,   655,
     707,  1536,     0,   656,   235,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,  1537,  1538,  1539,  1540,  1541,  1542,  1543,  1544,   708,
     668,   669,     0,     0,     0,     0,     0,     0,     0,     0,
    1545,  1546,     0,     0,     0,     0,     0,     0,     0,  1548,
     732,    86,    87,    88,   684,    90,    91,    92,   685,     0,
     686,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     733,   104,   105,   687,   734,     0,   107,   108,   109,   110,
     735,   736,   112,   113,   114,   115,     0,   116,   737,   738,
     688,   689,     0,     0,     0,   690,   691,     0,     0,     0,
       0,   692,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,   694,     0,   695,   696,    35,   418,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1480,  1481,
    1482,    45,  1483,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,   429,     0,     0,
       0,     0,  1484,     0,     0,   430,   431,     0,   432,   433,
     133,   434,   435,   436,   135,  1485,   137,  1486,  1487,     0,
     437,   438,   439,   440,   441,  1488,  1489,   442,   443,  1490,
    1491,   444,     0,   445,   446,   447,   448,  1492,     0,  1493,
       0,   449,   450,   451,   452,   148,   453,   699,     0,   454,
     455,   456,   457,   458,   459,     0,   151,   460,     0,  1494,
    1495,  1496,  1497,  1498,  1499,  1500,   461,   462,   463,   464,
     701,   465,  1501,  1502,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,  1503,   479,   480,     0,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,   489,   490,  1504,   491,   492,
     493,  1505,  1506,   494,     0,   495,   496,  1507,   497,     0,
     498,     0,   499,   169,     0,   170,   500,   501,   502,     0,
     503,  1508,     0,   504,     0,   505,   506,   703,   507,   508,
     173,   509,   510,   511,     0,   512,   513,   514,   515,   516,
     517,     0,   518,   174,   175,     0,   519,   520,   521,  1509,
    1510,     0,  1511,     0,   522,   178,   179,   523,   180,   524,
     525,   526,   527,   528,     0,   529,   530,     0,   531,  1512,
     182,   532,   183,     0,   533,   534,   535,  1513,  1514,   536,
     537,   538,   539,   540,   541,   704,   542,   543,   705,   544,
     545,   546,  1515,   189,  1516,   547,   548,   191,  1517,   549,
     550,   193,   551,  1518,  1519,   552,  1520,   553,   554,   555,
       0,   556,     0,     0,  1521,   558,   559,     0,     0,   560,
     196,   197,   561,   198,  1522,   562,   563,   564,   565,   566,
     567,   568,     0,   569,  1523,   570,   201,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,  1524,
     582,   583,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,   210,
     599,   600,  1525,   601,   602,   603,   604,   605,   606,   706,
     607,     0,   608,   609,   610,   611,   612,  1526,   613,   217,
     614,   615,   219,   616,  1527,   617,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,  1528,     0,   628,
     629,     0,   630,   631,   632,   633,   634,   635,     0,  1529,
    1530,     0,     0,   637,  1531,   638,  1532,  1533,   639,   640,
     641,   642,   643,   644,   645,     0,  1534,   646,   647,   648,
     649,   650,  1535,     0,   651,   652,   653,   654,   655,   707,
    1536,     0,   656,   235,   657,   658,   659,   660,     0,     0,
     661,     0,     0,   662,   663,   664,   665,   666,   667,   237,
    1537,  1538,  1539,  1540,  1541,  1542,  1543,  1544,   708,   668,
     669,     0,     0,     0,     0,     0,     0,     0,     0,  1545,
    1546,     0,     0,     0,     0,     0,     0,     0,  1548,   732,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   733,
     104,   105,   687,   734,     0,   107,   108,   109,   110,   735,
     736,   112,   113,   114,   115,     0,   116,   737,   738,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1480,  1481,  1482,
      45,  1483,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,  1484,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,   135,  1485,   137,  1486,  1487,     0,   437,
     438,   439,   440,   441,  1488,  1489,   442,   443,  1490,  1491,
     444,     0,   445,   446,   447,   448,  1492,     0,  1493,     0,
     449,   450,   451,   452,   148,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,  1494,  1495,
    1496,  1497,  1498,  1499,  1500,   461,   462,   463,   464,   701,
     465,  1501,  1502,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
    1503,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,  1504,   491,   492,   493,
    1505,  1506,   494,     0,   495,   496,  1507,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1508,     0,   504,     0,   505,   506,   703,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,   175,     0,   519,   520,   521,  1509,  1510,
       0,  1511,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,  1512,   182,
     532,   183,     0,   533,   534,   535,  1513,  1514,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,  1515,   189,  1516,   547,   548,   191,  1517,   549,   550,
     193,   551,  1518,  1519,   552,  1520,   553,   554,   555,     0,
     556,     0,     0,  1521,   558,   559,     0,     0,   560,   196,
     197,   561,   198,  1522,   562,   563,   564,   565,   566,   567,
     568,     0,   569,  1523,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,  1524,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,  1525,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,  1526,   613,   217,   614,
     615,   219,   616,  1527,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,  1528,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,  1529,  1530,
       0,     0,   637,  1531,   638,  1532,  1533,   639,   640,   641,
     642,   643,   644,   645,     0,  1534,   646,   647,   648,   649,
     650,  1535,     0,   651,   652,   653,   654,   655,   707,  1536,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,  4525,  1537,
    1538,  1539,  1540,  1541,  1542,  1543,  1544,   708,   668,   669,
       0,     0,     0,     0,     0,     0,     0,     0,  1545,  1546,
       0,     0,     0,     0,     0,     0,     0,  1548,   732,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   733,   104,
     105,   687,   734,     0,   107,   108,   109,   110,   735,   736,
     112,   113,   114,   115,     0,   116,   737,   738,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,   418,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1480,  1481,  1482,    45,
    1483,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
    1484,     0,     0,   430,   431,     0,   432,   433,   133,   434,
     435,   436,   135,  1485,   137,  1486,  1487,     0,   437,   438,
     439,   440,   441,  1488,  1489,   442,   443,  1490,  1491,   444,
       0,   445,   446,   447,   448,  1492,     0,  1493,     0,   449,
     450,   451,   452,   148,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0,   151,   460,     0,  1494,  1495,  1496,
    1497,  1498,  1499,  1500,   461,   462,   463,   464,   701,   465,
    1501,  1502,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,  1503,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,  1504,   491,   492,   493,  1505,
    1506,   494,     0,   495,   496,  1507,   497,     0,   498,     0,
     499,   169,     0,   170,   500,   501,   502,     0,   503,  1508,
       0,   504,     0,   505,   506,   703,   507,   508,   173,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518,   174,   175,     0,   519,   520,   521,  1509,  1510,     0,
    1511,     0,   522,   178,   179,   523,   180,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,  1512,   182,   532,
     183,     0,   533,   534,   535,  1513,  1514,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
    1515,   189,  1516,   547,  4534,   191,  1517,   549,   550,   193,
     551,  1518,  1519,   552,  1520,   553,   554,   555,     0,   556,
       0,     0,  1521,   558,   559,     0,     0,   560,   196,   197,
     561,   198,  1522,   562,   563,   564,   565,   566,   567,   568,
       0,   569,  1523,   570,   201,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,  1524,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,   210,   599,   600,
    1525,   601,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,  1526,   613,   217,   614,   615,
     219,   616,  1527,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,  1528,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,  1529,  1530,     0,
       0,   637,  1531,   638,  1532,  1533,   639,   640,   641,   642,
     643,   644,   645,     0,  1534,   646,   647,   648,   649,   650,
    1535,     0,   651,   652,   653,   654,   655,   707,  1536,     0,
     656,   235,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,   237,  1537,  1538,
    1539,  1540,  1541,  1542,  1543,  1544,   708,   668,   669,     0,
       0,     0,     0,     0,     0,     0,     0,  1545,  1546,     0,
       0,     0,     0,     0,     0,     0,  1548,   732,    86,    87,
      88,   684,    90,    91,    92,   685,     0,   686,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   733,   104,   105,
     687,   734,     0,   107,   108,   109,   110,   735,   736,   112,
     113,   114,   115,     0,   116,   737,   738,   688,   689,     0,
       0,     0,   690,   691,     0,     0,     0,     0,   692,     0,
       0,     0,     0,     0,     0,     0,     0,   693,     0,   694,
       0,   695,   696,    35,   418,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1480,  1481,  1482,    45,  1483,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,   429,     0,     0,     0,     0,  1484,
       0,     0,   430,   431,     0,   432,   433,   133,   434,   435,
     436,   135,  1485,   137,  1486,  1487,     0,   437,   438,   439,
     440,   441,  1488,  1489,   442,   443,  1490,  1491,   444,     0,
     445,   446,   447,   448,  1492,     0,  1493,     0,   449,   450,
     451,   452,   148,   453,   699,     0,   454,   455,   456,   457,
     458,   459,     0,   151,   460,     0,  1494,  1495,  1496,  1497,
    1498,  1499,  1500,   461,   462,   463,   464,   701,   465,  1501,
    1502,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,  1503,   479,
     480,     0,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,   489,   490,  1504,   491,   492,   493,  1505,  1506,
     494,     0,   495,   496,  1507,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,  1508,     0,
     504,     0,   505,   506,   703,   507,   508,   173,   509,   510,
     511,     0,   512,   513,   514,   515,   516,   517,     0,   518,
     174,   175,     0,   519,   520,   521,  1509,  1510,     0,  1511,
       0,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,     0,   529,   530,     0,   531,  1512,   182,   532,   183,
       0,   533,   534,   535,  1513,  1514,   536,   537,   538,   539,
     540,   541,   704,   542,   543,   705,   544,   545,   546,  1515,
     189,  1516,   547,   548,   191,     0,   549,   550,   193,   551,
    1518,  1519,   552,  1520,   553,   554,   555,     0,   556,     0,
       0,  1521,   558,   559,     0,     0,   560,   196,   197,   561,
     198,  1522,   562,   563,   564,   565,   566,   567,   568,     0,
     569,  1523,   570,   201,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,  1524,   582,   583,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   210,   599,   600,  1525,
     601,   602,   603,   604,   605,   606,   706,   607,     0,   608,
     609,   610,   611,   612,  1526,   613,   217,   614,   615,   219,
     616,  1527,   617,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,  1528,     0,   628,   629,     0,   630,
     631,   632,   633,   634,   635,     0,  1529,  1530,     0,     0,
     637,  1531,   638,  1532,  1533,   639,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,   650,  1535,
       0,   651,   652,   653,   654,   655,   707,  1536,     0,   656,
     235,   657,   658,   659,   660,     0,     0,   661,     0,     0,
     662,   663,   664,   665,   666,   667,   237,  1537,  1538,  1539,
    1540,  1541,  1542,  1543,  1544,   708,   668,   669,     0,     0,
       0,     0,     0,     0,     0,     0,  2910,  2911,     0,     0,
       0,     0,     0,     0,     0,  1548,   732,    86,    87,    88,
     684,    90,    91,    92,   685,     0,   686,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   733,   104,   105,   687,
     734,     0,   107,   108,   109,   110,   735,   736,   112,   113,
     114,   115,     0,   116,   737,   738,   688,   689,     0,     0,
       0,   690,   691,     0,     0,     0,     0,   692,     0,     0,
       0,     0,     0,     0,     0,     0,   693,     0,   694,     0,
     695,   696,    35,   418,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1480,  1481,  1482,    45,  1483,     0,
       0,     0,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,   429,     0,     0,     0,     0,  1484,     0,
       0,   430,   431,     0,   432,   433,   133,   434,   435,   436,
   -2681,  1485,   137,  1486,  1487,     0,   437,   438,   439,   440,
     441,  1488,  1489,   442,   443,  1490,  1491,   444,     0,   445,
     446,   447,   448,  1492,     0,  1493,     0,   449,   450,   451,
     452,   148,   453,   699,     0,   454,   455,   456,   457,   458,
     459,     0,   151,   460,  5130,  1494,  1495,  1496,  1497,  1498,
    1499,  1500,   461,   462,   463,   464,   701,   465,  1501,  1502,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,  1503,   479,   480,
       0,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,   489,   490,  1504,   491,   492,   493,  1505,  1506,   494,
       0,   495,   496,  1507,   497,     0,   498,     0,   499,   169,
       0,   170,   500,   501,   502,     0,   503,  1508,     0,   504,
       0,   505,   506,   703,   507,   508,     0,   509,   510,   511,
       0,   512,   513,   514,   515,   516,   517,     0,   518,   174,
     175,     0,   519,   520,   521,  1509,  1510,     0,  1511,     0,
     522,   178,   179,   523,   180,   524,   525,   526,   527,   528,
       0,   529,   530,     0,   531,  1512,   182,   532,     0,     0,
     533,   534,   535,  1513,  1514,   536,   537,   538,   539,   540,
     541,   704,   542,   543,   705,   544,   545,   546,  1515,   189,
    1516,   547,   548,   191,     0,   549,   550,   193,   551,  1518,
    1519,   552,  1520,   553,   554,   555,     0,   556,     0,     0,
    1521,   558,   559,     0,     0,   560,   196,   197,   561,   198,
    1522,   562,   563,   564,   565,   566,   567,   568,     0,   569,
    1523,   570,   201,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,  1524,   582,   583,   584,   585,
       0,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,   210,   599,   600,  1525,   601,
     602,   603,   604,   605,   606,   706,   607,     0,   608,   609,
     610,   611,   612,  1526,   613,   217,   614,   615,     0,   616,
    1527,   617,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,  1528,     0,   628,   629,     0,   630,   631,
     632,   633,   634,   635,     0,  1529,  1530,     0,     0,   637,
    1531,   638,  1532,  1533,   639,   640,   641,   642,  5131,   644,
     645,     0,  1534,   646,   647,   648,   649,   650,  1535,     0,
     651,   652,   653,   654,   655,   707,  1536,     0,   656,   235,
     657,   658,   659,   660,     0,     0,   661,     0,     0,   662,
     663,   664,   665,   666,   667,   237,  1537,  1538,  1539,  1540,
    1541,  1542,  1543,  1544,   708,   668,   669,     0,     0,     0,
       0,     0,     0,     0,     0,  1545,  1546,     0,     0,     0,
       0,     0,     0,     0,  1548,   732,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   733,   104,   105,   687,   734,
       0,   107,   108,   109,   110,   735,   736,   112,   113,   114,
     115,     0,   116,   737,   738,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1480,  1481,     0,    45,  1483,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,  1484,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,   135,
    1485,   137,  1486,  1487,     0,   437,   438,   439,   440,   441,
    1488,  1489,   442,   443,  1490,  1491,   444,     0,   445,   446,
     447,   448,  1492,     0,  1493,     0,   449,   450,   451,   452,
     148,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,  1494,  1495,  1496,  1497,  1498,  1499,
    1500,   461,   462,   463,   464,   701,   465,  1501,  1502,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,  1503,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,  1504,   491,   492,   493,  1505,  1506,   494,     0,
     495,   496,  1507,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,  1508,     0,   504,     0,
     505,   506,   703,   507,   508,   173,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,   175,
       0,   519,   520,   521,  1509,  1510,     0,  1511,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,  1512,   182,   532,   183,     0,   533,
     534,   535,  1513,  1514,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,  1515,   189,  1516,
     547,   548,   191,     0,   549,   550,   193,   551,  1518,  1519,
     552,  1520,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,   197,   561,   198,  1522,
     562,   563,   564,   565,   566,   567,   568,     0,   569,  1523,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,  1524,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,  1525,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,  1526,   613,   217,   614,   615,   219,   616,  1527,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,  1528,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,  1529,  1530,     0,     0,   637,  1531,
     638,  1532,  1533,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,  1535,     0,   651,
     652,   653,   654,   655,   707,  1536,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,  1537,  1538,  1539,  1540,  1541,
    1542,  1543,  1544,   708,   668,   669,     0,     0,     0,     0,
     732,    86,    87,    88,   684,    90,    91,    92,   685,     0,
     686,    95,     0,  1548,    98,    99,   100,   101,   102,   103,
     733,   104,   105,   687,   734,     0,   107,   108,   109,   110,
     735,   736,   112,   113,   114,   115,     0,   116,   737,   738,
     688,   689,     0,     0,     0,   690,   691,     0,     0,     0,
       0,   692,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,   694,     0,   695,   696,    35,   418,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1480,  1481,
       0,    45,  1483,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,   429,     0,     0,
       0,     0,  1484,     0,     0,   430,   431,     0,   432,   433,
     133,   434,   435,   436,   135,  1485,   137,  1486,  1487,     0,
    4127,   438,   439,   440,   441,  1488,  1489,   442,   443,  1490,
    1491,   444,     0,   445,   446,   447,   448,  1492,     0,  1493,
       0,   449,   450,   451,   452,   148,   453,   699,     0,   454,
     455,   456,   457,   458,   459,     0,   151,   460,     0,  1494,
    1495,  1496,  1497,  1498,  1499,  1500,   461,   462,   463,   464,
     701,   465,  1501,  1502,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,  1503,   479,   480,     0,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,   489,   490,  1504,   491,   492,
     493,  1505,  1506,   494,     0,   495,   496,  1507,   497,     0,
     498,     0,   499,   169,     0,   170,   500,   501,   502,     0,
     503,  1508,     0,   504,     0,   505,   506,   703,   507,   508,
     173,   509,   510,   511,     0,   512,   513,   514,   515,   516,
     517,     0,   518,   174,   175,     0,   519,   520,   521,  1509,
    1510,     0,  1511,     0,   522,   178,   179,   523,   180,   524,
     525,   526,   527,   528,     0,   529,   530,     0,   531,  1512,
     182,   532,   183,     0,   533,   534,   535,  1513,  1514,   536,
     537,   538,   539,   540,   541,   704,   542,   543,   705,   544,
     545,   546,  1515,   189,  1516,   547,   548,   191,     0,   549,
     550,   193,   551,  1518,  1519,   552,  1520,   553,   554,   555,
       0,   556,     0,     0,   557,   558,   559,     0,     0,   560,
     196,   197,   561,   198,  1522,   562,   563,   564,   565,   566,
     567,   568,     0,   569,  1523,   570,   201,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,  1524,
     582,   583,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,   210,
     599,   600,  1525,   601,   602,   603,   604,   605,   606,   706,
     607,     0,   608,   609,   610,   611,   612,  1526,   613,   217,
     614,   615,   219,   616,  1527,   617,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,  1528,     0,   628,
     629,     0,   630,   631,   632,   633,   634,   635,     0,  1529,
    1530,     0,     0,   637,  1531,   638,  1532,  1533,   639,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,   650,  1535,     0,   651,   652,   653,   654,   655,   707,
    1536,     0,   656,   235,   657,   658,   659,   660,     0,     0,
     661,     0,     0,   662,   663,   664,   665,   666,   667,   237,
    1537,  1538,  1539,  1540,  1541,  1542,  1543,  1544,   708,   668,
     669,     0,     0,     0,     0,   732,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,  1548,    98,
      99,   100,   101,   102,   103,   733,   104,   105,   687,   734,
       0,   107,   108,   109,   110,   735,   736,   112,   113,   114,
     115,     0,   116,   737,   738,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1480,  1481,  1482,    45,  1483,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,  1484,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,     0,
    1485,   137,  1486,  1487,     0,   437,   438,   439,   440,   441,
    1488,  1489,   442,   443,  1490,  1491,   444,     0,   445,   446,
     447,   448,  1492,     0,  1493,     0,   449,   450,   451,   452,
     148,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,  1494,  1495,  1496,  1497,  1498,  1499,
    1500,   461,   462,   463,   464,   701,   465,  1501,  1502,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,  1503,   479,   480,     0,
     481,   482,   483,     0,   484,     0,   486,     0,   487,   488,
     489,   490,  1504,   491,   492,   493,  1505,  1506,   494,     0,
     495,   496,  1507,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,  1508,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,   175,
       0,   519,   520,   521,  1509,  1510,     0,  1511,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,  1512,   182,   532,     0,     0,   533,
     534,   535,  1513,  1514,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,  1515,   189,  1516,
     547,   548,   191,     0,   549,   550,   193,   551,  1518,  1519,
     552,  1520,   553,   554,   555,     0,   556,     0,     0,  1521,
     558,   559,     0,     0,   560,   196,   197,   561,   198,  1522,
     562,   563,   564,   565,   566,   567,   568,     0,   569,  1523,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,  1524,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,  1525,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,  1526,   613,   217,   614,   615,     0,   616,  1527,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,  1528,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,  1529,  1530,     0,     0,   637,  1531,
     638,  1532,  1533,   639,   640,   641,   642,   643,   644,   645,
       0,  1534,   646,   647,   648,   649,   650,  1535,     0,   651,
     652,   653,   654,   655,   707,  1536,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,  1537,  1538,  1539,  1540,  1541,
    1542,  1543,  1544,   708,   668,   669,     0,     0,     0,     0,
       0,     0,     0,     0,  1545,  1546,     0,     0,     0,     0,
       0,     0,     0,  1548,   732,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   733,   104,   105,   687,   734,     0,
     107,   108,   109,   110,   735,   736,   112,   113,   114,   115,
       0,   116,   737,   738,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,   418,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1480,  1481,  1482,    45,  1483,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,  1484,     0,     0,   430,
     431,     0,   432,   433,   133,   434,   435,   436,     0,  1485,
     137,  1486,  1487,     0,   437,   438,   439,   440,   441,  1488,
    1489,   442,   443,  1490,  1491,   444,     0,   445,   446,   447,
     448,  1492,     0,  1493,     0,   449,   450,   451,   452,   148,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
     151,   460,     0,  1494,  1495,  1496,  1497,  1498,  1499,  1500,
     461,   462,   463,   464,   701,   465,  1501,  1502,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,  1503,   479,   480,     0,   481,
     482,   483,     0,   484,     0,   486,     0,   487,   488,   489,
     490,  1504,   491,   492,   493,  1505,  1506,   494,     0,   495,
     496,  1507,   497,     0,   498,     0,   499,   169,     0,   170,
     500,   501,   502,     0,   503,  1508,     0,   504,     0,   505,
     506,   703,   507,   508,     0,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,   174,   175,     0,
     519,   520,   521,  1509,  1510,     0,  1511,     0,   522,   178,
     179,   523,   180,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,  1512,   182,   532,     0,     0,   533,   534,
     535,  1513,  1514,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,  1515,   189,  1516,   547,
     548,   191,     0,   549,   550,   193,   551,  1518,  1519,   552,
    1520,   553,   554,   555,     0,   556,     0,     0,  1521,   558,
     559,     0,     0,   560,   196,   197,   561,   198,  1522,   562,
     563,   564,   565,   566,   567,   568,     0,   569,  1523,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,  1524,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,   210,   599,   600,  1525,   601,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,  1526,   613,   217,   614,   615,     0,   616,  1527,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1528,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,  1529,  1530,     0,     0,   637,  1531,   638,
    1532,  1533,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,  1535,     0,   651,   652,
     653,   654,   655,   707,  1536,     0,   656,   235,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,   237,  1537,  1538,  1539,  1540,  1541,  1542,
    1543,  1544,   708,   668,   669,     0,     0,     0,     0,     0,
       0,     0,     0,  2910,  2911,     0,     0,     0,     0,     0,
       0,     0,  1548,   732,    86,    87,    88,   684,    90,    91,
      92,   685,     0,   686,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   733,   104,   105,   687,   734,     0,   107,
     108,   109,   110,   735,   736,   112,   113,   114,   115,     0,
     116,   737,   738,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,   135,   136,   137,
     138,   139,     0,   437,   438,   439,   440,   441,     0,  1489,
     442,   443,   698,   140,   444,     0,   445,   446,   447,   448,
    1492,     0,  1493,     0,   449,   450,   451,   452,   148,   453,
     699,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,  1494,  1495,  1496,  1497,  1498,  1499,  1500,   461,
     462,   463,   464,   701,   465,   155,   156,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
     164,   491,   492,   493,  1505,     0,   494,     0,   495,   496,
     168,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1508,     0,   504,     0,   505,   506,
     703,   507,   508,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,   175,     0,   519,
     520,   521,     0,   176,     0,   177,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,  3655,   529,   530,
       0,   531,  1512,   182,   532,   183,     0,   533,   534,   535,
    1513,  1514,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,   188,   189,   190,   547,   548,
     191,     0,   549,   550,   193,   551,     0,  1519,   552,   195,
     553,   554,   555,     0,   556,     0,  1092,   557,   558,   559,
       0,     0,   560,   196,   197,   561,   198,  1522,   562,   563,
     564,   565,   566,   567,   568,     0,   569,  1523,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   203,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,   212,  3656,   602,   603,   604,
     605,   606,   706,   607,   215,   608,   609,   610,   611,   612,
    1526,   613,   217,   614,   615,   219,   616,   220,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
    1528,     0,   628,   629,   223,   630,   631,   632,   633,   634,
     635,     0,   224,   225,     0,     0,   637,  1531,   638,  1532,
       0,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,  1535,     0,   651,   652,   653,
     654,   655,  2205,   234,     0,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,   236,   662,   663,   664,   665,
     666,   667,   237,  1537,  1538,  1539,  1540,  1541,  1542,  1543,
    1544,   708,   668,   669,     0,     0,     0,     0,   732,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,  3657,    98,    99,   100,   101,   102,   103,   733,   104,
     105,   687,   734,     0,   107,   108,   109,   110,   735,   736,
     112,   113,   114,   115,     0,   116,   737,   738,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
       0,     0,     0,   430,   431,     0,   432,   433,   133,   434,
     435,   436,   135,   136,   137,   138,   139,     0,   437,   438,
     439,   440,   441,     0,  1489,   442,   443,   698,   140,   444,
       0,   445,   446,   447,   448,  1492,     0,  1493,     0,   449,
     450,   451,   452,   148,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0,   151,   460,     0,  1494,  1495,  1496,
    1497,  1498,  1499,  1500,   461,   462,   463,   464,   701,   465,
     155,   156,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,   164,   491,   492,   493,  1505,
       0,   494,     0,   495,   496,   168,   497,     0,   498,     0,
     499,   169,     0,   170,   500,   501,   502,     0,   503,  1508,
       0,   504,     0,   505,   506,   703,   507,   508,   173,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518,   174,   175,     0,   519,   520,   521,     0,   176,     0,
     177,     0,   522,   178,   179,   523,   180,   524,   525,   526,
     527,   528,  3655,   529,   530,     0,   531,  1512,   182,   532,
     183,     0,   533,   534,   535,  1513,  1514,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
     188,   189,   190,   547,   548,   191,     0,   549,   550,   193,
     551,     0,  1519,   552,   195,   553,   554,   555,     0,   556,
       0,  1092,   557,   558,   559,     0,     0,   560,   196,   197,
     561,   198,  1522,   562,   563,   564,   565,   566,   567,   568,
       0,   569,  1523,   570,   201,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   203,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,   210,   599,   600,
     212,  3656,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,  1526,   613,   217,   614,   615,
     219,   616,   220,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,  1528,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,   224,   225,     0,
       0,   637,  1531,   638,  1532,     0,   639,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,   650,
    1535,     0,   651,   652,   653,   654,   655,   707,   234,     0,
     656,   235,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,   237,  1537,  1538,
    1539,  1540,  1541,  1542,  1543,  1544,   708,   668,   669,     0,
       0,     0,     0,   732,    86,    87,    88,   684,    90,    91,
      92,   685,     0,   686,    95,     0,  3657,    98,    99,   100,
     101,   102,   103,   733,   104,   105,   687,   734,     0,   107,
     108,   109,   110,   735,   736,   112,   113,   114,   115,     0,
     116,   737,   738,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,   135,   136,   137,
     138,   139,     0,   437,   438,   439,   440,   441,     0,  1489,
     442,   443,   698,   140,   444,     0,   445,   446,   447,   448,
    1492,     0,  1493,     0,   449,   450,   451,   452,   148,   453,
     699,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,  1494,  1495,  1496,  1497,  1498,  1499,  1500,   461,
     462,   463,   464,   701,   465,   155,   156,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
     164,   491,   492,   493,  1505,     0,   494,     0,   495,   496,
     168,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1508,     0,   504,     0,   505,   506,
     703,   507,   508,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,   175,     0,   519,
     520,   521,     0,   176,     0,   177,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,  1512,   182,   532,   183,     0,   533,   534,   535,
    1513,  1514,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,   188,   189,   190,   547,   548,
     191,     0,   549,   550,   193,   551,     0,  1519,   552,   195,
     553,   554,   555,     0,   556,     0,     0,   557,   558,   559,
       0,     0,   560,   196,   197,   561,   198,  1522,   562,   563,
     564,   565,   566,   567,   568,     0,   569,  1523,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   203,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,   212,  3656,   602,   603,   604,
     605,   606,   706,   607,     0,   608,   609,   610,   611,   612,
    1526,   613,   217,   614,   615,   219,   616,   220,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
    1528,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,   224,   225,     0,     0,   637,  1531,   638,  1532,
       0,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,  1535,     0,   651,   652,   653,
     654,   655,   707,   234,     0,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,   237,  1537,  1538,  1539,  1540,  1541,  1542,  1543,
    1544,   708,   668,   669,     0,     0,     0,     0,   732,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,   246,    98,    99,   100,   101,   102,   103,   733,   104,
     105,   687,   734,     0,   107,   108,   109,   110,   735,   736,
     112,   113,   114,   115,     0,   116,   737,   738,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
       0,     0,     0,   430,   431,     0,   432,   433,   133,   434,
     435,   436,   135,   136,   137,   138,   139,     0,   437,   438,
     439,   440,   441,     0,  1489,   442,   443,   698,   140,   444,
       0,   445,   446,   447,   448,  1492,     0,  1493,     0,   449,
     450,   451,   452,   148,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0,   151,   460,     0,  1494,  1495,  1496,
    1497,  1498,  1499,  1500,   461,   462,   463,   464,   701,   465,
     155,   156,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,   164,   491,   492,   493,  1505,
       0,   494,     0,   495,   496,   168,   497,     0,   498,     0,
     499,   169,     0,   170,   500,   501,   502,     0,   503,  1508,
       0,   504,     0,   505,   506,   703,   507,   508,   173,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518,   174,   175,     0,   519,   520,   521,     0,   176,     0,
     177,     0,   522,   178,   179,   523,   180,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,  1512,   182,   532,
     183,     0,   533,   534,   535,  1513,  1514,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
     188,   189,   190,   547,   548,   191,     0,   549,   550,   193,
     551,     0,  1519,   552,   195,   553,   554,   555,     0,   556,
       0,     0,   557,   558,   559,     0,     0,   560,   196,   197,
     561,   198,  1522,   562,   563,   564,   565,   566,   567,   568,
       0,   569,  1523,   570,   201,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   203,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,   210,   599,   600,
     212,   601,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,  1526,   613,   217,   614,   615,
     219,   616,   220,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,  1528,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,   224,   225,     0,
       0,   637,  1531,   638,  1532,     0,   639,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,   650,
    1535,     0,   651,   652,   653,   654,   655,   707,   234,     0,
     656,   235,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,   237,  1537,  1538,
    1539,  1540,  1541,  1542,  1543,  1544,   708,   668,   669,     0,
       0,     0,     0,   732,    86,    87,    88,   684,    90,    91,
      92,   685,     0,   686,    95,     0,  4252,    98,    99,   100,
     101,   102,   103,   733,   104,   105,   687,   734,     0,   107,
     108,   109,   110,   735,   736,   112,   113,   114,   115,     0,
     116,   737,   738,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,   135,   136,   137,
     138,   139,     0,   437,   438,   439,   440,   441,     0,     0,
     442,   443,   698,   140,   444,     0,   445,   446,   447,   448,
     144,     0,   145,     0,   449,   450,   451,   452,   148,   453,
     699,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,     0,     0,     0,   152,     0,     0,     0,   461,
     462,   463,   464,   701,   465,   155,   156,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
     164,   491,   492,   493,   166,     0,   494,     0,   495,   496,
     168,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     703,   507,   508,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,   175,     0,   519,
     520,   521,     0,   176,     0,   177,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,   181,   182,   532,   183,     0,   533,   534,   535,
       0,     0,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,   188,   189,   190,   547,   548,
     191,     0,   549,   550,   193,   551,     0,   194,   552,   195,
     553,   554,   555,     0,   556,     0,     0,   557,   558,   559,
       0,     0,   560,   196,   197,   561,   198,   199,   562,   563,
     564,   565,   566,   567,   568,     0,   569,   200,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   203,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,   212,   601,   602,   603,   604,
     605,   606,   706,   607,     0,   608,   609,   610,   611,   612,
       0,   613,   217,   614,   615,   219,   616,   220,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,   224,   225,     0,     0,   637,   226,   638,   227,
       0,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,   655,   707,   234,     0,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   708,   668,   669,     0,     0,     0,     0,     0,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,  4853,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   687,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
       0,  4179,     0,   430,   431,     0,   432,   433,     0,   434,
     435,   436,   135,   136,     0,   138,   139,     0,   437,   438,
     439,   440,   441,     0,     0,   442,   443,   698,   140,   444,
       0,   445,   446,   447,   448,   144,     0,     0,     0,   449,
     450,   451,   452,     0,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0, -1513,   460,     0,     0,     0,     0,
       0,     0,     0,     0,   461,   462,   463,   464,   701,   465,
     155,   156,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,   164,   491,   492,   493,   166,
       0,   494,     0,   495,   496,   168,   497,     0,   498,     0,
     499,     0,     0, -1513,   500,   501,   502,     0,   503,   172,
       0,   504,     0,   505,   506,   703,   507,   508,     0,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518, -1513,   175,     0,   519,   520,   521,     0,   176,     0,
     177,     0,   522,     0,     0,   523, -1513,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,   181, -1513,   532,
       0,     0,   533,   534,   535,     0,     0,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
     188, -1513,   190,   547,   548,   191,     0,   549,   550,     0,
     551,     0,   194,   552,   195,   553,   554,   555,     0,   556,
       0,     0,   557,   558,   559,     0,     0,   560,   196,     0,
     561,     0,   199,   562,   563,   564,   565,   566,   567,   568,
       0,   569,   200,   570,   201,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   203,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598, -1513,   599,   600,
     212,   601,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,     0,   613,   217,   614,   615,
       0,   616,   220,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,   224,   225,     0,
       0,   637,   226,   638,   227,     0,   639,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,   650,
       0,     0,   651,   652,   653,   654,   655,   707,   234,     0,
     656,     0,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   708,   668,   669,     0,
       0,     0,     0,     0,     0,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,  1642,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   687,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,     0,     0,     0,    37,    38,    39,    40,    41,    42,
       0,    44,     0,     0,     0,    45,     0,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,     0,     0,     0,   430,
     431,     0,   432,   433,     0,   434,   435,   436,   135,   136,
       0,   138,   139,     0,   437,   438,   439,   440,   441,     0,
       0,   442,   443,   698,   140,   444,     0,   445,   446,   447,
     448,   144,     0,     0,     0,   449,   450,   451,   452,     0,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
       0,   460,     0,     0,     0,     0,     0,     0,     0,     0,
     461,   462,   463,   464,   701,   465,   155,   156,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,   164,   491,   492,   493,   166,     0,   494,     0,   495,
     496,   168,   497,     0,   498,     0,   499,     0,     0,     0,
     500,   501,   502,     0,   503,   172,     0,   504,     0,   505,
     506,   703,   507,   508,     0,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,     0,   175,     0,
     519,   520,   521,     0,   176,     0,   177,     0,   522,     0,
       0,   523,     0,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,   181,     0,   532,     0,     0,   533,   534,
     535,     0,     0,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,   188,     0,   190,   547,
     548,   191,     0,   549,   550,     0,   551,     0,   194,   552,
     195,   553,   554,   555,     0,   556,     0,     0,   557,   558,
     559,     0,     0,   560,   196,     0,   561,     0,   199,   562,
     563,   564,   565,   566,   567,   568,     0,   569,   200,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   203,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,     0,   599,   600,   212,   601,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,     0,   613,   217,   614,   615,     0,   616,   220,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   222,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,   224,   225,     0,     0,   637,   226,   638,
     227,     0,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,     0,     0,   651,   652,
     653,   654,   655,   707,   234,     0,   656,     0,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   708,   668,   669,     0,     0,     0,     0,     0,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,  3940,  3941,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,    37,
      38,    39,    40,    41,    42,     0,    44,     0,     0,     0,
      45,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
       0,     0,     0,     0,     0,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,  3941,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   687,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,   418,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,     0,     0,     0,   430,
     431,     0,   432,   433,     0,   434,   435,   436,   135,   136,
       0,   138,   139,     0,   437,   438,   439,   440,   441,     0,
       0,   442,   443,   698,   140,   444,     0,   445,   446,   447,
     448,   144,     0,     0,     0,   449,   450,   451,   452,     0,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
       0,   460,     0,     0,     0,     0,     0,     0,     0,     0,
     461,   462,   463,   464,   701,   465,   155,   156,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,   164,   491,   492,   493,   166,     0,   494,     0,   495,
     496,   168,   497,     0,   498,     0,   499,     0,     0,     0,
     500,   501,   502,     0,   503,   172,     0,   504,     0,   505,
     506,   703,   507,   508,     0,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,     0,   175,     0,
     519,   520,   521,     0,   176,     0,   177,     0,   522,     0,
       0,   523,     0,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,   181,     0,   532,     0,     0,   533,   534,
     535,     0,     0,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,   188,     0,   190,   547,
     548,   191,     0,   549,   550,     0,   551,     0,   194,   552,
     195,   553,   554,   555,     0,   556,     0,     0,   557,   558,
     559,     0,     0,   560,   196,     0,   561,     0,   199,   562,
     563,   564,   565,   566,   567,   568,     0,   569,   200,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   203,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,     0,   599,   600,   212,   601,   602,   603,
     604,   605,   606,   706,   607,   215,   608,   609,   610,   611,
     612,     0,   613,   217,   614,   615,     0,   616,   220,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   222,     0,   628,   629,   223,   630,   631,   632,   633,
     634,   635,     0,   224,   225,     0,     0,   637,   226,   638,
     227,     0,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,     0,     0,   651,   652,
     653,   654,   655,  2205,   234,     0,   656,     0,   657,   658,
     659,   660,     0,     0,   661,     0,   236,   662,   663,   664,
     665,   666,   667,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   708,   668,   669,     0,     0,     0,     0,     0,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,   246,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
     215,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
     223,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,  2205,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,   236,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
       0,     0,     0,     0,     0,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,   246,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   687,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,     0,     0,     0,   430,
     431,     0,   432,   433,     0,   434,   435,   436,   135,   136,
       0,   138,   139,     0,   437,   438,   439,   440,   441,     0,
       0,   442,   443,   698,   140,   444,     0,   445,   446,   447,
     448,   144,     0,     0,     0,   449,   450,   451,   452,     0,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
       0,   460,     0,     0,     0,     0,     0,     0,     0,     0,
     461,   462,   463,   464,   701,   465,   155,   156,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,   164,   491,   492,   493,   166,     0,   494,     0,   495,
     496,   168,   497,     0,   498,     0,   499,     0,     0,     0,
     500,   501,   502,     0,   503,   172,     0,   504,     0,   505,
     506,   703,   507,   508,     0,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,     0,   175,     0,
     519,   520,   521,     0,   176,     0,   177,     0,   522,     0,
       0,   523,     0,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,   181,     0,   532,     0,     0,   533,   534,
     535,     0,     0,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,   188,     0,   190,   547,
     548,   191,     0,   549,   550,     0,   551,     0,   194,   552,
     195,   553,   554,   555,     0,   556,     0,     0,   557,   558,
     559,     0,     0,   560,   196,     0,   561,     0,   199,   562,
     563,   564,   565,   566,   567,   568,     0,   569,   200,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   203,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,     0,   599,   600,   212,   601,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,     0,   613,   217,   614,   615,     0,   616,   220,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   222,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,   224,   225,     0,     0,   637,   226,   638,
     227,     0,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,     0,     0,   651,   652,
     653,   654,   655,   707,   234,     0,   656,     0,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   708,   668,   669,     0,     0,     0,     0,     0,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,  1617,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
       0,     0,     0,     0,     0,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,  3073,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   687,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,     0,     0,     0,   430,
     431,     0,   432,   433,     0,   434,   435,   436,   135,   136,
       0,   138,   139,     0,   437,   438,   439,   440,   441,     0,
       0,   442,   443,   698,   140,   444,     0,   445,   446,   447,
     448,   144,     0,     0,     0,   449,   450,   451,   452,     0,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
       0,   460,     0,     0,     0,     0,     0,     0,     0,     0,
     461,   462,   463,   464,   701,   465,   155,   156,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,   164,   491,   492,   493,   166,     0,   494,     0,   495,
     496,   168,   497,     0,   498,     0,   499,     0,     0,     0,
     500,   501,   502,     0,   503,   172,     0,   504,     0,   505,
     506,   703,   507,   508,     0,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,     0,   175,     0,
     519,   520,   521,     0,   176,     0,   177,     0,   522,     0,
       0,   523,     0,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,   181,     0,   532,     0,     0,   533,   534,
     535,     0,     0,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,   188,     0,   190,   547,
     548,   191,     0,   549,   550,     0,   551,     0,   194,   552,
     195,   553,   554,   555,     0,   556,     0,     0,   557,   558,
     559,     0,     0,   560,   196,     0,   561,     0,   199,   562,
     563,   564,   565,   566,   567,   568,     0,   569,   200,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   203,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,     0,   599,   600,   212,   601,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,     0,   613,   217,   614,   615,     0,   616,   220,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   222,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,   224,   225,     0,     0,   637,   226,   638,
     227,     0,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,     0,     0,   651,   652,
     653,   654,   655,   707,   234,     0,   656,     0,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   708,   668,   669,     0,     0,     0,     0,     0,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,  4163,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
       0,     0,     0,     0,   732,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,  4576,    98,    99,
     100,   101,   102,   103,   733,   104,   105,   687,   734,     0,
     107,   108,   109,   110,   735,   736,   112,   113,   114,   115,
       0,   116,   737,   738,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,   418,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,     0,     0,  1216,    45,     0,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,   739,   427,
     428,   429,   740,   741,   742,   743,   744,   745,   746,   430,
     431,   747,   432,   433,   133,   434,   435,   436,     0,  1915,
     137,  1916,  1917,   748,   437,   438,   439,   440,   441,   749,
     750,   442,   443,  1918,  1919,   444,   752,   445,   446,   447,
     448,     0,   753,   145,   754,   449,   450,   451,   452,   148,
     453,   699,   756,   454,   455,   456,   457,   458,   459,   757,
     151,   460,     0,   759,   760,   761,   152,   762,   763,   764,
     461,   462,   463,   464,   701,   465,  1920,  1921,   466,   765,
     467,   766,   468,   469,   470,   471,   472,   767,   473,   474,
     475,   768,   769,   476,   477,  1503,   479,   480,   770,   481,
     482,   483,   771,   484,   485,   486,   772,   487,   488,   489,
     490,     0,   491,   492,   493,     0,   773,   494,   774,   495,
     496,  1922,   497,   775,   498,   776,   499,   169,   777,   170,
     500,   501,   502,   778,   503,     0,   779,   504,   780,   505,
     506,   703,   507,   508,   173,   509,   510,   511,   781,   512,
     513,   514,   515,   516,   517,   782,   518,   174,     0,     0,
     519,   520,   521,  1509,  1923,   785,  1924,   786,   522,   178,
     179,   523,   180,   524,   525,   526,   527,   528,   787,   529,
     530,   788,   531,     0,   182,   532,   183,   789,   533,   534,
     535,   790,   791,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,  1925,   189,  1926,   547,
     548,     0,   792,   549,   550,   193,   551,   793,     0,   552,
    1927,   553,   554,   555,   794,   556,   795,   796,  3927,   558,
     559,   797,   798,   560,     0,   197,   561,   198,     0,   562,
     563,   564,   565,   566,   567,   568,   799,   569,     0,   570,
       0,   571,   572,   573,   800,   574,   575,   576,   577,   578,
     579,   580,   581,  1928,   582,   583,   584,   585,   801,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
     802,   597,   598,   210,   599,   600,     0,   601,   602,   603,
     604,   605,   606,   706,   607,   803,   608,   609,   610,   611,
     612,   804,   613,  2412,   614,   615,   219,   616,  1930,   617,
     805,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,     0,   806,   628,   629,   807,   630,   631,   632,   633,
     634,   635,   808,  1931,  1932,     0,   810,   637,     0,   638,
       0,   811,   639,   640,   641,   642,   643,   644,   645,     0,
     813,   646,   647,   648,   649,   650,   814,   815,   651,   652,
     653,   654,   655,     0,  1933,   817,   656,   235,   657,   658,
     659,   660,   818,   819,   661,   820,   821,   662,   663,   664,
     665,   666,   667,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   708,   668,   669,     0,     0,     0,     0,  1219,
    1220,  1221,     0,  3928,  3929,  1224,  1225,  1226,  1227,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   687,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,  1216,     0,
       0,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
       0,     0,     0,   430,   431,     0,   432,   433,     0,   434,
     435,   436,   135,   136,     0,   138,   139,     0,   437,   438,
     439,   440,   441,     0,     0,   442,   443,   698,   140,   444,
       0,   445,  1217,   447,   448,   144,     0,     0,     0,   449,
     450,   451,   452,     0,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0,     0,   460,     0,     0,     0,     0,
       0,     0,     0,     0,   461,   462,   463,   464,   701,   465,
     155,   156,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,   164,   491,   492,   493,   166,
       0,  1218,     0,   495,   496,   168,   497,     0,   498,     0,
     499,     0,     0,     0,   500,   501,   502,     0,   503,   172,
       0,   504,     0,   505,   506,   703,   507,   508,     0,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518,     0,   175,     0,   519,   520,   521,     0,   176,     0,
     177,     0,   522,     0,     0,   523,     0,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,   181,     0,   532,
       0,     0,   533,   534,   535,     0,     0,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
     188,     0,   190,   547,   548,   191,     0,   549,   550,     0,
     551,     0,   194,   552,   195,   553,   554,   555,     0,   556,
       0,     0,   557,   558,   559,     0,     0,   560,   196,     0,
     561,     0,   199,   562,   563,   564,   565,   566,   567,   568,
       0,   569,   200,   570,   201,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   203,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,     0,   599,   600,
     212,   601,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,     0,   613,   217,   614,   615,
       0,   616,   220,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,   224,   225,     0,
       0,   637,   226,   638,   227,     0,   639,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,   650,
       0,     0,   651,   652,   653,   654,   655,   707,   234,     0,
     656,     0,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   708,   668,   669,     0,
       0,     0,     0,  1219,  1220,  1221,     0,  1222,  1223,  1224,
    1225,  1226,  1227,    86,    87,    88,   684,    90,    91,    92,
     685,     0,   686,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   687,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   688,   689,     0,     0,     0,   690,   691,     0,
       0,     0,     0,   692,     0,     0,     0,     0,     0,     0,
       0,     0,   693,     0,   694,     0,   695,   696,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,  1216,     0,     0,     0,     0,     0,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,   429,
       0,     0,     0,     0,     0,     0,     0,   430,   431,     0,
     432,   433,     0,   434,   435,   436,   135,   136,     0,   138,
     139,     0,   437,   438,   439,   440,   441,     0,     0,   442,
     443,   698,   140,   444,     0,   445,  1311,   447,   448,   144,
       0,     0,     0,   449,   450,   451,   452,     0,   453,   699,
       0,   454,   455,   456,   457,   458,   459,     0,     0,   460,
       0,     0,     0,     0,     0,     0,     0,     0,   461,   462,
     463,   464,   701,   465,   155,   156,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,   489,   490,   164,
     491,   492,   493,   166,     0,  1312,     0,   495,   496,   168,
     497,     0,   498,     0,   499,     0,     0,     0,   500,   501,
     502,     0,   503,   172,     0,   504,     0,   505,   506,   703,
     507,   508,     0,   509,   510,   511,     0,   512,   513,   514,
     515,   516,   517,     0,   518,     0,   175,     0,   519,   520,
     521,     0,   176,     0,   177,     0,   522,     0,     0,   523,
       0,   524,   525,   526,   527,   528,     0,   529,   530,     0,
     531,   181,     0,   532,     0,     0,   533,   534,   535,     0,
       0,   536,   537,   538,   539,   540,   541,   704,   542,   543,
     705,   544,   545,   546,   188,     0,   190,   547,   548,   191,
       0,   549,   550,     0,   551,     0,   194,   552,   195,   553,
     554,   555,     0,   556,     0,     0,   557,   558,   559,     0,
       0,   560,   196,     0,   561,     0,   199,   562,   563,   564,
     565,   566,   567,   568,     0,   569,   200,   570,   201,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   203,   582,   583,   584,   585,     0,   586,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,     0,   599,   600,   212,   601,   602,   603,   604,   605,
     606,   706,   607,     0,   608,   609,   610,   611,   612,     0,
     613,   217,   614,   615,     0,   616,   220,   617,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
       0,   628,   629,     0,   630,   631,   632,   633,   634,   635,
       0,   224,   225,     0,     0,   637,   226,   638,   227,     0,
     639,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,   650,     0,     0,   651,   652,   653,   654,
     655,   707,   234,     0,   656,     0,   657,   658,   659,   660,
       0,     0,   661,     0,     0,   662,   663,   664,   665,   666,
     667,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     708,   668,   669,     0,     0,     0,     0,  1219,  1220,  1221,
       0,  1222,  1223,  1224,  1225,  1226,  1227,    86,    87,    88,
     684,    90,    91,    92,   685,     0,   686,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   687,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   688,   689,     0,     0,
       0,   690,   691,     0,     0,     0,     0,   692,     0,     0,
       0,     0,     0,     0,     0,     0,   693,     0,   694,     0,
     695,   696,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,  1216,     0,     0,     0,
       0,     0,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,   429,     0,     0,     0,     0,     0,     0,
       0,   430,   431,     0,   432,   433,     0,   434,   435,   436,
     135,   136,     0,   138,   139,     0,   437,   438,   439,   440,
     441,     0,     0,   442,   443,   698,   140,   444,     0,   445,
    1368,   447,   448,   144,     0,     0,     0,   449,   450,   451,
     452,     0,   453,   699,     0,   454,   455,   456,   457,   458,
     459,     0,     0,   460,     0,     0,     0,     0,     0,     0,
       0,     0,   461,   462,   463,   464,   701,   465,   155,   156,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,   489,   490,   164,   491,   492,   493,   166,     0,  1369,
       0,   495,   496,   168,   497,     0,   498,     0,   499,     0,
       0,     0,   500,   501,   502,     0,   503,   172,     0,   504,
       0,   505,   506,   703,   507,  1370,     0,   509,   510,   511,
       0,   512,   513,   514,   515,   516,   517,     0,   518,     0,
     175,     0,   519,   520,   521,     0,   176,     0,   177,     0,
     522,     0,     0,   523,     0,   524,   525,   526,   527,   528,
       0,   529,   530,     0,   531,   181,     0,   532,     0,     0,
     533,   534,   535,     0,     0,   536,   537,   538,   539,   540,
     541,   704,   542,   543,   705,   544,   545,   546,   188,     0,
     190,   547,   548,   191,     0,   549,   550,     0,   551,     0,
     194,   552,   195,   553,   554,   555,     0,   556,     0,     0,
     557,   558,   559,     0,     0,   560,   196,     0,   561,     0,
     199,   562,   563,   564,   565,   566,   567,   568,     0,   569,
     200,   570,   201,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   203,   582,   583,   584,   585,
       0,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,     0,   599,   600,   212,   601,
     602,   603,   604,   605,   606,   706,   607,     0,   608,   609,
     610,   611,   612,     0,   613,   217,   614,   615,     0,   616,
     220,   617,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   222,     0,   628,   629,     0,   630,   631,
     632,   633,   634,   635,     0,   224,   225,     0,     0,   637,
     226,   638,   227,     0,   639,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,   650,     0,     0,
     651,   652,   653,   654,   655,   707,   234,     0,   656,     0,
     657,   658,   659,   660,     0,     0,   661,     0,     0,   662,
     663,   664,   665,   666,   667,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   708,   668,   669,     0,     0,     0,
       0,  1219,  1220,  1221,     0,  1222,  1223,  1224,  1225,  1226,
    1227,    86,    87,    88,   684,    90,    91,    92,   685,     0,
     686,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   687,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     688,   689,     0,     0,     0,   690,   691,     0,     0,     0,
       0,   692,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,   694,     0,   695,   696,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
    1216,     0,     0,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,   429,     0,     0,
       0,     0,     0,     0,     0,   430,   431,     0,   432,   433,
       0,   434,   435,   436,   135,   136,     0,   138,   139,     0,
     437,   438,   439,   440,   441,     0,     0,   442,   443,   698,
     140,   444,     0,   445,  1900,   447,   448,   144,     0,     0,
       0,   449,   450,   451,   452,     0,   453,   699,     0,   454,
     455,   456,   457,   458,   459,     0,     0,   460,     0,     0,
       0,     0,     0,     0,     0,     0,   461,   462,   463,   464,
     701,   465,   155,   156,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,   489,   490,   164,   491,   492,
     493,   166,     0,  1901,     0,   495,   496,   168,   497,     0,
     498,     0,   499,     0,     0,     0,   500,   501,   502,     0,
     503,   172,     0,   504,     0,   505,   506,   703,   507,   508,
       0,   509,   510,   511,     0,   512,   513,   514,   515,   516,
     517,     0,   518,     0,   175,     0,   519,   520,   521,     0,
     176,     0,   177,     0,   522,     0,     0,   523,     0,   524,
     525,   526,   527,   528,     0,   529,   530,     0,   531,   181,
       0,   532,     0,     0,   533,   534,   535,     0,     0,   536,
     537,   538,   539,   540,   541,   704,   542,   543,   705,   544,
     545,   546,   188,     0,   190,   547,   548,   191,     0,   549,
     550,     0,   551,     0,   194,   552,   195,   553,   554,   555,
       0,   556,     0,     0,   557,   558,   559,     0,     0,   560,
     196,     0,   561,     0,   199,   562,   563,   564,   565,   566,
     567,   568,     0,   569,   200,   570,   201,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   203,
     582,   583,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,     0,
     599,   600,   212,   601,   602,   603,   604,   605,   606,   706,
     607,     0,   608,   609,   610,   611,   612,     0,   613,   217,
     614,   615,     0,   616,   220,   617,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,     0,   628,
     629,     0,   630,   631,   632,   633,   634,   635,     0,   224,
     225,     0,     0,   637,   226,   638,   227,     0,   639,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,   650,     0,     0,   651,   652,   653,   654,   655,   707,
     234,     0,   656,     0,   657,   658,   659,   660,     0,     0,
     661,     0,     0,   662,   663,   664,   665,   666,   667,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   708,   668,
     669,     0,     0,     0,     0,  1219,  1220,  1221,     0,  1222,
    1223,  1224,  1225,  1226,  1227,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   687,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,  1216,     0,     0,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,     0,     0,     0,   430,
     431,     0,   432,   433,     0,   434,   435,   436,   135,   136,
       0,   138,   139,     0,   437,   438,   439,   440,   441,     0,
       0,   442,   443,   698,   140,   444,     0,   445,   446,   447,
     448,   144,     0,     0,     0,   449,   450,   451,   452,     0,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
       0,   460,     0,     0,     0,     0,     0,     0,     0,     0,
     461,   462,   463,   464,   701,   465,   155,   156,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,   164,   491,   492,   493,   166,     0,   494,     0,   495,
     496,   168,   497,     0,   498,     0,   499,     0,     0,     0,
     500,   501,   502,     0,   503,   172,     0,   504,     0,   505,
     506,   703,   507,   508,     0,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,     0,   175,     0,
     519,   520,   521,     0,   176,     0,   177,     0,   522,     0,
       0,   523,     0,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,   181,     0,   532,     0,     0,   533,   534,
     535,     0,     0,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,   188,     0,   190,   547,
     548,   191,     0,   549,   550,     0,   551,     0,   194,   552,
     195,   553,   554,   555,     0,   556,     0,     0,   557,   558,
     559,     0,     0,   560,   196,     0,   561,     0,   199,   562,
     563,   564,   565,   566,   567,   568,     0,   569,   200,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   203,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,     0,   599,   600,   212,   601,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,     0,   613,   217,   614,   615,     0,   616,   220,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   222,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,   224,   225,     0,     0,   637,   226,   638,
     227,     0,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,     0,     0,   651,   652,
     653,   654,   655,   707,   234,     0,   656,     0,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   708,   668,   669,     0,     0,     0,     0,  1219,
    1220,  1221,     0,  1222,  1223,  1224,  1225,  1226,  1227,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   687,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,  1216,     0,
       0,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
       0,     0,     0,   430,   431,     0,   432,   433,     0,   434,
     435,   436,   135,   136,     0,   138,   139,     0,   437,   438,
     439,   440,   441,     0,     0,   442,   443,   698,   140,   444,
       0,   445,  3173,   447,   448,   144,     0,     0,     0,   449,
     450,   451,   452,     0,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0,     0,   460,     0,     0,     0,     0,
       0,     0,     0,     0,   461,   462,   463,   464,   701,   465,
     155,   156,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,   164,   491,   492,   493,   166,
       0,  3174,     0,   495,   496,   168,   497,     0,   498,     0,
     499,     0,     0,     0,   500,   501,   502,     0,   503,   172,
       0,   504,     0,   505,   506,   703,   507,   508,     0,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518,     0,   175,     0,   519,   520,   521,     0,   176,     0,
     177,     0,   522,     0,     0,   523,     0,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,   181,     0,   532,
       0,     0,   533,   534,   535,     0,     0,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
     188,     0,   190,   547,   548,   191,     0,   549,   550,     0,
     551,     0,   194,   552,   195,   553,   554,   555,     0,   556,
       0,     0,   557,   558,   559,     0,     0,   560,   196,     0,
     561,     0,   199,   562,   563,   564,   565,   566,   567,   568,
       0,   569,   200,   570,   201,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   203,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,     0,   599,   600,
     212,   601,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,     0,   613,   217,   614,   615,
       0,   616,   220,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,   224,   225,     0,
       0,   637,   226,   638,   227,     0,   639,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,   650,
       0,     0,   651,   652,   653,   654,   655,   707,   234,     0,
     656,     0,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   708,   668,   669,     0,
       0,     0,     0,  1219,  1220,  1221,     0,  1222,  1223,  1224,
    1225,  1226,  1227,    86,    87,    88,   684,    90,    91,    92,
     685,     0,   686,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   687,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   688,   689,     0,     0,     0,   690,   691,     0,
       0,     0,     0,   692,     0,     0,     0,     0,     0,     0,
       0,     0,   693,     0,   694,     0,   695,   696,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,  1216,     0,     0,     0,     0,     0,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,   429,
       0,     0,     0,     0,     0,     0,     0,   430,   431,     0,
     432,   433,     0,   434,   435,   436,   135,   136,     0,   138,
     139,     0,   437,   438,   439,   440,   441,     0,     0,   442,
     443,   698,   140,   444,     0,   445,   446,   447,   448,   144,
       0,     0,     0,   449,   450,   451,   452,     0,   453,   699,
       0,   454,   455,   456,   457,   458,   459,     0,     0,   460,
       0,     0,     0,     0,     0,     0,     0,     0,   461,   462,
     463,   464,   701,   465,   155,   156,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,   489,   490,   164,
     491,   492,   493,   166,     0,   494,     0,   495,   496,   168,
     497,     0,   498,     0,   499,     0,     0,     0,   500,   501,
     502,     0,   503,   172,     0,   504,     0,   505,   506,   703,
     507,   508,     0,   509,   510,   511,     0,   512,   513,   514,
     515,   516,   517,     0,   518,     0,   175,     0,   519,   520,
     521,     0,   176,     0,   177,     0,   522,     0,     0,   523,
       0,   524,   525,   526,   527,   528,     0,   529,   530,     0,
     531,   181,     0,   532,     0,     0,   533,   534,   535,     0,
       0,   536,   537,   538,   539,   540,   541,   704,   542,   543,
     705,   544,   545,   546,   188,     0,   190,   547,   548,   191,
       0,   549,   550,     0,   551,     0,   194,   552,   195,   553,
     554,   555,     0,   556,     0,     0,  4836,   558,   559,     0,
       0,   560,   196,     0,   561,     0,   199,   562,   563,   564,
     565,   566,   567,   568,     0,   569,   200,   570,   201,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   203,   582,   583,   584,   585,     0,   586,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,     0,   599,   600,   212,   601,   602,   603,   604,   605,
     606,   706,   607,     0,   608,   609,   610,   611,   612,     0,
     613,   217,   614,   615,     0,   616,   220,   617,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
       0,   628,   629,     0,   630,   631,   632,   633,   634,   635,
       0,   224,   225,     0,     0,   637,   226,   638,   227,     0,
     639,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,   650,     0,     0,   651,   652,   653,   654,
     655,   707,   234,     0,   656,     0,   657,   658,   659,   660,
       0,     0,   661,     0,     0,   662,   663,   664,   665,   666,
     667,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     708,   668,   669,     0,     0,     0,     0,  1219,  1220,  1221,
       0,  1222,  1223,  1224,  1225,  1226,  1227,   732,    86,    87,
      88,   684,    90,    91,    92,   685,     0,   686,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   733,   104,   105,
     687,   734,     0,   107,   108,   109,   110,   735,   736,   112,
     113,   114,   115,     0,   116,   737,   738,   688,   689,     0,
       0,     0,   690,   691,     0,     0,     0,     0,   692,     0,
       0,     0,     0,     0,     0,     0,     0,   693,     0,   694,
       0,   695,   696,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,   739,   427,   428,   429,   740,   741,   742,   743,   744,
     745,   746,   430,   431,   747,   432,   433,   133,   434,   435,
     436,   135,   136,   137,   138,   139,   748,   437,   438,   439,
     440,   441,   749,   750,   442,   443,   751,   140,   444,   752,
     445,   446,   447,   448,   144,   753,   145,   754,   449,   450,
     451,   452,   148,   453,   755,   756,   454,   455,   456,   457,
     458,   459,   757,   151,   460,   758,   759,   760,   761,   152,
     762,   763,   764,   461,   462,   463,   464,   701,   465,   155,
     156,   466,   765,   467,   766,   468,   469,   470,   471,   472,
     767,   473,   474,   475,   768,   769,   476,   477,   478,   479,
     480,   770,   481,   482,   483,   771,   484,   485,   486,   772,
     487,   488,   489,   490,   164,   491,   492,   493,   166,   773,
     494,   774,   495,   496,   168,   497,   775,   498,   776,   499,
     169,   777,   170,   500,   501,   502,   778,   503,   172,   779,
     504,   780,   505,   506,   703,   507,   508,   173,   509,   510,
     511,   781,   512,   513,   514,   515,   516,   517,   782,   518,
     174,   175,   783,   519,   520,   521,   784,   176,   785,   177,
     786,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,   787,   529,   530,   788,   531,   181,   182,   532,   183,
     789,   533,   534,   535,   790,   791,   536,   537,   538,   539,
     540,   541,   704,   542,   543,   705,   544,   545,   546,   188,
     189,   190,   547,   548,   191,   792,   549,   550,   193,   551,
     793,   194,   552,   195,   553,   554,   555,   794,   556,   795,
     796,   557,   558,   559,   797,   798,   560,   196,   197,   561,
     198,   199,   562,   563,   564,   565,   566,   567,   568,   799,
     569,   200,   570,   201,   571,   572,   573,   800,   574,   575,
     576,   577,   578,   579,   580,   581,   203,   582,   583,   584,
     585,   801,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,   802,   597,   598,   210,   599,   600,   212,
     601,   602,   603,   604,   605,   606,   706,   607,   803,   608,
     609,   610,   611,   612,   804,   613,   217,   614,   615,   219,
     616,   220,   617,   805,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,   806,   628,   629,   807,   630,
     631,   632,   633,   634,   635,   808,   224,   225,   809,   810,
     637,   226,   638,   227,   811,   639,   640,   641,   642,   643,
     644,   645,   812,   813,   646,   647,   648,   649,   650,   814,
     815,   651,   652,   653,   654,   655,   816,   234,   817,   656,
     235,   657,   658,   659,   660,   818,   819,   661,   820,   821,
     662,   663,   664,   665,   666,   667,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   708,   668,   669,     0,   732,
      86,    87,    88,   684,    90,    91,    92,   685,  2304,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   733,
     104,   105,   687,   734,     0,   107,   108,   109,   110,   735,
     736,   112,   113,   114,   115,     0,   116,   737,   738,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,     0,  1915,   137,  1916,  1917,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,  1918,  1919,
     444,     0,   445,   446,   447,   448,     0,     0,   145,     0,
     449,   450,   451,   452,   148,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,     0,     0,
       0,   152,     0,     0,     0,   461,   462,   463,   464,   701,
     465,  1920,  1921,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
    1503,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,     0,   491,   492,   493,
       0,     0,   494,     0,   495,   496,  1922,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
       0,     0,   504,     0,   505,   506,   703,   507,   508,   173,
     509,   510,   511,  2408,   512,   513,   514,   515,   516,   517,
       0,   518,   174,  2409,     0,   519,   520,   521,  1509,  1923,
       0,  1924,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,     0,   182,
     532,   183,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,  1925,   189,  1926,   547,   548,     0,     0,   549,   550,
     193,   551,     0,     0,   552,  1927,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,  2410,   560,  2411,
     197,   561,   198,     0,   562,   563,   564,   565,   566,   567,
     568,     0,   569,     0,   570,     0,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,  1928,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,     0,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,  2412,   614,
     615,   219,   616,  1930,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,     0,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,  1931,  1932,
       0,     0,   637,     0,   638,     0,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,     0,  1933,
    2413,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   708,   668,   669,
       0,     0,    86,    87,    88,   684,    90,    91,    92,   685,
    2414,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,     0,     0,    86,    87,    88,   684,    90,    91,
      92,   685,  1099,   686,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   687,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,     0,   434,   435,   436,   135,   136,     0,
     138,   139,     0,   437,   438,   439,   440,   441,     0,     0,
     442,   443,   698,   140,   444,     0,   445,   446,   447,   448,
     144,     0,     0,     0,   449,   450,   451,   452,     0,   453,
     699,     0,   454,   455,   456,   457,   458,   459,     0,     0,
     460,     0,     0,     0,     0,     0,     0,     0,     0,   461,
     462,   463,   464,   701,   465,   155,   156,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
     164,   491,   492,   493,   166,     0,   494,     0,   495,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     703,   507,   508,     0,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,     0,   175,     0,   519,
     520,   521,     0,   176,     0,   177,     0,   522,     0,     0,
     523,     0,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,   181,     0,   532,     0,     0,   533,   534,   535,
       0,     0,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,   188,     0,   190,   547,   548,
     191,     0,   549,   550,     0,   551,     0,   194,   552,   195,
     553,   554,   555,     0,   556,     0,     0,   557,   558,   559,
       0,     0,   560,   196,     0,   561,     0,   199,   562,   563,
     564,   565,   566,   567,   568,     0,   569,   200,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   203,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   212,   601,   602,   603,   604,
     605,   606,   706,   607,     0,   608,   609,   610,   611,   612,
       0,   613,   217,   614,   615,     0,   616,   220,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,   224,   225,     0,     0,   637,   226,   638,   227,
       0,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,   655,   707,   234,     0,   656,     0,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   708,   668,   669,     0,     0,    86,    87,    88,   684,
      90,    91,    92,   685,  4882,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,    45,     0,     0,     0,
       0,   419,   996,   421,   422,   423,   424,   425,   426,   997,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   998,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   999,   168,   497,     0,   498,     0,  1000,     0,  1001,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,  1002,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,  1003,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
    1004,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,  1005,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,  1006,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,     0,     0,     0,     0,
       0,     0,     0,     0,  1007,  1008,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,    45,     0,     0,     0,
       0,   419,   996,   421,   422,   423,   424,   425,   426,   997,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,  1029,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   999,   168,   497,     0,   498,     0,  1030,     0,  1001,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,  1002,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,  1003,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
    1004,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,  1005,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,  1006,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,     0,     0,     0,     0,
       0,     0,     0,     0,  1007,  1008,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,    45,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  1416,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,  1001,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,  1002,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,     0,     0,     0,     0,
       0,     0,     0,     0,  1007,  1008,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,    45,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  1421,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,  1001,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,  1002,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,     0,     0,     0,     0,
       0,     0,     0,     0,  1007,  1008,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
     702,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,  1588,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,     0,     0,     0,  1069,
    1589,    86,    87,    88,   684,    90,    91,    92,   685,  1070,
     686,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   687,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     688,   689,     0,     0,     0,   690,   691,     0,     0,     0,
       0,   692,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,   694,     0,   695,   696,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,   429,     0,     0,
       0,     0,     0,     0,     0,   430,   431,     0,   432,   433,
       0,   434,   435,   436,   135,   136,     0,   138,   139,     0,
     437,   438,   439,   440,   441,     0,     0,  1071,   443,  1045,
     140,   444,     0,   445,   446,   447,   448,   144,     0,     0,
       0,   449,   450,   451,   452,     0,   453,  1072,     0,  1073,
     455,   456,   457,   458,   459,     0,     0,   460,     0,     0,
       0,     0,     0,     0,     0,     0,   461,   462,   463,   464,
     701,   465,   155,   156,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,   489,   490,   164,   491,   492,
     493,   166,     0,   494,     0,   495,   496,   168,   497,     0,
     498,     0,   499,     0,     0,     0,   500,   501,   502,     0,
     503,   172,     0,   504,     0,   505,   506,   703,   507,   508,
       0,   509,   510,   511,     0,   512,   513,   514,   515,   516,
     517,     0,   518,     0,   175,     0,   519,   520,   521,     0,
     176,     0,   177,     0,   522,     0,     0,   523,     0,   524,
     525,   526,   527,   528,     0,   529,   530,     0,   531,   181,
       0,   532,     0,     0,   533,   534,  1074,     0,     0,   536,
     537,   538,   539,   540,   541,   704,   542,   543,   705,   544,
     545,  1075,   188,     0,   190,   547,   548,   191,     0,   549,
     550,     0,   551,     0,   194,   552,   195,   553,   554,   555,
       0,   556,     0,     0,   557,   558,   559,     0,     0,   560,
     196,     0,   561,     0,   199,   562,   563,   564,   565,   566,
     567,   568,     0,   569,   200,   570,   201,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   203,
     582,   583,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,     0,
    1076,   600,   212,   601,   602,   603,  1077,   605,   606,   706,
     607,     0,   608,   609,   610,   611,  1078,     0,   613,   217,
     614,   615,     0,   616,   220,   617,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,     0,   628,
     629,     0,   630,   631,   632,   633,   634,   635,     0,  1079,
     225,     0,     0,  1080,   226,   638,   227,     0,   639,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,   650,     0,     0,   651,   652,   653,   654,   655,  1049,
     234,     0,   656,     0,   657,   658,   659,   660,     0,     0,
     661,     0,     0,   662,   663,   664,   665,   666,  1081,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   708,   668,
     669,   732,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   733,   104,   105,   687,   734,     0,   107,   108,   109,
     110,   735,   736,   112,   113,   114,   115,     0,   116,   737,
     738,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,     0,
       0,     0,    45,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,   739,   427,   428,   429,   740,
     741,   742,   743,   744,   745,   746,   430,   431,   747,   432,
     433,   133,   434,   435,   436,   135,   136,   137,   138,   139,
     748,   437,   438,   439,   440,   441,   749,   750,   442,   443,
     751,   140,   444,   752,   445,   446,   447,   448,   144,   753,
     145,   754,   449,   450,   451,   452,   148,   453,   755,   756,
     454,   455,   456,   457,   458,   459,   757,   151,   460,   758,
     759,   760,   761,   152,   762,   763,   764,   461,   462,   463,
     464,   701,   465,   155,   156,   466,   765,   467,   766,   468,
     469,   470,   471,   472,   767,   473,   474,   475,   768,   769,
     476,   477,   478,   479,   480,   770,   481,   482,   483,   771,
     484,   485,   486,   772,   487,   488,   489,   490,   164,   491,
     492,   493,   166,   773,   494,   774,   495,   496,   168,   497,
     775,   498,   776,   499,   169,   777,   170,   500,   501,   502,
     778,   503,   172,   779,   504,   780,   505,   506,   703,   507,
     508,   173,   509,   510,   511,   781,   512,   513,   514,   515,
     516,   517,   782,   518,   174,   175,   783,   519,   520,   521,
     784,   176,   785,   177,   786,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,   787,   529,   530,   788,   531,
     181,   182,   532,   183,   789,   533,   534,   535,   790,   791,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,   189,   190,   547,   548,   191,   792,
     549,   550,   193,   551,   793,   194,   552,   195,   553,   554,
     555,   794,   556,   795,   796,   557,   558,   559,   797,   798,
     560,   196,   197,   561,   198,   199,   562,   563,   564,   565,
     566,   567,   568,   799,   569,   200,   570,   201,   571,   572,
     573,   800,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,   801,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,   802,   597,   598,
     210,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,   803,   608,   609,   610,   611,   612,   804,   613,
     217,   614,   615,   219,   616,   220,   617,   805,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,   806,
     628,   629,   807,   630,   631,   632,   633,   634,   635,   808,
     224,   225,   809,   810,   637,   226,   638,   227,   811,   639,
     640,   641,   642,   643,   644,   645,   812,   813,   646,   647,
     648,   649,   650,   814,   815,   651,   652,   653,   654,   655,
     816,   234,   817,   656,   235,   657,   658,   659,   660,   818,
     819,   661,   820,   821,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,   732,    86,    87,    88,   684,    90,    91,    92,
     685,     0,   686,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   733,   104,   105,   687,   734,     0,   107,   108,
     109,   110,   735,   736,   112,   113,   114,   115,     0,   116,
     737,   738,   688,   689,     0,     0,     0,   690,   691,     0,
       0,     0,     0,   692,     0,     0,     0,     0,     0,     0,
       0,     0,   693,     0,   694,     0,   695,   696,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   419,   420,
     421,   422,   423,   424,   425,   426,   739,   427,   428,   429,
     740,   741,   742,   743,   744,   745,   746,   430,   431,   747,
     432,   433,   133,   434,   435,   436,   135,   136,   137,   138,
     139,   748,   437,   438,   439,   440,   441,   749,   750,   442,
     443,   751,   140,   444,   752,   445,   446,   447,   448,   144,
     753,   145,   754,   449,   450,   451,   452,   148,   453,   755,
     756,   454,   455,   456,   457,   458,   459,   757,   151,   460,
     758,   759,   760,   761,   152,   762,   763,   764,   461,   462,
     463,   464,   701,   465,   155,   156,   466,   765,   467,   766,
     468,   469,   470,   471,   472,   767,   473,   474,   475,   768,
     769,   476,   477,   478,   479,   480,   770,   481,   482,   483,
     771,   484,   485,   486,   772,   487,   488,   489,   490,   164,
     491,   492,   493,   166,   773,   494,   774,   495,   496,   168,
     497,   775,   498,   776,   499,   169,   777,   170,   500,   501,
     502,   778,   503,   172,   779,   504,   780,   505,   506,   703,
     507,   508,   173,   509,   510,   511,   781,   512,   513,   514,
     515,   516,   517,   782,   518,   174,   175,   783,   519,   520,
     521,   784,   176,   785,   177,   786,   522,   178,   179,   523,
     180,   524,   525,   526,   527,   528,   787,   529,   530,   788,
     531,   181,   182,   532,   183,   789,   533,   534,   535,   790,
     791,   536,   537,   538,   539,   540,   541,   704,   542,   543,
     705,   544,   545,   546,   188,   189,   190,   547,   548,   191,
     792,   549,   550,   193,   551,   793,   194,   552,   195,   553,
     554,   555,   794,   556,   795,   796,   557,   558,   559,   797,
     798,   560,   196,   197,   561,   198,   199,   562,   563,   564,
     565,   566,   567,   568,   799,   569,   200,   570,   201,   571,
     572,   573,   800,   574,   575,   576,   577,   578,   579,   580,
     581,   203,   582,   583,   584,   585,   801,   586,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,   802,   597,
     598,   210,   599,   600,   212,   601,   602,   603,   604,   605,
     606,   706,   607,   803,   608,   609,   610,   611,   612,   804,
     613,   217,   614,   615,   219,   616,   220,   617,   805,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     806,   628,   629,   807,   630,   631,   632,   633,   634,   635,
     808,   224,   225,   809,   810,   637,   226,   638,   227,   811,
     639,   640,   641,   642,   643,   644,   645,   812,   813,   646,
     647,   648,   649,   650,   814,   815,   651,   652,   653,   654,
     655,   816,   234,   817,   656,   235,   657,   658,   659,   660,
     818,   819,   661,   820,   821,   662,   663,   664,   665,   666,
     667,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     708,   668,   669,   732,    86,    87,    88,   684,    90,    91,
      92,   685,     0,   686,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   733,   104,   105,   687,   734,     0,   107,
     108,   109,   110,   735,   736,   112,   113,   114,   115,     0,
     116,   737,   738,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,  3231,   424,   425,   426,   739,   427,   428,
     429,   740,   741,   742,   743,   744,   745,   746,   430,   431,
     747,   432,   433,   133,   434,   435,   436,   135,   136,   137,
     138,   139,   748,   437,   438,   439,   440,   441,   749,   750,
     442,   443,   751,   140,   444,   752,   445,   446,   447,   448,
     144,   753,   145,   754,   449,   450,   451,   452,   148,   453,
     755,   756,   454,   455,   456,   457,   458,   459,   757,   151,
     460,   758,   759,   760,   761,   152,   762,   763,   764,   461,
     462,   463,   464,   701,   465,   155,   156,   466,   765,   467,
     766,   468,   469,   470,   471,   472,   767,   473,   474,   475,
     768,   769,   476,   477,   478,  3232,   480,   770,   481,   482,
     483,   771,   484,   485,   486,   772,   487,   488,   489,   490,
     164,   491,   492,   493,   166,   773,   494,   774,   495,   496,
     168,   497,   775,   498,   776,   499,   169,   777,   170,   500,
     501,   502,   778,   503,   172,   779,   504,   780,   505,   506,
     703,   507,   508,   173,   509,   510,   511,   781,   512,   513,
     514,   515,   516,   517,   782,   518,   174,   175,   783,   519,
     520,   521,   784,   176,   785,   177,   786,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,   787,   529,   530,
     788,   531,   181,   182,   532,   183,   789,   533,   534,   535,
     790,   791,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,   188,   189,   190,   547,   548,
     191,   792,   549,   550,   193,   551,   793,   194,   552,   195,
     553,   554,   555,   794,   556,   795,   796,   557,   558,   559,
     797,   798,   560,   196,   197,   561,   198,   199,   562,   563,
     564,   565,   566,   567,   568,   799,   569,   200,   570,   201,
     571,   572,   573,   800,   574,   575,   576,   577,   578,   579,
     580,   581,   203,   582,   583,   584,   585,   801,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,   802,
     597,   598,   210,   599,   600,   212,   601,   602,   603,   604,
     605,   606,   706,   607,   803,   608,   609,   610,   611,   612,
     804,  3233,   217,   614,   615,   219,   616,   220,   617,   805,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,   806,   628,   629,   807,   630,   631,   632,   633,   634,
     635,   808,   224,   225,   809,   810,   637,   226,   638,   227,
     811,   639,   640,   641,   642,   643,   644,   645,   812,   813,
     646,   647,   648,   649,   650,   814,   815,   651,   652,   653,
     654,   655,   816,   234,   817,   656,   235,   657,   658,   659,
     660,   818,   819,   661,   820,   821,   662,   663,   664,   665,
     666,   667,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   708,   668,   669,   732,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   733,   104,   105,   687,   734,     0,
     107,   108,   109,   110,   735,   736,   112,   113,   114,   115,
       0,   116,   737,   738,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,     0,     0,     0,   430,
     431,     0,   432,   433,   133,   434,   435,   436,   135,   136,
     137,   138,   139,     0,   437,   438,   439,   440,   441,     0,
    1489,   442,   443,   698,   140,   444,     0,   445,   446,   447,
     448,  1492,     0,  1493,     0,   449,   450,   451,   452,   148,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
     151,   460,     0,  1494,  1495,  1496,  1497,  1498,  1499,  1500,
     461,   462,   463,   464,   701,   465,   155,   156,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,   164,   491,   492,   493,  1505,     0,   494,     0,   495,
     496,   168,   497,     0,   498,     0,   499,   169,     0,   170,
     500,   501,   502,     0,   503,  1508,     0,   504,     0,   505,
     506,   703,   507,   508,   173,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,   174,   175,     0,
     519,   520,   521,     0,   176,     0,   177,     0,   522,   178,
     179,   523,   180,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,  1512,   182,   532,   183,     0,   533,   534,
     535,  1513,  1514,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,   188,   189,   190,   547,
     548,   191,     0,   549,   550,   193,   551,     0,  1519,   552,
     195,   553,   554,   555,     0,   556,     0,     0,   557,   558,
     559,     0,     0,   560,   196,   197,   561,   198,  1522,   562,
     563,   564,   565,   566,   567,   568,     0,   569,  1523,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   203,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,   210,   599,   600,   212,   601,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,  1526,   613,   217,   614,   615,   219,   616,   220,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1528,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,   224,   225,     0,     0,   637,  1531,   638,
    1532,     0,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,  1535,     0,   651,   652,
     653,   654,   655,   707,   234,     0,   656,   235,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,   237,  1537,  1538,  1539,  1540,  1541,  1542,
    1543,  1544,   708,   668,   669,   732,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   733,   104,   105,   687,   734,
       0,   107,   108,   109,   110,   735,   736,   112,   113,   114,
     115,     0,   116,   737,   738,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,   135,
     136,   137,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,   145,     0,   449,   450,   451,   452,
     148,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,     0,     0,     0,   152,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,   173,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,   182,   532,   183,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,   189,   190,
     547,   548,   191,     0,   549,   550,   193,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,   197,   561,   198,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,   219,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,   732,    86,    87,    88,
     684,    90,    91,    92,   685,     0,   686,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   733,   104,   105,   687,
     734,     0,   107,   108,   109,   110,   735,   736,   112,   113,
     114,   115,     0,   116,   737,   738,   688,   689,     0,     0,
       0,   690,   691,     0,     0,     0,     0,   692,     0,     0,
       0,     0,     0,     0,     0,     0,   693,     0,   694,     0,
     695,   696,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,   429,     0,     0,     0,     0,     0,     0,
       0,   430,   431,     0,   432,   433,   133,   434,   435,   436,
     135,   136,   137,   138,   139,     0,   437,   438,   439,   440,
     441,     0,     0,   442,   443,   698,   140,   444,     0,   445,
     446,   447,   448,   144,     0,   145,     0,   449,   450,   451,
     452,   148,   453,   699,     0,   454,   455,   456,   457,   458,
     459,     0,   151,   460,     0,     0,     0,     0,   152,     0,
       0,     0,   461,   462,   463,   464,   701,   465,   155,   156,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,   489,   490,   164,   491,   492,   493,   166,     0,   494,
       0,   495,   496,   168,   497,     0,   498,     0,   499,   169,
       0,   170,   500,   501,   502,     0,   503,   172,     0,   504,
       0,   505,   506,   703,   507,  1351,   173,   509,   510,   511,
       0,   512,   513,   514,   515,   516,   517,     0,   518,   174,
     175,     0,   519,   520,   521,     0,   176,     0,   177,     0,
     522,   178,   179,   523,   180,   524,   525,   526,   527,   528,
       0,   529,   530,     0,   531,   181,   182,   532,   183,     0,
     533,   534,   535,     0,     0,   536,   537,   538,   539,   540,
     541,   704,   542,   543,   705,   544,   545,   546,   188,   189,
     190,   547,   548,   191,     0,   549,   550,   193,   551,     0,
     194,   552,   195,   553,   554,   555,     0,   556,     0,     0,
     557,   558,   559,     0,     0,   560,   196,   197,   561,   198,
     199,   562,   563,   564,   565,   566,   567,   568,     0,   569,
     200,   570,   201,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   203,   582,   583,   584,   585,
       0,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,   210,   599,   600,   212,   601,
     602,   603,   604,   605,   606,   706,   607,     0,   608,   609,
     610,   611,   612,     0,   613,   217,   614,   615,   219,   616,
     220,   617,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   222,     0,   628,   629,     0,   630,   631,
     632,   633,   634,   635,     0,   224,   225,     0,     0,   637,
     226,   638,   227,     0,   639,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,   650,     0,     0,
     651,   652,   653,   654,   655,   707,   234,     0,   656,   235,
     657,   658,   659,   660,     0,     0,   661,     0,     0,   662,
     663,   664,   665,   666,   667,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   708,   668,   669,   732,    86,    87,
      88,   684,    90,    91,    92,   685,     0,   686,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   733,   104,   105,
     687,   734,     0,   107,   108,   109,   110,   735,   736,   112,
     113,   114,   115,     0,   116,   737,   738,   688,   689,     0,
       0,     0,   690,   691,     0,     0,     0,     0,   692,     0,
       0,     0,     0,     0,     0,     0,     0,   693,     0,   694,
       0,   695,   696,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,   429,     0,     0,     0,     0,     0,
       0,     0,   430,   431,     0,   432,   433,   133,   434,   435,
     436,   135,   136,   137,   138,   139,     0,   437,   438,   439,
     440,   441,     0,     0,   442,   443,   698,   140,   444,     0,
     445,   446,   447,   448,   144,     0,   145,     0,   449,   450,
     451,   452,   148,   453,   699,     0,   454,   455,   456,   457,
     458,   459,     0,   151,   460,     0,     0,     0,     0,   152,
       0,     0,     0,   461,   462,   463,   464,   701,   465,   155,
     156,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,   489,   490,   164,   491,   492,   493,   166,     0,
     494,     0,   495,   496,   168,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,   703,   507,  1361,   173,   509,   510,
     511,     0,   512,   513,   514,   515,   516,   517,     0,   518,
     174,   175,     0,   519,   520,   521,     0,   176,     0,   177,
       0,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,     0,   529,   530,     0,   531,   181,   182,   532,   183,
       0,   533,   534,   535,     0,     0,   536,   537,   538,   539,
     540,   541,   704,   542,   543,   705,   544,   545,   546,   188,
     189,   190,   547,   548,   191,     0,   549,   550,   193,   551,
       0,   194,   552,   195,   553,   554,   555,     0,   556,     0,
       0,   557,   558,   559,     0,     0,   560,   196,   197,   561,
     198,   199,   562,   563,   564,   565,   566,   567,   568,     0,
     569,   200,   570,   201,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   203,   582,   583,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   210,   599,   600,   212,
     601,   602,   603,   604,   605,   606,   706,   607,     0,   608,
     609,   610,   611,   612,     0,   613,   217,   614,   615,   219,
     616,   220,   617,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,     0,   628,   629,     0,   630,
     631,   632,   633,   634,   635,     0,   224,   225,     0,     0,
     637,   226,   638,   227,     0,   639,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,   650,     0,
       0,   651,   652,   653,   654,   655,   707,   234,     0,   656,
     235,   657,   658,   659,   660,     0,     0,   661,     0,     0,
     662,   663,   664,   665,   666,   667,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   708,   668,   669,   732,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   733,   104,
     105,   687,   734,     0,   107,   108,   109,   110,   735,   736,
     112,   113,   114,   115,     0,   116,   737,   738,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
       0,     0,     0,   430,   431,     0,   432,   433,   133,   434,
     435,   436,     0,  1915,   137,  1916,  1917,     0,   437,   438,
     439,   440,   441,     0,     0,   442,   443,  1918,  1919,   444,
       0,   445,   446,   447,   448,     0,     0,   145,     0,   449,
     450,   451,   452,   148,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0,   151,   460,     0,     0,     0,     0,
     152,     0,     0,     0,   461,   462,   463,   464,   701,   465,
    1920,  1921,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,  1503,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,     0,   491,   492,   493,     0,
       0,   494,     0,   495,   496,  1922,   497,     0,   498,     0,
     499,   169,     0,   170,   500,   501,   502,     0,   503,     0,
       0,   504,     0,   505,   506,   703,   507,   508,   173,   509,
     510,   511,  2408,   512,   513,   514,   515,   516,   517,     0,
     518,   174,  2409,     0,   519,   520,   521,  1509,  1923,     0,
    1924,     0,   522,   178,   179,   523,   180,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,     0,   182,   532,
     183,     0,   533,   534,   535,     0,     0,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
    1925,   189,  1926,   547,   548,     0,     0,   549,   550,   193,
     551,     0,     0,   552,  1927,   553,   554,   555,     0,   556,
       0,     0,   557,   558,   559,     0,     0,   560,  2411,   197,
     561,   198,     0,   562,   563,   564,   565,   566,   567,   568,
       0,   569,     0,   570,     0,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,  1928,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,   210,   599,   600,
       0,   601,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,     0,   613,  2412,   614,   615,
     219,   616,  1930,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,     0,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,  1931,  1932,     0,
       0,   637,     0,   638,     0,     0,   639,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,   650,
       0,     0,   651,   652,   653,   654,   655,     0,  1933,  2413,
     656,   235,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   708,   668,   669,   732,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   733,
     104,   105,   687,   734,     0,   107,   108,   109,   110,   735,
     736,   112,   113,   114,   115,     0,   116,   737,   738,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,     0,  1915,   137,  1916,  1917,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,  1918,  1919,
     444,     0,   445,   446,   447,   448,     0,     0,   145,     0,
     449,   450,   451,   452,   148,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,     0,     0,
       0,   152,     0,     0,     0,   461,   462,   463,   464,   701,
     465,  1920,  1921,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
    1503,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,     0,   491,   492,   493,
       0,     0,   494,     0,   495,   496,  1922,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
       0,     0,   504,     0,   505,   506,   703,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,     0,     0,   519,   520,   521,  1509,  1923,
       0,  1924,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,     0,   182,
     532,   183,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,  1925,   189,  1926,   547,   548,     0,     0,   549,   550,
     193,   551,  2499,     0,   552,  1927,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,     0,
     197,   561,   198,     0,   562,   563,   564,   565,   566,   567,
     568,     0,   569,     0,   570,     0,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,  1928,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,     0,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,  2412,   614,
     615,   219,   616,  1930,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,     0,     0,   628,   629,
    4032,   630,   631,   632,   633,   634,   635,     0,  1931,  1932,
       0,     0,   637,     0,   638,     0,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,     0,  1933,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   708,   668,   669,
     732,    86,    87,    88,   684,    90,    91,    92,   685,     0,
     686,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     733,   104,   105,   687,   734,     0,   107,   108,   109,   110,
     735,   736,   112,   113,   114,   115,     0,   116,   737,   738,
     688,   689,     0,     0,     0,   690,   691,     0,     0,     0,
       0,   692,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,   694,     0,   695,   696,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,   429,     0,     0,
       0,     0,     0,     0,     0,   430,   431,     0,   432,   433,
     133,   434,   435,   436,     0,  1915,   137,  1916,  1917,     0,
     437,   438,   439,   440,   441,     0,     0,   442,   443,  1918,
    1919,   444,     0,   445,   446,   447,   448,     0,     0,   145,
       0,   449,   450,   451,   452,   148,   453,   699,     0,   454,
     455,   456,   457,   458,   459,     0,   151,   460,     0,     0,
       0,     0,   152,     0,     0,     0,   461,   462,   463,   464,
     701,   465,  1920,  1921,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,  1503,   479,   480,     0,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,   489,   490,     0,   491,   492,
     493,     0,     0,   494,     0,   495,   496,  1922,   497,     0,
     498,     0,   499,   169,     0,   170,   500,   501,   502,     0,
     503,     0,     0,   504,     0,   505,   506,   703,   507,   508,
     173,   509,   510,   511,     0,   512,   513,   514,   515,   516,
     517,     0,   518,   174,     0,     0,   519,   520,   521,  1509,
    1923,     0,  1924,     0,   522,   178,   179,   523,   180,   524,
     525,   526,   527,   528,     0,   529,   530,     0,   531,     0,
     182,   532,   183,     0,   533,   534,   535,     0,     0,   536,
     537,   538,   539,   540,   541,   704,   542,   543,   705,   544,
     545,   546,  1925,   189,  1926,   547,   548,  2557,     0,   549,
     550,   193,   551,     0,     0,   552,  1927,   553,   554,   555,
       0,   556,     0,     0,   557,   558,   559,     0,     0,   560,
       0,   197,   561,   198,     0,   562,   563,   564,   565,   566,
     567,   568,     0,   569,     0,   570,     0,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,  1928,
     582,   583,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,   210,
     599,   600,     0,   601,   602,   603,   604,   605,   606,   706,
     607,     0,   608,   609,   610,   611,   612,     0,   613,  1929,
     614,   615,   219,   616,  1930,   617,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,     0,     0,   628,
     629,     0,   630,   631,   632,   633,   634,   635,     0,  1931,
    1932,     0,     0,   637,     0,   638,     0,     0,   639,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,   650,     0,     0,   651,   652,   653,   654,   655,     0,
    1933,     0,   656,   235,   657,   658,   659,   660,     0,     0,
     661,     0,     0,   662,   663,   664,   665,   666,   667,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   708,   668,
     669,   732,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   733,   104,   105,   687,   734,     0,   107,   108,   109,
     110,   735,   736,   112,   113,   114,   115,     0,   116,   737,
     738,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,   133,   434,   435,   436,     0,  1915,   137,  1916,  1917,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
    1918,  1919,   444,     0,   445,   446,   447,   448,     0,     0,
     145,     0,   449,   450,   451,   452,   148,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,   151,   460,     0,
       0,     0,     0,   152,     0,     0,     0,   461,   462,   463,
     464,   701,   465,  1920,  1921,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,  1503,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,     0,   491,
     492,   493,     0,     0,   494,     0,   495,   496,  1922,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,     0,     0,   504,     0,   505,   506,   703,   507,
     508,   173,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,   174,     0,     0,   519,   520,   521,
    1509,  1923,     0,  1924,     0,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
       0,   182,   532,   183,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,  1925,   189,  1926,   547,   548,  3855,     0,
     549,   550,   193,   551,     0,     0,   552,  1927,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,     0,   197,   561,   198,     0,   562,   563,   564,   565,
     566,   567,   568,     0,   569,     0,   570,     0,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
    1928,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     210,   599,   600,     0,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
    1929,   614,   615,   219,   616,  1930,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,     0,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
    1931,  1932,     0,     0,   637,     0,   638,     0,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
       0,  1933,     0,   656,   235,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   708,
     668,   669,   732,    86,    87,    88,   684,    90,    91,    92,
     685,     0,   686,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   733,   104,   105,   687,   734,     0,   107,   108,
     109,   110,   735,   736,   112,   113,   114,   115,     0,   116,
     737,   738,   688,   689,     0,     0,     0,   690,   691,     0,
       0,     0,     0,   692,     0,     0,     0,     0,     0,     0,
       0,     0,   693,     0,   694,     0,   695,   696,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,   429,
       0,     0,     0,     0,     0,     0,     0,   430,   431,     0,
     432,   433,   133,   434,   435,   436,     0,  1915,   137,  1916,
    1917,     0,   437,   438,   439,   440,   441,     0,     0,   442,
     443,  1918,  1919,   444,     0,   445,   446,   447,   448,     0,
       0,   145,     0,   449,   450,   451,   452,   148,   453,   699,
       0,   454,   455,   456,   457,   458,   459,     0,   151,   460,
       0,     0,     0,     0,   152,     0,     0,     0,   461,   462,
     463,   464,   701,   465,  1920,  1921,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,  1503,   479,   480,     0,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,   489,   490,     0,
     491,   492,   493,     0,     0,   494,     0,   495,   496,  1922,
     497,     0,   498,     0,   499,   169,     0,   170,   500,   501,
     502,     0,   503,     0,     0,   504,     0,   505,   506,   703,
     507,   508,   173,   509,   510,   511,     0,   512,   513,   514,
     515,   516,   517,     0,   518,   174,     0,     0,   519,   520,
     521,  1509,  1923,     0,  1924,     0,   522,   178,   179,   523,
     180,   524,   525,   526,   527,   528,     0,   529,   530,     0,
     531,     0,   182,   532,   183,     0,   533,   534,   535,     0,
       0,   536,   537,   538,   539,   540,   541,   704,   542,   543,
     705,   544,   545,   546,  1925,   189,  1926,   547,   548,     0,
       0,   549,   550,   193,   551,     0,     0,   552,  1927,   553,
     554,   555,     0,   556,     0,     0,   557,   558,   559,     0,
       0,   560,     0,   197,   561,   198,     0,   562,   563,   564,
     565,   566,   567,   568,     0,   569,     0,   570,     0,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,  1928,   582,   583,   584,   585,     0,   586,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,   210,   599,   600,     0,   601,   602,   603,   604,   605,
     606,   706,   607,     0,   608,   609,   610,   611,   612,     0,
     613,  1929,   614,   615,   219,   616,  1930,   617,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,     0,
       0,   628,   629,     0,   630,   631,   632,   633,   634,   635,
       0,  1931,  1932,     0,     0,   637,     0,   638,     0,     0,
     639,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,   650,     0,     0,   651,   652,   653,   654,
     655,     0,  1933,     0,   656,   235,   657,   658,   659,   660,
       0,     0,   661,     0,     0,   662,   663,   664,   665,   666,
     667,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     708,   668,   669,   732,    86,    87,    88,   684,    90,    91,
      92,   685,     0,   686,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   733,   104,   105,   687,   734,     0,   107,
     108,   109,   110,   735,   736,   112,   113,   114,   115,     0,
     116,   737,   738,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,     0,  1915,   137,
    1916,  1917,     0,   437,   438,   439,   440,   441,     0,     0,
     442,   443,  1918,  1919,   444,     0,   445,   446,   447,   448,
       0,     0,   145,     0,   449,   450,   451,   452,   148,   453,
     699,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,     0,     0,     0,   152,     0,     0,     0,   461,
     462,   463,   464,   701,   465,  1920,  1921,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,  1503,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
       0,   491,   492,   493,     0,     0,   494,     0,   495,   496,
    1922,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,     0,     0,   504,     0,   505,   506,
     703,   507,   508,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,     0,     0,   519,
     520,   521,  1509,  1923,     0,  1924,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,     0,   182,   532,   183,     0,   533,   534,   535,
       0,     0,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,  1925,   189,  1926,   547,   548,
       0,     0,   549,   550,   193,   551,     0,     0,   552,  1927,
     553,   554,   555,     0,   556,     0,     0,   557,   558,   559,
       0,     0,   560,     0,   197,   561,   198,     0,   562,   563,
     564,   565,   566,   567,   568,     0,   569,     0,   570,     0,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,  1928,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,     0,   601,   602,   603,   604,
     605,   606,   706,   607,     0,   608,   609,   610,   611,   612,
       0,   613,  2412,   614,   615,   219,   616,  1930,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
       0,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,  1931,  1932,     0,     0,   637,     0,   638,     0,
       0,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,   655,     0,  1933,     0,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   708,   668,   669,   732,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   733,   104,   105,   687,   734,     0,
     107,   108,   109,   110,   735,   736,   112,   113,   114,   115,
       0,   116,   737,   738,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,     0,     0,     0,   430,
     431,     0,   432,   433,   133,   434,   435,   436,     0,  1915,
     137,  1916,  1917,     0,   437,   438,   439,   440,   441,     0,
       0,   442,   443,  1918,  1919,   444,     0,   445,   446,   447,
     448,     0,     0,   145,     0,   449,   450,   451,   452,   148,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
     151,   460,     0,     0,     0,     0,   152,     0,     0,     0,
     461,   462,   463,   464,   701,   465,  1920,  1921,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,  1503,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,     0,   491,   492,   493,     0,     0,   494,     0,   495,
     496,  1922,   497,     0,   498,     0,   499,   169,     0,   170,
     500,   501,   502,     0,   503,     0,     0,   504,     0,   505,
     506,   703,   507,   508,   173,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,   174,     0,     0,
     519,   520,   521,  1509,  1923,     0,  1924,     0,   522,   178,
     179,   523,   180,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,     0,   182,   532,   183,     0,   533,   534,
     535,     0,     0,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,  1925,   189,  1926,   547,
     548,     0,     0,   549,   550,   193,   551,     0,     0,   552,
    1927,   553,   554,   555,     0,   556,     0,     0,   557,   558,
     559,     0,     0,   560,     0,   197,   561,   198,     0,   562,
     563,   564,   565,   566,   567,   568,     0,   569,     0,   570,
       0,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,  1928,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,   210,   599,   600,     0,   601,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,     0,   613,     0,   614,   615,   219,   616,  1930,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,     0,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,  1931,  1932,     0,     0,   637,     0,   638,
       0,     0,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,     0,     0,   651,   652,
     653,   654,   655,     0,  1933,     0,   656,   235,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   708,   668,   669,   732,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   733,   104,   105,   687,   734,
       0,   107,   108,   109,   110,   735,   736,   112,   113,   114,
     115,     0,   116,   737,   738,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,     0,
       0,   137,     0,     0,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,     0,     0,   444,     0,   445,   446,
     447,   448,     0,     0,   145,     0,   449,   450,   451,   452,
     148,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,     0,     0,     0,   152,     0,     0,
       0,   461,   462,   463,   464,   701,   465,     0,     0,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,     0,   491,   492,   493,     0,     0,   494,     0,
     495,   496,     0,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,     0,     0,   504,     0,
     505,   506,   703,   507,   508,   173,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,     0,
       0,   519,   520,   521,     0,     0,     0,     0,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,     0,   182,   532,   183,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,     0,   189,     0,
     547,   548,     0,     0,   549,   550,   193,   551,     0,     0,
     552,     0,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,     0,   197,   561,   198,     0,
     562,   563,   564,   565,   566,   567,   568,     0,   569,     0,
     570,     0,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,     0,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,     0,   614,   615,   219,   616,     0,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,     0,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,     0,     0,     0,     0,   637,     0,
     638,     0,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,     0,     0,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,   739,
     427,   428,   429,   740,   741,   742,   743,   744,   745,   746,
     430,   431,   747,   432,   433,   133,   434,   435,   436,   135,
     136,   137,   138,   139,   748,   437,   438,   439,   440,   441,
     749,   750,   442,   443,     0,   140,   444,   752,   445,   446,
     447,   448,   144,   753,   145,   754,   449,   450,   451,   452,
     148,   453,   755,   756,   454,   455,   456,   457,   458,   459,
     757,   151,   460,     0,   759,   760,   761,   152,   762,   763,
     764,   461,   462,   463,   464,     0,   465,   155,   156,   466,
     765,   467,   766,   468,   469,   470,   471,   472,   767,   473,
     474,   475,   768,   769,   476,   477,   478,   479,   480,   770,
     481,   482,   483,   771,   484,   485,   486,   772,   487,   488,
     489,   490,   164,   491,   492,   493,   166,   773,   494,   774,
     495,   496,   168,   497,   775,   498,   776,   499,   169,   777,
     170,   500,   501,   502,   778,   503,   172,   779,   504,   780,
     505,   506,     0,   507,   508,   173,   509,   510,   511,   781,
     512,   513,   514,   515,   516,   517,   782,   518,   174,   175,
       0,   519,   520,   521,     0,   176,   785,   177,   786,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,   787,
     529,   530,   788,   531,   181,   182,   532,   183,   789,   533,
     534,   535,   790,   791,   536,   537,   538,   539,   540,   541,
       0,   542,   543,     0,   544,   545,   546,   188,   189,   190,
     547,   548,   191,   792,   549,   550,   193,   551,   793,   194,
     552,   195,   553,   554,   555,   794,   556,   795,   796,   557,
     558,   559,   797,   798,   560,   196,   197,   561,   198,   199,
     562,   563,   564,   565,   566,   567,   568,   799,   569,   200,
     570,   201,   571,   572,   573,   800,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,   801,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,   802,   597,   598,   210,   599,   600,   212,   601,   602,
     603,   604,   605,   606,     0,   607,   803,   608,   609,   610,
     611,   612,   804,   613,   217,   614,   615,   219,   616,   220,
     617,   805,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,   806,   628,   629,   807,   630,   631,   632,
     633,   634,   635,   808,   224,   225,     0,   810,   637,   226,
     638,   227,   811,   639,   640,   641,   642,   643,   644,   645,
       0,   813,   646,   647,   648,   649,   650,   814,   815,   651,
     652,   653,   654,   655,     0,   234,   817,   656,   235,   657,
     658,   659,   660,   818,   819,   661,   820,   821,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,     0,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
    1161,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,  2445,   445,   446,
     447,   448,   144,     0,     0,  2517,   449,   450,   451,   452,
       0,   453,   699,  2446,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,  2518,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,  2448,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,  2449,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,  2450,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,  2445,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,  2446,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,  2518,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,  2448,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,  3406,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,  2449,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,  2450,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,  1058,   425,   426,  1016,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
    1017,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,  1059,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,  1018,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,  1019,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  1016,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
    1017,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,  3135,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,  1018,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,  1019,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,  2445,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,  2446,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,  2518,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,  2448,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,  2449,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,  2450,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,   697,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,   700,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
     702,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  1016,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
    1017,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,  1018,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,  1019,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,   927,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,   928,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   929,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  2106,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,  2107,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,  2108,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,  2109,   499,     0,     0,
       0,  2110,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,  2111,  2112,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,  2113,   605,   606,   706,   607,     0,  2114,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,  2115,   630,  2116,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,  2117,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
    1017,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,  1018,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,  1019,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,  2095,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,  2390,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,  2999,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,  3000,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,  3001,   630,   631,  3002,
     633,  3003,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,  3004,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,   724,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
     702,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,   877,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  1343,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,   130,   131,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  3215,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,  3216,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  3227,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,  3228,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   933,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   978,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,  1033,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,  1092,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1240,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,  1092,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  1591,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1765,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,  1092,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,  2003,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,  2095,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,  2390,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,  4179,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,  4193,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
    4420,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
    4422,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
    4424,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,  4839,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
    1042,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  1044,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,  1045,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,     0,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,  1046,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,  1047,   225,     0,     0,  1048,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,  1049,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  1086,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,  1045,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,     0,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,  1087,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,  1088,   225,     0,     0,  1089,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,  1049,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,  1106,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1212,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1236,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1248,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1302,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1316,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1356,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1375,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1377,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1379,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1382,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1388,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,  1602,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,  1071,   443,  1045,   140,  1603,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,     0,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,  1075,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,  1076,   600,   212,   601,   602,
     603,  1077,   605,   606,   706,   607,     0,   608,   609,   610,
     611,  1595,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,  1079,   225,     0,     0,  1080,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,  1049,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,  1081,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,  1728,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1812,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1962,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  1992,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  2027,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  2029,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,  2031,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
    2144,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,  2357,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,  