.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "CREATE LANGUAGE" "l" "2001-09-05" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE LANGUAGE \- define a new procedural language
.SH SYNOPSIS
.sp
.nf
CREATE [ TRUSTED ] [ PROCEDURAL ] LANGUAGE \fIlangname\fR
    HANDLER \fIcall_handler\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
Using \fBCREATE LANGUAGE\fR, a
PostgreSQL user can register a new
procedural language with a PostgreSQL
database. Subsequently, functions and trigger procedures can be
defined in this new language. The user must have the
PostgreSQL superuser privilege to
register a new language.
.PP
\fBCREATE LANGUAGE\fR effectively associates the
language name with a call handler that is responsible for executing
functions written in the language. Refer to the
\fIProgrammer's Guide\fR for more information
about language call handlers.
.PP
Note that procedural languages are local to individual databases.
To make a language available in all databases by default, it should
be installed into the template1 database.
.SH "PARAMETERS"
.TP
\fBTRUSTED\fR
TRUSTED specifies that the call handler for
the language is safe, that is, it does not offer an
unprivileged user any functionality to bypass access
restrictions. If this keyword is omitted when registering the
language, only users with the
PostgreSQL superuser privilege can
use this language to create new functions.
.TP
\fBPROCEDURAL\fR
This is a noise word.
.TP
\fB\fIlangname\fB\fR
The name of the new procedural language. The language name is
case insensitive. A procedural language cannot override one of
the built-in languages of PostgreSQL.

For backward compatibility, the name may be enclosed by single
quotes.
.TP
\fBHANDLER \fIcall_handler\fB\fR
\fIcall_handler\fR is
the name of a previously registered function that will be
called to execute the procedural language functions. The call
handler for a procedural language must be written in a compiled
language such as C with version 1 call convention and
registered with PostgreSQL as a
function taking no arguments and returning the
\fBopaque\fR type, a placeholder for unspecified or
undefined types.
.SH "DIAGNOSTICS"
.sp
.nf
CREATE
.sp
.fi
.PP
This message is returned if the language is successfully
created.
.sp
.nf
ERROR:  PL handler function \fIfuncname\fR() doesn't exist
.sp
.fi
.PP
This error is returned if the function \fIfuncname\fR() is not found.
.SH "NOTES"
.PP
This command normally should not be executed directly by users.
For the procedural languages supplied in the
PostgreSQL distribution, the \fBcreatelang\fR(1) script should be used, which will also
install the correct call handler. (\fBcreatelang\fR
will call \fBCREATE LANGUAGE\fR internally.)
.PP
Use the CREATE FUNCTION [\fBcreate_function\fR(l)] command to create a new
function.
.PP
Use DROP LANGUAGE [\fBdrop_language\fR(l)], or better yet the \fBdroplang\fR(1) script, to drop procedural languages.
.PP
The system catalog \fBpg_language\fR records
information about the currently installed procedural languages.
.sp
.nf
        Table "pg_language"
   Attribute   |  Type   | Modifier
---------------+---------+----------
 lanname       | name    |
 lanispl       | boolean |
 lanpltrusted  | boolean |
 lanplcallfoid | oid     |
 lancompiler   | text    |

   lanname   | lanispl | lanpltrusted | lanplcallfoid | lancompiler
-------------+---------+--------------+---------------+-------------
 internal    | f       | f            |             0 | n/a
 C           | f       | f            |             0 | /bin/cc
 sql         | f       | f            |             0 | postgres
.sp
.fi
.PP
At present, the definition of a procedural language cannot be
changed once it has been created.
.SH "EXAMPLES"
.PP
The following two commands executed in sequence will register a new
procedural language and the associated call handler.
.sp
.nf
CREATE FUNCTION plsample_call_handler () RETURNS opaque
    AS '$libdir/plsample'
    LANGUAGE C;
CREATE LANGUAGE plsample
    HANDLER plsample_call_handler;
.sp
.fi
.SH "COMPATIBILITY"
.PP
\fBCREATE LANGUAGE\fR is a
PostgreSQL extension.
.SH "HISTORY"
.PP
The \fBCREATE LANGUAGE\fR command first appeared in
PostgreSQL 6.3.
.SH "SEE ALSO"
.PP
\fBcreatelang\fR(1), \fBcreate_function\fR(l), \fBdroplang\fR(1), \fBdrop_language\fR(l), \fIPostgreSQL Programmer's Guide\fR

