.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "DROP OPERATOR" "" "2009-01-30" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP OPERATOR \- remove an operator

.SH SYNOPSIS
.sp
.nf
DROP OPERATOR \fIname\fR ( \fIlefttype\fR | NONE , \fIrighttype\fR | NONE ) [ CASCADE | RESTRICT ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBDROP OPERATOR\fR drops an existing operator from
the database system. To execute this command you must be the owner
of the operator.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of an existing operator.
.TP
\fB\fIlefttype\fB\fR
The data type of the operator's left operand; write
NONE if the operator has no left operand.
.TP
\fB\fIrighttype\fB\fR
The data type of the operator's right operand; write
NONE if the operator has no right operand.
.TP
\fBCASCADE\fR
Automatically drop objects that depend on the operator.
.TP
\fBRESTRICT\fR
Refuse to drop the operator if any objects depend on it. This
is the default.
.SH "EXAMPLES"
.PP
Remove the power operator a^b for type \fBinteger\fR:
.sp
.nf
DROP OPERATOR ^ (integer, integer);
.sp
.fi
.PP
Remove the left unary bitwise complement operator
~b for type \fBbit\fR:
.sp
.nf
DROP OPERATOR ~ (none, bit);
.sp
.fi
.PP
Remove the right unary factorial operator x!
for type \fBinteger\fR:
.sp
.nf
DROP OPERATOR ! (integer, none);
.sp
.fi
.SH "COMPATIBILITY"
.PP
There is no \fBDROP OPERATOR\fR statement in the SQL standard.
.SH "SEE ALSO"
CREATE OPERATOR [\fBcreate_operator\fR(l)]
